/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.AbstractPrefsPropertyPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.AbstractPropertySheet;
import cerent.util.gui.ChoicePropertyEditor;
import cerent.util.gui.IntegerPropertyEditor;
import cerent.util.orb.ICtcORB;
import cerent.util.orb.OngORB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PrefsFirewallPropertyPane
extends AbstractPrefsPropertyPane {
    private static final String IIOP = "IIOP";
    private static final String SSLIOP = "SSLIOP";
    static final int INTEGER_FIELD_POSITION = 2;
    static final int DEFAULT_FIELD_POSITION = 0;
    private Object iiopLoadedValue_ = null;
    private Object ssliopLoadedValue_ = null;
    private ChoicePropertyEditor iiopListenerPortChoiceEdit_;
    private IntegerPropertyEditor iiopListenerPortIntegerEdit_;
    private ChoicePropertyEditor ssliopListenerPortChoiceEdit_;
    private IntegerPropertyEditor ssliopListenerPortIntegerEdit_;
    private int portNum = -1;
    private static final SDebug db = new SDebug("PrefsFirewallPropertyPane");

    public PrefsFirewallPropertyPane(String string, AbstractPropertySheet abstractPropertySheet, Preferences preferences) {
        super(string, abstractPropertySheet, preferences);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        this.createIiopPane();
        if (this.iiopListenerPortChoiceEdit_ != null) {
            jPanel.add(this.iiopListenerPortChoiceEdit_);
        }
        this.createSsliopPane();
        if (this.ssliopListenerPortChoiceEdit_ != null) {
            jPanel.add(this.ssliopListenerPortChoiceEdit_);
        }
        this.add((Component)jPanel, "North");
        this.notifyAllPropertyEditors(this);
        this.load();
    }

    private void createIiopPane() {
        try {
            String string = "CTC CORBA (IIOP) Listener Port";
            String[] stringArray = new String[]{"Default - Variable", "Standard Constant (683)", "Other Constant:"};
            String[] stringArray2 = new String[]{String.valueOf(0), String.valueOf(683), String.valueOf(-1)};
            this.iiopListenerPortChoiceEdit_ = new ChoicePropertyEditor(string, stringArray, stringArray2, 0, 2);
            this.iiopListenerPortIntegerEdit_ = new IntegerPropertyEditor(null);
            this.iiopListenerPortChoiceEdit_.subPanels()[2].add(this.iiopListenerPortIntegerEdit_);
            final JTextField jTextField = this.iiopListenerPortIntegerEdit_.getTxtInput();
            this.iiopListenerPortChoiceEdit_.getButtons()[2].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    Object object = changeEvent.getSource();
                    JRadioButton jRadioButton = (JRadioButton)object;
                    if (jRadioButton.isSelected()) {
                        jTextField.setEnabled(true);
                    } else {
                        jTextField.setEnabled(false);
                    }
                }
            });
            this.iiopListenerPortIntegerEdit_.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object = propertyChangeEvent.getSource();
                    IntegerPropertyEditor integerPropertyEditor = (IntegerPropertyEditor)object;
                    String string = (String)integerPropertyEditor.getValue();
                    if (!string.equals("")) {
                        PrefsFirewallPropertyPane.this.iiopListenerPortChoiceEdit_.setVariableValue(string);
                        PrefsFirewallPropertyPane.this.iiopListenerPortChoiceEdit_.setDirty(true);
                    }
                }
            });
            JRadioButton[] jRadioButtonArray = this.iiopListenerPortChoiceEdit_.getButtons();
            JRadioButton jRadioButton = jRadioButtonArray[2];
            jRadioButton.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object = propertyChangeEvent.getSource();
                    JRadioButton jRadioButton = (JRadioButton)object;
                    if (jRadioButton.isSelected()) {
                        String string = (String)PrefsFirewallPropertyPane.this.iiopListenerPortChoiceEdit_.getValue();
                        PrefsFirewallPropertyPane.this.iiopListenerPortIntegerEdit_.setValue(string);
                    }
                }
            });
            this.iiopListenerPortIntegerEdit_.setMinValue(0);
            this.iiopListenerPortIntegerEdit_.setMaxValue(65535);
            if (!this.iiopListenerPortIntegerEdit_.getValue().equals("")) {
                this.iiopListenerPortChoiceEdit_.setValue(String.valueOf(0));
            }
        }
        catch (Exception exception) {
            db.finer("Exception in PrefsFirewallPropertyPane() " + exception);
        }
    }

    private void createSsliopPane() {
        try {
            String string = "CTC CORBA (SSLIOP) Listener Port";
            String[] stringArray = new String[]{"Default - Variable", "Standard Constant (684)", "Other Constant:"};
            String[] stringArray2 = new String[]{String.valueOf(0), String.valueOf(684), String.valueOf(-1)};
            this.ssliopListenerPortChoiceEdit_ = new ChoicePropertyEditor(string, stringArray, stringArray2, 0, 2);
            this.ssliopListenerPortIntegerEdit_ = new IntegerPropertyEditor(null);
            this.ssliopListenerPortChoiceEdit_.subPanels()[2].add(this.ssliopListenerPortIntegerEdit_);
            final JTextField jTextField = this.ssliopListenerPortIntegerEdit_.getTxtInput();
            this.ssliopListenerPortChoiceEdit_.getButtons()[2].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    Object object = changeEvent.getSource();
                    JRadioButton jRadioButton = (JRadioButton)object;
                    if (jRadioButton.isSelected()) {
                        jTextField.setEnabled(true);
                    } else {
                        jTextField.setEnabled(false);
                    }
                }
            });
            this.ssliopListenerPortIntegerEdit_.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object = propertyChangeEvent.getSource();
                    IntegerPropertyEditor integerPropertyEditor = (IntegerPropertyEditor)object;
                    String string = (String)integerPropertyEditor.getValue();
                    if (!string.equals("")) {
                        PrefsFirewallPropertyPane.this.ssliopListenerPortChoiceEdit_.setVariableValue(string);
                        PrefsFirewallPropertyPane.this.ssliopListenerPortChoiceEdit_.setDirty(true);
                    }
                }
            });
            JRadioButton[] jRadioButtonArray = this.ssliopListenerPortChoiceEdit_.getButtons();
            JRadioButton jRadioButton = jRadioButtonArray[2];
            jRadioButton.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object = propertyChangeEvent.getSource();
                    JRadioButton jRadioButton = (JRadioButton)object;
                    if (jRadioButton.isSelected()) {
                        String string = (String)PrefsFirewallPropertyPane.this.ssliopListenerPortChoiceEdit_.getValue();
                        PrefsFirewallPropertyPane.this.ssliopListenerPortIntegerEdit_.setValue(string);
                    }
                }
            });
            this.ssliopListenerPortIntegerEdit_.setMinValue(0);
            this.ssliopListenerPortIntegerEdit_.setMaxValue(65535);
            if (!this.ssliopListenerPortIntegerEdit_.getValue().equals("")) {
                this.ssliopListenerPortChoiceEdit_.setValue(String.valueOf(0));
            }
        }
        catch (Exception exception) {
            db.finer("Exception in PrefsFirewallPropertyPane() " + exception);
        }
    }

    @Override
    protected boolean onValidate(Container container) {
        block7: {
            String string;
            block6: {
                if (this.iiopListenerPortChoiceEdit_.isDirty() || this.iiopListenerPortIntegerEdit_.isDirty()) {
                    try {
                        string = (String)this.iiopListenerPortChoiceEdit_.getValue();
                        this.portNum = this.validatePortNum(string, this.iiopLoadedValue_, IIOP);
                        ErrorMsg.displayWarning(null, (EID)NEMC.WID_PORT_SETTING_AFTER_REBOOT_PARAM_1, IIOP, String.valueOf(this.portNum));
                    }
                    catch (Exception exception) {
                        if (exception instanceof UnchangedException) break block6;
                        return false;
                    }
                }
            }
            if (this.ssliopListenerPortChoiceEdit_.isDirty() || this.ssliopListenerPortIntegerEdit_.isDirty()) {
                try {
                    string = (String)this.ssliopListenerPortChoiceEdit_.getValue();
                    this.portNum = this.validatePortNum(string, this.ssliopLoadedValue_, SSLIOP);
                    ErrorMsg.displayWarning(null, (EID)NEMC.WID_PORT_SETTING_AFTER_REBOOT_PARAM_1, SSLIOP, String.valueOf(this.portNum));
                }
                catch (Exception exception) {
                    if (exception instanceof UnchangedException) break block7;
                    return false;
                }
            }
        }
        return true;
    }

    public int validatePortNum(String string, Object object, String string2) throws UnchangedException, UnavailableException, NumberFormatException {
        if (object != null && object.equals(string)) {
            throw new UnchangedException();
        }
        int n = -1;
        String string3 = "unspecified";
        try {
            int n2 = Integer.decode(string);
            if (((ICtcORB)OngORB.instance()).isPortAvailable(n2)) {
                string3 = n2 == 0 ? "'dynamic'" : String.valueOf(n2);
                return n2;
            }
            if (db.on()) {
                db.println("Port " + string + " is unavailable");
            }
            ErrorMsg.displayError(this, NEMC.EID_LISTENER_PORT_IN_USE_PARAM_1, string2, string3);
            throw new UnavailableException();
        }
        catch (NumberFormatException numberFormatException) {
            if (db.on()) {
                db.println("Port '" + string + "' is not a valid number");
            }
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_INVALID_NUMBER);
            throw numberFormatException;
        }
    }

    @Override
    public void store() {
        String string = (String)this.iiopListenerPortChoiceEdit_.getValue();
        this.store("ong.orb", "iioplistenerport", this.iiopListenerPortChoiceEdit_);
        this.iiopLoadedValue_ = string;
        string = (String)this.ssliopListenerPortChoiceEdit_.getValue();
        if (this.iiopLoadedValue_.equals(string) && Integer.parseInt(string) != 0) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_INVALID_SSLIOP_PORT);
            return;
        }
        this.store("ong.orb", "sslioplistenerport", this.ssliopListenerPortChoiceEdit_);
        this.ssliopLoadedValue_ = string;
    }

    @Override
    public void load() {
        this.load("ong.orb", "iioplistenerport", this.iiopListenerPortChoiceEdit_);
        this.iiopLoadedValue_ = this.iiopListenerPortChoiceEdit_.getValue();
        this.load("ong.orb", "sslioplistenerport", this.ssliopListenerPortChoiceEdit_);
        this.ssliopLoadedValue_ = this.ssliopListenerPortChoiceEdit_.getValue();
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.PrefsFirewallPropertyPane;
    }

    private class UnavailableException
    extends Exception {
    }

    private class UnchangedException
    extends Exception {
    }
}

