/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Feature;
import cerent.cms.model.IModel;
import cerent.cms.model.ISecurityPolicy;
import cerent.cms.model.NetSecurityModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SecurityPolicy;
import cerent.cms.model.vf.AbstractVersionedFeature;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import cerent.util.gui.TimePeriodPropertyEditor;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

class SecurityPolicyDataSource
extends AbstractRowDataSource {
    private IModel _model;
    private ArrayList _values;
    private static final String[] _columnNames = new String[]{"Node", "Superuser", "Provisioning", "Maintenance", "Retrieve", "Password Reuse Threshold", "Password Flipping", "Failed Logins Before Lockout", "Lockout Duration", "Single Session Per User", "Change Password On First-Time Login", "Prevent Super User Disable", "Disable Inactive User", "Minimum Password Difference"};
    private static final Class[] _columnClasses = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Boolean.class, Boolean.class, Boolean.class, String.class, String.class};
    private static final SDebug db = new SDebug("SecurityPolicyDataSource");

    SecurityPolicyDataSource(IModel iModel) {
        this._model = iModel;
        this._values = new ArrayList();
    }

    private void fetchValues(NodeModel nodeModel, ArrayList arrayList) {
        try {
            if (nodeModel.provides(Feature.SECURITY_POLICY)) {
                arrayList.add(new PolicyInfo(nodeModel));
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            // empty catch block
        }
    }

    private static NodeModel nodeModel(Object object) {
        return object instanceof INetElement ? (NodeModel)((INetElement)object).getNodeModel() : (NodeModel)object;
    }

    private static void addNodeModel(Object object, ArrayList arrayList) {
        NodeModel nodeModel = SecurityPolicyDataSource.nodeModel(object);
        if (nodeModel != null && nodeModel.provides(Feature.SECURITY_POLICY)) {
            arrayList.add(nodeModel);
        }
    }

    List getNodes() {
        ArrayList arrayList = new ArrayList();
        if (this._model instanceof NetworkModel) {
            Iterator iterator = Network.instance().getElements().iterator();
            while (iterator.hasNext()) {
                SecurityPolicyDataSource.addNodeModel(iterator.next(), arrayList);
            }
        } else {
            SecurityPolicyDataSource.addNodeModel(this._model, arrayList);
        }
        return arrayList;
    }

    void refreshFromModel(SortableRowTableModel sortableRowTableModel) {
        block5: {
            try {
                ArrayList arrayList = new ArrayList();
                if (this._model instanceof NetworkModel) {
                    Iterator iterator = Network.instance().getElements().iterator();
                    while (iterator.hasNext()) {
                        this.fetchValues(SecurityPolicyDataSource.nodeModel(iterator.next()), arrayList);
                    }
                } else {
                    this.fetchValues(SecurityPolicyDataSource.nodeModel(this._model), arrayList);
                }
                SwingUtilities.invokeAndWait(new Refresher(sortableRowTableModel, arrayList));
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("exception: " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    ColumnRenderer[] getRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[_columnNames.length];
        for (int i = 0; i < _columnNames.length; ++i) {
            columnRendererArray[i] = 1 <= i && i <= 4 ? new GroupAttributeRenderer(i) : new Renderer(i);
        }
        return columnRendererArray;
    }

    public synchronized Object getObjectAtRow(int n) {
        return this._values.get(n);
    }

    public synchronized int getRowCount() {
        return this._values.size();
    }

    public Class getRowObjectClass() {
        return PolicyInfo.class;
    }

    private class GroupAttributeRenderer
    extends Renderer {
        private JTextArea textArea;

        GroupAttributeRenderer(int n) {
            super(n);
            this.textArea = new JTextArea();
            this.textArea.setOpaque(true);
            this.textArea.setLineWrap(true);
        }

        @Override
        public int getWidth() {
            return 100;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
            Color color2 = bl ? jTable.getSelectionBackground() : jTable.getBackground();
            this.textArea.setText((String)((PolicyInfo)object).getValueAt(n2));
            this.textArea.setForeground(color);
            this.textArea.setBackground(color2);
            int n3 = this.textArea.getPreferredSize().height;
            int n4 = jTable.getRowHeight(n);
            if (n4 < n3) {
                jTable.setRowHeight(n3);
            }
            return this.textArea;
        }
    }

    static class PolicyInfo {
        private static String NOT_APPLICABLE = "N/A";
        private ISecurityPolicy _policy;
        private String _nodeName;
        private String _superAttributes;
        private String _provAttributes;
        private String _mainAttributes;
        private String _retrAttributes;
        private String _passwordReuse;
        private String _lockoutThreshold;
        private String _lockoutDuration;
        private Boolean _singleSession;
        private Boolean _forcePasswordChange;
        private String _passwordFlipping;
        private String _maxIdleDaysBeforeDisable;
        private String _minChangedCharsInPwd;
        private Boolean _superUserDisable;

        PolicyInfo(NodeModel nodeModel) {
            AbstractVersionedFeature abstractVersionedFeature;
            AbstractVersionedFeature abstractVersionedFeature2;
            this._policy = PolicyInfo.getSecurityPolicy(nodeModel);
            this._nodeName = nodeModel.getName();
            this._superAttributes = this.getAttributes(3);
            this._provAttributes = this.getAttributes(2);
            this._mainAttributes = this.getAttributes(1);
            this._retrAttributes = this.getAttributes(0);
            this._passwordReuse = this._policy.getPasswordReuseThreshold() + " (times)";
            this._lockoutThreshold = this._policy.getLockoutThreshold() + " (times)";
            this._lockoutDuration = this._policy.isManualUnlock() ? "FOREVER" : TimePeriodPropertyEditor.toStringMMSS(this._policy.getLockoutDuration());
            this._singleSession = this._policy.isSingleSessionPerUser() ? Boolean.TRUE : Boolean.FALSE;
            this._forcePasswordChange = this._policy.getForcePasswordChange() ? Boolean.TRUE : Boolean.FALSE;
            this._passwordFlipping = this._policy.getPasswordFlippingPolicyEnabled() ? this._policy.getPasswordFlippingPolicyThreshold() + " (days)" : "NONE";
            this._maxIdleDaysBeforeDisable = this._policy.getDisableInactiveUserPolicyEnabled() ? this._policy.getMaxInactiveDaysBeforeDisable() + " (days)" : "NONE";
            this._minChangedCharsInPwd = NOT_APPLICABLE;
            if (nodeModel.provides(Feature.SECURITY_VERSIONING) && AbstractVersionedFeature.isCompatibilityPresent((AbstractVersionedFeature)(abstractVersionedFeature2 = NetSecurityModel.instance().getSecurityVersion()), (AbstractVersionedFeature)(abstractVersionedFeature = nodeModel.getSecurityModel().getSecurityVersion()))) {
                this._minChangedCharsInPwd = new Short(this._policy.getMinChangedCharsInPwd()).toString() + " (character" + (this._policy.getMinChangedCharsInPwd() > 1 ? "s)" : ")");
            }
            if (nodeModel.provides(Feature.SEC_PREVENT_SUPER_USER_DISABLE)) {
                this._superUserDisable = this._policy.getPreventSuperUserDisabledPolicy();
            }
        }

        ISecurityPolicy getSecurityPolicy() {
            return this._policy;
        }

        public static ISecurityPolicy getSecurityPolicy(NodeModel nodeModel) {
            int n;
            int n2;
            ISecurityPolicy iSecurityPolicy = nodeModel.getSecurityModel().getSecurityPolicy();
            if (nodeModel.provides(Feature.SECURITY_VERSIONING)) {
                return iSecurityPolicy;
            }
            SecurityPolicy securityPolicy = new SecurityPolicy();
            for (n2 = 0; n2 < SecurityLevel.SECURITY_LEVELS.length; ++n2) {
                n = SecurityLevel.SECURITY_LEVELS[n2].value();
                securityPolicy.setIdleTimeout(n, iSecurityPolicy.getIdleTimeout(n));
            }
            securityPolicy.setPasswordReuseThreshold(iSecurityPolicy.getPasswordReuseThreshold());
            securityPolicy.setPasswordDuration(iSecurityPolicy.getPasswordDuration());
            securityPolicy.setLockoutThreshold(iSecurityPolicy.getLockoutThreshold());
            securityPolicy.setManualUnlock(iSecurityPolicy.isManualUnlock());
            securityPolicy.setLockoutDuration(iSecurityPolicy.getLockoutDuration());
            securityPolicy.setSingleSessionPerUser(iSecurityPolicy.isSingleSessionPerUser());
            if (nodeModel.provides(Feature.SEC_PASSWD_AGING)) {
                securityPolicy.setForcePasswordChange(iSecurityPolicy.getForcePasswordChange());
                securityPolicy.setPasswordFlippingPolicyEnabled(iSecurityPolicy.getPasswordFlippingPolicyEnabled());
                securityPolicy.setPasswordFlippingPolicyThreshold(iSecurityPolicy.getPasswordFlippingPolicyThreshold());
                securityPolicy.setPasswordExprPolicyEnabled(iSecurityPolicy.isPasswordExprPolicyEnabled());
                securityPolicy.setDisableInactiveUserPolicyEnabled(iSecurityPolicy.getDisableInactiveUserPolicyEnabled());
                securityPolicy.setMaxInactiveDaysBeforeDisable(iSecurityPolicy.getMaxInactiveDaysBeforeDisable());
                for (n2 = 0; n2 <= 3; ++n2) {
                    n = iSecurityPolicy.getPasswordExprPeriod(n2);
                    int n3 = iSecurityPolicy.getPasswordExprWarningPeriod(n2);
                    securityPolicy.setPasswordExprPolicy(n2, n, n3);
                }
            }
            if (nodeModel.provides(Feature.SEC_PREVENT_SUPER_USER_DISABLE)) {
                securityPolicy.setPreventSuperUserDisabledPolicy(iSecurityPolicy.getPreventSuperUserDisabledPolicy());
            }
            return securityPolicy;
        }

        Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this._nodeName;
                }
                case 1: {
                    return this._superAttributes;
                }
                case 2: {
                    return this._provAttributes;
                }
                case 3: {
                    return this._mainAttributes;
                }
                case 4: {
                    return this._retrAttributes;
                }
                case 5: {
                    return this._passwordReuse;
                }
                case 6: {
                    return this._passwordFlipping;
                }
                case 7: {
                    return this._lockoutThreshold;
                }
                case 8: {
                    return this._lockoutDuration;
                }
                case 9: {
                    return this._singleSession;
                }
                case 10: {
                    return this._forcePasswordChange;
                }
                case 11: {
                    return this._superUserDisable;
                }
                case 12: {
                    return this._maxIdleDaysBeforeDisable;
                }
                case 13: {
                    return this._minChangedCharsInPwd;
                }
            }
            return null;
        }

        int cmpValueAt(PolicyInfo policyInfo, int n) {
            switch (n) {
                case 0: {
                    return this._nodeName.compareTo(policyInfo._nodeName);
                }
                case 1: {
                    return this._superAttributes.compareTo(policyInfo._superAttributes);
                }
                case 2: {
                    return this._provAttributes.compareTo(policyInfo._provAttributes);
                }
                case 3: {
                    return this._mainAttributes.compareTo(policyInfo._mainAttributes);
                }
                case 4: {
                    return this._retrAttributes.compareTo(policyInfo._retrAttributes);
                }
                case 5: {
                    return ComparisonUtil.compare((int)this._policy.getPasswordReuseThreshold(), (int)policyInfo._policy.getPasswordReuseThreshold());
                }
                case 6: {
                    return ComparisonUtil.compare((int)(this._policy.getPasswordFlippingPolicyEnabled() ? this._policy.getPasswordFlippingPolicyThreshold() : 0), (int)(policyInfo._policy.getPasswordFlippingPolicyEnabled() ? policyInfo._policy.getPasswordFlippingPolicyThreshold() : 0));
                }
                case 7: {
                    return ComparisonUtil.compare((int)this._policy.getLockoutThreshold(), (int)policyInfo._policy.getLockoutThreshold());
                }
                case 8: {
                    return this._lockoutDuration.compareTo(policyInfo._lockoutDuration);
                }
                case 9: {
                    return ComparisonUtil.compare((boolean)this._singleSession, (boolean)policyInfo._singleSession);
                }
                case 10: {
                    return ComparisonUtil.compare((boolean)this._forcePasswordChange, (boolean)policyInfo._forcePasswordChange);
                }
                case 11: {
                    return ComparisonUtil.compare((boolean)this._superUserDisable, (boolean)policyInfo._superUserDisable);
                }
                case 12: {
                    return ComparisonUtil.compare((int)(this._policy.getDisableInactiveUserPolicyEnabled() ? this._policy.getMaxInactiveDaysBeforeDisable() : 0), (int)(policyInfo._policy.getDisableInactiveUserPolicyEnabled() ? policyInfo._policy.getMaxInactiveDaysBeforeDisable() : 0));
                }
                case 13: {
                    return this._minChangedCharsInPwd.compareTo(policyInfo._minChangedCharsInPwd);
                }
            }
            return -1;
        }

        private String getAttributes(int n) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Idle: ").append(TimePeriodPropertyEditor.toStringHHMM(this._policy.getIdleTimeout(n)));
            if (this._policy.isPasswordExprPolicyEnabled()) {
                stringBuffer.append("\nExpr: ").append(this._policy.getPasswordExprPeriod(n)).append(" day(s)\nWarn: ").append(this._policy.getPasswordExprWarningPeriod(n)).append(" day(s)");
            } else {
                stringBuffer.append("\nExpr: NONE\nWarn: NONE");
            }
            return stringBuffer.toString();
        }
    }

    private class Refresher
    implements Runnable {
        private SortableRowTableModel _tm;
        private ArrayList _newValues;

        Refresher(SortableRowTableModel sortableRowTableModel, ArrayList arrayList) {
            this._tm = sortableRowTableModel;
            this._newValues = arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SecurityPolicyDataSource securityPolicyDataSource = SecurityPolicyDataSource.this;
            synchronized (securityPolicyDataSource) {
                SecurityPolicyDataSource.this._values = this._newValues;
            }
            this._tm.dataSourceChanged();
            this._tm = null;
            this._newValues = null;
        }
    }

    private class Renderer
    implements ColumnRenderer {
        private final int _column;

        Renderer(int n) {
            this._column = n;
        }

        public String getName() {
            return _columnNames[this._column];
        }

        public int getWidth() {
            return 80;
        }

        public int getAlignment() {
            return 2;
        }

        public boolean isResizable() {
            return true;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return jTable.getDefaultRenderer(_columnClasses[this._column]).getTableCellRendererComponent(jTable, ((PolicyInfo)object).getValueAt(n2), bl, bl2, n, n2);
        }

        public int compareColumn(Object object, Object object2, int n) {
            if (object instanceof PolicyInfo) {
                if (object2 instanceof PolicyInfo) {
                    return ((PolicyInfo)object).cmpValueAt((PolicyInfo)object2, n);
                }
                return -1;
            }
            return 1;
        }
    }
}

