/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetSecurityModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractDataSourceControl;
import cerent.cms.ui.NoPrivilegePane;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SecurityActivePane;
import cerent.cms.ui.SecurityPolicyPane;
import cerent.cms.ui.SecurityUsersPane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Observable;
import java.util.Observer;

public class SecurityProvPane
extends ObserverPane
implements Observer {
    private final int USER_TAB = 0;
    private final int ACTIVE_TAB = 1;
    private final int POLICY_TAB = 2;
    private static final SDebug db = new SDebug("SecurityProvPane");
    TabbedView parentView = null;
    boolean isSuperUser = this.isUserAuthorized(SecurityLevel.SUPERUSER);
    private ObservableMgr _omgr;

    public SecurityProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.parentView = tabbedView;
        this.subTabs = new SubTabbedView(tabbedView.getUiModel(), tabbedView);
        this._omgr = new ObservableMgr();
        this.setDataSourceControl(this._omgr);
        this.subTabs.setTabPlacement(1);
        this.subTabs.add((Component)((Object)new SecurityUsersPane("Users", tabbedView.getUiModel(), this.subTabs)), 0);
        this.isSuperUser = this.isUserAuthorized(SecurityLevel.SUPERUSER);
        if (this.isSuperUser) {
            this.subTabs.add((Component)((Object)new SecurityActivePane("Active Logins", tabbedView.getUiModel(), this.subTabs)), 1);
            this.subTabs.add((Component)((Object)new SecurityPolicyPane("Policy", tabbedView.getUiModel(), this.subTabs)), 2);
        } else {
            this.subTabs.add((Component)((Object)new NoPrivilegePane("Active Logins", tabbedView)), 1);
            this.subTabs.add((Component)((Object)new NoPrivilegePane("Policy", tabbedView)), 2);
        }
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.subTabs);
    }

    @Override
    public void update(Observable observable, Object object) {
        block14: {
            if (SecurityProvPane.db.on) {
                db.println("update:enter: from: " + observable.toString());
            }
            boolean bl = this.isUserAuthorized(SecurityLevel.SUPERUSER);
            if (observable instanceof NetSecurityModel && object == ModelUpdateType.CHANGED && this.isSuperUser != bl) {
                this.isSuperUser = bl;
                if (bl) {
                    block13: {
                        if (SecurityProvPane.db.on) {
                            db.println("update: super user");
                        }
                        SecurityActivePane securityActivePane = new SecurityActivePane("Active Logins", this.parentView.getUiModel(), this.subTabs);
                        this.subTabs.setComponentAt(1, (Component)((Object)securityActivePane));
                        try {
                            if (this.subTabs.getComponentAt(1).isShowing()) {
                                securityActivePane.enteringPage();
                            }
                        }
                        catch (Exception exception) {
                            if (!SecurityProvPane.db.on) break block13;
                            db.println("update: exception in update ACTIVE_TAB");
                        }
                    }
                    SecurityPolicyPane securityPolicyPane = new SecurityPolicyPane("Policy", this.parentView.getUiModel(), this.subTabs);
                    this.subTabs.setComponentAt(2, (Component)((Object)securityPolicyPane));
                    try {
                        if (this.subTabs.getComponentAt(2).isShowing()) {
                            securityPolicyPane.enteringPage();
                        }
                        break block14;
                    }
                    catch (Exception exception) {
                        if (SecurityProvPane.db.on) {
                            db.println("update: exception in update POLICY_TAB");
                        }
                        break block14;
                    }
                }
                if (SecurityProvPane.db.on) {
                    db.println("update: non-super user");
                }
                this.subTabs.setComponentAt(1, (Component)((Object)new NoPrivilegePane("Active Logins", this.parentView)));
                this.subTabs.setComponentAt(2, (Component)((Object)new NoPrivilegePane("Policy", this.parentView)));
            }
        }
        if (SecurityProvPane.db.on) {
            db.println("update:exit");
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
    }

    @Override
    public void leavingPage() throws Exception {
        super.leavingPage();
    }

    protected void displayErrorDialog(Pane pane, Exception exception, String string) {
    }

    private class ObservableMgr
    extends AbstractDataSourceControl {
        private NetSecurityModel _secuModel = null;
        private ObservableManager _om;

        ObservableMgr() {
            this._om = new ObservableManager(SecurityProvPane.this, true);
        }

        @Override
        public void refreshFromModel(int n) throws Exception {
            if (n == -1) {
                this._secuModel = NetSecurityModel.instance();
                this._om.addObservable((Observable)((Object)this._secuModel));
            }
        }

        public synchronized void refreshFromModel() throws Exception {
        }

        public void applyToModel() {
        }

        public IObservableManager getObservableManager() {
            return this._om;
        }

        @Override
        public void disposeDataSource() {
            this._om.removeObservable((Observable)((Object)this._secuModel));
        }
    }
}

