/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ServerTrailModel;
import cerent.cms.ncp.ServerTrailRepairOperator;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.NetworkViewController;
import cerent.cms.ui.ServerTrailRepairGuessTerms;
import cerent.cms.ui.ServerTrailRepairInfo;
import cerent.cms.ui.ServerTrailRepairPreamble;
import cerent.cms.ui.ServerTrailRepairTerms;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;

public class ServerTrailRepairDialog
extends WzDialog {
    private static final String TITLE = "Server Trail Repair";
    public static final int VIGN_WIDTH = 200;
    public static final String WZPANE_SERVER_TRAIL_REP_PREAMBLE = "Server Trail Repair Introduction";
    public static final String WZPANE_SERVER_TRAIL_REP_DISCOVER = "Discover IP Changes";
    public static final String WZPANE_SERVER_TRAIL_REP_TERMS = "Server Trail Terminations to Repair";
    private ServerTrailRepairInfo info;

    public static ServerTrailRepairDialog instance(Component component) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        return new ServerTrailRepairDialog(frame, TITLE);
    }

    public ServerTrailRepairDialog(Frame frame, String string) {
        super(frame, string, new WzDiagDebug("ServerTrailLinkCreationDialog"), true, true);
        int n = 700;
        int n2 = 450;
        this.setSize(new Dimension(n, n2));
        this.createPanesAndSetCurrent();
        this.setLocationRelativeTo(frame);
        this.info = new ServerTrailRepairInfo();
    }

    @Override
    protected void createPanesAndSetCurrent() {
        this.wzPaneMap.put(WZPANE_SERVER_TRAIL_REP_PREAMBLE, new ServerTrailRepairPreamble(this, this.db, WZPANE_SERVER_TRAIL_REP_PREAMBLE));
        this.wzPaneMap.put(WZPANE_SERVER_TRAIL_REP_DISCOVER, new ServerTrailRepairGuessTerms(this, this.db, WZPANE_SERVER_TRAIL_REP_DISCOVER));
        this.wzPaneMap.put(WZPANE_SERVER_TRAIL_REP_TERMS, new ServerTrailRepairTerms(this, this.db, WZPANE_SERVER_TRAIL_REP_TERMS));
        this.setCurrentPane(WZPANE_SERVER_TRAIL_REP_PREAMBLE);
    }

    @Override
    protected void apply() throws Exception {
        List<ServerTrailModel> list = this.info.getTerms();
        if (list == null || list.size() == 0) {
            CerentDialog.infoDialog((Component)this, (String)"No Server Trail to repair.", (String)"Completed");
        } else {
            ServerTrailRepairOperator serverTrailRepairOperator = ServerTrailRepairOperator.newInstance();
            LinkedList<String> linkedList = new LinkedList<String>();
            if (!serverTrailRepairOperator.fixTerminations(this.info.getIpChange(), this.info.getTerms(), linkedList)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : linkedList) {
                    stringBuilder.append(string).append("\n\n");
                }
                ErrorMsg.displayDetailed((Component)this, NEMC.EID_SERVER_TRAIL_REPAIR_FAILURE, stringBuilder.toString());
                throw new Exception();
            }
            Network network = Network.instance();
            INetElement iNetElement = network.findNetElemByIp(this.info.getIpChange().getOldIp());
            if (iNetElement != null && !iNetElement.getConnectionState()) {
                NetworkViewController.instance().getNetworkMap().deleteSelectedNetElement(iNetElement.getNodeModel());
            }
            CerentDialog.infoDialog((Component)this, (String)"All Server Trails repaired.", (String)"Completed");
        }
    }

    @Override
    public boolean handleFinishException(Exception exception) {
        return true;
    }

    public void setFinishEnabled(boolean bl) {
        this.setButtonsEnabled(!bl, bl);
        if (this.finishButton.isEnabled()) {
            this.finishButton.requestFocus();
        }
    }

    public void setNextEnabled(boolean bl) {
        this.setButtonsEnabled(bl, !bl);
    }

    public ServerTrailRepairInfo getInfo() {
        return this.info;
    }

    private static String toString(IEntityModel iEntityModel) {
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        return ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iEntityModel.getModuleModel()).getString((Object)iEntityModel, iNodeModel.provides(Feature.MULTISHELF) && iNodeModel.isMultishelf() ? "shelf " : "slot ");
    }
}

