/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IBlsrModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISquelchTblEntry;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.LoSquelchTableDialog;
import cerent.cms.ui.SquelchTblColumnGroup;
import cerent.cms.ui.SquelchTblColumnModel;
import cerent.cms.ui.SquelchTblHeader;
import cerent.util.SDHTDMTerminology;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.TableModelAdapter;
import cerent.util.gui.TablePrintPane;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SquelchTableDialog
extends TablePrintPane
implements ActionListener,
MouseListener,
Observer {
    private static final int HO_NUM = 0;
    private static final int WEST_SRC_HO = 1;
    private static final int WEST_SRC_LO = 2;
    private static final int WEST_DEST_HO = 3;
    private static final int WEST_DEST_LO = 4;
    private static final int EAST_SRC_HO = 5;
    private static final int EAST_SRC_LO = 6;
    private static final int EAST_DEST_HO = 7;
    private static final int EAST_DEST_LO = 8;
    protected static final int MARGIN = 5;
    private UTable utable;
    private JButton retrieveButton;
    private JLabel retrieveLabel;
    private ButtonGroup rbGroup;
    private JRadioButton au4Rb;
    private JRadioButton au3Rb;
    private String oldAction;
    private final String STR_SDH_AU4 = "SDH-AU4";
    private final String STR_SDH_AU3 = "SDH-AU3";
    private SquelchTableModel tableModel;
    private IEntityCellRenderer cr;
    private IBlsrModel blsrModel;
    private INodeModel node;
    private String[] columnNames;
    private int[] fields;
    private TDMTerminology terms;
    private boolean isSdh;
    private boolean showLo;
    private String nodeName;
    private String ringName;
    private short nodeId;
    private static DateFormat dateFormat;
    private boolean is600;
    private static final SDebug db;

    public SquelchTableDialog(JComponent jComponent, IEntityCellRenderer iEntityCellRenderer, IBlsrModel iBlsrModel, boolean bl) {
        this(JOptionPane.getFrameForComponent(jComponent), iEntityCellRenderer, iBlsrModel, bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.retrieveButton)) {
            this.tableModel.updateTableModel(this.blsrModel);
            this.tableModel.fireTableDataChanged();
            if (dateFormat == null) {
                dateFormat = DateFormat.getDateTimeInstance(1, 1);
            }
            String string = "Retrieved: " + dateFormat.format(new Date());
            this.retrieveLabel.setText(string);
        } else if (actionEvent.getSource() instanceof JRadioButton) {
            String string = actionEvent.getActionCommand();
            if (this.oldAction.equals(string)) {
                return;
            }
            if (actionEvent.getSource().equals(this.au4Rb)) {
                this.oldAction = "SDH-AU4";
                this.utable.getColumnModel().getColumn(0).setHeaderValue("VC4");
            } else {
                this.oldAction = "SDH-AU3";
                this.utable.getColumnModel().getColumn(0).setHeaderValue("VC3");
            }
            this.utable.getTableHeader().resizeAndRepaint();
            this.tableModel.updateTableModel(this.blsrModel);
            this.tableModel.fireTableDataChanged();
            String string2 = "Retrieved: " + dateFormat.format(new Date());
            this.retrieveLabel.setText(string2);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public SquelchTableDialog(Frame frame, IEntityCellRenderer iEntityCellRenderer, IBlsrModel iBlsrModel, boolean bl) {
        super("");
        this.cr = iEntityCellRenderer;
        this.blsrModel = iBlsrModel;
        this.showLo = bl;
        this.node = this.blsrModel.getNodeModel();
        this.terms = this.node.getTDMTerminology();
        this.isSdh = this.terms instanceof SDHTDMTerminology;
        this.nodeName = this.node.getName();
        this.ringName = this.blsrModel.getBlsrProvision().getRingName();
        this.nodeId = this.blsrModel.getBlsrProvision().getNodeId();
        this.is600 = iBlsrModel.getNodeModel().getNeType().startsWith("15600");
        this.updateTitle();
        this.initColumnNames();
        this.initContentPane();
        this.pack();
        this.setLocationRelativeTo(frame);
        this.node.addObserver((Observer)this);
        this.blsrModel.addObserver((Observer)this);
    }

    @Override
    public void update(Observable observable, Object object) {
        boolean bl = false;
        db.fine("observable = " + observable.getClass().getName() + ", object value = " + object.toString());
        if (object.equals(ModelUpdateType.CHANGED)) {
            if (observable.equals(this.node)) {
                String string = this.node.getName();
                if (!string.equals(this.nodeName)) {
                    this.nodeName = string;
                    bl = true;
                }
            } else if (observable.equals(this.blsrModel)) {
                String string = this.blsrModel.getBlsrProvision().getRingName();
                short s = this.blsrModel.getBlsrProvision().getNodeId();
                if (s != this.nodeId) {
                    this.nodeId = s;
                    bl = true;
                }
                if (!string.equals(this.ringName)) {
                    this.ringName = string;
                    bl = true;
                }
            }
            if (bl) {
                this.updateTitle();
            }
        } else if (object.equals(ModelUpdateType.DELETED) && observable.equals(this.blsrModel)) {
            this.dispose();
        }
    }

    private void updateTitle() {
        this.setTitle(" Squelch Table: " + this.nodeName + " (Ring " + this.ringName + ", Node " + this.nodeId + ")");
    }

    private void initContentPane() {
        IEntityModel iEntityModel;
        IEntityModel iEntityModel2;
        SquelchTblColumnModel squelchTblColumnModel;
        JPanel jPanel;
        JPanel jPanel2;
        block9: {
            int n;
            jPanel2 = new JPanel(new BorderLayout());
            this.retrieveButton = new JButton("Retrieve");
            dateFormat = DateFormat.getDateTimeInstance(1, 1);
            this.retrieveLabel = new JLabel("Retrieved: " + dateFormat.format(new Date()));
            this.retrieveButton.addActionListener(this);
            jPanel = null;
            if (this.is600 && this.isSdh) {
                jPanel = new JPanel(new FlowLayout());
                this.rbGroup = new ButtonGroup();
                this.au4Rb = new JRadioButton("SDH-AU4");
                this.au4Rb.setActionCommand("SDH-AU4");
                this.oldAction = "SDH-AU4";
                this.au4Rb.setSelected(true);
                this.au4Rb.addActionListener(this);
                this.rbGroup.add(this.au4Rb);
                this.au3Rb = new JRadioButton("SDH-AU3");
                this.au3Rb.setActionCommand("SDH-AU3");
                this.au3Rb.addActionListener(this);
                this.rbGroup.add(this.au3Rb);
            }
            this.tableModel = new SquelchTableModel(this.blsrModel);
            this.utable = new UTable(null);
            this.utable.addMouseListener((MouseListener)this);
            this.utable.setAutoResizeMode(4);
            this.utable.setColumnModel((TableColumnModel)new SquelchTblColumnModel());
            this.utable.setTableHeader((JTableHeader)new SquelchTblHeader((SquelchTblColumnModel)this.utable.getColumnModel()));
            this.utable.setModel((TableModel)this.tableModel);
            this.setTable((JTable)this.utable);
            this.setAdapter(new TableModelAdapter((TableModel)this.tableModel, (JTable)this.utable));
            this.utable.setCellSelectionEnabled(true);
            ((DefaultTableCellRenderer)this.utable.getDefaultRenderer(JLabel.class)).setHorizontalAlignment(0);
            squelchTblColumnModel = (SquelchTblColumnModel)this.utable.getColumnModel();
            for (n = 0; n < squelchTblColumnModel.getColumnCount(); ++n) {
                squelchTblColumnModel.getColumn(n).setCellRenderer(new SquelchTableCellRenderer());
            }
            n = this.blsrModel.getBlsrProvision().getWestEntityIndex();
            int n2 = this.blsrModel.getBlsrProvision().getEastEntityIndex();
            iEntityModel2 = null;
            iEntityModel = null;
            try {
                iEntityModel2 = this.node.getEntityTable().getEntityModelByIndex(n);
                iEntityModel = this.node.getEntityTable().getEntityModelByIndex(n2);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block9;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        String string = "West: ";
        String string2 = "East: ";
        this.cr.getString((Object)iEntityModel2, "slot ");
        if (iEntityModel2 != null) {
            string = string + this.cr.getString((Object)iEntityModel2, "slot ");
        }
        if (iEntityModel != null) {
            string2 = string2 + this.cr.getString((Object)iEntityModel, "slot ");
        }
        SquelchTblColumnGroup squelchTblColumnGroup = new SquelchTblColumnGroup(string);
        int n = 1;
        int n3 = this.showLo ? 4 : 2;
        for (int i = 0; i < n3; ++i) {
            squelchTblColumnGroup.add(squelchTblColumnModel.getColumn(n++));
        }
        SquelchTblColumnGroup squelchTblColumnGroup2 = new SquelchTblColumnGroup(string2);
        for (int i = 0; i < n3; ++i) {
            squelchTblColumnGroup2.add(squelchTblColumnModel.getColumn(n++));
        }
        squelchTblColumnModel.addColumnGroup(squelchTblColumnGroup);
        squelchTblColumnModel.addColumnGroup(squelchTblColumnGroup2);
        UScrollPane uScrollPane = new UScrollPane((Component)this.utable);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(5, 5));
        ((JComponent)container).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        container.add((Component)uScrollPane, "Center");
        jPanel2.add((Component)this.retrieveButton, "West");
        jPanel2.add((Component)this.retrieveLabel, "East");
        if (this.is600 && this.isSdh) {
            jPanel.add(this.au4Rb);
            jPanel.add(this.au3Rb);
            jPanel2.add((Component)jPanel, "Center");
        }
        container.add((Component)jPanel2, "South");
    }

    @Override
    public void dispose() {
        this.tableModel = null;
        this.utable.removeMouseListener((MouseListener)this);
        this.node.deleteObserver((Observer)this);
        this.blsrModel.deleteObserver((Observer)this);
        if (this.au4Rb != null) {
            this.au4Rb.removeActionListener(this);
        }
        if (this.au3Rb != null) {
            this.au3Rb.removeActionListener(this);
        }
        super.dispose();
    }

    private void initColumnNames() {
        if (!this.showLo) {
            this.columnNames = new String[]{this.terms.getGeneralTerms(0), "Source", "Dest", "Source", "Dest"};
            this.fields = new int[]{0, 1, 3, 5, 7};
        } else {
            this.columnNames = new String[]{this.terms.getGeneralTerms(0), "Source", this.terms.getGeneralTerms(1), "Dest", this.terms.getGeneralTerms(1), "Source", this.terms.getGeneralTerms(1), "Dest", this.terms.getGeneralTerms(1)};
            this.fields = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        ISquelchTblEntry iSquelchTblEntry;
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        int n = this.utable.getSelectedRow();
        int n2 = this.utable.getSelectedColumn();
        if (this.showLo && (n2 == 2 || n2 == 4 || n2 == 6 || n2 == 8) && (iSquelchTblEntry = (ISquelchTblEntry)this.utable.getValueAt(n, n2)) != null) {
            Map map = iSquelchTblEntry.getWestLoSquelchMap();
            Map map2 = iSquelchTblEntry.getEastLoSquelchMap();
            new LoSquelchTableDialog(this, this.node, n, this.blsrModel.getBlsrProvision(), map, map2).show();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    static {
        db = new SDebug("SquelchTableDialog");
    }

    private class SquelchTableCellRenderer
    extends DefaultTableCellRenderer {
        private ImageIcon checkIcon = new ImageIcon(this.getClass().getResource("/images/check_blue.gif"), "X");
        private JLabel emptyLabel = new JLabel("");
        private JLabel dataLabel = new JLabel();

        public SquelchTableCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setIcon(this.checkIcon);
            this.addMouseListener(SquelchTableDialog.this);
            this.dataLabel.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this.emptyLabel;
            }
            switch (SquelchTableDialog.this.fields[n2]) {
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    this.setBackground(bl ? Color.CYAN : Color.WHITE);
                    return this;
                }
            }
            this.dataLabel.setText(object.toString());
            return this.dataLabel;
        }
    }

    class SquelchTableModel
    extends AbstractTableModel {
        private ISquelchTblEntry[] squelchTable = null;

        SquelchTableModel(IBlsrModel iBlsrModel) {
            this.updateTableModel(iBlsrModel);
        }

        private ISquelchTblEntry[] filterAU4AndAU3TableEntry(ISquelchTblEntry[] iSquelchTblEntryArray) {
            if (SquelchTableDialog.this.is600 && SquelchTableDialog.this.isSdh) {
                ArrayList<ISquelchTblEntry> arrayList = new ArrayList<ISquelchTblEntry>();
                for (int i = 0; i < iSquelchTblEntryArray.length; ++i) {
                    ISquelchTblEntry iSquelchTblEntry = iSquelchTblEntryArray[i];
                    if (SquelchTableDialog.this.oldAction.equals("SDH-AU3")) {
                        if (iSquelchTblEntry.getEastStsWidth() == 1 || iSquelchTblEntry.getWestStsWidth() == 1) {
                            arrayList.add(iSquelchTblEntry);
                            continue;
                        }
                        iSquelchTblEntry.setEastStsSource((short)255);
                        iSquelchTblEntry.setEastStsDestination((short)255);
                        iSquelchTblEntry.setWestStsSource((short)255);
                        iSquelchTblEntry.setWestStsDestination((short)255);
                        arrayList.add(iSquelchTblEntry);
                        continue;
                    }
                    if (iSquelchTblEntry.getEastStsWidth() >= 3 || iSquelchTblEntry.getWestStsWidth() >= 3) {
                        arrayList.add(iSquelchTblEntry);
                        continue;
                    }
                    iSquelchTblEntry.setEastStsSource((short)255);
                    iSquelchTblEntry.setEastStsDestination((short)255);
                    iSquelchTblEntry.setWestStsSource((short)255);
                    iSquelchTblEntry.setWestStsDestination((short)255);
                    arrayList.add(iSquelchTblEntry);
                }
                return arrayList.toArray(new ISquelchTblEntry[0]);
            }
            return iSquelchTblEntryArray;
        }

        protected void updateTableModel(IBlsrModel iBlsrModel) {
            this.squelchTable = iBlsrModel != null ? this.filterAU4AndAU3TableEntry(iBlsrModel.getISquelchTbl()) : new ISquelchTblEntry[0];
        }

        @Override
        public String getColumnName(int n) {
            return SquelchTableDialog.this.columnNames[n];
        }

        public Class getColumnClass(int n) {
            if (SquelchTableDialog.this.showLo && (n == 2 || n == 4 || n == 6 || n == 8)) {
                return JLabel.class;
            }
            return super.getColumnClass(n);
        }

        @Override
        public int getColumnCount() {
            return SquelchTableDialog.this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (!SquelchTableDialog.this.isSdh) {
                return this.squelchTable.length;
            }
            if (SquelchTableDialog.this.is600 && SquelchTableDialog.this.oldAction.equals("SDH-AU3")) {
                return this.squelchTable.length;
            }
            return this.squelchTable.length / 3;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            int n3 = n;
            n3 = SquelchTableDialog.this.isSdh ? (SquelchTableDialog.this.is600 && SquelchTableDialog.this.oldAction.equals("SDH-AU3") ? n : n * 3) : n;
            switch (SquelchTableDialog.this.fields[n2]) {
                case 0: {
                    return new Integer(n + 1);
                }
                case 1: {
                    return this.formatNodeId(this.squelchTable[n3].getWestStsSource());
                }
                case 2: {
                    if (this.squelchTable[n3].isWestSrcLoAccessOrCapable()) {
                        return this.squelchTable[n3];
                    }
                    return null;
                }
                case 3: {
                    return this.formatNodeId(this.squelchTable[n3].getWestStsDestination());
                }
                case 4: {
                    if (this.squelchTable[n3].isWestDestLoAccessOrCapable()) {
                        return this.squelchTable[n3];
                    }
                    return null;
                }
                case 5: {
                    return this.formatNodeId(this.squelchTable[n3].getEastStsSource());
                }
                case 6: {
                    if (this.squelchTable[n3].isEastSrcLoAccessOrCapable()) {
                        return this.squelchTable[n3];
                    }
                    return null;
                }
                case 7: {
                    return this.formatNodeId(this.squelchTable[n3].getEastStsDestination());
                }
                case 8: {
                    if (this.squelchTable[n3].isEastDestLoAccessOrCapable()) {
                        return this.squelchTable[n3];
                    }
                    return null;
                }
            }
            return null;
        }

        private Object formatNodeId(short s) {
            return s == 255 ? (Object)null : new Short(s);
        }
    }
}

