/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.VirtualLinksDirector;
import cerent.util.IAsyncObserver;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.job.JobStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class VirtualLinkDataSource
extends AbstractRowDataSource
implements Runnable {
    private static final SDebug db = new SDebug("VirtualLinkDataSource");
    private VirtualLinksDirector vld;
    private INodeModel nm;
    private ArrayList rows = new ArrayList();
    private IAsyncObserver refreshObserver = null;

    public VirtualLinkDataSource(VirtualLinksDirector virtualLinksDirector, INodeModel iNodeModel) {
        this.vld = virtualLinksDirector;
        this.nm = iNodeModel;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getObjectAtRow(int n) {
        try {
            return this.rows.get(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Collection getAllObjects() {
        return new ArrayList(this.rows);
    }

    public void refresh(IAsyncObserver iAsyncObserver) {
        this.refreshObserver = iAsyncObserver;
        new Thread(this).start();
    }

    public void changed() {
        this.fireDataSourceChanged();
    }

    protected Set getVirtualLinks() {
        return this.vld.getVirtualLinks();
    }

    @Override
    public void run() {
        Set set = this.getVirtualLinks();
        if (this.nm != null) {
            this.filterVirtualLinks(set);
            this.updateVirtualLinks(set);
        } else {
            for (IVirtualLinkModel iVirtualLinkModel : set) {
                IEntityModel iEntityModel;
                IEntityModel iEntityModel2 = iVirtualLinkModel.getOrigEntity();
                if (!VirtualLinksDirector.shouldSwap(iEntityModel2, iEntityModel = iVirtualLinkModel.getTermEntity())) continue;
                iVirtualLinkModel.swap();
            }
        }
        this.rows = new ArrayList(set);
        Collections.sort(this.rows);
        this.changed();
        if (this.refreshObserver != null) {
            this.refreshObserver.asyncUpdate((Object)this, JobStatus.JOB_COMPLETE);
        }
    }

    private void filterVirtualLinks(Set set) {
        if (this.nm != null) {
            IIpAddr iIpAddr = this.nm.getIpConfig().getIpAddress();
            if (this.nm.isSecureMode()) {
                iIpAddr = this.nm.getSecureIpConfig().getIpAddress();
            }
            if (iIpAddr == null) {
                return;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                IVirtualLinkModel iVirtualLinkModel = (IVirtualLinkModel)iterator.next();
                if (iVirtualLinkModel.getOrigNode().compareTo((Object)iIpAddr) == 0 || iVirtualLinkModel.getTermNode().compareTo((Object)iIpAddr) == 0) continue;
                iterator.remove();
            }
        }
    }

    private void updateVirtualLinks(Set set) {
        if (this.nm != null) {
            IIpAddr iIpAddr = this.nm.getIpConfig().getIpAddress();
            if (this.nm.isSecureMode()) {
                iIpAddr = this.nm.getSecureIpConfig().getIpAddress();
            }
            if (iIpAddr == null) {
                return;
            }
            for (IVirtualLinkModel iVirtualLinkModel : set) {
                IEntityModel iEntityModel = iVirtualLinkModel.getOrigEntity();
                IEntityModel iEntityModel2 = iVirtualLinkModel.getTermEntity();
                if (iEntityModel == null || iEntityModel2 == null) continue;
                if (VirtualLinksDirector.shouldSwap(iEntityModel, iEntityModel2)) {
                    iVirtualLinkModel.swap();
                    continue;
                }
                if (VirtualLinksDirector.isSwappable(iEntityModel, iEntityModel2) || iVirtualLinkModel.getOrigNode().compareTo((Object)iIpAddr) == 0) continue;
                iVirtualLinkModel.swap();
            }
        }
    }
}

