/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Attribute;
import cerent.cms.model.IWavelength;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Wavelength
implements IWavelength {
    public static final int C_BAND_SELECTOR = 0;
    public static final int L_BAND_SELECTOR = 1;
    public static final int ALL_BANDS_SELECTOR = 2;
    public static final int ODD_CHANNELS_SELECTOR = 0;
    public static final int EVEN_CHANNELS_SELECTOR = 1;
    public static final int ALL_CHANNELS_SELECTOR = 2;
    public static final int CHANNELS_32 = 32;
    public static final int CHANNELS_40 = 40;
    public static final int CHANNELS_80 = 80;
    private static final List<Attribute> ochncCWavelengthAttrs = new LinkedList<Attribute>();
    private static final List<Attribute> ochncLWavelengthAttrs;
    private static final List<Attribute> ochncCEWavelengthAttrs;
    private static final List<Attribute> cOddWavelengthAttrs;
    private static final List<Attribute> cEvenWavelengthAttrs;
    private static final Attribute cMaintenanceWave;
    private static final List<Attribute> lOddWavelengthAttrs;
    private static final List<Attribute> lEvenWavelengthAttrs;
    private static final Attribute lMaintenanceWave;
    private static Attribute[] c80Attrs;
    private static final List<Attribute> cwdmWavelengthAttrs;
    private static final List<Attribute> reachSpecWavelengthAttrs;
    private static final Attribute FirstTunableWLAttr;
    public static final Attribute UnknownWLAttr;
    private static final Attribute AutoprovWLAttr;
    private static final Set<Attribute> allWavelengthsAttrs;
    private static final Set<Attribute> allDwdmWavelengthsAttrs;
    private static final Map<Integer, Integer> crsLambdas;

    private Wavelength() {
    }

    public static String getWavelengthStringFromWavelength(int n) {
        if (n == AutoprovWLAttr.getIntValue()) {
            return AutoprovWLAttr.toString();
        }
        String string = null;
        Iterator<Attribute> iterator = allWavelengthsAttrs.iterator();
        while (string == null && iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (attribute.getIntValue() != n) continue;
            string = attribute.toString();
        }
        return string == null ? "UNKNOWN" : string;
    }

    public static Double getNumericWavelength(int n) {
        if (AutoprovWLAttr.getIntValue() == n) {
            return 0.0;
        }
        return Double.valueOf(Wavelength.getWavelengthStringFromWavelength(n).replace(" nm", ""));
    }

    public static int getWavelengthFromWavelengthString(String string) {
        if (AutoprovWLAttr.toString().equals(string)) {
            return AutoprovWLAttr.getIntValue();
        }
        int n = 174;
        Iterator<Attribute> iterator = allWavelengthsAttrs.iterator();
        while (n == 174 && iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (!attribute.toString().equals(string)) continue;
            n = attribute.getIntValue();
        }
        return n;
    }

    public static Attribute getWlAttribute(int n) {
        Attribute attribute = null;
        Iterator<Attribute> iterator = allWavelengthsAttrs.iterator();
        Attribute attribute2 = null;
        while (attribute == null && iterator.hasNext()) {
            attribute2 = iterator.next();
            if (attribute2.getIntValue() != n) continue;
            attribute = attribute2;
        }
        if (attribute == null) {
            attribute = FirstTunableWLAttr;
        }
        return attribute;
    }

    public static Attribute getCMaintenanceWlAttribute() {
        return cMaintenanceWave;
    }

    public static Attribute getLMaintenanceWlAttribute() {
        return lMaintenanceWave;
    }

    public static Attribute[] getDwdmWavelengthAttrs() {
        Attribute[] attributeArray = allDwdmWavelengthsAttrs.toArray(new Attribute[0]);
        Arrays.sort(attributeArray, new AttrSorter());
        return attributeArray;
    }

    public static Attribute[] getAllWavelengthAttrs(boolean bl) {
        Attribute[] attributeArray = allWavelengthsAttrs.toArray(new Attribute[0]);
        Arrays.sort(attributeArray, new AttrSorter());
        if (bl) {
            attributeArray = Wavelength.addZeroAttribute(attributeArray);
        }
        return attributeArray;
    }

    private static Attribute[] getOchncCWavelengthAttrs(int n) {
        if (n == 40) {
            return ochncCWavelengthAttrs.toArray(new Attribute[0]);
        }
        if (n == 32) {
            Attribute[] attributeArray = new Attribute[32];
            for (int i = 0; i < 8; ++i) {
                System.arraycopy(ochncCWavelengthAttrs.toArray(new Attribute[0]), 4 * i + i, attributeArray, 4 * i, 4);
            }
            return attributeArray;
        }
        if (n == 80) {
            return Wavelength.getC80WlAttrs();
        }
        return new Attribute[0];
    }

    private static Attribute[] getOchncCEWavelengthAttrs(int n) {
        if (n == 40) {
            return ochncCEWavelengthAttrs.toArray(new Attribute[0]);
        }
        if (n == 32) {
            Attribute[] attributeArray = new Attribute[32];
            for (int i = 0; i < 8; ++i) {
                System.arraycopy(ochncCEWavelengthAttrs.toArray(new Attribute[0]), 4 * i + i, attributeArray, 4 * i, 4);
            }
            return attributeArray;
        }
        if (n == 80) {
            return Wavelength.getC80WlAttrs();
        }
        return new Attribute[0];
    }

    private static Attribute[] getC80WlAttrs() {
        if (c80Attrs == null) {
            LinkedList<Attribute> linkedList = new LinkedList<Attribute>();
            linkedList.addAll(ochncCEWavelengthAttrs);
            linkedList.addAll(ochncCWavelengthAttrs);
            c80Attrs = linkedList.toArray(new Attribute[0]);
            Arrays.sort(c80Attrs, new AttrSorter());
        }
        return c80Attrs;
    }

    private static Attribute[] getOchncLWavelengthAttrs(int n) {
        if (n == 40) {
            return ochncLWavelengthAttrs.toArray(new Attribute[0]);
        }
        if (n == 32) {
            Attribute[] attributeArray = new Attribute[32];
            System.arraycopy(ochncLWavelengthAttrs.toArray(new Attribute[0]), 8, attributeArray, 0, 32);
            return attributeArray;
        }
        return new Attribute[0];
    }

    public static Attribute[] getWavelengthAttrs(int n, int n2, boolean bl) {
        if (n == 0) {
            if (n2 == 0) {
                return bl ? Wavelength.addZeroAttribute(cOddWavelengthAttrs.toArray(new Attribute[0])) : cOddWavelengthAttrs.toArray(new Attribute[0]);
            }
            if (n2 == 1) {
                return bl ? Wavelength.addZeroAttribute(cEvenWavelengthAttrs.toArray(new Attribute[0])) : cEvenWavelengthAttrs.toArray(new Attribute[0]);
            }
        } else if (n == 1) {
            if (n2 == 0) {
                return bl ? Wavelength.addZeroAttribute(lOddWavelengthAttrs.toArray(new Attribute[0])) : lOddWavelengthAttrs.toArray(new Attribute[0]);
            }
            if (n2 == 1) {
                return bl ? Wavelength.addZeroAttribute(lEvenWavelengthAttrs.toArray(new Attribute[0])) : lEvenWavelengthAttrs.toArray(new Attribute[0]);
            }
        }
        return new Attribute[0];
    }

    public static Attribute[] getWavelengthAttrs(int n, int n2, int n3, boolean bl) {
        if (n == 0) {
            if (n3 == 80) {
                return Wavelength.wavelengthAttrs(Wavelength.getC80WlAttrs(), bl);
            }
            if (n2 == 0) {
                return Wavelength.wavelengthAttrs(Wavelength.getOchncCWavelengthAttrs(n3), bl);
            }
            if (n2 == 1) {
                return Wavelength.wavelengthAttrs(Wavelength.getOchncCEWavelengthAttrs(n3), bl);
            }
        } else if (n == 1) {
            return Wavelength.wavelengthAttrs(Wavelength.getOchncLWavelengthAttrs(n3), bl);
        }
        return Wavelength.getDwdmWavelengthAttrs();
    }

    private static Attribute[] addZeroAttribute(Attribute[] attributeArray) {
        Attribute[] attributeArray2 = new Attribute[attributeArray.length + 1];
        attributeArray2[0] = FirstTunableWLAttr;
        System.arraycopy(attributeArray, 0, attributeArray2, 1, attributeArray.length);
        return attributeArray2;
    }

    private static Attribute[] wavelengthAttrs(Attribute[] attributeArray, boolean bl) {
        int n = bl ? attributeArray.length + 1 : attributeArray.length;
        int n2 = 0;
        Attribute[] attributeArray2 = new Attribute[n];
        if (bl) {
            attributeArray2[0] = cMaintenanceWave;
            ++n2;
        }
        System.arraycopy(attributeArray, 0, attributeArray2, n2, n);
        return attributeArray2;
    }

    private static void putAttribute(List<Attribute> list, int n, String string) {
        Attribute attribute = new Attribute(string, n);
        list.add(attribute);
        allWavelengthsAttrs.add(attribute);
        if (list != cwdmWavelengthAttrs || list != reachSpecWavelengthAttrs) {
            allDwdmWavelengthsAttrs.add(attribute);
        }
    }

    public static int getLambdaLChannelOffset(int n, int n2) {
        Attribute[] attributeArray = Wavelength.getOchncLWavelengthAttrs(n2);
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].getIntValue() != n) continue;
            return i;
        }
        return -1;
    }

    public static int getLambdaCChannelOffset(int n, int n2) {
        Attribute[] attributeArray = Wavelength.getOchncCWavelengthAttrs(n2);
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].getIntValue() != n) continue;
            return i;
        }
        return -1;
    }

    public static int getLambdaCEChannelOffset(int n, int n2) {
        Attribute[] attributeArray = Wavelength.getOchncCEWavelengthAttrs(n2);
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].getIntValue() != n) continue;
            return i;
        }
        return -1;
    }

    public static Attribute getFirstTunableWLAttr() {
        return FirstTunableWLAttr;
    }

    public static String getBandString(Attribute attribute) {
        if (Wavelength.isCBandLambda(attribute)) {
            return "C";
        }
        if (Wavelength.isLBandLambda(attribute)) {
            return "L";
        }
        return "";
    }

    public static String getParityString(Attribute attribute) {
        if (Wavelength.isOddLambda(attribute)) {
            return "odd";
        }
        if (Wavelength.isEvenLambda(attribute)) {
            return "even";
        }
        return "";
    }

    public static String getWideWL(Attribute attribute) {
        String string = attribute.toString();
        if (FirstTunableWLAttr != attribute) {
            string = string + " (" + Wavelength.getBandString(attribute) + "-Band, " + Wavelength.getParityString(attribute) + ")";
        }
        return string;
    }

    public static Attribute[] getCwdmWavelengthAttrs(boolean bl) {
        return bl ? Wavelength.addZeroAttribute(cwdmWavelengthAttrs.toArray(new Attribute[0])) : cwdmWavelengthAttrs.toArray(new Attribute[0]);
    }

    public static boolean isEvenLambda(Attribute attribute) {
        return cEvenWavelengthAttrs.contains(attribute) || lEvenWavelengthAttrs.contains(attribute);
    }

    public static boolean isOddLambda(Attribute attribute) {
        return cOddWavelengthAttrs.contains(attribute) || lOddWavelengthAttrs.contains(attribute);
    }

    public static boolean isCBandLambda(Attribute attribute) {
        return cOddWavelengthAttrs.contains(attribute) || cEvenWavelengthAttrs.contains(attribute);
    }

    public static boolean isLBandLambda(Attribute attribute) {
        return lOddWavelengthAttrs.contains(attribute) || lEvenWavelengthAttrs.contains(attribute);
    }

    public static int getLambdaFromLabel(String string) {
        if (!string.endsWith(" nm")) {
            string = string + " nm";
        }
        for (Attribute attribute : allWavelengthsAttrs) {
            if (!attribute.toString().equals(string)) continue;
            return attribute.getIntValue();
        }
        return 174;
    }

    public static int getLambdaFromCrsLambdaId(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 174;
        }
        if (crsLambdas.containsKey(n)) {
            return crsLambdas.get(n);
        }
        return 174;
    }

    public static int getCrsLambdaIdFromLambda(int n) {
        if (crsLambdas.containsValue(n)) {
            for (Map.Entry<Integer, Integer> entry : crsLambdas.entrySet()) {
                if (entry.getValue() != n) continue;
                return entry.getKey();
            }
        }
        return -1;
    }

    static {
        ochncCEWavelengthAttrs = new LinkedList<Attribute>();
        ochncLWavelengthAttrs = new LinkedList<Attribute>();
        cOddWavelengthAttrs = new LinkedList<Attribute>();
        cEvenWavelengthAttrs = new LinkedList<Attribute>();
        lOddWavelengthAttrs = new LinkedList<Attribute>();
        lEvenWavelengthAttrs = new LinkedList<Attribute>();
        cwdmWavelengthAttrs = new LinkedList<Attribute>();
        reachSpecWavelengthAttrs = new LinkedList<Attribute>();
        FirstTunableWLAttr = new Attribute("First Tunable Wavelength", 0);
        UnknownWLAttr = new Attribute("UNKNOWN", 174);
        AutoprovWLAttr = new Attribute("AUTOPROV", 0);
        allWavelengthsAttrs = new TreeSet<Attribute>();
        allDwdmWavelengthsAttrs = new TreeSet<Attribute>();
        cMaintenanceWave = new Attribute("maintenance", 82);
        lMaintenanceWave = new Attribute("maintenance", 82);
        crsLambdas = new HashMap<Integer, Integer>();
        Wavelength.putAttribute(ochncCWavelengthAttrs, 1, "1530.33 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 2, "1531.12 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 3, "1531.90 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 4, "1532.68 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 88, "1533.47 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 5, "1534.25 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 6, "1535.04 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 7, "1535.82 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 8, "1536.61 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 94, "1537.40 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 9, "1538.19 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 10, "1538.98 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 11, "1539.77 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 12, "1540.56 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 100, "1541.35 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 13, "1542.14 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 14, "1542.94 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 15, "1543.73 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 16, "1544.53 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 106, "1545.32 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 17, "1546.12 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 18, "1546.92 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 19, "1547.72 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 20, "1548.51 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 112, "1549.32 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 21, "1550.12 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 22, "1550.92 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 23, "1551.72 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 24, "1552.52 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 118, "1553.33 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 25, "1554.13 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 26, "1554.94 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 27, "1555.75 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 28, "1556.55 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 124, "1557.36 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 29, "1558.17 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 30, "1558.98 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 31, "1559.79 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 32, "1560.61 nm");
        Wavelength.putAttribute(ochncCWavelengthAttrs, 170, "1561.42 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 84, "1530.72 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 85, "1531.51 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 86, "1532.29 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 87, "1533.07 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 89, "1533.86 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 90, "1534.64 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 91, "1535.43 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 92, "1536.22 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 93, "1537.00 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 95, "1537.79 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 96, "1538.58 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 97, "1539.37 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 98, "1540.16 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 99, "1540.95 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 101, "1541.75 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 102, "1542.54 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 103, "1543.33 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 104, "1544.13 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 105, "1544.92 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 107, "1545.72 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 108, "1546.52 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 109, "1547.32 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 110, "1548.11 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 111, "1548.91 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 113, "1549.72 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 114, "1550.52 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 115, "1551.32 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 116, "1552.12 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 117, "1552.93 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 119, "1553.73 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 120, "1554.54 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 121, "1555.34 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 122, "1556.15 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 123, "1556.96 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 125, "1557.77 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 126, "1558.58 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 127, "1559.39 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 128, "1560.20 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 129, "1561.01 nm");
        Wavelength.putAttribute(ochncCEWavelengthAttrs, 171, "1561.83 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 131, "1571.24 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 133, "1572.06 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 135, "1572.89 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 137, "1573.71 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 139, "1574.54 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 141, "1575.37 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 143, "1576.20 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 145, "1577.03 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 34, "1577.86 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 36, "1578.69 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 38, "1579.52 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 40, "1580.35 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 42, "1581.18 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 44, "1582.02 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 46, "1582.85 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 48, "1583.69 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 50, "1584.53 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 52, "1585.36 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 54, "1586.20 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 56, "1587.04 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 58, "1587.88 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 60, "1588.73 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 62, "1589.57 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 64, "1590.41 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 66, "1591.26 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 68, "1592.10 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 70, "1592.95 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 72, "1593.79 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 147, "1594.64 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 149, "1595.49 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 151, "1596.34 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 153, "1597.19 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 155, "1598.04 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 157, "1598.89 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 159, "1599.75 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 161, "1600.60 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 163, "1601.46 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 165, "1602.31 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 167, "1603.17 nm");
        Wavelength.putAttribute(ochncLWavelengthAttrs, 169, "1604.03 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 82, "1529.55 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 1, "1530.33 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 2, "1531.12 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 3, "1531.90 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 4, "1532.68 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 88, "1533.47 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 5, "1534.25 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 6, "1535.04 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 7, "1535.82 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 8, "1536.61 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 94, "1537.40 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 9, "1538.19 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 10, "1538.98 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 11, "1539.77 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 12, "1540.56 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 100, "1541.35 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 13, "1542.14 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 14, "1542.94 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 15, "1543.73 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 16, "1544.53 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 106, "1545.32 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 17, "1546.12 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 18, "1546.92 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 19, "1547.72 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 20, "1548.51 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 112, "1549.32 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 21, "1550.12 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 22, "1550.92 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 23, "1551.72 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 24, "1552.52 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 118, "1553.33 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 25, "1554.13 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 26, "1554.94 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 27, "1555.75 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 28, "1556.55 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 124, "1557.36 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 29, "1558.17 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 30, "1558.98 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 31, "1559.79 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 32, "1560.61 nm");
        Wavelength.putAttribute(cOddWavelengthAttrs, 170, "1561.42 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 83, "1529.94 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 84, "1530.72 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 85, "1531.51 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 86, "1532.29 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 87, "1533.07 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 89, "1533.86 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 90, "1534.64 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 91, "1535.43 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 92, "1536.22 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 93, "1537.00 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 95, "1537.79 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 96, "1538.58 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 97, "1539.37 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 98, "1540.16 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 99, "1540.95 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 101, "1541.75 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 102, "1542.54 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 103, "1543.33 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 104, "1544.13 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 105, "1544.92 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 107, "1545.72 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 108, "1546.52 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 109, "1547.32 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 110, "1548.11 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 111, "1548.91 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 113, "1549.72 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 114, "1550.52 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 115, "1551.32 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 116, "1552.12 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 117, "1552.93 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 119, "1553.73 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 120, "1554.54 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 121, "1555.34 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 122, "1556.15 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 123, "1556.96 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 125, "1557.77 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 126, "1558.58 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 127, "1559.39 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 128, "1560.20 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 129, "1561.01 nm");
        Wavelength.putAttribute(cEvenWavelengthAttrs, 171, "1561.83 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 130, "1570.83 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 132, "1571.65 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 134, "1572.48 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 136, "1573.30 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 138, "1574.13 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 140, "1574.95 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 142, "1575.78 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 144, "1576.61 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 33, "1577.44 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 35, "1578.27 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 37, "1579.10 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 39, "1579.93 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 41, "1580.77 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 43, "1581.60 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 45, "1582.44 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 47, "1583.27 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 49, "1584.11 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 51, "1584.95 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 53, "1585.78 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 55, "1586.62 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 57, "1587.46 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 59, "1588.30 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 61, "1589.15 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 63, "1589.99 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 65, "1590.83 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 67, "1591.68 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 69, "1592.52 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 71, "1593.37 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 146, "1594.22 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 148, "1595.06 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 150, "1595.91 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 152, "1596.76 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 154, "1597.62 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 156, "1598.47 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 158, "1599.32 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 160, "1600.17 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 162, "1601.03 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 164, "1601.88 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 166, "1602.74 nm");
        Wavelength.putAttribute(lOddWavelengthAttrs, 168, "1603.60 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 131, "1571.24 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 133, "1572.06 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 135, "1572.89 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 137, "1573.71 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 139, "1574.54 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 141, "1575.37 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 143, "1576.20 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 145, "1577.03 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 34, "1577.86 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 36, "1578.69 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 38, "1579.52 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 40, "1580.35 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 42, "1581.18 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 44, "1582.02 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 46, "1582.85 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 48, "1583.69 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 50, "1584.53 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 52, "1585.36 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 54, "1586.20 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 56, "1587.04 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 58, "1587.88 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 60, "1588.73 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 62, "1589.57 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 64, "1590.41 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 66, "1591.26 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 68, "1592.10 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 70, "1592.95 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 72, "1593.79 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 147, "1594.64 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 149, "1595.49 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 151, "1596.34 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 153, "1597.19 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 155, "1598.04 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 157, "1598.89 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 159, "1599.75 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 161, "1600.60 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 163, "1601.46 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 165, "1602.31 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 167, "1603.17 nm");
        Wavelength.putAttribute(lEvenWavelengthAttrs, 169, "1604.03 nm");
        Wavelength.putAttribute(cwdmWavelengthAttrs, 75, "1470 nm");
        Wavelength.putAttribute(cwdmWavelengthAttrs, 76, "1490 nm");
        Wavelength.putAttribute(cwdmWavelengthAttrs, 77, "1510 nm");
        Wavelength.putAttribute(cwdmWavelengthAttrs, 78, "1530 nm");
        Wavelength.putAttribute(cwdmWavelengthAttrs, 74, "1550 nm");
        Wavelength.putAttribute(cwdmWavelengthAttrs, 79, "1570 nm");
        Wavelength.putAttribute(cwdmWavelengthAttrs, 80, "1590 nm");
        Wavelength.putAttribute(cwdmWavelengthAttrs, 81, "1610 nm");
        Wavelength.putAttribute(reachSpecWavelengthAttrs, 172, " 850 nm");
        Wavelength.putAttribute(reachSpecWavelengthAttrs, 73, "1310 nm");
        crsLambdas.put(3, 82);
        crsLambdas.put(4, 83);
        crsLambdas.put(5, 1);
        crsLambdas.put(6, 84);
        crsLambdas.put(7, 2);
        crsLambdas.put(8, 85);
        crsLambdas.put(9, 3);
        crsLambdas.put(10, 86);
        crsLambdas.put(11, 4);
        crsLambdas.put(12, 87);
        crsLambdas.put(13, 88);
        crsLambdas.put(14, 89);
        crsLambdas.put(15, 5);
        crsLambdas.put(16, 90);
        crsLambdas.put(17, 6);
        crsLambdas.put(18, 91);
        crsLambdas.put(19, 7);
        crsLambdas.put(20, 92);
        crsLambdas.put(21, 8);
        crsLambdas.put(22, 93);
        crsLambdas.put(23, 94);
        crsLambdas.put(24, 95);
        crsLambdas.put(25, 9);
        crsLambdas.put(26, 96);
        crsLambdas.put(27, 10);
        crsLambdas.put(28, 97);
        crsLambdas.put(29, 11);
        crsLambdas.put(30, 98);
        crsLambdas.put(31, 12);
        crsLambdas.put(32, 99);
        crsLambdas.put(33, 100);
        crsLambdas.put(34, 101);
        crsLambdas.put(35, 13);
        crsLambdas.put(36, 102);
        crsLambdas.put(37, 14);
        crsLambdas.put(38, 103);
        crsLambdas.put(39, 15);
        crsLambdas.put(40, 104);
        crsLambdas.put(41, 16);
        crsLambdas.put(42, 105);
        crsLambdas.put(43, 106);
        crsLambdas.put(44, 107);
        crsLambdas.put(45, 17);
        crsLambdas.put(46, 108);
        crsLambdas.put(47, 18);
        crsLambdas.put(48, 109);
        crsLambdas.put(49, 19);
        crsLambdas.put(50, 110);
        crsLambdas.put(51, 20);
        crsLambdas.put(52, 111);
        crsLambdas.put(53, 112);
        crsLambdas.put(54, 113);
        crsLambdas.put(55, 21);
        crsLambdas.put(56, 114);
        crsLambdas.put(57, 22);
        crsLambdas.put(58, 115);
        crsLambdas.put(59, 23);
        crsLambdas.put(60, 116);
        crsLambdas.put(61, 24);
        crsLambdas.put(62, 117);
        crsLambdas.put(63, 118);
        crsLambdas.put(64, 119);
        crsLambdas.put(65, 25);
        crsLambdas.put(66, 120);
        crsLambdas.put(67, 26);
        crsLambdas.put(68, 121);
        crsLambdas.put(69, 27);
        crsLambdas.put(70, 122);
        crsLambdas.put(71, 28);
        crsLambdas.put(72, 123);
        crsLambdas.put(73, 124);
        crsLambdas.put(74, 125);
        crsLambdas.put(75, 29);
        crsLambdas.put(76, 126);
        crsLambdas.put(77, 30);
        crsLambdas.put(78, 127);
        crsLambdas.put(79, 31);
        crsLambdas.put(80, 128);
        crsLambdas.put(81, 32);
        crsLambdas.put(82, 129);
        crsLambdas.put(83, 170);
        crsLambdas.put(84, 171);
    }

    public static class AttrSorter
    implements Comparator<Object> {
        @Override
        public int compare(Object object, Object object2) {
            if (!(object instanceof Attribute) || !(object2 instanceof Attribute)) {
                throw new ClassCastException("Cannot Cast to Attribute");
            }
            return ((Attribute)object).getKey().compareTo(((Attribute)object2).getKey());
        }
    }
}

