/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeType;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NetworkViewController;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.ExtensionFileFilter;
import cerent.util.gui.PersistentFileChooserPanel;
import com.sun.org.apache.xerces.internal.dom.DocumentImpl;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLgenerate
extends AbstractPane
implements ActionListener {
    private static final SDebug db = new NetworkViewController.RvcDebug();
    private JButton OKbutton;
    private JButton CancelButton;
    private JButton HelpButton;
    private int len = Network.instance().getAllElements().size();
    private JCheckBox[] CheckBoxList = new JCheckBox[this.len + 1];
    private JCheckBox SelectAll = new JCheckBox("Select All");
    private int[] check = new int[this.len + 1];
    private INetElement ne = null;
    private Iterator itr;
    private Document xmldoc = new DocumentImpl();
    private JDialog XmlDialog = new JDialog();
    private String fileName = null;
    private String logname = null;
    private JPanel NodeChoserPanelInner;
    private JPanel ButtonsPanel;
    private JPanel SelectXmlPanel;
    private JPanel SelectLogPanel;
    private PersistentFileChooserPanel setupFile;
    private PersistentFileChooserPanel setupLog;

    public XMLgenerate() {
        super("abstractpane");
    }

    public void generateXML() {
        Object object;
        Element element = this.xmldoc.createElement("network");
        this.xmldoc.appendChild(element);
        Collection collection = Network.instance().getAllElements();
        this.itr = collection.iterator();
        this.len = collection.size() + 1;
        this.XmlDialog.setModal(true);
        this.XmlDialog.setTitle("Export Network Information into XML");
        this.XmlDialog.setResizable(false);
        this.XmlDialog.setBounds(600, 350, 550, 400);
        this.NodeChoserPanelInner = new JPanel();
        this.NodeChoserPanelInner.setLayout(new BoxLayout(this.NodeChoserPanelInner, 1));
        this.SelectAll.setBackground(Color.WHITE);
        this.NodeChoserPanelInner.add((Component)this.SelectAll, (Object)this.NodeChoserPanelInner);
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.ne = (INetElement)iterator.next();
            object = this.ne.getNodeModel().getDelegate();
            if (!Feature.provides((INodeModel)object, (Feature)Feature.XML_GENERATE) || !object.getPackageTypeStr().equals(INodeType.PACKAGE_TYPES[3])) continue;
            this.CheckBoxList[n] = new JCheckBox(this.ne.getName());
            this.CheckBoxList[n].setBackground(Color.WHITE);
            this.CheckBoxList[n].setAlignmentX(0.0f);
            this.NodeChoserPanelInner.add((Component)this.CheckBoxList[n], (Object)this.NodeChoserPanelInner);
            this.CheckBoxList[n].addActionListener(this);
            ++n;
        }
        this.len = n;
        if (n == 0) {
            this.SelectAll.setVisible(false);
        }
        this.NodeChoserPanelInner.setBounds(0, 0, 550, 25 * (this.len + 1));
        this.NodeChoserPanelInner.setPreferredSize(new Dimension(100, 25 * (this.len + 1)));
        object = new JScrollPane(this.NodeChoserPanelInner);
        this.NodeChoserPanelInner.setBackground(Color.WHITE);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.setBounds(6, 5, 530, 175);
        jPanel.add((Component)object);
        jPanel.setBorder(BorderFactory.createTitledBorder("Select Nodes to Export to XML (only compatible nodes in the network are shown)"));
        this.XmlDialog.add(jPanel);
        this.SelectXmlPanel = new JPanel(new FlowLayout(0, 1, 1));
        this.SelectXmlPanel.setBorder(BorderFactory.createTitledBorder("Export XML to"));
        this.setupFile = new PersistentFileChooserPanel(null, true, "", "", 10);
        this.setupFile.setFileFilter((FileFilter)new ExtensionFileFilter("xml", "XML files"));
        this.setupFile.initCombo();
        this.setupFile.setEditable(false);
        this.SelectXmlPanel.add((Component)this.setupFile);
        this.SelectXmlPanel.setBounds(6, 185, 530, 70);
        this.SelectLogPanel = new JPanel(new FlowLayout(0, 1, 1));
        this.SelectLogPanel.setBorder(BorderFactory.createTitledBorder("Save Log to"));
        this.setupLog = new PersistentFileChooserPanel(null, true, "", "", 10);
        this.setupLog.setFileFilter((FileFilter)new ExtensionFileFilter("log", "Log files"));
        this.setupLog.initCombo();
        this.setupLog.setEditable(false);
        this.SelectLogPanel.add((Component)this.setupLog);
        this.SelectLogPanel.setBounds(6, 260, 530, 70);
        this.SelectAll.addActionListener(this);
        this.ButtonsPanel = new JPanel();
        this.ButtonsPanel.setLayout(new BoxLayout(this.ButtonsPanel, 0));
        this.OKbutton = new JButton(" OK ");
        this.CancelButton = new JButton("Cancel");
        CSHelpID cSHelpID = this.getHelpID();
        this.HelpButton = new JButton("Help");
        this.ButtonsPanel.add(Box.createHorizontalGlue());
        this.ButtonsPanel.add(this.OKbutton);
        this.ButtonsPanel.add(Box.createHorizontalStrut(2));
        this.ButtonsPanel.add(this.CancelButton);
        this.ButtonsPanel.add(Box.createHorizontalStrut(2));
        if (cSHelpID != null) {
            this.ButtonsPanel.add(new CSHelpButton(cSHelpID));
        }
        this.OKbutton.setEnabled(false);
        this.ButtonsPanel.setBounds(6, 325, 530, 50);
        this.XmlDialog.add(this.SelectXmlPanel);
        this.XmlDialog.add(this.SelectLogPanel);
        this.XmlDialog.add(this.ButtonsPanel);
        this.OKbutton.addActionListener(this);
        this.CancelButton.addActionListener(this);
        this.HelpButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setVisible(false);
        this.XmlDialog.add(jPanel2);
        this.XmlDialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block23: {
            Object object = actionEvent.getSource();
            if (object == this.OKbutton) {
                String string;
                Closeable closeable;
                block22: {
                    int n;
                    this.fileName = this.setupFile.getSelectedFileName();
                    this.logname = this.setupLog.getSelectedFileName();
                    if (this.fileName.equals("")) {
                        ErrorMsg.displayDetailed((Component)this.XmlDialog, NEMC.EID_XML_NAME_NULL, "");
                        return;
                    }
                    if (this.logname.equals("")) {
                        ErrorMsg.displayDetailed((Component)this.XmlDialog, NEMC.EID_LOG_NAME_NULL, "");
                        return;
                    }
                    for (n = 0; n < this.len; ++n) {
                        this.check[n] = this.CheckBoxList[n].isSelected() ? 1 : 0;
                    }
                    this.XmlDialog.dispose();
                    n = 0;
                    if (!this.fileName.endsWith(".xml")) {
                        this.fileName = this.fileName + ".xml";
                    }
                    if (!this.logname.endsWith(".log")) {
                        this.logname = this.logname + ".log";
                    }
                    FileWriter fileWriter = null;
                    try {
                        fileWriter = new FileWriter(this.logname);
                        closeable = new BufferedWriter(fileWriter);
                        while (this.itr.hasNext()) {
                            this.ne = (INetElement)this.itr.next();
                            if (!this.ne.isInited()) {
                                if (this.check[n] != 1) continue;
                                ((Writer)closeable).write("Exporting node " + this.ne.getName() + "\n");
                                ((Writer)closeable).write("Failed. Node not initialised\n");
                                continue;
                            }
                            string = this.ne.getNodeModel().getDelegate();
                            if (!Feature.provides((INodeModel)string, (Feature)Feature.XML_GENERATE) || !string.getPackageTypeStr().equals(INodeType.PACKAGE_TYPES[3])) continue;
                            if (this.check[n] == 0) {
                                ++n;
                                continue;
                            }
                            ((Writer)closeable).write("Exporting node " + this.ne.getName() + "\n");
                            string.getNodeInfo(this.xmldoc);
                            ++n;
                            ((Writer)closeable).write("Success\n");
                        }
                        ((BufferedWriter)closeable).close();
                    }
                    catch (IOException iOException) {
                        if (!db.on()) break block22;
                        SDebug.printStackTrace((Throwable)iOException);
                    }
                }
                try {
                    string = "mp-schema.dtd";
                    closeable = new FileOutputStream(this.fileName);
                    OutputFormat outputFormat = new OutputFormat("XML", "ISO-8859-1", true);
                    outputFormat.setIndent(1);
                    outputFormat.setIndenting(true);
                    outputFormat.setDoctype(null, string);
                    XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)closeable, outputFormat);
                    xMLSerializer.asDOMSerializer();
                    xMLSerializer.serialize(this.xmldoc.getDocumentElement());
                    ((FileOutputStream)closeable).close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)fileNotFoundException);
                    }
                    break block23;
                }
                catch (IOException iOException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)iOException);
                    }
                    break block23;
                }
            }
            if (object == this.CancelButton) {
                this.XmlDialog.dispose();
            } else if (object == this.SelectAll) {
                boolean bl = this.SelectAll.isSelected();
                for (int i = 0; i < this.len; ++i) {
                    this.CheckBoxList[i].setSelected(bl);
                }
                this.OKbutton.setEnabled(bl);
            } else {
                boolean bl = this.CheckBoxList[0].isSelected();
                boolean bl2 = this.CheckBoxList[0].isSelected();
                for (int i = 1; i < this.len; ++i) {
                    bl2 = bl2 || this.CheckBoxList[i].isSelected();
                    bl = bl && this.CheckBoxList[i].isSelected();
                }
                this.OKbutton.setEnabled(bl2);
                this.SelectAll.setSelected(bl);
            }
        }
    }

    @Override
    public void leavingPage() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void enteringPage() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void refresh() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.XMLgenerate;
    }
}

