/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aic;

import cerent.cms.ui.aic.AicMaintVWRowObject;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class AicMaintVWColumnRenderer
extends AbstractColumnRenderer {
    public static final int IP = -1;
    public static final int NODE = -2;
    private JLabel label;
    private JCheckBox checkbox;
    private int mode;
    private boolean bgChecked = false;
    private static EmptyBorder emptyBorder = new EmptyBorder(0, 2, 0, 2);

    public AicMaintVWColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(this.alignment);
        this.label.setOpaque(true);
        this.label.setBorder(emptyBorder);
        if (n >= 0) {
            this.checkbox = new JCheckBox("", true);
            this.checkbox.setHorizontalAlignment(this.alignment);
        }
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string;
        if (!this.bgChecked) {
            this.label.setBackground(jTable.getBackground());
            if (this.checkbox != null) {
                this.checkbox.setBackground(jTable.getBackground());
            }
            this.bgChecked = true;
        }
        JLabel jLabel = this.label;
        AicMaintVWRowObject aicMaintVWRowObject = (AicMaintVWRowObject)object;
        switch (this.mode) {
            case -1: {
                string = aicMaintVWRowObject.getPrintableIpAddress();
                break;
            }
            case -2: {
                string = aicMaintVWRowObject.node;
                break;
            }
            default: {
                if (aicMaintVWRowObject.vwStatus[this.mode]) {
                    return this.checkbox;
                }
                string = "";
            }
        }
        this.label.setText(string);
        return this.label;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        String string;
        int n2 = 100;
        boolean bl = true;
        int n3 = 0;
        switch (n) {
            case -1: {
                string = "Node Address";
                break;
            }
            case -2: {
                string = "Node";
                break;
            }
            default: {
                string = "Virtual Wire " + (n + 1);
            }
        }
        return new AicMaintVWColumnRenderer(n, string, n2, bl, n3);
    }

    @Override
    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        AicMaintVWRowObject aicMaintVWRowObject = (AicMaintVWRowObject)object;
        AicMaintVWRowObject aicMaintVWRowObject2 = (AicMaintVWRowObject)object2;
        switch (this.mode) {
            case -1: {
                n2 = aicMaintVWRowObject.ipCompareTo(aicMaintVWRowObject2);
                break;
            }
            case -2: {
                n2 = aicMaintVWRowObject.node.compareTo(aicMaintVWRowObject2.node);
                break;
            }
            default: {
                if (aicMaintVWRowObject.vwStatus[this.mode] == aicMaintVWRowObject2.vwStatus[this.mode]) break;
                n2 = aicMaintVWRowObject.vwStatus[this.mode] ? -1 : 1;
            }
        }
        return n2;
    }
}

