/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aic;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.OneNodeStatus;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.RoDataSourceControl;
import cerent.cms.ui.aic.AicMaintVWRowObject;
import cerent.util.IObservableManager;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;

public class AicMaintVWDataSource
extends AbstractRowDataSource
implements RoDataSourceControl {
    private static final SDebug db = new SDebug("VWDataSrc");
    private ArrayList vwList = new ArrayList();
    private INodeModel nodeModel;

    public AicMaintVWDataSource(IModel iModel) {
        if (db.on()) {
            db.println("<init>");
        }
        this.nodeModel = iModel.getNodeModel();
    }

    public void refreshFromModel() throws Exception {
        if (AicMaintVWDataSource.db.on) {
            db.println("refreshing");
        }
        this.vwList.clear();
        OneNodeStatus[] oneNodeStatusArray = this.nodeModel.getNodeStatusList();
        for (int i = 0; i < oneNodeStatusArray.length; ++i) {
            String string;
            if (db.on()) {
                db.println("On statusList, found nodeId " + oneNodeStatusArray[i].nodeId);
            }
            if ((string = this.getNodeName(oneNodeStatusArray[i].nodeId)) == null) continue;
            this.vwList.add(new AicMaintVWRowObject(string, oneNodeStatusArray[i].nodeId, this.nodeModel.getVWMasks(), oneNodeStatusArray[i].virtualWire));
        }
        this.fireDataSourceChanged();
    }

    public void refreshFromModel(int n) throws Exception {
        this.refreshFromModel();
    }

    public void disposeDataSource() {
        if (this.vwList != null) {
            this.vwList.clear();
        }
    }

    public IObservableManager getObservableManager() {
        return null;
    }

    public Object getObjectAtRow(int n) {
        return this.vwList.get(n);
    }

    public int getRowCount() {
        return this.vwList.size();
    }

    public Collection getAllObjects() {
        return this.vwList;
    }

    private String getNodeName(int n) {
        String string = null;
        try {
            String string2 = InetUtil.makeDottedString(n);
            NetElement netElement = (NetElement)Network.instance().findNetElemByIp(string2);
            if (netElement != null) {
                string = netElement.getNodeModel().getName();
            }
        }
        catch (AbstractCmsCommFailException abstractCmsCommFailException) {
            db.println("Caught " + (Object)((Object)abstractCmsCommFailException));
        }
        return string;
    }
}

