/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.apc;

import cerent.cms.model.Feature;
import cerent.cms.model.IApcDomainItem;
import cerent.cms.model.IDwdmApcModels;
import cerent.cms.model.INodeModel;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.topo.Network;
import cerent.cms.ui.apc.ApcDomainNode;
import cerent.cms.ui.apc.ApcDomainRootNode;
import cerent.cms.ui.apc.ApcDomainSpan;
import cerent.util.KDebug;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class ApcDomainDomainNode
extends ApcDomainNode {
    private int progressState = -1;
    private int apcState = -1;
    private int apcAdminState = -1;
    private IApcDomainItem from;
    private IApcDomainItem to;
    private DefaultMutableTreeNode treeNode;
    private String name;
    private boolean allowOperation = false;
    private int failingNode;
    private ArrayList<IDwdmApcModels> listApcModels = new ArrayList();

    public ApcDomainDomainNode(ApcDomainRootNode apcDomainRootNode, IApcDomainItem[] iApcDomainItemArray, boolean bl) {
        super(apcDomainRootNode);
        IApcDomainItem iApcDomainItem;
        this.allowOperation = bl;
        try {
            if (iApcDomainItemArray.length == 1) {
                iApcDomainItem = iApcDomainItemArray[0];
                INodeModel iNodeModel = Network.instance().getNodeModel(iApcDomainItem.getNodeId());
                if (iNodeModel != null) {
                    IDwdmApcModels iDwdmApcModels = iNodeModel.getIDwdmApcModels();
                    this.listApcModels.add(iDwdmApcModels);
                    if (iApcDomainItem.getSideIn() == 0) {
                        this.apcState = iDwdmApcModels.getApcState((short)iApcDomainItem.getSideOut());
                        this.apcAdminState = iDwdmApcModels.getApcAdminState((short)iApcDomainItem.getSideOut());
                    } else {
                        this.apcState = iDwdmApcModels.getApcState((short)iApcDomainItem.getSideIn());
                        this.apcAdminState = iDwdmApcModels.getApcAdminState((short)iApcDomainItem.getSideIn());
                    }
                }
                new ApcDomainSpan(this, iApcDomainItem, iApcDomainItem);
            } else {
                for (int i = 0; i < iApcDomainItemArray.length; ++i) {
                    IApcDomainItem iApcDomainItem2 = iApcDomainItemArray[i];
                    INodeModel iNodeModel = Network.instance().getNodeModel(iApcDomainItem2.getNodeId());
                    if (this.apcState == -1 && iNodeModel != null && iNodeModel.isInited() && !iNodeModel.isAuthenticationFailed()) {
                        IDwdmApcModels iDwdmApcModels = iNodeModel.getIDwdmApcModels();
                        this.listApcModels.add(iDwdmApcModels);
                        this.failingNode = -1;
                        if (iApcDomainItem2.getSideOut() != 0) {
                            this.apcState = iDwdmApcModels.getApcState((short)iApcDomainItem2.getSideOut());
                            this.apcAdminState = iDwdmApcModels.getApcAdminState((short)iApcDomainItem2.getSideOut());
                            this.progressState = iDwdmApcModels.getDwdmApcModel(iApcDomainItem2.getSideOut()).getApcProgressState();
                            if (iNodeModel.provides(Feature.APC_ABORTED_NODE)) {
                                this.failingNode = iDwdmApcModels.getDwdmApcModel(iApcDomainItem2.getSideOut()).getApcFailingNodeId();
                            }
                        } else if (iApcDomainItem2.getSideIn() != 0) {
                            this.apcState = iDwdmApcModels.getApcState((short)iApcDomainItem2.getSideIn());
                            this.apcAdminState = iDwdmApcModels.getApcAdminState((short)iApcDomainItem2.getSideIn());
                            this.progressState = iDwdmApcModels.getDwdmApcModel(iApcDomainItem2.getSideIn()).getApcProgressState();
                            if (iNodeModel.provides(Feature.APC_ABORTED_NODE)) {
                                this.failingNode = iDwdmApcModels.getDwdmApcModel(iApcDomainItem2.getSideIn()).getApcFailingNodeId();
                            }
                        }
                    }
                    if (i + 1 >= iApcDomainItemArray.length) continue;
                    new ApcDomainSpan(this, iApcDomainItem2, iApcDomainItemArray[i + 1]);
                }
            }
        }
        catch (WrongNodeSide wrongNodeSide) {
            KDebug.printStackTrace((Throwable)wrongNodeSide);
        }
        if (iApcDomainItemArray.length > 0) {
            this.from = iApcDomainItem = iApcDomainItemArray[0];
            this.to = iApcDomainItem = iApcDomainItemArray[iApcDomainItemArray.length - 1];
        }
    }

    @Override
    public int getAPCState() {
        return this.apcState;
    }

    @Override
    public boolean isDomainNode() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isSpan() {
        return false;
    }

    @Override
    public boolean isSpanNode() {
        return false;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = ApcDomainDomainNode.formatApcDomainItem(this.from, this.to);
        } else if (this.from != null && ApcDomainDomainNode.getNodeModel(this.from) == null || this.to != null && ApcDomainDomainNode.getNodeModel(this.to) == null) {
            this.name = ApcDomainDomainNode.formatApcDomainItem(this.from, this.to);
        }
        return this.name;
    }

    public int getAPCAdminState() {
        return this.apcAdminState;
    }

    public void setAPCState(int n) {
        this.apcState = n;
    }

    public void setAPCAdminState(int n) {
        this.apcAdminState = n;
    }

    public void setDefaultMutableTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.treeNode = defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDefaultMutableTreeNode() {
        return this.treeNode;
    }

    public boolean isAllowOperation() {
        return this.allowOperation;
    }

    public void setAllowOperation(boolean bl) {
        this.allowOperation = bl;
    }

    public ArrayList getApcModels() {
        return this.listApcModels;
    }

    public int getAPCProgressState() {
        return this.progressState;
    }

    public void setAPCProgressState(int n) {
        this.progressState = n;
    }

    public int getAPCFailingNodeId() {
        return this.failingNode;
    }

    public void setAPCFailingNodeId(int n) {
        this.failingNode = n;
    }
}

