/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.apc;

import cerent.cms.model.IApcDomainItem;
import cerent.cms.model.INodeModel;
import cerent.cms.topo.Network;
import cerent.cms.ui.DwdmSide;
import java.util.LinkedList;
import java.util.List;

public abstract class ApcDomainNode {
    private ApcDomainNode parent;
    private List<ApcDomainNode> children = new LinkedList<ApcDomainNode>();

    protected ApcDomainNode(ApcDomainNode apcDomainNode) {
        this.parent = apcDomainNode;
        if (apcDomainNode != null) {
            apcDomainNode.addChild(this);
        }
    }

    public String toString() {
        return this.getName();
    }

    protected ApcDomainNode getParent() {
        return this.parent;
    }

    private void addChild(ApcDomainNode apcDomainNode) {
        this.children.add(apcDomainNode);
    }

    public <T extends ApcDomainNode> T[] getChildren(T[] TArray) {
        return (ApcDomainNode[])this.children.toArray(TArray);
    }

    public void clear() {
        this.children.clear();
    }

    public abstract boolean isDomainNode();

    public abstract boolean isSpanNode();

    public abstract boolean isSpan();

    public abstract boolean isRoot();

    public abstract String getName();

    public abstract int getAPCState();

    public ApcDomainNode getDomain() {
        return null;
    }

    public boolean containsNode(INodeModel iNodeModel, int n) {
        for (ApcDomainNode apcDomainNode : this.children) {
            if (!apcDomainNode.containsNode(iNodeModel, n)) continue;
            return true;
        }
        return false;
    }

    public static String formatApcDomainItem(IApcDomainItem iApcDomainItem, IApcDomainItem iApcDomainItem2) {
        StringBuilder stringBuilder = new StringBuilder();
        INodeModel iNodeModel = null;
        INodeModel iNodeModel2 = null;
        if (iApcDomainItem != null) {
            iNodeModel = ApcDomainNode.getNodeModel(iApcDomainItem);
        }
        if (iApcDomainItem2 != null) {
            iNodeModel2 = ApcDomainNode.getNodeModel(iApcDomainItem2);
        }
        if (iNodeModel == null && iNodeModel2 == null) {
            stringBuilder.append(" Unknown ");
            return stringBuilder.toString();
        }
        if (iNodeModel == null) {
            stringBuilder.append(" tcc ? side ?");
        } else {
            stringBuilder.append(iNodeModel.getName());
            if (iNodeModel.isInited()) {
                stringBuilder.append(" side ").append(iApcDomainItem.getSideOut() == 0 ? "?" : DwdmSide.getSideFromOffset(iApcDomainItem.getSideOut()));
            }
            if (iApcDomainItem == iApcDomainItem2) {
                stringBuilder.append(" , ? ");
                return stringBuilder.toString();
            }
        }
        stringBuilder.append(" , ");
        if (iNodeModel2 == null) {
            stringBuilder.append(" tcc ? side ?");
        } else {
            stringBuilder.append(iNodeModel2.getName());
            if (iNodeModel2.isInited()) {
                stringBuilder.append(" side ").append(iApcDomainItem2.getSideIn() == 0 ? "?" : DwdmSide.getSideFromOffset(iApcDomainItem2.getSideIn()));
            }
        }
        return stringBuilder.toString();
    }

    public static INodeModel getNodeModel(IApcDomainItem iApcDomainItem) {
        return Network.instance().getNodeModel(iApcDomainItem.getNodeId());
    }

    public static boolean isStartingNode(IApcDomainItem iApcDomainItem) {
        return iApcDomainItem.getSideIn() == 0;
    }

    public static boolean isTerminatingNode(IApcDomainItem iApcDomainItem) {
        return iApcDomainItem.getSideOut() == 0;
    }
}

