/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.BlsrSpan;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.blsr.BlsrMapLinkCookie;
import cerent.cms.ui.blsr.BlsrMapPort;
import cerent.cms.ui.blsr.BlsrPort;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.network.NetMapLink;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.DetailedMapLinkStyle;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapToolkit;
import java.awt.Font;

public class BlsrMapLink
extends NetMapLink {
    private static final SDebug db = new SDebug("BlsrMapLink");
    private boolean included = false;
    private INetLink netLink;
    private BlsrSpan blsrSpan;
    private ITdmPortModel srcPortModel;
    private ITdmPortModel dstPortModel;
    private INodeModel eastNodeModel;
    private INodeModel westNodeModel;
    private BlsrPort eastBlsrPort;
    private BlsrPort westBlsrPort;

    public BlsrMapLink(MapToolkit mapToolkit, MapNode mapNode, MapNode mapNode2, String string) {
        super(mapToolkit, mapNode, mapNode2, string);
    }

    @Override
    public synchronized void init(Object object, Object object2) {
        super.init(object, object2);
        if (this.getUserObject() instanceof INetLink) {
            this.netLink = (INetLink)this.getUserObject();
        }
        if (this.getUserCookie() instanceof BlsrMapLinkCookie) {
            BlsrMapLinkCookie blsrMapLinkCookie = (BlsrMapLinkCookie)this.getUserCookie();
            this.blsrSpan = blsrMapLinkCookie.getBlsrSpan();
            this.srcPortModel = blsrMapLinkCookie.getSrcPortModel();
            this.dstPortModel = blsrMapLinkCookie.getDstPortModel();
            this.eastNodeModel = blsrMapLinkCookie.getEastNodeModel();
            this.westNodeModel = blsrMapLinkCookie.getWestNodeModel();
            this.eastBlsrPort = blsrMapLinkCookie.getEastBlsrPort();
            this.westBlsrPort = blsrMapLinkCookie.getWestBlsrPort();
        }
        this.setAnnotationFont(new Font("Arial", 0, 12));
        this.setCenterLabel();
    }

    public INetLink getNetLink() {
        return this.netLink;
    }

    public BlsrSpan getBlsrSpan() {
        return this.blsrSpan;
    }

    public ITdmPortModel getSrcPortModel() {
        return this.srcPortModel;
    }

    public ITdmPortModel getDstPortModel() {
        return this.dstPortModel;
    }

    public INodeModel getEastNodeModel() {
        return this.eastNodeModel;
    }

    public INodeModel getWestNodeModel() {
        return this.westNodeModel;
    }

    public BlsrPort getEastBlsrPort() {
        return this.eastBlsrPort;
    }

    public BlsrPort getWestBlsrPort() {
        return this.westBlsrPort;
    }

    @Override
    public String getToolTipText() {
        BlsrNode blsrNode;
        Object object;
        String string = "";
        Object object2 = this.getUserObject();
        if (object2 instanceof BlsrSpan) {
            if (this.blsrSpan.isProtectSpan()) {
                ITdmPortModel iTdmPortModel = this.blsrSpan.getEastProtectPort();
                object = this.blsrSpan.getWestProtectPort();
                blsrNode = this.blsrSpan.getEastSide();
                BlsrNode blsrNode2 = this.blsrSpan.getWestSide();
                String string2 = blsrNode.getNodeModel().getName() + "/";
                string2 = string2 + BlsrMapPort.asSlashSeparatedString(iTdmPortModel, "EP");
                string2 = string2 + " to ";
                string2 = string2 + blsrNode2.getNodeModel().getName() + "/";
                string = string2 = string2 + BlsrMapPort.asSlashSeparatedString((ITdmPortModel)object, "WP");
            } else {
                string = super.getToolTipText();
            }
        } else if (object2 instanceof INetLink) {
            string = super.getToolTipText();
        } else if (BlsrMapLink.db.on) {
            db.println("The userKey is not an instanceof BlsrSpan or INetLink - instead it's class is: " + object2.getClass());
        }
        if (6 == this.getState() && null != this.blsrSpan) {
            boolean bl = false;
            object = this.blsrSpan.getEastSide();
            blsrNode = this.blsrSpan.getWestSide();
            if (null != object && null != blsrNode && ((BlsrNode)object).isProvisioned() && blsrNode.isProvisioned()) {
                bl = true;
            }
            string = bl ? string + " (K3 Byte MISMATCHED)" : string + " (excluded due to wrong OSPF Area)";
        }
        return string;
    }

    public static INetLink findReverseLink(INetLink iNetLink) {
        return Network.instance().findReverseLink(iNetLink);
    }

    public void setIncluded(boolean bl) {
        if (BlsrMapLink.db.on) {
            db.println("state changed to included=" + bl + " for BlsrMapLink==" + this);
        }
        this.included = bl;
        if (bl) {
            this.setState(3);
        } else {
            this.setState(1);
        }
    }

    @Override
    public void setState(int n) {
        if (BlsrMapLink.db.on) {
            db.println("state changed to newState=" + this.getStateNameForInt(n) + " for BlsrMapLink=" + this);
        }
        super.setState(n);
        this.clearStyles();
        DetailedMapLinkStyle detailedMapLinkStyle = new DetailedMapLinkStyle(0, BlsrMapLink.stateToColor(n));
        this.addStyle(detailedMapLinkStyle);
    }

    private String getStateNameForInt(int n) {
        String string = "Unknown";
        switch (n) {
            case 1: {
                string = "LINK_DOWN_STATE";
                break;
            }
            case 2: {
                string = "LINK_UP_STATE";
                break;
            }
            case 3: {
                string = "LINK_INCLUDED_STATE";
                break;
            }
            case 4: {
                string = "LINK_ACTIVE_STATE";
                break;
            }
            case 5: {
                string = "LINK_STANDBY_STATE";
                break;
            }
            case 6: {
                string = "LINK_EXCLUDED_STATE";
                break;
            }
            case 7: {
                string = "LINK_ROLL_STATE";
            }
        }
        return string;
    }

    @Override
    public void setSourcePort(MapPort mapPort) {
        String string;
        super.setSourcePort(mapPort);
        if (mapPort != null && mapPort instanceof BlsrMapPort && (string = mapPort.getInfoString()) != null && string.length() > 0) {
            this.setSrcLabel(string);
        }
    }

    @Override
    public void setTargetPort(MapPort mapPort) {
        String string;
        super.setTargetPort(mapPort);
        if (mapPort != null && mapPort instanceof BlsrMapPort && (string = mapPort.getInfoString()) != null && string.length() > 0) {
            this.setTargetLabel(string);
        }
    }

    public void setCenterLabel() {
        boolean bl;
        boolean bl2 = bl = !(this.getUserObject() instanceof INetLink) || this.blsrSpan == null || this.srcPortModel == null || this.dstPortModel == null;
        if (bl) {
            return;
        }
        if (this.blsrSpan.getWestSide() != null && this.blsrSpan.getEastSide() != null) {
            boolean bl3 = this.getState() == 3;
            ITdmPortModel iTdmPortModel = null;
            ITdmPortModel iTdmPortModel2 = null;
            String string = null;
            String string2 = null;
            BlsrNode blsrNode = this.blsrSpan.getWestSide();
            if (blsrNode.getWestPort() == this.srcPortModel) {
                iTdmPortModel = this.dstPortModel;
                iTdmPortModel2 = this.srcPortModel;
            } else {
                iTdmPortModel = this.srcPortModel;
                iTdmPortModel2 = this.dstPortModel;
            }
            string = BlsrMapLink.getInfo(iTdmPortModel, bl3 ? "E" : null);
            string2 = BlsrMapLink.getInfo(iTdmPortModel2, bl3 ? "W" : null);
            if (blsrNode.getWestPort() == this.srcPortModel) {
                this.setSrcLabel(string2);
                this.setTargetLabel(string);
            } else {
                this.setSrcLabel(string);
                this.setTargetLabel(string2);
            }
        } else {
            this.setSrcLabel(BlsrMapLink.getInfo(this.srcPortModel, null));
            this.setTargetLabel(BlsrMapLink.getInfo(this.dstPortModel, null));
        }
    }

    public static String getInfo(ITdmPortModel iTdmPortModel, String string) {
        StringBuffer stringBuffer = new StringBuffer(16);
        if (iTdmPortModel != null) {
            stringBuffer.append("s");
            stringBuffer.append(iTdmPortModel.getSlot());
            stringBuffer.append("/");
            stringBuffer.append("p");
            stringBuffer.append(PortHelper.getPortNumString((IPortModel)iTdmPortModel));
            if (string != null) {
                stringBuffer.append("/");
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }
}

