/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.blsr.BlsrMapPort;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.table.AbstractTableModel;

public class RcdProtectPortTableModel
extends AbstractTableModel {
    private BlsrRingModel ringModel = null;
    private BlsrNode[] nodes;
    private ITdmPortModel[] eastProtectPorts;
    private ITdmPortModel[] westProtectPorts;
    private static final SDebug db = new SDebug("RcdProtectPortTableModel");
    private String[] columnNames = new String[]{"Name", "West working", "West protect", "East working", "East protect"};
    public static final int NAME_COLUMN = 0;
    public static final int WEST_WORKING_COLUMN = 1;
    public static final int WEST_PROTECT_COLUMN = 2;
    public static final int EAST_WORKING_COLUMN = 3;
    public static final int EAST_PROTECT_COLUMN = 4;
    private static String BLSR_TERM;

    public RcdProtectPortTableModel(BlsrRingModel blsrRingModel) {
        this.ringModel = blsrRingModel;
        this.nodes = blsrRingModel.getBlsrNodes();
        this.eastProtectPorts = new ITdmPortModel[this.nodes.length];
        this.westProtectPorts = new ITdmPortModel[this.nodes.length];
        BLSR_TERM = blsrRingModel.getBlsrRingInfo().getTDMTerminology().getRingTerms(1);
    }

    @Override
    public int getRowCount() {
        int n = 0;
        if (this.ringModel != null) {
            n = this.nodes.length;
        }
        return n;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object;
        switch (n2) {
            case 0: {
                object = this.nodes[n].getNodeModel().getName();
                break;
            }
            case 1: {
                object = this.nodes[n].getWestPort();
                break;
            }
            case 2: {
                object = this.westProtectPorts[n];
                break;
            }
            case 3: {
                object = this.nodes[n].getEastPort();
                break;
            }
            case 4: {
                object = this.eastProtectPorts[n];
                break;
            }
            default: {
                object = "INVALID row=" + n + ", col=" + n2;
            }
        }
        return object;
    }

    private ITdmPortModel convertValueToTdmPortModel(Object object) {
        ITdmPortModel iTdmPortModel = null;
        if (null != object && object instanceof ITdmPortModel) {
            iTdmPortModel = (ITdmPortModel)object;
        }
        return iTdmPortModel;
    }

    private boolean is3Card4FiberBlsr(int n, int n2, int n3, int n4) {
        if (n == n2 && n3 != n4) {
            return true;
        }
        if (n != n2 && n3 == n4) {
            return true;
        }
        if (n == n4 && n3 != n2) {
            return true;
        }
        return n != n4 && n3 == n2;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ITdmPortModel iTdmPortModel = this.convertValueToTdmPortModel(object);
        boolean bl = false;
        boolean bl2 = true;
        try {
            int n3 = this.nodes[n].getEastPort().getSlot();
            int n4 = this.nodes[n].getWestPort().getSlot();
            if (n2 == 2) {
                db.fine("Setting West Protect Port on Node" + this.nodes[n] + " to: " + BlsrMapPort.asSlashSeparatedString(iTdmPortModel, null));
                if (iTdmPortModel != null && this.eastProtectPorts[n] != null) {
                    int n5 = this.eastProtectPorts[n].getSlot();
                    int n6 = iTdmPortModel.getSlot();
                    if (n6 == n5) {
                        ErrorMsg.displayError((Component)this.getFrame(), (EID)NEMC.EID_CANNT_USE_SAME_SLOT_FOR_EAST_WEST_PROTECT_PORT);
                        bl2 = false;
                    }
                    if (bl2 && this.is3Card4FiberBlsr(n5, n3, n6, n4)) {
                        ErrorMsg.displayError((Component)this.getFrame(), (EID)NEMC.EID_3_CARD_NOT_ALLOWED_FOR_4F_BLSR_PARAM_1, (Object)BLSR_TERM);
                        bl2 = false;
                    }
                    if (n6 == n3) {
                        ErrorMsg.displayError((Component)this.getFrame(), (EID)NEMC.EID_CANNT_USE_SAME_SLOT_FOR_EAST_WORKING_WEST_PROTECT_PORT);
                        bl2 = false;
                    }
                }
                if (bl2) {
                    this.westProtectPorts[n] = iTdmPortModel;
                    bl = true;
                }
            } else if (n2 == 4) {
                db.fine("Setting East Protect Port on Node" + this.nodes[n] + " to: " + BlsrMapPort.asSlashSeparatedString(iTdmPortModel, null));
                if (iTdmPortModel != null && this.westProtectPorts[n] != null) {
                    int n7 = this.westProtectPorts[n].getSlot();
                    int n8 = iTdmPortModel.getSlot();
                    if (n8 == n7) {
                        ErrorMsg.displayError((Component)this.getFrame(), (EID)NEMC.EID_CANNT_USE_SAME_SLOT_FOR_EAST_WEST_PROTECT_PORT);
                        bl2 = false;
                    }
                    if (bl2 && this.is3Card4FiberBlsr(n8, n3, n7, n4)) {
                        ErrorMsg.displayError((Component)this.getFrame(), (EID)NEMC.EID_3_CARD_NOT_ALLOWED_FOR_4F_BLSR_PARAM_1, (Object)BLSR_TERM);
                        bl2 = false;
                    }
                    if (n8 == n4) {
                        ErrorMsg.displayError((Component)this.getFrame(), (EID)NEMC.EID_CANNT_USE_SAME_SLOT_FOR_WEST_WORKING_EAST_PROTECT_PORT);
                        bl2 = false;
                    }
                }
                if (bl2) {
                    this.eastProtectPorts[n] = iTdmPortModel;
                    bl = true;
                }
            }
            if (bl) {
                this.fireTableCellUpdated(n, n2);
            }
        }
        catch (Exception exception) {
            db.fine("Exception caught in setValueAt()");
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this.getFrame(), (EID)NEMC.EID_GENERAL_EXCEPTION);
        }
    }

    private Frame getFrame() {
        return UiToolkit.instance().getApplicationFrame();
    }

    public Class getColumnClass(int n) {
        if (n == 1 || n == 2 || n == 3 || n == 4) {
            return ITdmPortModel.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n2 == 2 || n2 == 4) {
            bl = true;
        }
        return bl;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.eastProtectPorts[i] != null) {
                this.nodes[i].setEastProtectPort(this.eastProtectPorts[i]);
            }
            if (this.westProtectPorts[i] == null) continue;
            this.nodes[i].setWestProtectPort(this.westProtectPorts[i]);
        }
    }

    public void unapplyToModel() throws Exception {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.eastProtectPorts[i] != null) {
                this.nodes[i].setEastProtectPort(null);
            }
            if (this.westProtectPorts[i] == null) continue;
            this.nodes[i].setWestProtectPort(null);
        }
    }

    public void refreshFromModel() {
        if (RcdProtectPortTableModel.db.on) {
            db.println("refreshFromModel() called");
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            BlsrNode blsrNode = this.nodes[i];
            this.setValueAt(blsrNode.getEastProtectPort(), i, 4);
            this.setValueAt(blsrNode.getWestProtectPort(), i, 2);
        }
    }

    public ITdmPortModel[] getEastProtectPorts() {
        return this.eastProtectPorts;
    }

    public ITdmPortModel[] getWestProtectPorts() {
        return this.westProtectPorts;
    }
}

