/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.BlsrSpanSwitched;
import cerent.cms.model.DuplicateRingId;
import cerent.cms.model.Feature;
import cerent.cms.model.IBlsrModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.BlsrRingManager;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NetworkProvPane;
import cerent.cms.ui.RevertiveBehaviorCellEditor;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.blsr.RingEditDialog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.LetterOrDigitTextField;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RedRingProvPane
extends NetworkProvPane
implements DocumentListener,
ActionListener {
    private static final SDebug db = new SDebug("RedRingProvPane");
    private BlsrRingModel ringModel;
    private NodeModel cmsHostModel;
    private LetterOrDigitTextField ringIdTF;
    private UComboBox ringRevCB;
    private UComboBox spanRevCB;
    private JButton addNodeButton;
    private JButton removeNodeButton;
    private boolean ringIdDirty = false;
    private boolean ringRevDirty = false;
    private boolean spanRevDirty = false;
    private static final String INCONSISTENT = "INCONSISTENT";
    private String BLSR_TERM = " ";

    public RedRingProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.ringModel = (BlsrRingModel)tabbedView.getUiModel();
        this.cmsHostModel = (NodeModel)NetworkModel.instance().getCmsHostModel();
        this.BLSR_TERM = this.cmsHostModel.getTDMTerminology().getRingTerms(1);
        this.addNodeButton = new JButton("Add a Node...");
        this.addNodeButton.setActionCommand("addNodeButton");
        this.addNodeButton.addActionListener(this);
        this.removeNodeButton = new JButton("Remove Node...");
        this.removeNodeButton.setActionCommand("removeNodeButton");
        this.removeNodeButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.ringIdTF = new LetterOrDigitTextField(6);
        this.ringIdTF.getDocument().addDocumentListener(this);
        this.enableComponent(this.ringIdTF, this.cmsHostModel);
        this.ringRevCB = RevertiveBehaviorCellEditor.getComboBox(true);
        this.ringRevCB.setActionCommand("ringRevCB");
        this.ringRevCB.addActionListener((ActionListener)this);
        this.enableComponent((JComponent)this.ringRevCB, this.cmsHostModel);
        this.spanRevCB = RevertiveBehaviorCellEditor.getComboBox(true);
        this.spanRevCB.setActionCommand("spanRevCB");
        this.spanRevCB.addActionListener((ActionListener)this);
        if (this.ringModel.getBlsrRingInfo().isFourFiber()) {
            this.enableComponent((JComponent)this.spanRevCB, this.cmsHostModel);
        } else {
            this.spanRevCB.setEnabled(false);
        }
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.anchor(17);
        gridBagPanel.inset(5, 10);
        gridBagPanel.add("Ring Name:", 0, 0);
        gridBagPanel.add((Component)this.ringIdTF, 1, 0);
        gridBagPanel.add("Ring Reversion:", 0, 1);
        gridBagPanel.add((Component)this.ringRevCB, 1, 1);
        gridBagPanel.add("Span Reversion:", 0, 2);
        gridBagPanel.add((Component)this.spanRevCB, 1, 2);
        jPanel.add(gridBagPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jPanel);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(jPanel2);
    }

    @Override
    public void destroy() {
        if (db.on()) {
            db.println("dispose");
        }
        super.destroy();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.ringIdDirty = true;
        if (RedRingProvPane.db.on) {
            db.println("ringIdDirty = true -- changedUpdate");
        }
        this.setDirty();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.ringIdDirty = true;
        if (RedRingProvPane.db.on) {
            db.println("ringIdDirty = true -- insertUpdate");
        }
        this.setDirty();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.ringIdDirty = true;
        if (RedRingProvPane.db.on) {
            db.println("ringIdDirty = true -- removeUpdate");
        }
        this.setDirty();
    }

    @Override
    public void applyChangesToModel() throws Exception {
        Object object;
        if (RedRingProvPane.db.on) {
            db.println("applyChangesToModel: start");
            db.println("  ringIdDirty:" + this.ringIdDirty);
            db.println("  ringRevDirty:" + this.ringRevDirty);
            db.println("  spanRevDirty:" + this.spanRevDirty);
        }
        if (this.ringRevDirty) {
            object = (IRevertiveBehavior)this.ringRevCB.getSelectedItem();
            if (db.on()) {
                db.println("updating the ring reversion time to: " + object.getReversionTime());
            }
            this.ringModel.setRingReversion((IRevertiveBehavior)object);
            this.ringRevDirty = false;
        }
        if (this.spanRevDirty) {
            object = (IRevertiveBehavior)this.spanRevCB.getSelectedItem();
            if (db.on()) {
                db.println("updating the span reversion time to: " + object.getReversionTime());
            }
            this.ringModel.setSpanReversion((IRevertiveBehavior)object);
            this.spanRevDirty = false;
        }
        object = this.ringIdTF.getText().toUpperCase();
        if (this.ringIdDirty) {
            if (((String)object).length() > 0) {
                try {
                    this.ringModel.setRingName((String)object);
                    this.ringIdDirty = false;
                }
                catch (DuplicateRingId duplicateRingId) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BLSR_UNIQUE_RING_ID);
                }
                catch (BlsrSpanSwitched blsrSpanSwitched) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BLSR_SWITCH_ACTIVE_CAN_NOT_CHANGE_RING_NAME_PARAM_1, (Object)this.BLSR_TERM);
                }
                if (RedRingProvPane.db.on) {
                    db.println("ringIdDirty = false -- just called setRingName(" + (String)object + ")");
                }
                if (!this.ringIdDirty) {
                    RingEditDialog.closeEditWindow(this.ringModel);
                }
            } else {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BLSR_NO_RING_NAME);
            }
        }
        if (db.on()) {
            db.println("applyChangesToModel: finish");
            db.println("  ringIdDirty:" + this.ringIdDirty);
            db.println("  ringRevDirty:" + this.ringRevDirty);
            db.println("  spanRevDirty:" + this.spanRevDirty);
        }
    }

    private boolean isRingIdValid(String string) {
        boolean bl = true;
        try {
            short s = Short.parseShort(string);
            bl = s > 0 && s <= 9999;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    private boolean isAlphanumericNameSupported(BlsrNode[] blsrNodeArray) {
        boolean bl = true;
        for (int i = 0; i < blsrNodeArray.length && bl; ++i) {
            bl = blsrNodeArray[i].getNodeModel().provides(Feature.BLSR_PATRIOT_EXTENSIONS);
        }
        return bl;
    }

    @Override
    public boolean onValidate() {
        Object object;
        Object object2;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.ringIdDirty) {
            bl4 = true;
            object2 = this.ringIdTF.getText().toUpperCase().trim();
            if (!this.ringIdSanityCheck((String)object2)) {
                bl = false;
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BLSR_UNIQUE_RING_ID);
            } else if (this.isAlphanumericNameSupported(this.ringModel.getBlsrNodes()) && ((String)object2).length() > this.ringModel.getMaxRingNameLength()) {
                bl = false;
                object = new Object[]{String.valueOf(this.ringModel.getMaxRingNameLength())};
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BLSR_ID_MAX_LENGTH_EXCEEDED_PARAM_1, (Object[])object);
            } else if (!this.isAlphanumericNameSupported(this.ringModel.getBlsrNodes()) && !this.isRingIdValid((String)object2)) {
                bl = false;
                ErrorMsg.displayError((Component)((Object)this), NEMC.EID_BLSR_NUMERIC_RING_ID_PARAM_2, String.valueOf(0), String.valueOf(9999));
            } else if (((String)object2).equalsIgnoreCase("all")) {
                bl = false;
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BLSR_RING_ID_TL1_KEYWORD);
            } else if (((String)object2).length() < 1) {
                bl = false;
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BLSR_NO_RING_NAME);
            } else {
                object = new String();
                object = (String)object + "You are currently editing the ring named " + this.ringModel.getRingName() + ".\n";
                object = (String)object + "Changing the ring name will cause this edit window to close.\n";
                object = (String)object + "You will then have to open a new edit window to edit the ring with your new ring name.\n";
                object = (String)object + "Are you sure you want to continue?\n";
                bl = CerentDialog.yesNoDialog((Component)((Object)this), (String)object, (String)"Changing Ring Name");
            }
        }
        if (this.ringRevDirty) {
            bl4 = true;
            object2 = this.ringRevCB.getSelectedItem();
            if (object2.equals(INCONSISTENT)) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANNOT_SET_REVERSION_TO_INCONSISTENT);
                bl = false;
            } else {
                object = (Object[])object2;
                if (object.getReversionMode() == 1) {
                    try {
                        if (this.ringModel.hasPCAConnections()) {
                            bl3 = true;
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        db.println("Got an IllegalStateException in onValidate querying for PCA connections (ring reversion):" + illegalStateException);
                        bl = false;
                    }
                }
            }
        }
        if (bl && this.spanRevDirty) {
            bl4 = true;
            object2 = this.spanRevCB.getSelectedItem();
            if (object2.equals(INCONSISTENT)) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANNOT_SET_REVERSION_TO_INCONSISTENT);
                bl = false;
            } else {
                object = (IRevertiveBehavior)object2;
                if (object.getReversionMode() == 1) {
                    try {
                        if (this.ringModel.hasPCAConnections()) {
                            bl3 = true;
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        db.println("Got an IllegalStateException in onValidate querying for PCA connections (span reversion):" + illegalStateException);
                        bl = false;
                    }
                }
            }
        }
        if (bl3) {
            object2 = "This " + this.BLSR_TERM + " carries Protection Channel Access (PCA) circuits.\n";
            object2 = (String)object2 + "If you set reversion time to \"never\", PCA circuit traffic \n";
            object2 = (String)object2 + "will be preempted indefinitely in case of a protection switch \n";
            object2 = (String)object2 + "until you undo the protection switch.\n\n";
            object2 = (String)object2 + "Is it OK to continue?";
            bl = CerentDialog.yesNoDialog((Component)((Object)this), (String)object2, (String)"PCA Traffic Loss Warning");
        }
        if (bl && bl4 && this.ringModel.getState() == 2) {
            object2 = ErrorMsg.getString((EID)NEMC.WID_BLSR_RING_STATUS_INCOMPLETE);
            object2 = (String)object2 + "Is it OK to continue?";
            bl = CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)object2, (String)"Confirm Apply");
        }
        return bl;
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel: start");
        }
        this.ringIdTF.setText(this.ringModel.getRingName().toUpperCase());
        IRevertiveBehavior iRevertiveBehavior = this.ringModel.getRingReversion();
        this.ringRevCB.removeItem((Object)INCONSISTENT);
        if (iRevertiveBehavior.getReversionMode() == -1) {
            this.ringRevCB.addItem((Object)INCONSISTENT);
            this.ringRevCB.setSelectedItem((Object)INCONSISTENT);
        } else {
            if (iRevertiveBehavior.getReversionMode() == 1) {
                iRevertiveBehavior.setReversionTime(300);
            }
            this.ringRevCB.setSelectedItem((Object)iRevertiveBehavior);
            if (RedRingProvPane.db.on) {
                db.println("ring reversion time is: " + iRevertiveBehavior.getReversionTime());
            }
        }
        IRevertiveBehavior iRevertiveBehavior2 = this.ringModel.getSpanReversion();
        if (iRevertiveBehavior2 != null) {
            this.spanRevCB.removeItem((Object)INCONSISTENT);
            if (iRevertiveBehavior2.getReversionMode() == -1) {
                this.spanRevCB.addItem((Object)INCONSISTENT);
                this.spanRevCB.setSelectedItem((Object)INCONSISTENT);
            } else {
                if (iRevertiveBehavior2.getReversionMode() == 1) {
                    iRevertiveBehavior2.setReversionTime(300);
                }
                this.spanRevCB.setSelectedItem((Object)iRevertiveBehavior2);
                if (RedRingProvPane.db.on) {
                    db.println("span reversion time is: " + iRevertiveBehavior2.getReversionTime());
                }
            }
        } else {
            this.spanRevCB.setSelectedIndex(0);
        }
        if (RedRingProvPane.db.on) {
            db.println("  Setting all dirty flags to FALSE - since we just refreshed from model.");
        }
        this.ringIdDirty = false;
        this.ringRevDirty = false;
        this.spanRevDirty = false;
        this.setDirty(false);
        if (db.on()) {
            db.println("refreshFromModel: finish");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("addNodeButton")) {
            if (db.on()) {
                db.println("Start the Add a Node Wizard!");
            }
        } else if (string.equals("removeNodeButton")) {
            if (db.on()) {
                db.println("Start the Remove a Node Wizard!");
            }
        } else if (string.equals("ringRevCB")) {
            if (RedRingProvPane.db.on) {
                db.println("ringRevDirty set to TRUE");
            }
            this.ringRevDirty = true;
            this.setDirty();
        } else if (string.equals("spanRevCB")) {
            if (RedRingProvPane.db.on) {
                db.println("spanRevDirty set to TRUE");
            }
            this.spanRevDirty = true;
            this.setDirty();
        } else if (db.on()) {
            db.println("Got an unknown command here!" + string + "\nActionEvent was: " + actionEvent);
        }
    }

    JButton getAddNodeWizardButton() {
        return this.addNodeButton;
    }

    JButton getRemoveNodeWizardButton() {
        return this.removeNodeButton;
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.RedRingProvPane;
    }

    private boolean ringIdSanityCheck(String string) {
        boolean bl = true;
        BlsrNode[] blsrNodeArray = this.ringModel.getBlsrNodes();
        block0: for (int i = 0; i < blsrNodeArray.length; ++i) {
            NodeModel nodeModel = blsrNodeArray[i].getNodeModel();
            Iterator iterator = nodeModel.getElementModels().getBlsrElements().iterator();
            while (iterator.hasNext()) {
                String string2 = BlsrRingManager.getRingName((IBlsrModel)iterator.next());
                if (!string2.equalsIgnoreCase(string)) continue;
                bl = false;
                continue block0;
            }
        }
        return bl;
    }
}

