/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.cfm;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.IMAProfileInfo;
import cerent.cms.model.IXPL2ModuleModel;
import cerent.cms.model.MAProfileInfo;
import cerent.cms.model.ProvisionError;
import cerent.cms.ui.cfm.MAProfilePane;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MAProfileModifyDialog
extends JDialog
implements ActionListener {
    private static final String TITLE = "Modify MA Profile";
    public static final String OK = "OK";
    public static final String CANCEL = "Cancel";
    public static final int MARGIN = 5;
    private static final String MANAME = "MA Name:";
    private JTextField maName = new JTextField(10);
    private static final String VLAN = "Vlan:";
    private JTextField maVlan = new JTextField(7);
    private static final String CCENABLE = "CC Enable:";
    private JCheckBox cc_enable = new JCheckBox();
    IXPL2ModuleModel module;
    String name = null;
    short vlan = 0;
    boolean ccenable = false;
    private static final int MAX_VLANID = 4094;
    MAProfilePane parentPane;
    private JButton okButton;
    private JButton cancelButton;
    private IMAProfileInfo orig;

    public MAProfileModifyDialog(Frame frame, IMAProfileInfo iMAProfileInfo, IEntityModel iEntityModel, MAProfilePane mAProfilePane) {
        super(frame, TITLE, true);
        this.parentPane = mAProfilePane;
        this.module = (IXPL2ModuleModel)iEntityModel;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MAProfileModifyDialog.this.dispose();
            }
        });
        this.orig = iMAProfileInfo;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.createAttributesPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.initializeForm();
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private void initializeForm() {
        this.maName.setText(this.orig.getMAName());
        this.maVlan.setText(String.valueOf(this.orig.getVlanId()));
        this.cc_enable.setSelected(this.orig.getCCEnabled());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.apply()) {
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    private JPanel createAttributesPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.add(new JLabel(MANAME));
        jPanel2.add(new JLabel(VLAN));
        jPanel2.add(new JLabel(CCENABLE));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1));
        jPanel3.add(this.maName);
        jPanel3.add(this.maVlan);
        jPanel3.add(this.cc_enable);
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private boolean apply() {
        String string = null;
        string = this.maName.getText();
        if (string == null || string.equalsIgnoreCase("") || string.length() <= 0 || string.length() > 43) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CFM_MA_LENGTH_ERROR);
        }
        short s = 0;
        String string2 = this.maVlan.getText();
        if (string2 == null || string2.equalsIgnoreCase("") || string2.length() <= 0) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_ERROR_PROVISIONING_VLAN_ID);
        } else {
            s = Short.valueOf(string2);
            if (s <= 0 || s >= 4094) {
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_ERROR_PROVISIONING_VLAN_ID);
            }
        }
        try {
            MAProfileInfo mAProfileInfo = new MAProfileInfo(string, s, this.cc_enable.isSelected());
            this.module.modifyMAProfile(this.orig, (IMAProfileInfo)mAProfileInfo);
        }
        catch (ProvisionError provisionError) {
            EID eID = provisionError.getEID();
            if (eID != null) {
                ErrorMsg.displayDetailed((Component)this, eID, (Exception)((Object)provisionError));
            }
            ErrorMsg.displayDetailed((Component)this, CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
        }
        this.parentPane.refresh();
        return true;
    }
}

