/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.cfm;

import cerent.cms.model.Attribute;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IMAProfileInfo;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IXPL2ModuleModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractProvTableModel;
import cerent.cms.ui.AbstractProvTablePane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.cfm.MAProfileModifyDialog;
import cerent.cms.ui.cfm.MAProfileTableModel;
import cerent.cms.ui.cfm.ProfileLoadStoreDialog;
import cerent.util.ComparisonUtil;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.WID;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedProgressDialog;
import cerent.util.gui.IDetailedProgressController;
import cerent.util.gui.IDetailedProgressDialog;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class MAProfilePane
extends AbstractProvTablePane
implements Observer,
ActionListener,
TableModelListener,
ListSelectionListener {
    private static final int MAX_VLAN_ID = 4093;
    private static final int COLUM_MAXWidth = 45;
    private static final int COLUM_MINWidth = 45;
    static Dimension SELECTIONBOX_DIM = new Dimension(200, 150);
    static Dimension BUTTON0_DIM = new Dimension(75, 25);
    static Dimension BUTTON1_DIM = new Dimension(125, 25);
    private static String PREF_SCOPE_VALUE = "warnVlanDbProfileScope";
    private static String PREF_SCOPE_DESCR = "Scope Change Will Lose Vlan Db Profile Editor Contents";
    private static final SDebug db = new SDebug("MAProfilePane");
    private INodeModel nm = null;
    private boolean isThisGuestPane = false;
    private JPanel bottomPanel;
    private JPanel bottomLeftPanel;
    private JButton loadButton;
    private JButton storeButton;
    private JButton modifyButton;
    private JPanel bottomRightPanel;
    private JTextField rowNumTxt;
    private JButton addRowButton;
    private JButton deleteRowButton;
    private JLabel permDelLabel;
    private JCheckBox permDelCB;
    private JLabel selectAllLabel;
    private JCheckBox selectAllCB;
    private CSHelpButton helpButton;
    private IEntityModel currentCard = null;

    public MAProfilePane(String string, TabbedView tabbedView, boolean bl) {
        super(string, tabbedView, new MAProfileTableModel((Container)tabbedView, false, null), true);
        this.nm = tabbedView.getUiModel().getNodeModel();
        this.isThisGuestPane = bl;
        this.initComponents();
    }

    private void initComponents() {
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.setLayout(new BorderLayout());
        this.dataModel = this.dataModel;
        this.table = new UTable((TableModel)this.dataModel);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getColumnModel().getColumn(0).setMinWidth(200);
        this.table.getColumnModel().getColumn(0).setMaxWidth(350);
        this.table.getColumnModel().getColumn(1).setMinWidth(150);
        this.table.getColumnModel().getColumn(1).setMaxWidth(150);
        this.table.getColumnModel().getColumn(2).setMinWidth(150);
        this.table.getColumnModel().getColumn(2).setMaxWidth(150);
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){
            boolean flag = true;

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n;
                TableColumnModel tableColumnModel = MAProfilePane.this.table.getColumnModel();
                int n2 = tableColumnModel.getColumn(n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex();
                if (n2 < 0) {
                    return;
                }
                MAProfilePane.this.sortAllRowsBy(MAProfilePane.this.dataModel, n2 + 1, this.flag);
                this.flag = !this.flag;
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add(jScrollPane, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomLeftPanel = new JPanel();
        this.bottomLeftPanel.setLayout(new FlowLayout(0));
        this.loadButton = new JButton("Load...");
        this.loadButton.addActionListener(this);
        this.storeButton = new JButton("Store...");
        this.storeButton.addActionListener(this);
        this.modifyButton = new JButton("Modify Selected Profile(s)...");
        this.modifyButton.addActionListener(this);
        this.bottomLeftPanel.add(this.loadButton);
        this.bottomLeftPanel.add(this.storeButton);
        this.bottomLeftPanel.add(this.modifyButton);
        this.bottomRightPanel = new JPanel();
        this.bottomRightPanel.setLayout(new FlowLayout(2));
        Dimension dimension = this.loadButton.getMinimumSize();
        dimension.width = dimension.width / 2 + 5;
        this.rowNumTxt = new JTextField("1");
        this.rowNumTxt.setMinimumSize(dimension);
        this.rowNumTxt.setPreferredSize(dimension);
        this.rowNumTxt.setHorizontalAlignment(0);
        this.enableComponent(this.rowNumTxt, (IModel)this.nm);
        this.addRowButton = new JButton("Add row(s)");
        this.addRowButton.addActionListener(this);
        this.enableComponent(this.addRowButton, (IModel)this.nm);
        this.deleteRowButton = new JButton("Delete Sel. row(s)");
        this.deleteRowButton.addActionListener(this);
        this.bottomRightPanel.add(this.rowNumTxt);
        this.bottomRightPanel.add(this.addRowButton);
        JPanel jPanel = new JPanel();
        jPanel.add(this.deleteRowButton);
        this.permDelLabel = new JLabel("on Node:");
        jPanel.add(this.permDelLabel);
        this.permDelCB = new JCheckBox();
        jPanel.add(this.permDelCB);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.bottomRightPanel.add(jPanel);
        JPanel jPanel2 = new JPanel();
        this.selectAllLabel = new JLabel("Select All");
        jPanel2.add(this.selectAllLabel);
        this.selectAllCB = new JCheckBox();
        jPanel2.add(this.selectAllCB);
        this.selectAllCB.addActionListener(this);
        this.bottomRightPanel.add(jPanel2);
        Dimension dimension2 = new Dimension(75, 25);
        if (this.getHelpID() != null) {
            this.helpButton = new CSHelpButton(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MAProfilePane.this.helpButton.launchHelp(MAProfilePane.this.getHelpID());
                }
            });
            this.helpButton.setMinimumSize(dimension2);
            this.helpButton.setMaximumSize(dimension2);
            this.bottomRightPanel.add(this.helpButton);
        }
        this.bottomPanel.add((Component)this.bottomLeftPanel, "Center");
        this.bottomPanel.add((Component)this.bottomRightPanel, "East");
        this.add(this.bottomPanel, "South");
    }

    @Override
    public void leavingPage() throws Exception {
        if (((MAProfileTableModel)this.dataModel).isDirty() && this.isThisGuestPane && this.table.getRowCount() > 0) {
            IgnorableDialog.warningDialog((String)ErrorMsg.getString((EID)NEMC.WID_UNSAVED_PROFILE_EDITOR), (String)PREF_SCOPE_VALUE, (String)PREF_SCOPE_DESCR);
        }
        this.table.getModel().removeTableModelListener(this);
    }

    @Override
    protected int getLeavingPageOption() {
        boolean bl = CerentDialog.yesNoDialog((Component)((Object)this), (String)"The current MA profile have been changed but not stored.\nLeaving this tab will discard these changes.\nIs it OK to continue?", (String)"Changed Profiles Not Stored");
        if (bl) {
            return 1;
        }
        return 2;
    }

    @Override
    public void enteringPage() throws Exception {
        this.disableButtons();
        this.table.getModel().addTableModelListener(this);
        super.enteringPage();
    }

    @Override
    public void refresh() {
        this.doImportFromCard(this.currentCard, true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.loadButton) {
            this.loadAction(true);
        } else if (object == this.storeButton) {
            this.storeAction();
            this.disableButtons();
            this.resetDirty();
            ((MAProfileTableModel)this.dataModel).resetDirty();
        } else if (object == this.addRowButton) {
            this.addRowAction();
        } else if (object == this.modifyButton) {
            this.modifyAction();
        } else if (object == this.deleteRowButton) {
            this.deleteRowAction();
            this.disableButtons();
        } else if (object == this.selectAllCB) {
            if (this.selectAllCB.isSelected()) {
                this.table.setColumnSelectionAllowed(false);
                this.table.setRowSelectionAllowed(true);
                int n = this.table.getRowCount();
                this.table.setRowSelectionInterval(0, n - 1);
            } else {
                int n = this.table.getRowCount();
                this.table.removeRowSelectionInterval(0, n - 1);
                this.table.setRowSelectionAllowed(true);
            }
        } else if (db.on()) {
            db.println("MAProfilePane : no ActionPerformed command !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAction(boolean bl) {
        boolean bl2;
        if (bl && this.table.getRowCount() > 0 && !(bl2 = CerentDialog.yesNoDialog((Component)((Object)this), (String)"MA profiles already exist.\nLoading a new profiles will discard the current MA Profiles.\nIs it OK to continue?", (String)"Changing Maintenance Profile"))) {
            return;
        }
        ArrayList arrayList = this.getNodeInfoList();
        IModel iModel = this.getUiModel();
        IModel iModel2 = iModel instanceof NetworkModel ? null : iModel;
        ProfileLoadStoreDialog profileLoadStoreDialog = new ProfileLoadStoreDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), arrayList, iModel2, ProfileLoadStoreDialog.ActionType.LOAD);
        profileLoadStoreDialog.init();
        try {
            Collection<IModel> collection;
            profileLoadStoreDialog.setVisible(true);
            if (!profileLoadStoreDialog.isCancelled() && (collection = profileLoadStoreDialog.getSelectedModels()).size() > 0) {
                IEntityModel iEntityModel = (IEntityModel)collection.iterator().next();
                this.doImportFromCard(iEntityModel, bl);
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        finally {
            profileLoadStoreDialog.dispose();
        }
    }

    private void modifyAction() {
        int n = this.table.getSelectedRow();
        if (((MAProfileTableModel)this.dataModel).checkForInvalidDomains(n)) {
            ErrorMsg.displayWarning((Component)((Object)this), (WID)NEMC.WID_INVALID_DOMAIN_STORING);
            return;
        }
        IMAProfileInfo iMAProfileInfo = ((MAProfileTableModel)this.dataModel).getMAProfileFromTable(n);
        MAProfileModifyDialog mAProfileModifyDialog = new MAProfileModifyDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), iMAProfileInfo, this.currentCard, this);
    }

    private void deleteDBAction() {
        ProfileLoadStoreDialog profileLoadStoreDialog;
        block4: {
            ArrayList arrayList = this.getNodeInfoList();
            IModel iModel = this.getUiModel();
            IModel iModel2 = iModel instanceof NetworkModel ? null : iModel;
            profileLoadStoreDialog = new ProfileLoadStoreDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), arrayList, iModel2, ProfileLoadStoreDialog.ActionType.DELETE);
            profileLoadStoreDialog.init();
            try {
                profileLoadStoreDialog.setVisible(true);
                if (!profileLoadStoreDialog.isCancelled()) {
                    Collection<IModel> collection = profileLoadStoreDialog.getSelectedModels();
                    this.deleteOnCard(collection);
                    if (collection.size() > 0) {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), "The MA Profile has been deleted.");
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        profileLoadStoreDialog.dispose();
        this.doImportFromCard(this.currentCard, true);
        this.permDelCB.setSelected(false);
    }

    private void doImportFromCard(IEntityModel iEntityModel, boolean bl) {
        try {
            if (iEntityModel instanceof IXPL2ModuleModel) {
                IXPL2ModuleModel iXPL2ModuleModel;
                if (db.on()) {
                    db.println("doImportFromCard() from card: ");
                    iXPL2ModuleModel = iEntityModel.getNodeModel();
                    db.println("  " + iXPL2ModuleModel.getName() + " - " + iEntityModel);
                }
                iXPL2ModuleModel = (IXPL2ModuleModel)iEntityModel;
                this.currentCard = iEntityModel;
                ArrayList<IMAProfileInfo> arrayList = new ArrayList<IMAProfileInfo>();
                arrayList.addAll(Arrays.asList(iXPL2ModuleModel.getAllMAProfiles()));
                if (bl) {
                    ((MAProfileTableModel)this.dataModel).setMAProfileCurrentList(new ArrayList<IMAProfileInfo>(arrayList));
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeAction() {
        if (db.on()) {
            db.println("doStoreAction");
        }
        if (((MAProfileTableModel)this.dataModel).checkForInvalidDomains()) {
            ErrorMsg.displayWarning((Component)((Object)this), (WID)NEMC.WID_INVALID_MA_STORING);
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null && nArray.length == 0) {
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), "No Rows are selected. Please select the Profiles to be saved.");
            return;
        }
        ArrayList arrayList = this.getNodeInfoList();
        IModel iModel = this.getUiModel();
        IModel iModel2 = iModel instanceof NetworkModel ? null : iModel;
        ProfileLoadStoreDialog profileLoadStoreDialog = new ProfileLoadStoreDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), arrayList, iModel2, ProfileLoadStoreDialog.ActionType.STORE);
        profileLoadStoreDialog.init();
        try {
            profileLoadStoreDialog.setVisible(true);
            if (!profileLoadStoreDialog.isCancelled()) {
                Collection<IModel> collection = profileLoadStoreDialog.getSelectedModels();
                this.doStoreOnCard(collection);
                JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), "The MA Profile has been saved.");
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        finally {
            profileLoadStoreDialog.dispose();
        }
    }

    private void doStoreOnCard(Collection<IModel> collection) throws Exception {
        if (collection == null || collection.size() == 0) {
            return;
        }
        if (db.on()) {
            db.println("doStoreOnCard() for cards: ");
            for (IModel object2 : collection) {
                INodeModel bl = object2.getNodeModel();
                db.println("  " + bl.getName() + " - " + object2);
            }
        }
        ArrayList<IMAProfileInfo> arrayList = null;
        int[] nArray = this.table.getSelectedRows();
        arrayList = nArray != null && nArray.length > 0 ? ((MAProfileTableModel)this.dataModel).getMAProfilesFromTable(nArray) : ((MAProfileTableModel)this.dataModel).getMAProfileCurrentList(true);
        boolean bl = false;
        String string = "saved";
        DetailedLog detailedLog = new DetailedLog(3, "The MA Profile was not " + string);
        for (IModel iModel : collection) {
            bl |= this.doModifyValidation(arrayList, (IEntityModel)iModel, detailedLog);
        }
        if (bl) {
            ErrorMsg.displayWarning((Component)((Object)this), NEMC.EID_CFM_PROFILE_MODIFY_WARN);
            throw new Exception();
        }
        for (IModel iModel : collection) {
            bl |= this.doStoreOnCard(arrayList, (IEntityModel)iModel, detailedLog);
        }
        if (bl) {
            IModel iModel;
            IDetailedProgressController iDetailedProgressController = new IDetailedProgressController(){

                public void start(IDetailedProgressDialog iDetailedProgressDialog) {
                }

                public boolean isCancelSupported() {
                    return false;
                }

                public void cancel() {
                }
            };
            iModel = new DetailedProgressDialog(JOptionPane.getFrameForComponent(this.getParent()), "Error", detailedLog, iDetailedProgressController);
            iModel.setCompleted(true);
            iModel.start();
            throw new Exception();
        }
    }

    private boolean doModifyValidation(ArrayList<IMAProfileInfo> arrayList, IEntityModel iEntityModel, DetailedLog detailedLog) {
        boolean bl = false;
        if (iEntityModel instanceof IXPL2ModuleModel) {
            IXPL2ModuleModel iXPL2ModuleModel = (IXPL2ModuleModel)iEntityModel;
            IMAProfileInfo iMAProfileInfo = null;
            IMAProfileInfo iMAProfileInfo2 = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    iMAProfileInfo = arrayList.get(i);
                    ArrayList<IMAProfileInfo> arrayList2 = new ArrayList<IMAProfileInfo>();
                    arrayList2.addAll(Arrays.asList(iXPL2ModuleModel.getAllMAProfiles()));
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        iMAProfileInfo2 = (IMAProfileInfo)arrayList2.get(j);
                        if (!iMAProfileInfo.getMAName().equals(iMAProfileInfo2.getMAName())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    break;
                }
                catch (Exception exception) {
                    bl = true;
                    String string = "retrieving";
                    String string2 = null;
                    if (exception instanceof ProvisionError && ((ProvisionError)((Object)exception)).getEID() != null) {
                        string2 = ((ProvisionError)((Object)exception)).getEID().getMessage();
                    }
                    DetailedLog detailedLog2 = new DetailedLog(3, "an error occurred while " + string + " the MAProfiles " + " from the card. " + (string2 != null ? "Reason = " + string2 : ""), exception);
                    detailedLog.addChild(detailedLog2);
                    detailedLog.updateTime();
                }
            }
        }
        return bl;
    }

    private boolean doStoreOnCard(ArrayList<IMAProfileInfo> arrayList, IEntityModel iEntityModel, DetailedLog detailedLog) {
        boolean bl = false;
        if (iEntityModel instanceof IXPL2ModuleModel) {
            IXPL2ModuleModel iXPL2ModuleModel = (IXPL2ModuleModel)iEntityModel;
            IMAProfileInfo iMAProfileInfo = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    iMAProfileInfo = arrayList.get(i);
                    iXPL2ModuleModel.addMAProfile(iMAProfileInfo);
                    continue;
                }
                catch (Exception exception) {
                    bl = true;
                    String string = "storing";
                    String string2 = null;
                    if (exception instanceof ProvisionError && ((ProvisionError)((Object)exception)).getEID() != null) {
                        string2 = ((ProvisionError)((Object)exception)).getEID().getMessage();
                    }
                    DetailedLog detailedLog2 = new DetailedLog(3, "an error occurred while " + string + " the MAProfile " + iMAProfileInfo.getMAName() + " to the card. " + (string2 != null ? "Reason = " + string2 : ""), exception);
                    detailedLog.addChild(detailedLog2);
                    detailedLog.updateTime();
                }
            }
        }
        return bl;
    }

    protected void addRowAction() {
        int n = 0;
        try {
            n = Integer.parseInt(this.rowNumTxt.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_NUMBER);
            this.rowNumTxt.setText("");
            return;
        }
        if (n + this.dataModel.getRowCount() > 4093) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_MAX_VLAN_DB_PROFILES_PARAM_1, (Object)4093);
            return;
        }
        ((MAProfileTableModel)this.dataModel).addMAProfileTableRow(n);
    }

    protected void deleteRowAction() {
        if (this.permDelCB.isSelected()) {
            this.deleteDBAction();
        } else {
            ((MAProfileTableModel)this.dataModel).removeMAProfileTableRow(this.table.getSelectedRows());
        }
    }

    public void deleteOnCard(Collection<IModel> collection) throws Exception {
        if (collection == null || collection.size() == 0) {
            return;
        }
        if (db.on()) {
            db.println("deleteOnCard() for cards: ");
            for (IModel object2 : collection) {
                INodeModel bl = object2.getNodeModel();
                db.println("  " + bl.getName() + " - " + object2);
            }
        }
        ArrayList<IMAProfileInfo> arrayList = null;
        int[] nArray = this.table.getSelectedRows();
        arrayList = nArray != null ? ((MAProfileTableModel)this.dataModel).getMAProfilesFromTable(nArray) : ((MAProfileTableModel)this.dataModel).getMAProfileCurrentList(true);
        boolean bl = false;
        String string = "deleted";
        DetailedLog detailedLog = new DetailedLog(3, "The MA Profile was not " + string);
        for (IModel iModel : collection) {
            bl |= this.deleteOnCard(arrayList, (IEntityModel)iModel, detailedLog);
        }
        if (bl) {
            IModel iModel;
            IDetailedProgressController iDetailedProgressController = new IDetailedProgressController(){

                public void start(IDetailedProgressDialog iDetailedProgressDialog) {
                }

                public boolean isCancelSupported() {
                    return false;
                }

                public void cancel() {
                }
            };
            iModel = new DetailedProgressDialog(JOptionPane.getFrameForComponent(this.getParent()), "Error", detailedLog, iDetailedProgressController);
            iModel.setCompleted(true);
            iModel.start();
            throw new Exception();
        }
    }

    private boolean deleteOnCard(ArrayList<IMAProfileInfo> arrayList, IEntityModel iEntityModel, DetailedLog detailedLog) {
        boolean bl = false;
        if (iEntityModel instanceof IXPL2ModuleModel) {
            IXPL2ModuleModel iXPL2ModuleModel = (IXPL2ModuleModel)iEntityModel;
            IMAProfileInfo iMAProfileInfo = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    iMAProfileInfo = arrayList.get(i);
                    iXPL2ModuleModel.removeMAProfile(iMAProfileInfo);
                    continue;
                }
                catch (Exception exception) {
                    bl = true;
                    String string = "deleting";
                    String string2 = null;
                    if (exception instanceof ProvisionError && ((ProvisionError)((Object)exception)).getEID() != null) {
                        string2 = ((ProvisionError)((Object)exception)).getEID().getMessage();
                    }
                    DetailedLog detailedLog2 = new DetailedLog(3, "an error occurred while " + string + " the MAProfile " + iMAProfileInfo.getMAName() + " from the card. " + (string2 != null ? "Reason = " + string2 : ""), exception);
                    detailedLog.addChild(detailedLog2);
                    detailedLog.updateTime();
                }
            }
        }
        return bl;
    }

    private void disableButtons() {
        if (this.table.getRowCount() == 0) {
            this.storeButton.setEnabled(false);
            this.deleteRowButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
            this.selectAllCB.setEnabled(false);
        }
    }

    public ArrayList getNodeInfoList() {
        IModel iModel;
        if (db.on()) {
            db.println("----getNodeInfoList: begin()");
        }
        ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>();
        IModel iModel2 = iModel = this.uiModel instanceof NetworkModel ? null : this.uiModel;
        if (iModel != null) {
            INodeModel iNodeModel = iModel.getNodeModel();
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.STS_OVER_MSTP_ADM_ENHANCED)) {
                arrayList.add(iNodeModel);
            }
            return arrayList;
        }
        for (INetElement iNetElement : Network.instance().getElements()) {
            INodeModel iNodeModel = iNetElement.getNodeModel();
            if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.STS_OVER_MSTP_ADM_ENHANCED)) continue;
            arrayList.add(iNodeModel);
        }
        if (db.on()) {
            db.println("----getNodeInfoList: end()");
        }
        return arrayList;
    }

    public void sortAllRowsBy(AbstractProvTableModel abstractProvTableModel, int n, boolean bl) {
        ArrayList<IMAProfileInfo> arrayList = ((MAProfileTableModel)abstractProvTableModel).getMAProfileCurrentList(false);
        Collections.sort(arrayList, new ColumnSorter(n, bl));
        abstractProvTableModel.fireTableDataChanged();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.table.getRowCount() > 0) {
            int n;
            this.enableComponent(this.storeButton, (IModel)this.nm);
            this.enableComponent(this.selectAllCB, (IModel)this.nm);
            int[] nArray = this.table.getSelectedRows();
            int n2 = n = nArray == null ? 0 : nArray.length;
            if (n > 0) {
                this.enableComponent(this.deleteRowButton, (IModel)this.nm);
                this.enableComponent(this.permDelCB, (IModel)this.nm);
            } else if (this.deleteRowButton.isEnabled()) {
                this.deleteRowButton.setEnabled(false);
                this.permDelCB.setEnabled(false);
                this.table.setSelectionMode(2);
                this.selectAllCB.setSelected(false);
                this.selectAllCB.setEnabled(false);
            }
            ((MAProfileTableModel)this.dataModel).forceDirty();
        } else {
            this.table.setSelectionMode(2);
            this.selectAllCB.setSelected(false);
            this.selectAllCB.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (n > 0) {
            this.enableComponent(this.deleteRowButton, (IModel)this.nm);
            if (n == 1) {
                this.enableComponent(this.modifyButton, (IModel)this.nm);
            } else if (n > 1) {
                this.modifyButton.setEnabled(false);
            }
        } else if (this.deleteRowButton.isEnabled()) {
            this.deleteRowButton.setEnabled(false);
            if (this.modifyButton.isEnabled()) {
                this.modifyButton.setEnabled(false);
            }
        }
    }

    @Override
    protected Attribute[] getAttributes(String string) {
        return null;
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.MAProfilePane;
    }

    class ColumnSorter
    implements Comparator {
        int colIndex;
        boolean ascending;

        ColumnSorter(int n, boolean bl) {
            this.colIndex = n;
            this.ascending = bl;
        }

        public int compare(Object object, Object object2) {
            IMAProfileInfo iMAProfileInfo = (IMAProfileInfo)object;
            IMAProfileInfo iMAProfileInfo2 = (IMAProfileInfo)object2;
            if (iMAProfileInfo == null && iMAProfileInfo2 == null) {
                return 0;
            }
            if (iMAProfileInfo == null) {
                return 1;
            }
            if (iMAProfileInfo2 == null) {
                return -1;
            }
            if (iMAProfileInfo instanceof Comparable) {
                if (this.ascending) {
                    if (this.colIndex == 1) {
                        String string = iMAProfileInfo.getMAName();
                        String string2 = iMAProfileInfo2.getMAName();
                        return string.compareTo(string2);
                    }
                    if (this.colIndex == 2) {
                        short s = iMAProfileInfo.getVlanId();
                        short s2 = iMAProfileInfo2.getVlanId();
                        return ComparisonUtil.compare((long)s, (long)s2);
                    }
                    return ((Comparable)iMAProfileInfo).compareTo(iMAProfileInfo2);
                }
                if (this.colIndex == 1) {
                    String string = iMAProfileInfo.getMAName();
                    String string3 = iMAProfileInfo2.getMAName();
                    return string3.compareTo(string);
                }
                if (this.colIndex == 2) {
                    short s = iMAProfileInfo.getVlanId();
                    short s3 = iMAProfileInfo2.getVlanId();
                    return ComparisonUtil.compare((long)s3, (long)s);
                }
                return ((Comparable)iMAProfileInfo2).compareTo(iMAProfileInfo);
            }
            if (this.ascending) {
                return iMAProfileInfo.toString().compareTo(iMAProfileInfo2.toString());
            }
            return iMAProfileInfo2.toString().compareTo(iMAProfileInfo.toString());
        }
    }
}

