/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.cfm;

import cerent.cms.model.IMAProfileInfo;
import cerent.cms.model.MAProfileInfo;
import cerent.cms.ui.AbstractProvTableModel;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class MAProfileTableModel
extends AbstractProvTableModel {
    private ArrayList<IMAProfileInfo> mProfileList = new ArrayList();
    private Frame frame;
    private boolean isDirty;
    private static final int MAX_VLANID = 4094;

    public MAProfileTableModel(Container container, boolean bl, String string) {
        super(null, false, "");
        this.frame = JOptionPane.getFrameForComponent(container);
        this.columnNames = new String[]{"Maintenance Profile Name", "VLAN ID", "CC Enable"};
    }

    @Override
    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Short.class;
            }
            case 2: {
                return Boolean.class;
            }
        }
        return Boolean.class;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.mProfileList.size();
    }

    protected void addMAProfileTableRow(int n) {
        for (int i = 0; i < n; ++i) {
            this.mProfileList.add(new MAProfileInfo());
        }
        this.fireTableDataChanged();
    }

    protected void removeMAProfileTableRow(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i] - i;
            IMAProfileInfo iMAProfileInfo = this.mProfileList.remove(n);
        }
        this.fireTableDataChanged();
    }

    protected ArrayList<IMAProfileInfo> getMAProfilesFromTable(int[] nArray) {
        ArrayList<IMAProfileInfo> arrayList = new ArrayList<IMAProfileInfo>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            IMAProfileInfo iMAProfileInfo = this.mProfileList.get(n);
            arrayList.add(iMAProfileInfo);
        }
        return arrayList;
    }

    public void applyToModel() throws Exception {
    }

    @Override
    public Object getValueAt(int n, int n2) {
        IMAProfileInfo iMAProfileInfo = this.mProfileList.get(n);
        switch (n2) {
            case 0: {
                return new String(iMAProfileInfo.getMAName());
            }
            case 1: {
                if (iMAProfileInfo.getVlanId() == -1) {
                    return null;
                }
                return new Short(iMAProfileInfo.getVlanId());
            }
            case 2: {
                return new Boolean(iMAProfileInfo.getCCEnabled());
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        IMAProfileInfo iMAProfileInfo = this.mProfileList.get(n);
        switch (n2) {
            case 1: {
                Short s = (Short)object;
                if (s != null && s > 0 && s < 4094) {
                    iMAProfileInfo.setVlanId(s.shortValue());
                    break;
                }
                ErrorMsg.displayError((Component)this.frame, (EID)NEMC.EID_ERROR_PROVISIONING_VLAN_ID);
                break;
            }
            case 0: {
                if (object != null && ((String)object).length() > 0 && ((String)object).length() <= 43) {
                    iMAProfileInfo.setMAName((String)object);
                    break;
                }
                ErrorMsg.displayError((Component)this.frame, (EID)NEMC.EID_CFM_MA_LENGTH_ERROR);
                break;
            }
            case 2: {
                iMAProfileInfo.setCCEnabled(((Boolean)object).booleanValue());
            }
        }
    }

    private boolean isProfileNameExists(String string) {
        IMAProfileInfo iMAProfileInfo = null;
        for (int i = 0; i < this.mProfileList.size(); ++i) {
            iMAProfileInfo = this.mProfileList.get(i);
            if (iMAProfileInfo == null || !string.equals(iMAProfileInfo.getMAName())) continue;
            return true;
        }
        return false;
    }

    protected IMAProfileInfo getMAProfileFromTable(int n) {
        if (n + 1 <= this.mProfileList.size()) {
            return this.mProfileList.get(n);
        }
        return null;
    }

    protected boolean checkForInvalidDomains(int n) {
        boolean bl = false;
        IMAProfileInfo iMAProfileInfo = null;
        iMAProfileInfo = this.mProfileList.get(n);
        if (!iMAProfileInfo.isValid()) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            default: 
        }
        return true;
    }

    public ArrayList<IMAProfileInfo> getMAProfileCurrentList(boolean bl) {
        if (bl) {
            this.removeNotValidMAProfile();
        }
        return this.mProfileList;
    }

    private void removeNotValidMAProfile() {
        ArrayList<IMAProfileInfo> arrayList = new ArrayList<IMAProfileInfo>();
        IMAProfileInfo iMAProfileInfo = null;
        for (int i = 0; i < this.mProfileList.size(); ++i) {
            iMAProfileInfo = this.mProfileList.get(i);
            if (!iMAProfileInfo.isValid()) continue;
            arrayList.add(iMAProfileInfo);
        }
        this.mProfileList = arrayList;
        this.fireTableDataChanged();
    }

    protected boolean checkForInvalidDomains() {
        boolean bl = false;
        IMAProfileInfo iMAProfileInfo = null;
        for (int i = 0; i < this.mProfileList.size(); ++i) {
            iMAProfileInfo = this.mProfileList.get(i);
            if (iMAProfileInfo.isValid()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void setMAProfileCurrentList(ArrayList<IMAProfileInfo> arrayList) {
        this.mProfileList = arrayList;
        for (int i = 0; i < arrayList.size(); ++i) {
            IMAProfileInfo iMAProfileInfo = arrayList.get(i);
        }
        this.fireTableDataChanged();
    }

    public void forceDirty() {
        this.isDirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    public void resetDirty() {
        this.isDirty = false;
    }

    public void setEmptyTableModel() {
        this.setMAProfileCurrentList(new ArrayList<IMAProfileInfo>());
        this.isDirty = false;
    }
}

