/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.circuits.IAdminStatePanel;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.PluralisationUtil;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedDialog;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public abstract class AbstractAdminStatePanel
extends JPanel
implements IAdminStatePanel {
    public static final String SINGLE_CIRCUIT_DROP_PORTS_NOT_SET_PREFIX = "The  circuit state has not been applied to at least one drop on the following circuit:";
    public static final String MULTI_CIRCUIT_DROP_PORTS_NOT_SET_PREFIX = "The circuit state has not been applied to at least one drop on the following circuits: ";
    private static final String PORT_ICON_MSG = "\nUse the port icons on the detailed circuit map to determine which ports are affected.\nDouble-clicking the port icon navigates to the port display, in which individual port states can be directly set.";
    protected UComboBox adminStateCB;
    private static final String PREF_KEY = "ShowPortStateFail_EDIT";

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public int getAdminState() {
        return ((Attribute)this.adminStateCB.getSelectedItem()).getIntValue();
    }

    @Override
    public int getPortsState() {
        return this.getAdminState();
    }

    @Override
    public void setEnabled(INetCircuit iNetCircuit, boolean bl) {
        if (bl) {
            this.enableAll();
        } else {
            this.disableAll();
        }
    }

    @Override
    public JComponent registerActionListener(ActionListener actionListener) {
        this.adminStateCB.addActionListener(actionListener);
        return this.adminStateCB;
    }

    @Override
    public JComponent getActionEventSource() {
        return this.adminStateCB;
    }

    @Override
    public boolean isDirty() {
        return this.getAdminState() != -2;
    }

    @Override
    public void applyToCircuit(INetCircuit iNetCircuit) throws IncorrectCircuitState, AdminStateProvisioningError {
        int n = this.getAdminState();
        int n2 = this.getPortsState();
        if (n != -2) {
            if (!this.isIS(n) && !this.ConfirmDialog(this, n, this.isDropPortsSelected())) {
                this.setAdminState(-2);
            } else {
                StringBuffer stringBuffer;
                String string;
                ArrayList arrayList;
                iNetCircuit.setAdminState(n);
                if (this.isDropPortsSelected() && !NetCircuitModel.setAdminStateOnDropPorts(iNetCircuit, n2, arrayList = new ArrayList())) {
                    string = ErrorMsg.getString((EID)NEMC.WID_CURR_STATE_OR_TYPE_NOT_ALLOWED_PARAM_1, (Object)NetworkDefaults.circuitAdminStateToString(n2));
                    stringBuffer = new StringBuffer(SINGLE_CIRCUIT_DROP_PORTS_NOT_SET_PREFIX);
                    AbstractAdminStatePanel.buildDropPortsNotSet(iNetCircuit, arrayList, stringBuffer);
                    IgnorableDialog.detailedDialog((Component)this, (String)string, (String)stringBuffer.toString(), (String)"Apply to Ports Results", (String)PREF_KEY, (String)"Circuit Edit Dialog Apply Circuit State to Ports Failure");
                }
                if (iNetCircuit.getCircuitTypeObj().isOchccCircuitType() || iNetCircuit.getCircuitTypeObj().isOchncType()) {
                    arrayList = new ArrayList();
                    n2 = this.getAdminState();
                    if (!NetCircuitModel.setAdminStateOnRegenTrkPorts(iNetCircuit, n2, arrayList)) {
                        string = ErrorMsg.getString((EID)NEMC.WID_CURR_STATE_OR_TYPE_NOT_ALLOWED_PARAM_1, (Object)NetworkDefaults.circuitAdminStateToString(n2));
                        stringBuffer = new StringBuffer("The  circuit state has not been applied to at least one regen port on the following circuit:");
                        AbstractAdminStatePanel.buildDropPortsNotSet(iNetCircuit, arrayList, stringBuffer);
                        IgnorableDialog.detailedDialog((Component)this, (String)string, (String)stringBuffer.toString(), (String)"Apply to Ports Results", (String)"ShowRegenPortStateFail_EDIT", (String)"Circuit Edit Dialog Apply Circuit State to Regen Ports Failure");
                    }
                }
            }
        }
    }

    public static void buildDropPortsNotSet(INetCircuit iNetCircuit, ArrayList arrayList, StringBuffer stringBuffer) {
        String string = "   ";
        int n = 4;
        stringBuffer.append(iNetCircuit.getCircuitName()).append(":");
        if (arrayList.size() > n) {
            stringBuffer.append(string).append(" (more than four ports were not set).\n");
        } else {
            stringBuffer.append(".\n");
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(string).append((String)arrayList.get(i)).append("\n");
            }
        }
    }

    public static void showDropPortsFailure(Component component, int n, int n2, StringBuffer stringBuffer) {
        if (n2 > 0) {
            DetailedDialog detailedDialog = DetailedDialog.instance((Frame)JOptionPane.getFrameForComponent(component), (String)"Warning");
            detailedDialog.setText(ErrorMsg.getString((EID)NEMC.WID_CURR_STATE_OR_TYPE_NOT_ALLOWED_PARAM_1, (Object)NetworkDefaults.circuitAdminStateToString(n)), CerentDialog.WARNING_ICON);
            stringBuffer.append(PORT_ICON_MSG);
            detailedDialog.append(stringBuffer.toString());
            detailedDialog.setSize(400, detailedDialog.getHeight());
            detailedDialog.show();
        }
    }

    public static void showAdminStateResult(Component component, int n, int n2, int n3, int n4, StringBuffer stringBuffer, int n5, StringBuffer stringBuffer2) {
        String string;
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        ImageIcon imageIcon = null;
        stringBuffer4.append(n2).append(PluralisationUtil.s(" circuit", n2)).append(" (out of ").append(n3).append(" selected) ").append(PluralisationUtil.s("was", n2)).append(" successfully updated.\n\n");
        if (stringBuffer.length() > 0) {
            imageIcon = CerentDialog.WARNING_ICON;
            string = ErrorMsg.getString((EID)NEMC.WID_CURR_STATE_OR_TYPE_NOT_ALLOWED_PARAM_1, (Object)NetworkDefaults.circuitAdminStateToString(n));
            stringBuffer4.append(string + "\n");
            stringBuffer3.append(n4 > 0 ? MULTI_CIRCUIT_DROP_PORTS_NOT_SET_PREFIX : SINGLE_CIRCUIT_DROP_PORTS_NOT_SET_PREFIX).append(stringBuffer).append(PORT_ICON_MSG);
        }
        if (stringBuffer2.length() > 0) {
            imageIcon = CerentDialog.FATAL_ICON;
            stringBuffer3.append("The " + PluralisationUtil.s("state", n5) + " of the following " + PluralisationUtil.s("circuit", n5) + " " + PluralisationUtil.s("has", n5) + " not been updated:\n").append(stringBuffer2).append("\n\nPlease edit the individual " + PluralisationUtil.s("circuit", n5) + " to investigate and/or retry.");
        }
        if (stringBuffer3.length() > 0) {
            string = DetailedDialog.instance((Frame)JOptionPane.getFrameForComponent(component), (String)"Circuit State Transition Results");
            string.setText(stringBuffer4.toString(), imageIcon);
            string.append(stringBuffer3.toString());
            string.setSize(500, string.getHeight());
            string.show();
        }
    }

    public boolean ConfirmDialog(JComponent jComponent, int n, boolean bl) {
        String string = "will cause " + (bl ? "lines " : "connections ") + "to go out of service";
        return CerentDialog.yesNoDialog((Component)jComponent, (String)("The selected operation(s) " + string + (this.showAffectingWarning() ? (3 == n ? "." : " and " + (1 == n ? "will" : "might") + " be service affecting.\n" + (1 == n ? "AIS will be injected upstream and downstream.\n" : "")) : ".") + "\nIs it OK to apply these changes?"), (String)"Confirmation");
    }

    protected boolean showAffectingWarning() {
        return true;
    }

    protected boolean isIS(int n) {
        return n == 0;
    }
}

