/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.circuits.CircuitFilterCriteria;
import cerent.util.gui.AbstractPropertyDialogSheet;
import cerent.util.gui.AbstractPropertyPane;
import cerent.util.gui.CheckableItem;
import cerent.util.gui.CheckableList;
import cerent.util.gui.IntegerPropertyEditor;
import cerent.util.gui.StringChoicePropertyEditor;
import cerent.util.gui.StringPropertyEditor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AbstractCircuitFilterPane
extends AbstractPropertyPane {
    protected static final int PREFERRED_HEIGHT = 22;
    protected int labelPreferredWidth;
    protected int editorPreferredWidth;
    protected CircuitFilterCriteria filterCriteria;

    public AbstractCircuitFilterPane(String string, AbstractPropertyDialogSheet abstractPropertyDialogSheet, CircuitFilterCriteria circuitFilterCriteria, int n, int n2) {
        super(string, abstractPropertyDialogSheet);
        this.filterCriteria = circuitFilterCriteria;
        this.labelPreferredWidth = n;
        this.editorPreferredWidth = n2;
    }

    public void restoreDefaults() {
        this.parent.setApply();
    }

    protected void regularizePropertyEditor(StringPropertyEditor stringPropertyEditor) {
        stringPropertyEditor.setPreferredSize(new Dimension(this.labelPreferredWidth + this.editorPreferredWidth, 22));
        stringPropertyEditor.setLabelPreferredSize(this.labelPreferredWidth, 22);
        stringPropertyEditor.setEditorPreferredSize(this.editorPreferredWidth, 22);
        stringPropertyEditor.setEnabled(true);
    }

    protected void regularizePropertyEditor(StringChoicePropertyEditor stringChoicePropertyEditor) {
        stringChoicePropertyEditor.setPreferredSize(new Dimension(this.labelPreferredWidth + this.editorPreferredWidth, 22));
        stringChoicePropertyEditor.setLabelPreferredSize(this.labelPreferredWidth, 22);
        stringChoicePropertyEditor.setEditorPreferredSize(this.editorPreferredWidth, 22);
        stringChoicePropertyEditor.setEnabled(true);
    }

    protected void regularizePropertyEditor(IntegerPropertyEditor integerPropertyEditor) {
        integerPropertyEditor.setPreferredSize(new Dimension(this.labelPreferredWidth + this.editorPreferredWidth, 22));
        integerPropertyEditor.setLabelPreferredSize(this.labelPreferredWidth, 22);
        integerPropertyEditor.setEditorPreferredSize(this.editorPreferredWidth, 22);
        integerPropertyEditor.setEnabled(true);
    }

    protected void regularizeCheckableList(CheckableList checkableList, int n) {
        checkableList.setBackground(this.getBackground());
        checkableList.setVisibleRowCount(n);
        checkableList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AbstractCircuitFilterPane.this.parent.setApply();
            }
        });
    }

    protected void regularizePropertyEditor(JPanel jPanel, JLabel jLabel, int n) {
        jPanel.setPreferredSize(new Dimension(this.labelPreferredWidth + this.editorPreferredWidth, n));
        jLabel.setPreferredSize(new Dimension(this.labelPreferredWidth, 22));
    }

    protected List getSelectedObjects(CheckableList checkableList) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ListModel listModel = checkableList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            if (!checkableItem.isSelected()) continue;
            arrayList.add(checkableItem.getObject());
        }
        return arrayList;
    }

    protected void setSelectedObjects(CheckableList checkableList, List list) {
        ListModel listModel = checkableList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            checkableItem.setSelected(list.contains(checkableItem.getObject()));
        }
    }

    protected void enableSelectedObjects(CheckableList checkableList, List list) {
        ListModel listModel = checkableList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            checkableItem.setEnabled(list.contains(checkableItem.getObject()));
        }
    }

    protected void clearCheckableList(CheckableList checkableList) {
        ListModel listModel = checkableList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            checkableItem.setSelected(false);
        }
    }

    protected void sortCollection(Collection collection, Comparator comparator) {
        Object[] objectArray = collection.toArray();
        Arrays.sort(objectArray, comparator);
        collection.clear();
        collection.addAll(Arrays.asList(objectArray));
    }
}

