/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetVcatTermination;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AddVcatMembersDialog;
import cerent.cms.ui.circuits.CcdVcatRoutePane;
import cerent.cms.ui.circuits.VcatMemberTableData;
import java.awt.event.ActionEvent;
import java.util.Arrays;

public class AddVcatMemRoutePrefsPane
extends CcdVcatRoutePane {
    public AddVcatMemRoutePrefsPane(AddVcatMembersDialog addVcatMembersDialog, WzDiagDebug wzDiagDebug, String string) {
        super(addVcatMembersDialog, wzDiagDebug, string);
    }

    @Override
    protected int getVcatTxMembers() {
        return this.getAddVcatMemDlg().vcatTxMembers;
    }

    @Override
    public void validatePage() throws Exception {
        if (this.db.on()) {
            this.db.println("validatePage()");
        }
        super.validatePage();
    }

    @Override
    protected void addOrRouteNewCircuit() throws Exception {
        if (!this.urn) {
            this.getAbstractCktDlg().deleteDestination();
            if (this.db.on) {
                this.db.println("validatePage: deleteDestination() worked");
            }
            this.getAbstractCktDlg().addDestination(true);
            if (this.db.on) {
                this.db.println("validatePage: addDestination(true) worked");
            }
        }
    }

    @Override
    public void revalidateData() {
        INetCircuitEnd iNetCircuitEnd = this.getAbstractCktDlg().getSource();
        INetCircuitEnd iNetCircuitEnd2 = this.getAbstractCktDlg().getDest();
        INetVcatTermination iNetVcatTermination = ((NetVcatCircuit)this.getAbstractCktDlg().getCircuit()).getVcatTermFromCktEnd(iNetCircuitEnd);
        Short[] shortArray = iNetVcatTermination.getAvailableVcatMemNums();
        this.availableMemIds = new Integer[shortArray.length];
        for (int i = 0; i < shortArray.length; ++i) {
            this.availableMemIds[i] = new Integer(shortArray[i].intValue());
        }
        super.revalidateData();
        this.memberCktList = Arrays.asList(this.getAddVcatMemDlg().getNewCkts());
        if (!this.isFcmrPort && !this.isCe1000Port) {
            this.extendedBufferChBx.setSelected(false);
            this.extendedBufferChBx.setVisible(false);
        }
        NetVcatCircuit netVcatCircuit = (NetVcatCircuit)this.getAbstractCktDlg().getCircuit();
        if (!this.isOpenVcat()) {
            if (netVcatCircuit.getVcatRoutingPref() == 0) {
                int n = netVcatCircuit.getPhysicalRoutingPref();
                if (n == 2) {
                    this.independentFiberRB.setSelected(true);
                    this.commonFiberRB.setEnabled(false);
                    this.independentFiberRB.setEnabled(false);
                    this.diversePathAllCB.setEnabled(true);
                    if (!this.getAddVcatMemDlg().getCircuitInfo().isBackHaulCircuit()) {
                        if (this.protectionCB.getItemCount() == 3) {
                            this.protectionCB.addItem(protectionChoices[3]);
                        }
                        if (this.protectAllCB.getItemCount() == 3) {
                            this.protectAllCB.addItem((Object)protectionChoices[3]);
                        }
                    }
                } else if (n == 1) {
                    this.commonFiberRB.setSelected(true);
                    this.urnCB.setSelected(false);
                    this.urnCB.setEnabled(false);
                    this.diversePathAllCB.setEnabled(false);
                    if (this.protectionCB.getItemCount() > 3) {
                        this.protectionCB.removeItemAt(3);
                    }
                    if (this.protectAllCB.getItemCount() > 3) {
                        this.protectAllCB.removeItemAt(3);
                    }
                    if (netVcatCircuit.isSplitRoutingEnabled()) {
                        this.commonFiberRB.setEnabled(true);
                        this.independentFiberRB.setEnabled(true);
                    } else {
                        this.commonFiberRB.setEnabled(false);
                        this.independentFiberRB.setEnabled(false);
                    }
                }
            } else {
                int n = netVcatCircuit.getVcatRoutingPref();
                this.commonFiberRB.setEnabled(false);
                this.independentFiberRB.setEnabled(false);
                if (n == 1) {
                    this.commonFiberRB.setSelected(true);
                    this.urnCB.setSelected(false);
                    this.urnCB.setEnabled(false);
                    this.disableURN = true;
                    this.diversePathAllCB.setEnabled(false);
                    if (this.protectionCB.getItemCount() > 3) {
                        this.protectionCB.removeItemAt(3);
                    }
                    if (this.protectAllCB.getItemCount() > 3) {
                        this.protectAllCB.removeItemAt(3);
                    }
                } else if (n == 2) {
                    this.independentFiberRB.setSelected(true);
                    this.diversePathAllCB.setEnabled(true);
                    if (!this.getAddVcatMemDlg().getCircuitInfo().isBackHaulCircuit()) {
                        if (this.protectionCB.getItemCount() == 3) {
                            this.protectionCB.addItem(protectionChoices[3]);
                        }
                        if (this.protectAllCB.getItemCount() == 3) {
                            this.protectAllCB.addItem((Object)protectionChoices[3]);
                        }
                    }
                }
            }
            this.checkMemberProtection();
        } else if (netVcatCircuit.getVcatRoutingPref() == 0) {
            int n = netVcatCircuit.getPhysicalRoutingPref();
            if (n == 2) {
                this.independentFiberRB.setSelected(true);
                this.commonFiberRB.setEnabled(false);
                this.independentFiberRB.setEnabled(false);
                this.diversePathAllCB.setEnabled(true);
            } else {
                this.commonFiberRB.setSelected(true);
                this.urnCB.setSelected(false);
                this.urnCB.setEnabled(false);
                this.diversePathAllCB.setEnabled(false);
                if (netVcatCircuit.isSplitRoutingEnabled()) {
                    if (this.getAbstractCktDlg().isUniqueNodeDrop() && this.checkForCommonFiber()) {
                        this.commonFiberRB.setEnabled(true);
                        this.independentFiberRB.setEnabled(true);
                    } else {
                        this.commonFiberRB.setSelected(false);
                        this.commonFiberRB.setEnabled(false);
                        this.independentFiberRB.setSelected(true);
                        this.independentFiberRB.setEnabled(false);
                        this.urnCB.setEnabled(true);
                        this.selectedIndependentRouting();
                        this.diversePathAllCB.setEnabled(true);
                    }
                } else {
                    this.commonFiberRB.setEnabled(false);
                    this.independentFiberRB.setEnabled(false);
                }
            }
        } else {
            int n = netVcatCircuit.getVcatRoutingPref();
            this.commonFiberRB.setEnabled(false);
            this.independentFiberRB.setEnabled(false);
            if (n == 1) {
                this.commonFiberRB.setSelected(true);
                this.selectedCommonRouting();
                this.urnCB.setSelected(false);
                this.urnCB.setEnabled(false);
                this.disableURN = true;
                this.diversePathAllCB.setEnabled(false);
            } else if (n == 2) {
                this.independentFiberRB.setSelected(true);
                this.diversePathAllCB.setEnabled(true);
                this.selectedIndependentRouting();
            }
        }
    }

    @Override
    protected void syncButtons() {
        boolean bl = !this.autoRouteCB.isSelected() || this.autoRouteCB.isSelected() && (this.urnCB.isSelected() || this.rrbcCB.isSelected());
        this.getAbstractCktDlg().setNextEnabled(bl);
        this.getAbstractCktDlg().setFinishEnabled(!bl);
    }

    @Override
    protected String getNextPaneName() {
        if (!this.urn) {
            this.getAddVcatMemDlg();
            return "Route Review and Edit";
        }
        this.getAddVcatMemDlg();
        return "Constraints For Automatic Routing";
    }

    @Override
    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("AddVcatMemRoutePrefs:");
        return stringBuffer.toString();
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdVcatRoutePane;
    }

    private AddVcatMembersDialog getAddVcatMemDlg() {
        return (AddVcatMembersDialog)this.parent;
    }

    protected void checkMemberProtection() {
        boolean bl = false;
        if (this.independentFiberRB.isSelected()) {
            bl = true;
        }
        for (int i = 0; i < this.tbModel.tabData.size(); ++i) {
            VcatMemberTableData vcatMemberTableData = (VcatMemberTableData)this.tbModel.tabData.get(i);
            int n = vcatMemberTableData.protectionType;
            if (!bl) {
                if (n == 0) {
                    vcatMemberTableData.protectionType = 6;
                }
            } else if (n == 6) {
                vcatMemberTableData.protectionType = 0;
            }
            if (n == 0 || n == 6) {
                if (bl) {
                    vcatMemberTableData.nodeDiverseOption = this.getDiversityInt(this.nodeDiverseOptions[1]);
                    continue;
                }
                vcatMemberTableData.nodeDiverseOption = this.getDiversityInt(this.NOT_APPLICABLE);
                continue;
            }
            vcatMemberTableData.nodeDiverseOption = this.getDiversityInt(this.NOT_APPLICABLE);
        }
        this.tbModel.fireTableDataChanged();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.commonFiberRB) {
            this.urnCB.setSelected(false);
            this.urnCB.setEnabled(false);
        } else if (actionEvent.getSource() == this.independentFiberRB) {
            this.urnCB.setSelected(false);
            this.urnCB.setEnabled(true);
        }
    }

    private boolean checkForCommonFiber() {
        int n = ((AddVcatMembersDialog)this.getAbstractCktDlg()).getCmnFiberEntityIndex();
        if (n == -1) {
            return ((AddVcatMembersDialog)this.getAbstractCktDlg()).getDstPane().checkForCommonFiber();
        }
        return ((AddVcatMembersDialog)this.getAbstractCktDlg()).getDstPane().checkForCommonFiber(n);
    }
}

