/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.NetAdminState;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ui.AbstractProvPane;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.circuits.AbstractAdminStatePanel;
import cerent.cms.ui.circuits.IAdminStatePanel;
import cerent.util.SDebug;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;

public class AdminStatePanel
extends AbstractAdminStatePanel
implements IAdminStatePanel,
ActionListener {
    private static final int MARGIN = 10;
    private Attribute[] adminStateAttrs;
    private boolean applyToDropPorts;
    private boolean applyToDropPortsApplicable;
    private boolean applyToDropPortsOnly;
    protected static final String nullMessage = null;
    protected static final boolean noShowState = false;
    protected static final boolean noApplyToDropPortsOnly = false;
    protected JLabel serviceStateLabel;
    protected JLabel adminStateLB;
    protected JPanel dropPortsPanel;
    protected JCheckBox dropPortsCB;

    private boolean noChangeSupported(Attribute[] attributeArray) {
        for (int i = attributeArray.length - 1; i > -1; --i) {
            if (attributeArray[i].getValue() != -2) continue;
            return true;
        }
        return false;
    }

    protected AdminStatePanel(String string, String string2, boolean bl, int n, boolean bl2, Attribute[] attributeArray) {
        JComponent jComponent;
        this.adminStateAttrs = attributeArray;
        if (this.adminStateAttrs == null) {
            SDebug.root.severe("Null admin state attributes");
            this.adminStateAttrs = NetAdminState.getAdminStateAttrs();
        }
        boolean bl3 = this.noChangeSupported(this.adminStateAttrs);
        this.applyToDropPortsApplicable = true;
        this.applyToDropPorts = false;
        this.applyToDropPortsOnly = bl2;
        this.setLayout(new BoxLayout(this, 1));
        if (string != null) {
            this.setBorder(BorderFactory.createTitledBorder(string));
        }
        if (string2 != null && string2.length() > 0) {
            jComponent = new JLabel(string2);
            ((JLabel)jComponent).setUI((LabelUI)new MultiLineLabelUI());
            this.add(jComponent);
        }
        if (bl) {
            this.serviceStateLabel = new JLabel("Circuit State: ");
            this.add(this.serviceStateLabel);
            this.setServiceState(n);
        } else {
            this.serviceStateLabel = null;
        }
        if (bl2) {
            jComponent = AbstractProvPane.createHorizontalPanel(null);
            jComponent.setAlignmentX(0.0f);
            this.dropPortsCB = new JCheckBox("Change drop port admin state:");
            jComponent.add(this.dropPortsCB);
            this.dropPortsCB.addActionListener(this);
            this.adminStateCB = new UComboBox((Object[])this.adminStateAttrs);
            jComponent.add((Component)this.adminStateCB);
            this.adminStateCB.addActionListener((ActionListener)this);
            this.adminStateCB.setEnabled(false);
            this.add(jComponent);
        } else {
            jComponent = AbstractProvPane.createHorizontalPanel(null);
            jComponent.setAlignmentX(0.0f);
            this.adminStateLB = new JLabel(bl3 ? "Target Circuit Admin State:" : "State: ");
            jComponent.add(this.adminStateLB);
            this.adminStateCB = new UComboBox((Object[])this.adminStateAttrs);
            jComponent.add((Component)this.adminStateCB);
            this.adminStateCB.addActionListener((ActionListener)this);
            this.add(jComponent);
            this.dropPortsPanel = AbstractProvPane.createHorizontalPanel(null);
            this.dropPortsPanel.setAlignmentX(0.0f);
            this.dropPortsPanel.add(Box.createHorizontalStrut(10));
            this.dropPortsCB = new JCheckBox("Apply to drop ports");
            this.dropPortsPanel.add(this.dropPortsCB);
            this.dropPortsCB.addActionListener(this);
            this.add(this.dropPortsPanel);
        }
        this.setAdminState(bl3 ? -2 : 3);
    }

    public AdminStatePanel(String string, String string2, INetCircuit iNetCircuit, boolean bl, boolean bl2) {
        this(string, string2, bl2, iNetCircuit.getServiceState(), false, NetAdminState.getAdminStateAttrs(iNetCircuit, bl));
    }

    public AdminStatePanel(String string, INetCircuit iNetCircuit, boolean bl) {
        this(string, nullMessage, false, -1, false, NetAdminState.getAdminStateAttrs(iNetCircuit, bl));
    }

    public AdminStatePanel(String string, INetCircuit[] iNetCircuitArray, boolean bl) {
        this(string, nullMessage, false, -1, false, NetAdminState.getAdminStateAttrs(iNetCircuitArray, bl));
    }

    public AdminStatePanel(String string, INetCircuit[] iNetCircuitArray, boolean bl, boolean bl2) {
        this(string, nullMessage, false, -1, bl2, bl2 ? NetAdminState.getAdminStateAttrs(bl) : NetAdminState.getAdminStateAttrs(iNetCircuitArray, bl));
    }

    public AdminStatePanel(String string, ICircuitType iCircuitType, boolean bl) {
        this(string, nullMessage, false, -1, false, NetAdminState.getAdminStateAttrs(iCircuitType, bl));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        if (!this.applyToDropPortsApplicable) {
            return;
        }
        int n = this.getAdminState();
        boolean bl2 = bl = n != -2 && n != 4;
        if (actionEvent.getSource() == this.adminStateCB) {
            if (!this.applyToDropPortsOnly && this.dropPortsCB.isEnabled() != bl) {
                this.dropPortsCB.setEnabled(bl);
                this.dropPortsCB.setSelected(bl && this.applyToDropPorts);
            }
        } else if (actionEvent.getSource() == this.dropPortsCB && this.dropPortsCB.isEnabled()) {
            this.applyToDropPorts = this.dropPortsCB.isSelected();
            if (this.applyToDropPortsOnly) {
                this.adminStateCB.setEnabled(this.applyToDropPorts);
            }
        }
    }

    @Override
    public void setAdminState(int n) {
        if (this.getAdminState() == n) {
            return;
        }
        for (int i = 0; i < this.adminStateAttrs.length; ++i) {
            if (this.adminStateAttrs[i].getIntValue() != n) continue;
            this.adminStateCB.setSelectedItem((Object)this.adminStateAttrs[i]);
        }
    }

    private void setServiceState(int n) {
        if (this.serviceStateLabel != null) {
            this.serviceStateLabel.setText("Current Circuit State: " + NetworkDefaults.circuitServiceStateToString(n));
        }
    }

    @Override
    public void setApplyDropPorts(boolean bl) {
        if (this.applyToDropPortsApplicable) {
            if (this.dropPortsCB.isEnabled()) {
                this.dropPortsCB.setSelected(bl);
            } else {
                this.dropPortsCB.setSelected(false);
            }
            this.applyToDropPorts = bl;
        }
    }

    @Override
    public boolean getApplyDropPorts() {
        return this.applyToDropPorts;
    }

    @Override
    public boolean isDropPortsSelected() {
        return this.dropPortsCB.isSelected();
    }

    public void hidePopup() {
        this.adminStateCB.hidePopup();
    }

    @Override
    public void setEnabled(INetCircuit iNetCircuit, boolean bl) {
        this.setAdminStateCBEnabled(iNetCircuit, bl);
        this.setDropPortsCBEnabled(iNetCircuit, bl);
    }

    @Override
    public void setApplyDropPortsApplicable(boolean bl) {
        if (!this.applyToDropPortsOnly) {
            this.applyToDropPortsApplicable = bl;
            this.dropPortsCB.setEnabled(bl);
        }
    }

    @Override
    public void disableAll() {
        this.adminStateCB.setEnabled(false);
        this.dropPortsCB.setEnabled(false);
        this.adminStateLB.setEnabled(false);
    }

    @Override
    public void enableAll() {
        this.adminStateCB.setEnabled(true);
        this.dropPortsCB.setEnabled(true);
        this.adminStateLB.setEnabled(true);
    }

    private void setAdminStateCBEnabled(INetCircuit iNetCircuit, boolean bl) {
        if (!NetAdminState.circuitStatusAllowsAdminStateToBeEdited(iNetCircuit.getState())) {
            bl = false;
        }
        if (!this.applyToDropPortsOnly && !this.dropPortsCB.isSelected()) {
            this.adminStateLB.setEnabled(bl);
            this.adminStateCB.setEnabled(bl);
        }
    }

    private void setDropPortsCBEnabled(INetCircuit iNetCircuit, boolean bl) {
        if (iNetCircuit.isMonitorCircuit()) {
            bl = false;
        } else if (!NetAdminState.circuitAllowsStateApplicationToDrops(iNetCircuit)) {
            bl = false;
            this.applyToDropPorts = false;
            this.applyToDropPortsApplicable = false;
        } else if (!this.isDirty()) {
            bl = false;
        }
        this.dropPortsCB.setEnabled(bl);
    }
}

