/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.LoTunnelInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.circuits.AutorangeInfo;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.vlan.NetVlanInfo;
import cerent.util.AnnotatedException;
import cerent.util.DetailedLog;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import cerent.util.SONETTDMTerminology;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.ProgressDialogControl;
import cerent.util.gui.ProgressDialogResult;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observer;

public class Autoranger
implements ProgressDialogControl {
    private static final SDebug db = new SDebug("Autoranger");
    private static final String PREF_AUTORANGE_AVAIL_PORTS_VAL = "autorangeAvailPorts";
    private static final String PREF_AUTORANGE_AVAIL_PORTS_DESC = "Always autorange available ports.";
    private static final String PRI_SOURCE_STRING = "Primary Source";
    private static final String PRI_DEST_STRING = "Primary Destination";
    private static final String SEC_SOURCE_STRING = "Secondary Source";
    private static final String SEC_DEST_STRING = "Secondary Destination";
    CircuitCreatInfo cktInfo;
    String cktBaseName;
    RoutePrefs origRoutePrefs;
    INodeModel sourceNode;
    INodeModel altSourceNode;
    INodeModel destNode;
    INodeModel altDestNode;
    int priSourceEqType = 0;
    int secSourceEqType = 0;
    int priDestEqType = 0;
    int secDestEqType = 0;
    List priSourceList;
    List secSourceList;
    List priDestList;
    List secDestList;
    INetCircuitEnd priSource;
    INetCircuitEnd secSource;
    INetCircuitEnd priDest;
    INetCircuitEnd secDest;
    List priSourcePortList;
    List secSourcePortList;
    List priDestPortList;
    List secDestPortList;
    boolean isEther;
    boolean isTunnel;
    NetVlanInfo[] vlanSet;
    boolean enableStp;
    boolean upsrSwitchOnPdip;
    IRevertiveBehavior upsrReversion;
    short upsrSfBerLevel;
    short upsrSdBerLevel;
    int NUM_TO_CREATE;
    int OFFSET;
    int DELAY = 0;
    DetailedLog autoRangeLog = null;
    boolean stopRequested = false;
    boolean setAdminStateOnDrops = false;
    int adminStateOnDropsFailures = 0;
    StringBuffer adminStateOnDropsBuffer = new StringBuffer();
    boolean requestTransitTunnels = false;
    INodeModel lapStsGroomingNode;
    INetElement lapVtGroomingNe;
    List vtAndDs3MappedList;
    INodeModel mappedNodeModel;
    int ds3Sts;
    static final String FAILURE_DEFAULT = "See above.";
    static final String FAILURE_STOPPED_AUTORANGE = "User stopped autorange.";
    static final String FAILURE_PRI_SRC_ENDPOINTS = "Primary source has exhausted endpoint list.";
    static final String FAILURE_PRI_DST_ENDPOINTS = "Primary destination has exhausted endpoint list.";
    static final String FAILURE_SEC_SRC_ENDPOINTS = "Secondary source has exhausted endpoint list.";
    static final String FAILURE_SEC_DST_ENDPOINTS = "Secondary destination has exhausted endpoint list.";

    public Autoranger(AutorangeInfo autorangeInfo, int n, int n2) {
        this(autorangeInfo, n, n2, 0);
    }

    public Autoranger(AutorangeInfo autorangeInfo, int n, int n2, int n3) {
        this.NUM_TO_CREATE = n;
        this.OFFSET = n2;
        this.DELAY = n3;
        if (autorangeInfo != null) {
            this.cktInfo = autorangeInfo.cktInfo;
            this.cktBaseName = autorangeInfo.cktBaseName;
            this.origRoutePrefs = autorangeInfo.routePrefs;
            this.upsrSwitchOnPdip = autorangeInfo.upsrSwitchOnPdip;
            this.upsrReversion = autorangeInfo.upsrReversion;
            this.upsrSfBerLevel = autorangeInfo.upsrSfBerLevel;
            this.upsrSdBerLevel = autorangeInfo.upsrSdBerLevel;
            this.priSourceList = autorangeInfo.priSourceList;
            this.secSourceList = autorangeInfo.secSourceList;
            this.priDestList = autorangeInfo.priDestList;
            this.secDestList = autorangeInfo.secDestList;
            this.priSourcePortList = autorangeInfo.priSourcePortList;
            this.secSourcePortList = autorangeInfo.secSourcePortList;
            this.priDestPortList = autorangeInfo.priDestPortList;
            this.secDestPortList = autorangeInfo.secDestPortList;
            this.priSource = autorangeInfo.priSource;
            this.secSource = autorangeInfo.secSource;
            this.priDest = autorangeInfo.priDest;
            this.secDest = autorangeInfo.secDest;
            this.isEther = autorangeInfo.isEther;
            this.isTunnel = autorangeInfo.isTunnel;
            this.vlanSet = autorangeInfo.vlanSet;
            this.enableStp = autorangeInfo.enableStp;
            this.sourceNode = autorangeInfo.sourceNode;
            this.altSourceNode = autorangeInfo.altSourceNode;
            this.destNode = autorangeInfo.destNode;
            this.altDestNode = autorangeInfo.altDestNode;
            this.requestTransitTunnels = autorangeInfo.requestTransitTunnels;
            this.lapStsGroomingNode = autorangeInfo.lapStsGroomingNode;
            this.lapVtGroomingNe = autorangeInfo.lapVtGroomingNe;
            this.vtAndDs3MappedList = autorangeInfo.vtAndDs3MappedList;
            this.mappedNodeModel = autorangeInfo.mappedNodeModel;
            this.ds3Sts = autorangeInfo.ds3Sts;
        } else {
            db.println("Autoranger was given a null AutorangeInfo");
        }
    }

    public static boolean autorangeSupported(int n) {
        return n == 1 || n == 2 || n == 3 || n == 4 || n == 5;
    }

    public void setAdminStateOnDrops(boolean bl) {
        this.setAdminStateOnDrops = bl;
    }

    public int getAdminStateOnDropsFailures() {
        return this.adminStateOnDropsFailures;
    }

    public String getAdminStateOnDropsString() {
        return this.adminStateOnDropsBuffer.toString();
    }

    public static String prettyCircuitEndString(INetCircuitEnd iNetCircuitEnd) {
        return CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd);
    }

    private String getPortTextFromEntityList(List list) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            IEntityModel iEntityModel;
            if (stringBuffer.length() - n > 50) {
                stringBuffer.append("\n");
                n = stringBuffer.length();
            }
            if ((iEntityModel = (IEntityModel)list.get(i)).getGenericClass() == 7) {
                stringBuffer.append(CircuitEndCellRenderer.getPortString(iEntityModel, false));
            } else {
                stringBuffer.append(iEntityModel.toShortString());
            }
            if (i < list.size() - 1) {
                stringBuffer.append(',');
            }
            stringBuffer.append("    ");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    protected boolean updateEndpointsFromNextPort(Observer observer, String string, boolean bl, INodeModel iNodeModel, INetCircuitEnd iNetCircuitEnd, List list, List list2, List list3) throws Exception {
        Object object;
        int n;
        if (list.isEmpty() && iNetCircuitEnd != null && ((n = (object = iNetCircuitEnd.getEntityModel()).getEqType()) == 14 || n == 15)) {
            NetCircuitEnd netCircuitEnd = new NetCircuitEnd(iNetCircuitEnd);
            list.add(netCircuitEnd);
            if (db.on()) {
                db.println("\tNetCircuitEnd " + Autoranger.prettyCircuitEndString(netCircuitEnd) + " is being re-added to the endpointList." + "(" + string + ")");
            }
            return false;
        }
        list.removeAll(list3);
        this.specialCaseCheck(string, list, list3);
        if (list.isEmpty() && list2 != null && !list2.isEmpty()) {
            int n2;
            Object object2;
            if (!bl && observer != null && observer instanceof Component) {
                try {
                    int n3;
                    object = (IEntityModel)list2.get(0);
                    n = object.getEqType();
                    if (string.equals(PRI_SOURCE_STRING)) {
                        if (n == 32 && this.priDestEqType == 33 && this.vtAndDs3MappedList == null) {
                            throw new Exception("A DS3 to DS3XM circuit requires the use of a conversion circuit.");
                        }
                        n3 = this.priSourceEqType;
                    } else if (string.equals(PRI_DEST_STRING)) {
                        if (n == 32 && this.priSourceEqType == 33 && this.vtAndDs3MappedList == null) {
                            throw new Exception("A DS3 to DS3XM circuit requires the use of a conversion circuit.");
                        }
                        n3 = this.priDestEqType;
                    } else if (string.equals(SEC_SOURCE_STRING)) {
                        if (n == 32 && this.priDestEqType == 33 && this.vtAndDs3MappedList == null) {
                            throw new Exception("A DS3 to DS3XM circuit requires the use of a conversion circuit.");
                        }
                        n3 = this.secSourceEqType;
                    } else {
                        if (n == 32 && this.priSourceEqType == 33 && this.vtAndDs3MappedList == null) {
                            throw new Exception("A DS3 to DS3XM circuit requires the use of a conversion circuit.");
                        }
                        n3 = this.secDestEqType;
                    }
                    boolean bl2 = bl = n3 != n;
                    if (db.on()) {
                        db.println("\tPort changed, checking EqType for warning; old eq= " + n3 + ", " + "new eq= " + n);
                    }
                    if (string.equals(PRI_SOURCE_STRING)) {
                        this.priSourceEqType = n;
                    } else if (string.equals(PRI_DEST_STRING)) {
                        this.priDestEqType = n;
                    } else if (string.equals(SEC_SOURCE_STRING)) {
                        this.secSourceEqType = n;
                    } else {
                        this.secDestEqType = n;
                    }
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    throw exception;
                }
                if (bl) {
                    object = list2.size() == 1 ? "port has" : "ports have";
                    String string2 = list2.size() == 1 ? "this port" : "these ports";
                    String string3 = "Your request to create circuits has exceeded the resources\navailable on the " + string.toLowerCase() + " port.  The following " + (String)object + "\navailable resources that can be used to " + "continue circuit creation:\n\n" + this.getPortTextFromEntityList(list2) + "\n" + "Continue autoranging using " + string2 + "?";
                    n2 = IgnorableDialog.yesNoDialog((Component)((Component)((Object)observer)), (String)string3, (String)(object2 = "Continue Autoranging Using Ports on " + string + "?"), (String)PREF_AUTORANGE_AVAIL_PORTS_VAL, (String)PREF_AUTORANGE_AVAIL_PORTS_DESC) ? 1 : 0;
                    if (n2 == 0) {
                        throw new Exception("The user elected not to use additional ports on " + string + ".");
                    }
                }
            }
            object = new ArrayList();
            for (int i = 0; i < list2.size(); ++i) {
                try {
                    IEntityModel iEntityModel = (IEntityModel)list2.get(i);
                    object2 = NetCircuitManager.instance().getAvailSourcePoints(iNodeModel, iEntityModel, this.cktInfo);
                    object.add(iEntityModel);
                    if (object2 == null || object2.isEmpty()) continue;
                    object2.removeAll(list3);
                    this.specialCaseCheck(string, (List)object2, list3);
                    if (object2.isEmpty()) continue;
                    list.addAll(object2);
                    Autoranger.timestampDebug("\tChose a new entity; " + iEntityModel);
                    Autoranger.timestampDebug("\tadded some endpoints...");
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        INetCircuitEnd iNetCircuitEnd2 = (INetCircuitEnd)list.get(n2);
                        Autoranger.timestampDebug("\t" + n2 + "\t" + Autoranger.prettyCircuitEndString(iNetCircuitEnd2));
                    }
                    break;
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            list2.removeAll((Collection<?>)object);
        }
        if (!list.isEmpty()) {
            list3.add(list.get(0));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void executeTask(Observer observer) throws Exception {
        Object object;
        Object object2;
        Object object3;
        int n;
        int n2;
        Object object4;
        Object object5;
        Object object6;
        boolean bl = false;
        boolean bl2 = false;
        if (this.cktInfo == null) {
            throw new Exception("Circuit information was not specified.");
        }
        if (this.sourceNode == null) {
            throw new Exception("The primary source node was not specified.");
        }
        if (this.destNode == null) {
            throw new Exception("The primary destination node was not specified.");
        }
        if (this.cktBaseName == null) {
            throw new Exception("A circuit base name was not specified.");
        }
        if (this.origRoutePrefs == null) {
            throw new Exception("Route preferences were not specified.");
        }
        if (this.upsrReversion != null) {
            if (this.isEther || this.isTunnel) {
                if (this.sourceNode == null) throw new Exception("Source and/or destination nodes were not specified.");
                if (this.destNode == null) {
                    throw new Exception("Source and/or destination nodes were not specified.");
                }
            } else {
                if (this.priSourceList == null) throw new Exception("Primary source and/or destination nodes were not specified.");
                if (this.priDestList == null) {
                    throw new Exception("Primary source and/or destination nodes were not specified.");
                }
                object6 = null;
                object5 = null;
                object4 = null;
                if (this.priSource instanceof NetCircuitEnd) {
                    object6 = (NetCircuitEnd)this.priSource;
                }
                if (this.priDest instanceof NetCircuitEnd) {
                    object5 = (NetCircuitEnd)this.priDest;
                }
                if (this.secDest instanceof NetCircuitEnd) {
                    object4 = (NetCircuitEnd)this.secDest;
                }
                if (object6 != null) {
                    if (((NetCircuitEnd)object6).equals(object5)) {
                        bl = true;
                    } else if (((NetCircuitEnd)object6).equals(object4)) {
                        bl2 = true;
                    }
                }
            }
        }
        object6 = new Date();
        this.stopRequested = false;
        object5 = new boolean[this.NUM_TO_CREATE];
        object4 = new Object[this.NUM_TO_CREATE];
        String[] stringArray = new String[this.NUM_TO_CREATE];
        for (n2 = 0; n2 < this.NUM_TO_CREATE; ++n2) {
            object5[n2] = true;
            object4[n2] = FAILURE_DEFAULT;
            stringArray[n2] = "";
        }
        n2 = this.cktInfo.size();
        int n3 = this.getBreadth(n2);
        this.adminStateOnDropsFailures = 0;
        this.adminStateOnDropsBuffer = new StringBuffer();
        Autoranger.timestampDebug("Removing original source and destinations.");
        this.removeFromAllLists(this.priSource, n3);
        this.removeFromAllLists(this.secSource, n3);
        this.removeFromAllLists(this.priDest, n3);
        this.removeFromAllLists(this.secDest, n3);
        Autoranger.timestampDebug("Removed original source and destinations.");
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        try {
            if (this.priSource != null) {
                this.priSourceEqType = this.priSource.getEntityModel().getEqType();
            }
            Autoranger.timestampDebug("Primary Source entity type is " + this.priSourceEqType);
        }
        catch (Exception exception) {
            Autoranger.timestampDebug("Error getting Primary Source entity EqType: " + exception.getMessage());
        }
        try {
            if (this.priDest != null) {
                this.priDestEqType = this.priDest.getEntityModel().getEqType();
            }
            Autoranger.timestampDebug("Primary Destination entity type is " + this.priDestEqType);
        }
        catch (Exception exception) {
            Autoranger.timestampDebug("Error getting Primary Destination entity EqType: " + exception.getMessage());
        }
        try {
            if (this.secSource != null) {
                this.secSourceEqType = this.secSource.getEntityModel().getEqType();
            }
            Autoranger.timestampDebug("Secondary Source entity type is " + this.secSourceEqType);
        }
        catch (Exception exception) {
            Autoranger.timestampDebug("Error getting Secondary Source entity EqType: " + exception.getMessage());
        }
        try {
            if (this.secDest != null) {
                this.secDestEqType = this.secDest.getEntityModel().getEqType();
            }
            Autoranger.timestampDebug("Secondary Destination entity type is " + this.secDestEqType);
        }
        catch (Exception exception) {
            Autoranger.timestampDebug("Error getting Secondary Destination entity EqType: " + exception.getMessage());
        }
        for (n = 0; n < this.NUM_TO_CREATE; ++n) {
            int n4;
            ArrayList<DetailedLog> arrayList;
            block120: {
                boolean bl7;
                Object object7;
                Object object8;
                INetElement iNetElement;
                Object object9;
                Object object10;
                Object object11;
                block119: {
                    int n5;
                    INetCircuitEnd iNetCircuitEnd;
                    block118: {
                        object3 = new ArrayList();
                        int n6 = n + this.OFFSET;
                        Autoranger.timestampDebug("Iteration for Ckt #" + n6);
                        if (this.stopRequested) {
                            if (db.on()) {
                                db.println("User stopped autorange at iter#" + n);
                            }
                            object4[n] = FAILURE_STOPPED_AUTORANGE;
                            break;
                        }
                        if (observer != null) {
                            observer.update(null, new Integer(100 * n / this.NUM_TO_CREATE));
                            observer.update(null, "Autoranging circuit " + n6 + "/" + (this.NUM_TO_CREATE + 1));
                        }
                        if (this.cktBaseName.length() > 0) {
                            this.cktInfo.setName(this.cktBaseName + "_" + CircuitMapUtil.circuitSuffix(n6));
                        }
                        object2 = null;
                        object = null;
                        iNetCircuitEnd = null;
                        object11 = null;
                        object10 = null;
                        if (!this.isEther && !this.isTunnel) {
                            try {
                                object9 = new ArrayList();
                                n5 = this.updateEndpointsFromNextPort(observer, PRI_SOURCE_STRING, bl3, this.sourceNode, this.priSource, this.priSourceList, this.priSourcePortList, (List)object9) ? 1 : 0;
                                if (n5 == 1) {
                                    bl3 = true;
                                }
                                if ((n5 = (int)(this.updateEndpointsFromNextPort(observer, PRI_DEST_STRING, bl4, this.destNode, this.priDest, this.priDestList, this.priDestPortList, (List)object9) ? 1 : 0)) == 1) {
                                    bl4 = true;
                                }
                                if (this.secSource != null && (n5 = (int)(this.updateEndpointsFromNextPort(observer, SEC_SOURCE_STRING, bl5, this.altSourceNode, this.secSource, this.secSourceList, this.secSourcePortList, (List)object9) ? 1 : 0)) == 1) {
                                    bl5 = true;
                                }
                                if (this.secDest == null || (n5 = (int)(this.updateEndpointsFromNextPort(observer, SEC_DEST_STRING, bl6, this.altDestNode, this.secDest, this.secDestList, this.secDestPortList, (List)object9) ? 1 : 0)) != 1) break block118;
                                bl6 = true;
                            }
                            catch (Exception exception) {
                                object4[n] = exception;
                                break;
                            }
                        }
                    }
                    object9 = new RoutePrefs(this.origRoutePrefs);
                    if (this.isEther || this.isTunnel) {
                        n5 = this.sourceNode.getNodeId();
                        iNetElement = Network.instance().findNetElem(n5);
                        Autoranger.timestampDebug("\tSource NE=" + iNetElement);
                        try {
                            object2 = NetCircuitFactory.newCircuit(this.cktInfo, iNetElement);
                            break block119;
                        }
                        catch (Exception exception) {
                            object4[n] = exception;
                            Autoranger.destroyCircuit(n, (INetCircuit)object2);
                            continue;
                        }
                    }
                    if (this.priSourceList.size() < 1) {
                        object4[n] = FAILURE_PRI_SRC_ENDPOINTS;
                        Autoranger.destroyCircuit(n, (INetCircuit)object2);
                        break;
                    }
                    object = (INetCircuitEnd)this.priSourceList.get(0);
                    this.removeFromAllLists((INetCircuitEnd)object, n3);
                    String string = "\tPri Source:" + Autoranger.prettyCircuitEndString((INetCircuitEnd)object);
                    Autoranger.timestampDebug(string);
                    stringArray[n] = stringArray[n] + "\n" + string;
                    if (this.secSource != null) {
                        if (this.secSourceList.size() < 1) {
                            object4[n] = FAILURE_SEC_SRC_ENDPOINTS;
                            Autoranger.destroyCircuit(n, (INetCircuit)object2);
                            break;
                        }
                        iNetCircuitEnd = (INetCircuitEnd)this.secSourceList.get(0);
                        this.removeFromAllLists(iNetCircuitEnd, n3);
                        string = "\tSec Source:" + Autoranger.prettyCircuitEndString(iNetCircuitEnd);
                        Autoranger.timestampDebug(string);
                        stringArray[n] = stringArray[n] + "\n" + string;
                        object2 = NetCircuitFactory.newCircuit(this.cktInfo, (INetCircuitEnd)object, iNetCircuitEnd);
                    } else {
                        object2 = NetCircuitFactory.newCircuit(this.cktInfo, (INetCircuitEnd)object);
                    }
                    Autoranger.timestampDebug("\tCreated new circuit.");
                }
                if (object2 == null) {
                    object4[n] = "\tThe created circuit was null!  Next...";
                    Autoranger.destroyCircuit(n, (INetCircuit)object2);
                    db.println(object4[n].toString());
                    continue;
                }
                if (this.vtAndDs3MappedList != null) {
                    Autoranger.timestampDebug("\tThe VT and DS3 mapped list is not empty. Going to try to create conversion circuit");
                    if (this.vtAndDs3MappedList.size() < 2) {
                        object4[n] = "\tThe VT and DS3 mapped list size is less than two. Cannot create the pair of ports.";
                        Autoranger.destroyCircuit(n, (INetCircuit)object2);
                        db.println(object4[n].toString());
                        continue;
                    }
                    try {
                        IEntityModel iEntityModel = (IEntityModel)this.vtAndDs3MappedList.get(0);
                        iNetElement = (IEntityModel)this.vtAndDs3MappedList.get(1);
                        Autoranger.timestampDebug("\tThe two mapped port entities are " + iEntityModel + " and " + iNetElement);
                        NetCircuitEnd netCircuitEnd = new NetCircuitEnd();
                        netCircuitEnd.setEntityIndex(iEntityModel.getEntityIndex());
                        netCircuitEnd.setNodeModel(this.mappedNodeModel);
                        netCircuitEnd.setLoNum(null);
                        arrayList = new NetCircuitEnd();
                        arrayList.setEntityIndex(iNetElement.getEntityIndex());
                        arrayList.setNodeModel(this.mappedNodeModel);
                        arrayList.setLoNum(null);
                        object8 = object2.getAvailDropPoints(iEntityModel.getNodeModel(), iEntityModel);
                        if (object8 == null || object8.isEmpty()) {
                            object4[n] = "No available drop points found for " + iEntityModel;
                            Autoranger.destroyCircuit(n, (INetCircuit)object2);
                            continue;
                        }
                        INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)object8.get(0);
                        Autoranger.timestampDebug("\tUsing this endpoint as the first available drop point: " + Autoranger.prettyCircuitEndString(iNetCircuitEnd));
                        object7 = null;
                        try {
                            object7 = iNetCircuitEnd.getEntityModel();
                        }
                        catch (ObjNotFound objNotFound) {
                            SDebug.printStackTrace((Throwable)objNotFound);
                        }
                        if (object7 == null) {
                            object4[n] = "Cannot find available drop entity for drop point.";
                            Autoranger.destroyCircuit(n, (INetCircuit)object2);
                            continue;
                        }
                        IHoNum iHoNum = CircuitEndCellRenderer.convertToExternalHoNumber((IEntityModel)object7, iNetCircuitEnd.getHoNum());
                        IHoNum iHoNum2 = CircuitEndCellRenderer.convertToExternalHoNumber(iEntityModel, iHoNum);
                        IHoNum iHoNum3 = CircuitEndCellRenderer.convertToExternalHoNumber((IEntityModel)iNetElement, iHoNum);
                        netCircuitEnd.setHoNum(iHoNum2);
                        arrayList.setHoNum(iHoNum3);
                        INetCircuitEnd[] iNetCircuitEndArray = new INetCircuitEnd[2];
                        if (this.ds3Sts == 1) {
                            iNetCircuitEndArray[0] = netCircuitEnd;
                            iNetCircuitEndArray[1] = arrayList;
                        } else {
                            iNetCircuitEndArray[0] = arrayList;
                            iNetCircuitEndArray[1] = netCircuitEnd;
                        }
                        Autoranger.timestampDebug("\tUsing xmEnds[0] as " + Autoranger.prettyCircuitEndString(iNetCircuitEndArray[0]));
                        Autoranger.timestampDebug("\tUsing xmEnds[1] as " + Autoranger.prettyCircuitEndString(iNetCircuitEndArray[1]));
                        object2.setXmCircuitEnds(iNetCircuitEndArray);
                        this.vtAndDs3MappedList.remove(iEntityModel);
                        this.vtAndDs3MappedList.remove(iNetElement);
                        Autoranger.timestampDebug("\tRemoved these entities from the vtAndDsMappedList: " + iEntityModel + " and " + iNetElement);
                    }
                    catch (Exception exception) {
                        object4[n] = exception;
                        Autoranger.destroyCircuit(n, (INetCircuit)object2);
                        continue;
                    }
                }
                int n7 = this.cktInfo.type();
                boolean bl8 = bl7 = this.cktInfo.type() == 2 || this.cktInfo.type() == 5;
                if (!bl7) {
                    Autoranger.timestampDebug("\tCircuit is not VT or VC_LO; skipping LOT and LAP checks.");
                }
                if (this.isEther || this.isTunnel) {
                    if (this.sourceNode != this.destNode) {
                        int n8 = this.destNode.getNodeId();
                        arrayList = Network.instance().findNetElem(n8);
                        Autoranger.timestampDebug("\tDest NE=" + arrayList);
                        if (this.altDestNode == null) {
                            try {
                                object2.routeNetElement((INetElement)((Object)arrayList), (RoutePrefs)object9);
                                break block120;
                            }
                            catch (Exception exception) {
                                object4[n] = exception;
                                Autoranger.destroyCircuit(n, (INetCircuit)object2);
                                continue;
                            }
                        }
                        object8 = Network.instance().findNetElem(this.altDestNode.getNodeId());
                        Autoranger.timestampDebug("\tDest #2 NE=" + object8);
                        try {
                            object2.routeNetElement((INetElement)((Object)arrayList), (INetElement)object8, (RoutePrefs)object9);
                        }
                        catch (Exception exception) {
                            object4[n] = exception;
                            Autoranger.destroyCircuit(n, (INetCircuit)object2);
                            continue;
                        }
                    }
                } else {
                    block121: {
                        if (bl) {
                            object11 = object;
                            Autoranger.timestampDebug("\t(Pri Dest is the same as Pri Src)");
                        } else {
                            if (this.priDestList.size() < 1) {
                                object4[n] = FAILURE_PRI_DST_ENDPOINTS;
                                Autoranger.destroyCircuit(n, (INetCircuit)object2);
                                break;
                            }
                            object11 = (INetCircuitEnd)this.priDestList.get(0);
                            this.removeFromAllLists((INetCircuitEnd)object11, n3);
                        }
                        String string = "\tPri Dest:" + Autoranger.prettyCircuitEndString((INetCircuitEnd)object11);
                        Autoranger.timestampDebug(string);
                        stringArray[n] = stringArray[n] + "\n" + string;
                        if (this.secDest != null) {
                            if (bl2) {
                                object10 = object;
                                Autoranger.timestampDebug("\t(Sec Dest is the same as Pri Src)");
                            } else {
                                if (this.secDestList.size() < 1) {
                                    object4[n] = FAILURE_SEC_DST_ENDPOINTS;
                                    Autoranger.destroyCircuit(n, (INetCircuit)object2);
                                    break;
                                }
                                object10 = (INetCircuitEnd)this.secDestList.get(0);
                                this.removeFromAllLists((INetCircuitEnd)object10, n3);
                            }
                            string = "\tSec Dest:" + Autoranger.prettyCircuitEndString((INetCircuitEnd)object10);
                            Autoranger.timestampDebug(string);
                            stringArray[n] = stringArray[n] + "\n" + string;
                            try {
                                arrayList = new ArrayList<DetailedLog>();
                                arrayList.add((DetailedLog)object11);
                                arrayList.add((DetailedLog)object10);
                                if (bl7 && this.requestTransitTunnels) {
                                    Autoranger.timestampDebug("\tChecking for usable tunnels");
                                    boolean bl9 = NetCircuitManager.instance().canHaveOptionalLot((INetCircuit)object2, arrayList, (RoutePrefs)object9);
                                    Autoranger.timestampDebug("\thaveOptionalLot= " + bl9 + " (false=tunnel exists; true=" + "need to create one)");
                                    if (bl9) {
                                        Autoranger.createLoTunnel((INetCircuit)object2, arrayList, (RoutePrefs)object9, (List)object3);
                                    }
                                }
                                Autoranger.createLapIfNeeded(this.lapStsGroomingNode, this.sourceNode, this.destNode, (INetCircuitEnd)object, (INetCircuitEnd)object11, this.lapVtGroomingNe, (RoutePrefs)object9, this.cktInfo, this.upsrSwitchOnPdip, this.upsrReversion, this.upsrSfBerLevel, this.upsrSdBerLevel, (List)object3);
                                if (bl7 && !this.requestTransitTunnels && object2.useLAP() == null) {
                                    Autoranger.timestampDebug("\tChecking for LO Tunnel needed");
                                    boolean bl10 = NetCircuitManager.instance().isLoTunnelNeeded((INetCircuit)object2, arrayList, (RoutePrefs)object9);
                                    Autoranger.timestampDebug("\tloTunnelNeeded= " + bl10 + " (true= must create one)");
                                    if (bl10) {
                                        Autoranger.createLoTunnel((INetCircuit)object2, arrayList, (RoutePrefs)object9, (List)object3);
                                    }
                                }
                                Autoranger.timestampDebug("\tRequired Links:");
                                LinkedList linkedList = ((RoutePrefs)object9).getRequiredLinks();
                                if (linkedList != null) {
                                    for (int i = 0; i < linkedList.size(); ++i) {
                                        object7 = (INetLink)linkedList.get(i);
                                        Autoranger.timestampDebug("\t\t" + object7.prettyString());
                                    }
                                }
                                object2.routeDrop((INetCircuitEnd)object11, (INetCircuitEnd)object10, (RoutePrefs)object9);
                                break block121;
                            }
                            catch (Exception exception) {
                                object4[n] = exception;
                                Autoranger.destroyCircuit(n, (INetCircuit)object2);
                                this.destroyRelatedCkts((ArrayList)object3);
                                continue;
                            }
                        }
                        arrayList = new ArrayList<DetailedLog>();
                        arrayList.add((DetailedLog)object11);
                        try {
                            if (bl7 && this.requestTransitTunnels) {
                                boolean bl11 = NetCircuitManager.instance().canHaveOptionalLot((INetCircuit)object2, arrayList, (RoutePrefs)object9);
                                Autoranger.timestampDebug("\thaveOptionalLot= " + bl11);
                                if (bl11) {
                                    Autoranger.createLoTunnel((INetCircuit)object2, arrayList, (RoutePrefs)object9, (List)object3);
                                }
                            }
                            Autoranger.createLapIfNeeded(this.lapStsGroomingNode, this.sourceNode, this.destNode, (INetCircuitEnd)object, (INetCircuitEnd)object11, this.lapVtGroomingNe, (RoutePrefs)object9, this.cktInfo, this.upsrSwitchOnPdip, this.upsrReversion, this.upsrSfBerLevel, this.upsrSdBerLevel, (List)object3);
                            if (bl7 && !this.requestTransitTunnels && object2.useLAP() == null) {
                                Autoranger.timestampDebug("\tChecking for LO Tunnel needed");
                                boolean bl12 = NetCircuitManager.instance().isLoTunnelNeeded((INetCircuit)object2, arrayList, (RoutePrefs)object9);
                                Autoranger.timestampDebug("\tloTunnelNeeded= " + bl12 + " (true= must create one)");
                                if (bl12) {
                                    Autoranger.createLoTunnel((INetCircuit)object2, arrayList, (RoutePrefs)object9, (List)object3);
                                }
                            }
                            if (db.isFinerEnabled()) {
                                db.println("\tBefore route, ckt is: ");
                                object2.prettyPrint(db);
                                db.println("\tRouted with route prefs: " + ((RoutePrefs)object9).prettyString());
                            }
                            object2.routeDrop((INetCircuitEnd)object11, (RoutePrefs)object9);
                            if (!db.isFinerEnabled()) break block121;
                            db.println("\tAfter route, ckt is: ");
                            object2.prettyPrint(db);
                        }
                        catch (Exception exception) {
                            object4[n] = exception;
                            Autoranger.destroyCircuit(n, (INetCircuit)object2);
                            this.destroyRelatedCkts((ArrayList)object3);
                            continue;
                        }
                    }
                    Autoranger.timestampDebug("\tSuccessfully routed drop.");
                }
            }
            if (this.vlanSet != null) {
                try {
                    object2.assignVlanSet(this.vlanSet);
                    object2.createWithStpEnabled(this.enableStp);
                    Autoranger.timestampDebug("\tSet the VLAN info.");
                }
                catch (Exception exception) {
                    object4[n] = exception;
                    Autoranger.destroyCircuit(n, (INetCircuit)object2);
                    continue;
                }
            }
            if (!this.isLoCkt()) {
                try {
                    object2.sanityCheckManualRouting();
                    Autoranger.timestampDebug("\tPassed sanity check manual routing.");
                }
                catch (Exception exception) {
                    object4[n] = exception;
                    Autoranger.destroyCircuit(n, (INetCircuit)object2);
                    continue;
                }
            }
            try {
                object2.sanityCheck();
                Autoranger.timestampDebug("\tPassed sanity check.");
            }
            catch (Exception exception) {
                object4[n] = exception;
                Autoranger.destroyCircuit(n, (INetCircuit)object2);
                continue;
            }
            try {
                if (this.upsrReversion != null) {
                    object2.setUpsrSelectorAttributes(this.upsrReversion, this.upsrSfBerLevel, this.upsrSdBerLevel, this.upsrSwitchOnPdip);
                    Autoranger.timestampDebug("\tSet UPSR Selector Attributes.");
                } else {
                    Autoranger.timestampDebug("\tNot setting UPSR Selector attributes.");
                }
            }
            catch (Exception exception) {
                object4[n] = exception;
                Autoranger.destroyCircuit(n, (INetCircuit)object2);
                continue;
            }
            try {
                if (db.isFinerEnabled()) {
                    db.finer("iter #" + n + "\tCircuit before provisioning: ");
                    object2.prettyPrint(db);
                }
                Class<Autoranger> clazz = Autoranger.class;
                // MONITORENTER : cerent.cms.ui.circuits.Autoranger.class
                object2.provision();
                // MONITOREXIT : clazz
                Autoranger.timestampDebug("\tSuccessfully provisioned!");
                object5[n] = false;
            }
            catch (Exception exception) {
                if (db.isFinerEnabled()) {
                    db.finer("iter #" + n + "\tCircuit after FAILED provisioning: ");
                    object2.prettyPrint(db);
                }
                object4[n] = exception;
                Autoranger.destroyCircuit(n, (INetCircuit)object2);
                this.destroyRelatedCkts((ArrayList)object3);
                continue;
            }
            if (this.setAdminStateOnDrops && (arrayList = this.getApplyDropResult((INetCircuit)object2, n4 = this.cktInfo.adminState())) != null) {
                this.adminStateOnDropsBuffer.append((String)((Object)arrayList));
                ++this.adminStateOnDropsFailures;
            }
            try {
                Thread.sleep(this.DELAY);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.autoRangeLog = new DetailedLog("Circuit Autorange Error Summary:");
        n = 0;
        while (true) {
            if (n >= this.NUM_TO_CREATE) {
                Date date = new Date();
                Autoranger.timestampDebug("BEGIN: " + object6 + "\t" + ((Date)object6).getTime() + "\nFINISH: " + date + "\t" + date.getTime());
                return;
            }
            object3 = "Autoranged circuit #" + (n + this.OFFSET) + " ";
            if (object5[n]) {
                String string = (String)object3 + "failed: ";
                if (object4[n] instanceof NoRoute) {
                    object2 = (NoRoute)((Object)object4[n]);
                    object = ((NoRoute)((Object)object2)).getDetailedLog();
                    string = string + object.getDesc();
                    if (stringArray[n].length() > 0) {
                        string = string + stringArray[n];
                    }
                    object.setDesc(string);
                    this.autoRangeLog.addChild(object);
                } else {
                    string = object4[n] instanceof Exception ? string + ((Exception)object4[n]).getMessage() : string + object4[n].toString();
                    if (stringArray[n].length() > 0) {
                        string = string + stringArray[n];
                    }
                    this.autoRangeLog.addChild(new DetailedLog(string));
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyRelatedCkts(ArrayList arrayList) {
        ArrayList arrayList2 = arrayList;
        synchronized (arrayList2) {
            for (int i = 0; i < arrayList.size(); ++i) {
                INetCircuit iNetCircuit = (INetCircuit)arrayList.get(i);
                Autoranger.timestampDebug("Deleted related circuit: " + iNetCircuit);
                if (db.on()) {
                    iNetCircuit.prettyPrint(db);
                }
                try {
                    iNetCircuit.destroyCircuit();
                    continue;
                }
                catch (Exception exception) {
                    Autoranger.timestampDebug("could not delete related circuit: " + iNetCircuit);
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    private boolean isLoCkt() {
        return this.cktInfo.type() == 2 || this.cktInfo.type() == 5 || this.cktInfo.type() == 13 || this.cktInfo.type() == 11;
    }

    public static void createLoTunnel(INetCircuit iNetCircuit, List list, RoutePrefs routePrefs, List list2) throws Exception {
        String string = "\tcreateLoTunnel::";
        List list3 = NetCircuitManager.instance().createLoTunnels(iNetCircuit, list, routePrefs);
        Autoranger.timestampDebug(string + "Found " + list3.size() + " tunnels.");
        for (LoTunnelInfo loTunnelInfo : list3) {
            boolean bl = true;
            AnnotatedException annotatedException = null;
            try {
                Autoranger.timestampDebug(string + "Provisioning new LOT");
                loTunnelInfo.tunnel().provision();
                bl = false;
                list2.add(loTunnelInfo.tunnel());
                Autoranger.timestampDebug(string + " added LOT to related ckt list.");
            }
            catch (Exception exception) {
                annotatedException = new AnnotatedException("The required LO tunnel could not be created.", exception);
            }
            if (bl) {
                try {
                    Autoranger.timestampDebug(string + "Destroying the LOT");
                    loTunnelInfo.tunnel().destroyCircuit();
                }
                catch (Exception exception) {
                    throw new AnnotatedException("The LO tunnel could not be destroyed.", exception);
                }
                if (annotatedException != null) {
                    throw annotatedException;
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                Autoranger.timestampDebug(string + "Destination List #" + i + list.get(i));
            }
            Autoranger.timestampDebug(string + "Route Prefs: " + routePrefs.prettyString());
        }
    }

    protected static void createLapIfNeeded(INodeModel iNodeModel, INodeModel iNodeModel2, INodeModel iNodeModel3, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2, INetElement iNetElement, RoutePrefs routePrefs, CircuitCreatInfo circuitCreatInfo, boolean bl, IRevertiveBehavior iRevertiveBehavior, short s, short s2, List list) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        block22: {
            string = "\tcreateLap::";
            object5 = null;
            int n = circuitCreatInfo.type();
            if (n != 2 && n != 5) {
                Autoranger.timestampDebug(string + " leaving; circuit type does not allow " + "LAPs");
                return;
            }
            try {
                object5 = NetCircuitManager.instance().getLAPHo(iNodeModel3, iNetCircuitEnd2.getEntityModel(), iNetCircuitEnd2.getHoNum());
                if (object5 == null) {
                    object5 = NetCircuitManager.instance().getLAPHo(iNodeModel2, iNetCircuitEnd.getEntityModel(), iNetCircuitEnd.getHoNum());
                }
            }
            catch (ObjNotFound objNotFound) {
                if (!db.on()) break block22;
                SDebug.printStackTrace((Throwable)objNotFound);
            }
        }
        if (object5 == null) {
            if (iNodeModel == null || iNetElement == null) {
                Autoranger.timestampDebug(string + "No selected NE or LAP Grooming node " + "specified in original circuit, so NOT " + "creating a new LAP");
                return;
            }
            object4 = null;
            object4 = iNodeModel == iNodeModel3 ? (NetCircuitEnd)iNetCircuitEnd2 : (NetCircuitEnd)iNetCircuitEnd;
            Autoranger.timestampDebug(string + "The chosen LAP end is " + Autoranger.prettyCircuitEndString((INetCircuitEnd)object4));
            boolean bl2 = CircuitMapUtil.getTDMTerminology() instanceof SONETTDMTerminology;
            object3 = new CircuitCreatInfo(bl2 ? 7 : 8, bl2 ? 1 : 12, 1, false, "", circuitCreatInfo.adminState(), circuitCreatInfo.tl1Compatible());
            object2 = NetCircuitFactory.newCircuit((CircuitCreatInfo)object3, (INetCircuitEnd)object4);
            Autoranger.timestampDebug(string + "Created LAP circuit with source " + ((NetCircuitEnd)object4).prettyString());
            object = new RoutePrefs();
            ((RoutePrefs)object).setPathProt(routePrefs.getPathProt());
            ((RoutePrefs)object).setDiversityOption(2);
            ((RoutePrefs)object).setPcaPref(routePrefs.getPcaPref());
            object2.routeNetElement(iNetElement, (RoutePrefs)object);
            if (iRevertiveBehavior != null) {
                object2.setUpsrSelectorAttributes(iRevertiveBehavior, s, s2, bl);
            }
            Autoranger.timestampDebug(string + "routed NE= " + iNetElement.prettyString());
            try {
                if (db.on()) {
                    db.println("This is the LAP circuit before sanity check:");
                    object2.prettyPrint(db);
                }
                object2.sanityCheck();
                object2.provision();
                list.add(object2);
                object5 = object2;
                Autoranger.timestampDebug(string + "provision succeeded and added to " + "related circuit list.");
            }
            catch (Exception exception) {
                try {
                    object2.destroyCircuit();
                }
                catch (Exception exception2) {
                    throw new AnnotatedException("The LAP circuit could not be destroyed.", exception2);
                }
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                throw exception;
            }
        }
        Autoranger.timestampDebug(string + "Reusing existing LAP");
        Autoranger.timestampDebug(string + "The LAP we are using is " + object5);
        object4 = null;
        if (object5 != null) {
            try {
                object4 = NetCircuitManager.instance().getLAPHo(iNodeModel3, iNetCircuitEnd2.getEntityModel(), iNetCircuitEnd2.getHoNum()) != null ? object5.getReverseLapLink() : object5.getLapLink();
            }
            catch (ObjNotFound objNotFound) {
                throw new AnnotatedException("An appropriate network link to use for the LAP could not be found.", (Exception)((Object)objNotFound));
            }
            Autoranger.timestampDebug(string + "The INetLink we will add to the " + "route constraints (memberprefs) is " + object4);
            if (object4 == null) {
                throw new Exception("The mapped network link from the LAP was null.");
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object4);
            Autoranger.timestampDebug(string + "add " + object4 + " as required Link");
            object3 = routePrefs.getFwdDropPrefs().getMemberGroupPrefs();
            if (object3 == null) {
                throw new Exception("Member group preferences could not be derived from the routing preferences.");
            }
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (MemberGroupPrefs)object2.next();
                MemberPrefs memberPrefs = ((MemberGroupPrefs)object).getMemberPrefs();
                try {
                    memberPrefs.setReqEntityList(arrayList);
                }
                catch (ObjDuplicate objDuplicate) {
                    Autoranger.timestampDebug("Noted: added duplicate INetLink to the Required Entity List.");
                    SDebug.printStackTrace((Throwable)objDuplicate);
                }
            }
        } else {
            throw new Exception("A LAP could not be reused or created.");
        }
    }

    protected String getApplyDropResult(INetCircuit iNetCircuit, int n) {
        ArrayList arrayList = new ArrayList();
        try {
            if (!NetCircuitModel.setAdminStateOnDropPorts(iNetCircuit, n, arrayList)) {
                String string = "    ";
                int n2 = 2;
                StringBuffer stringBuffer = new StringBuffer(iNetCircuit.getCircuitName() + ":");
                if (arrayList.size() > n2) {
                    stringBuffer.append(string).append(" (more than 2 ports not set)\n");
                } else {
                    stringBuffer.append("\n");
                    int n3 = arrayList.size();
                    for (int i = 0; i < n3; ++i) {
                        stringBuffer.append(string).append((String)arrayList.get(i)).append("\n");
                    }
                }
                return stringBuffer.toString();
            }
            return null;
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public String getResultString(Exception exception) {
        throw new DeprecatedMethodCalled("ProgressDialogControl.getResultString(Exception)");
    }

    public ProgressDialogResult getResult(Exception exception) {
        return null;
    }

    public void stop() {
        this.stopRequested = true;
    }

    public boolean stopRequired() {
        return this.stopRequested;
    }

    public void suspend() {
    }

    public void resume() {
    }

    public DetailedLog getAutoRangeLog() {
        return this.autoRangeLog;
    }

    protected void removeFromAllLists(INetCircuitEnd iNetCircuitEnd, int n) {
        IHoNum iHoNum;
        if (iNetCircuitEnd == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        if (n > 1 && (iHoNum = iNetCircuitEnd.getHoNum()) != null) {
            n2 = iHoNum.getHoNum() - n + 1;
            n3 = iHoNum.getHoNum() + n - 1;
        }
        if (Autoranger.isPoolSharedForCard(iNetCircuitEnd)) {
            this.removeUsedHoForSharedPool(this.priSourceList, iNetCircuitEnd, n2, n3);
            this.removeUsedHoForSharedPool(this.priDestList, iNetCircuitEnd, n2, n3);
            this.removeUsedHoForSharedPool(this.secSourceList, iNetCircuitEnd, n2, n3);
            this.removeUsedHoForSharedPool(this.secDestList, iNetCircuitEnd, n2, n3);
        } else {
            this.removeObjectAndUsedHos(this.priSourceList, iNetCircuitEnd, n2, n3);
            this.removeObjectAndUsedHos(this.priDestList, iNetCircuitEnd, n2, n3);
            this.removeObjectAndUsedHos(this.secSourceList, iNetCircuitEnd, n2, n3);
            this.removeObjectAndUsedHos(this.secDestList, iNetCircuitEnd, n2, n3);
        }
    }

    protected void removeObjectAndUsedHos(List list, INetCircuitEnd iNetCircuitEnd, int n, int n2) {
        if (list != null) {
            if (list.contains(iNetCircuitEnd)) {
                list.remove(iNetCircuitEnd);
            }
            if (n != n2) {
                IEntityModel iEntityModel;
                block9: {
                    iEntityModel = null;
                    try {
                        iEntityModel = iNetCircuitEnd.getEntityModel();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block9;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                ArrayList<INetCircuitEnd> arrayList = new ArrayList<INetCircuitEnd>();
                for (int i = 0; i < list.size(); ++i) {
                    short s;
                    IHoNum iHoNum;
                    boolean bl;
                    INetCircuitEnd iNetCircuitEnd2;
                    block10: {
                        iNetCircuitEnd2 = (INetCircuitEnd)list.get(i);
                        if (iNetCircuitEnd2 == null || iEntityModel == null) continue;
                        bl = false;
                        try {
                            if (iNetCircuitEnd2.getEntityModel() == iEntityModel) {
                                bl = true;
                            }
                        }
                        catch (Exception exception) {
                            if (!db.on()) break block10;
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                    if (!bl || (iHoNum = iNetCircuitEnd2.getHoNum()) == null || (s = iHoNum.getHoNum()) < n || s > n2) continue;
                    arrayList.add(iNetCircuitEnd2);
                }
                list.removeAll(arrayList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void destroyCircuit(int n, INetCircuit iNetCircuit) {
        if (iNetCircuit != null) {
            try {
                if (db.isFineEnabled()) {
                    db.println("Destroying this circuit:");
                    iNetCircuit.prettyPrint(db);
                }
                Class<Autoranger> clazz = Autoranger.class;
                synchronized (Autoranger.class) {
                    iNetCircuit.destroyCircuit();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
            catch (Exception exception) {
                db.println("Destroy failed on iter #" + n);
                SDebug.printStackTrace((Throwable)exception);
            }
        } else {
            db.println("null circuit to destroy on iter #" + n);
        }
        {
            return;
        }
    }

    private int getBreadth(int n) {
        int n2;
        switch (n) {
            case 13: {
                n2 = 2;
                break;
            }
            case 2: 
            case 14: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 4;
                break;
            }
            case 3: {
                n2 = 6;
                break;
            }
            case 28: {
                n2 = 6;
                break;
            }
            case 16: {
                n2 = 8;
                break;
            }
            case 7: {
                n2 = 9;
                break;
            }
            case 4: {
                n2 = 12;
                break;
            }
            case 26: {
                n2 = 12;
                break;
            }
            case 17: {
                n2 = 16;
                break;
            }
            case 8: {
                n2 = 24;
                break;
            }
            case 33: {
                n2 = 32;
                break;
            }
            case 27: {
                n2 = 18;
                break;
            }
            case 25: {
                n2 = 36;
                break;
            }
            case 5: {
                n2 = 48;
                break;
            }
            case 18: {
                n2 = 64;
                break;
            }
            case 32: {
                n2 = 96;
                break;
            }
            case 6: {
                n2 = 192;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return n2;
    }

    protected static void timestampDebug(String string) {
        if (db.on()) {
            Date date = new Date();
            db.println(string + " [" + date.toString() + ", TS=" + date.getTime() + "]");
        }
    }

    public void dump() {
        INetCircuitEnd iNetCircuitEnd;
        int n;
        System.out.println("Primary Source is " + Autoranger.prettyCircuitEndString(this.priSource));
        if (this.priSourceList != null) {
            System.out.println("Primary Source List:");
            for (n = 0; n < this.priSourceList.size(); ++n) {
                iNetCircuitEnd = (INetCircuitEnd)this.priSourceList.get(n);
                System.out.print("\t" + n + "\t" + Autoranger.prettyCircuitEndString(iNetCircuitEnd) + "\tSL=");
                System.out.print(iNetCircuitEnd.getSlotNumber() + " HO=" + iNetCircuitEnd.getHoNum());
                System.out.println(" LO= " + iNetCircuitEnd.getLoNum());
            }
        }
        System.out.println("Primary Dest is " + Autoranger.prettyCircuitEndString(this.priDest));
        if (this.priDestList != null) {
            System.out.println("Primary Dest List:");
            for (n = 0; n < this.priDestList.size(); ++n) {
                iNetCircuitEnd = (INetCircuitEnd)this.priDestList.get(n);
                System.out.print("\t" + n + "\t" + Autoranger.prettyCircuitEndString(iNetCircuitEnd) + "\tSL=");
                System.out.print(iNetCircuitEnd.getSlotNumber() + " HO=" + iNetCircuitEnd.getHoNum());
                System.out.println(" LO= " + iNetCircuitEnd.getLoNum());
            }
        }
    }

    void specialCaseCheck(String string, List list, List list2) {
        if (list.size() < 1) {
            return;
        }
        if (!Autoranger.isPoolSharedForCard(this.priDest)) {
            return;
        }
        if (!string.equals(PRI_DEST_STRING)) {
            return;
        }
        if (this.priSource.getNodeId() != this.priDest.getNodeId() || this.priSource.getSlotNumber() != this.priDest.getSlotNumber()) {
            return;
        }
        INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)list.get(0);
        if (iNetCircuitEnd.getNodeId() != this.priDest.getNodeId() || iNetCircuitEnd.getSlotNumber() != this.priDest.getSlotNumber()) {
            return;
        }
        for (INetCircuitEnd iNetCircuitEnd2 : list2) {
            if (iNetCircuitEnd2.getEntityIndex() == iNetCircuitEnd.getEntityIndex()) {
                list.clear();
                db.println("clearing endpointList = " + Autoranger.prettyCircuitEndString(iNetCircuitEnd2));
                return;
            }
            this.removeCommonSts(list, iNetCircuitEnd2);
        }
    }

    private void removeCommonSts(List list, INetCircuitEnd iNetCircuitEnd) {
        db.println("endpoint to match = " + Autoranger.prettyCircuitEndString(iNetCircuitEnd));
        if (iNetCircuitEnd.getHoNum() == null) {
            return;
        }
        short s = iNetCircuitEnd.getHoNum().getHoNum();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            short s2;
            INetCircuitEnd iNetCircuitEnd2 = (INetCircuitEnd)iterator.next();
            if (iNetCircuitEnd2.getHoNum() == null || s != (s2 = iNetCircuitEnd2.getHoNum().getHoNum())) continue;
            iterator.remove();
            db.println("remove matching endpoint = " + Autoranger.prettyCircuitEndString(iNetCircuitEnd2));
        }
    }

    private static boolean isPoolSharedForCard(INetCircuitEnd iNetCircuitEnd) {
        boolean bl = false;
        try {
            if (iNetCircuitEnd.getEntityModel().getPayloadType() == 19) {
                bl = true;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return bl;
    }

    protected void removeUsedHoForSharedPool(List list, INetCircuitEnd iNetCircuitEnd, int n, int n2) {
        if (list == null || list.size() <= 0) {
            return;
        }
        if (!Autoranger.isPoolSharedForCard(iNetCircuitEnd) || !Autoranger.isPoolSharedForCard((INetCircuitEnd)list.get(0))) {
            return;
        }
        INetCircuitEnd iNetCircuitEnd2 = (INetCircuitEnd)list.get(0);
        if (iNetCircuitEnd.getNodeId() != iNetCircuitEnd2.getNodeId() || iNetCircuitEnd.getSlotNumber() != iNetCircuitEnd2.getSlotNumber()) {
            return;
        }
        if (iNetCircuitEnd.getEntityIndex() == iNetCircuitEnd2.getEntityIndex()) {
            list.clear();
            if (db.on()) {
                db.println("clearing inList same port cktEnd = " + Autoranger.prettyCircuitEndString(iNetCircuitEnd));
            }
            return;
        }
        if (iNetCircuitEnd.getHoNum() == null) {
            return;
        }
        short s = iNetCircuitEnd.getHoNum().getHoNum();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INetCircuitEnd iNetCircuitEnd3 = (INetCircuitEnd)iterator.next();
            if (iNetCircuitEnd3.getHoNum() == null) continue;
            short s2 = iNetCircuitEnd3.getHoNum().getHoNum();
            if (s == s2) {
                iterator.remove();
                if (!db.on()) continue;
                db.println("remove matching STS = " + s2);
                continue;
            }
            if (n == n2 || s2 < n || s2 > n2) continue;
            iterator.remove();
            if (!db.on()) continue;
            db.println("remove ranged match STS = " + s2);
        }
    }

    public List getNetCktEnds() throws Exception {
        ArrayList<INetCircuitEnd> arrayList = new ArrayList<INetCircuitEnd>();
        if (this.priDestList == null) {
            throw new Exception("Primary source and/or destination nodes were not specified.");
        }
        int n = this.cktInfo.size();
        int n2 = this.getBreadth(n);
        Autoranger.timestampDebug("Removing original source and destinations.");
        this.removeFromAllLists(this.priDest, n2);
        Autoranger.timestampDebug("Removed original source and destinations.");
        Object object = new Object();
        for (int i = 0; i < this.NUM_TO_CREATE; ++i) {
            INetCircuitEnd iNetCircuitEnd;
            block6: {
                Autoranger.timestampDebug("Iteration for Ckt end#" + i + 2);
                iNetCircuitEnd = null;
                if (!this.isEther && !this.isTunnel) {
                    try {
                        boolean bl = false;
                        ArrayList arrayList2 = new ArrayList();
                        boolean bl2 = this.updateEndpointsFromNextPort(null, PRI_DEST_STRING, bl, this.destNode, this.priDest, this.priDestList, this.priDestPortList, arrayList2);
                        if (!bl2) break block6;
                        bl = true;
                    }
                    catch (Exception exception) {
                        object = exception;
                        break;
                    }
                }
            }
            if (this.priDestList.size() < 1) {
                object = FAILURE_PRI_DST_ENDPOINTS;
                break;
            }
            iNetCircuitEnd = (INetCircuitEnd)this.priDestList.get(0);
            this.removeFromAllLists(iNetCircuitEnd, n2);
            arrayList.add(iNetCircuitEnd);
        }
        return arrayList;
    }
}

