/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.FramingType;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.topo.Network;
import cerent.cms.ui.OpticalChannelAttr;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.circuits.AbstractAdminStatePanel;
import cerent.cms.ui.circuits.AbstractCcdAttrsPane;
import cerent.cms.ui.circuits.CcdOCHNCAttrsPane;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.IAdminStatePanel;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CcdOCHCCAttrsPane
extends CcdOCHNCAttrsPane {
    public static final String[] sonetPayloadTypes = new String[]{"SONET", "Ethernet", "FC/FICON", "Data Storage", "Video", "OTU", "Other"};
    public static final String[] sdhPayloadTypes = new String[]{"SDH", "Ethernet", "FC/FICON", "Data Storage", "Video", "OTU", "Other"};
    public static HashMap<String, OchTrailHelper.OchccCircuitSize[]> cktSizesMap = new HashMap();

    public CcdOCHCCAttrsPane(CircuitCreationDialog circuitCreationDialog, WzDiagDebug wzDiagDebug, String string) {
        super(circuitCreationDialog, wzDiagDebug, string);
    }

    @Override
    protected void addLeftPane() {
        super.addLeftPane();
        this.biDirAttr.setEnabled(false);
        this.singleNodeOchncAttr.getUI().setVisible(false);
        this.circuitSizeAttr.setEnabled(true);
    }

    @Override
    protected boolean isPossibleProtectionCheck() {
        return true;
    }

    protected void addOptDir(JPanel jPanel, GridBagConstraints gridBagConstraints) {
    }

    @Override
    protected OpticalChannelAttr getOpticalChannelAttr() {
        return new OpticalChannelAttr(2);
    }

    @Override
    protected AbstractCcdAttrsPane.AdminStateAttr getAdminStateAttr() {
        this.adminStateAttr = new OchccAdminStateAttr();
        return this.adminStateAttr;
    }

    @Override
    protected void parseAdminAttr(ArrayList arrayList) {
        arrayList.add(this.parseAttr(this.adminStateAttr.getStateString()));
        arrayList.add(this.parseAttr(this.adminStateAttr.getShortApplyDropString()));
        OchccAdminStateAttr ochccAdminStateAttr = (OchccAdminStateAttr)this.adminStateAttr;
        if (this.adminStateAttr.adminStatePanel.getApplyDropPorts()) {
            arrayList.add(this.parseAttr(ochccAdminStateAttr.getPortsStateString()));
        }
    }

    @Override
    public void validatePage() throws Exception {
        super.validatePage();
        OchccCircuitSizeAttr ochccCircuitSizeAttr = (OchccCircuitSizeAttr)this.circuitSizeAttr;
        int n = ochccCircuitSizeAttr.getOchccCircuitSize().intValue();
        this.getCircuitInfo().setSpecificSize(n);
    }

    @Override
    protected AbstractCcdAttrsPane.CircuitSizeAttr getCircuitSizeAttr() {
        return new OchccCircuitSizeAttr(this.getCircuitType());
    }

    @Override
    public void revalidateData() {
        super.revalidateData();
        this.biDirAttr.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.biDirAttr.setEnabled(false);
    }

    static {
        OchTrailHelper.OchccCircuitSize[] ochccCircuitSizeArray = new OchTrailHelper.OchccCircuitSize[]{OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_OC_768, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_OC_192, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_OC_48, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_OC_12, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_OC_3};
        cktSizesMap.put(sonetPayloadTypes[0], ochccCircuitSizeArray);
        ochccCircuitSizeArray = new OchTrailHelper.OchccCircuitSize[]{OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_STM_256, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_STM_64, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_STM_16, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_STM_4, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_STM_1};
        cktSizesMap.put(sdhPayloadTypes[0], ochccCircuitSizeArray);
        ochccCircuitSizeArray = new OchTrailHelper.OchccCircuitSize[]{OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_40_GE, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_10_GE, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_1_GE, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_FE};
        cktSizesMap.put(sonetPayloadTypes[1], ochccCircuitSizeArray);
        ochccCircuitSizeArray = new OchTrailHelper.OchccCircuitSize[]{OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_10_GFC, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_8_GFC, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_4_GFC, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_2_GFC, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_1_GFC, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_4_GFICON, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_2_GFICON, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_1_GFICON};
        cktSizesMap.put(sonetPayloadTypes[2], ochccCircuitSizeArray);
        ochccCircuitSizeArray = new OchTrailHelper.OchccCircuitSize[]{OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_ESCON, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_ETR_CLO, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_ISC_PEER, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_ISC3_PEER_1G, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_ISC3_PEER_2G, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_ISC_COMPAT, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_ISC1, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_IB_5G};
        cktSizesMap.put(sonetPayloadTypes[3], ochccCircuitSizeArray);
        ochccCircuitSizeArray = new OchTrailHelper.OchccCircuitSize[]{OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_HDTV, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_SD1_D1, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_DV6000, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_DVB_ASI};
        cktSizesMap.put(sonetPayloadTypes[4], ochccCircuitSizeArray);
        ochccCircuitSizeArray = new OchTrailHelper.OchccCircuitSize[]{OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_OTU2, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_OTU3};
        cktSizesMap.put(sonetPayloadTypes[5], ochccCircuitSizeArray);
        ochccCircuitSizeArray = new OchTrailHelper.OchccCircuitSize[]{OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_PASSTROUGH};
        cktSizesMap.put(sonetPayloadTypes[6], ochccCircuitSizeArray);
    }

    class OchccAdminStateAttr
    extends AbstractCcdAttrsPane.AdminStateAttr {
        OchccAdminStateAttr() {
            this.adminStatePanel = new OchccAdminStatePanel();
        }

        @Override
        public String getApplyDropString() {
            String string = this.adminStatePanel.getApplyDropPorts() ? "True" : "False";
            return "Apply to OCHCC ports: " + string;
        }

        @Override
        public String getShortApplyDropString() {
            return this.getApplyDropString();
        }

        public String getPortsStateString() {
            return "Ports state: " + NetAdminState.getAdminStateStringFromAdminState(((OchccAdminStatePanel)this.adminStatePanel).getPortsState());
        }
    }

    static class OchccAdminStatePanel
    extends AbstractAdminStatePanel
    implements IAdminStatePanel,
    ActionListener,
    ChangeListener {
        protected JLabel adminStateLB;
        protected Attribute[] adminStateAttrs;

        public OchccAdminStatePanel() {
            this(false);
        }

        public OchccAdminStatePanel(boolean bl) {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createTitledBorder("State"));
            JPanel jPanel = WzPane.createHorizontalPanel(null);
            jPanel.setAlignmentX(0.0f);
            this.adminStateLB = new JLabel("State: ");
            jPanel.add(this.adminStateLB);
            this.adminStateAttrs = this.getAdminAttrs(bl);
            this.adminStateCB = new UComboBox((Object[])this.adminStateAttrs);
            jPanel.add((Component)this.adminStateCB);
            Attribute attribute = null;
            for (int i = 0; i < this.adminStateAttrs.length; ++i) {
                if (this.adminStateAttrs[i].getIntValue() != 0) continue;
                attribute = this.adminStateAttrs[i];
            }
            this.adminStateCB.setSelectedItem(attribute);
            this.adminStateCB.addActionListener((ActionListener)this);
            this.add(jPanel);
        }

        Attribute[] getAdminAttrs(boolean bl) {
            Attribute[] attributeArray = NetAdminState.getAdminStateAttrs();
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            for (int i = 0; i < attributeArray.length; ++i) {
                int n = attributeArray[i].getIntValue();
                if (n == 4 || n == 3 || n != 1 && n != 0 && n == 2) continue;
                arrayList.add(attributeArray[i]);
            }
            if (bl) {
                arrayList.add(NetAdminState.NO_CHANGE_ATTR);
            }
            return arrayList.toArray(new Attribute[0]);
        }

        @Override
        public int getAdminState() {
            return ((Attribute)this.adminStateCB.getSelectedItem()).getIntValue();
        }

        @Override
        public void setAdminState(int n) {
            if (this.getAdminState() == n) {
                return;
            }
            for (int i = 0; i < this.adminStateAttrs.length; ++i) {
                if (this.adminStateAttrs[i].getIntValue() != n) continue;
                this.adminStateCB.setSelectedItem((Object)this.adminStateAttrs[i]);
            }
        }

        @Override
        public void disableAll() {
            this.adminStateCB.setEnabled(false);
            this.adminStateLB.setEnabled(false);
        }

        @Override
        public void enableAll() {
            this.adminStateCB.setEnabled(true);
            this.adminStateLB.setEnabled(true);
        }

        @Override
        public JPanel getPanel() {
            return this;
        }

        @Override
        public boolean getApplyDropPorts() {
            return false;
        }

        @Override
        public void setApplyDropPorts(boolean bl) {
        }

        @Override
        public void setApplyDropPortsApplicable(boolean bl) {
        }

        @Override
        public boolean isDropPortsSelected() {
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
        }

        @Override
        protected boolean showAffectingWarning() {
            return false;
        }
    }

    class OchccCircuitSizeAttr
    extends AbstractCcdAttrsPane.CircuitSizeAttr
    implements ActionListener {
        protected UComboBox typeCB;

        OchccCircuitSizeAttr(int n) {
            this.p = WzPane.createHorizontalPanel(null);
            this.p.setAlignmentX(0.0f);
            int n2 = 180;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            this.lbl = new JLabel("Size: ");
            this.lbl.setPreferredSize(new Dimension(45, this.lbl.getHeight()));
            jPanel.add((Component)this.lbl, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.typeCB = new UComboBox((ComboBoxModel)this.getCircuitSizeTypeCBModel(), n2);
            jPanel.add((Component)this.typeCB, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.sizeCB = new UComboBox((ComboBoxModel)this.getCircuitSizeCBModel(), n2);
            jPanel.add((Component)this.sizeCB, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            CcdOCHCCAttrsPane.this.paneGc.gridwidth = 1;
            jPanel.add((Component)new JPanel(), gridBagConstraints);
            this.p.add(jPanel);
            this.typeCB.addActionListener((ActionListener)this);
            this.sizeCB.setRenderer((ListCellRenderer)new AbstractCcdAttrsPane.CircuitSizeCBRenderer());
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.typeCB.setEnabled(bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.sizeCB.setModel((ComboBoxModel)this.getCircuitSizeCBModel());
            this.sizeCB.setEnabled(this.typeCB.getSelectedItem() != null);
        }

        protected DefaultComboBoxModel getCircuitSizeTypeCBModel() {
            String[] stringArray = null;
            FramingType[] framingTypeArray = Network.instance().getSupportedFramingTypes();
            for (int i = 0; stringArray == null && i < framingTypeArray.length; ++i) {
                if (framingTypeArray[i].isSonet()) {
                    stringArray = sonetPayloadTypes;
                    continue;
                }
                if (!framingTypeArray[i].isSdh()) continue;
                stringArray = sdhPayloadTypes;
            }
            DefaultComboBoxModel defaultComboBoxModel = stringArray != null ? new DefaultComboBoxModel(stringArray) : new DefaultComboBoxModel();
            return defaultComboBoxModel;
        }

        protected DefaultComboBoxModel getCircuitSizeCBModel() {
            String string = (String)this.typeCB.getSelectedItem();
            if (string != null) {
                OchTrailHelper.OchccCircuitSize[] ochccCircuitSizeArray = cktSizesMap.get(string);
                DefaultComboBoxModel<OchTrailHelper.OchccCircuitSize> defaultComboBoxModel = new DefaultComboBoxModel<OchTrailHelper.OchccCircuitSize>(ochccCircuitSizeArray);
                return defaultComboBoxModel;
            }
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
            return defaultComboBoxModel;
        }

        public String getPayloadType() {
            return (String)this.typeCB.getSelectedItem();
        }

        @Override
        public int getCircuitSize() {
            return 31;
        }

        public OchTrailHelper.OchccCircuitSize getOchccCircuitSize() {
            return (OchTrailHelper.OchccCircuitSize)this.sizeCB.getSelectedItem();
        }

        @Override
        public String toString() {
            OchTrailHelper.OchccCircuitSize ochccCircuitSize = this.getOchccCircuitSize();
            return "Size: " + this.getPayloadType() + "/" + ochccCircuitSize.toString();
        }
    }
}

