/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.NetAdminState;
import cerent.cms.ui.AbstractProvPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.OpticalChannelAttr;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.circuits.AbstractAdminStatePanel;
import cerent.cms.ui.circuits.AbstractCcdAttrsPane;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.IAdminStatePanel;
import cerent.util.gui.UComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CcdOCHNCAttrsPane
extends AbstractCcdAttrsPane {
    public static final int HORIZ_OPT_DIR_MARGIN = 20;
    protected OpticalChannelAttr optChannel;
    protected SingleNodeOchncAttr singleNodeOchncAttr;
    protected ProtectionAttr protectionAttr;
    protected GridBagConstraints paneGc;

    public CcdOCHNCAttrsPane(CircuitCreationDialog circuitCreationDialog, WzDiagDebug wzDiagDebug, String string) {
        super(circuitCreationDialog, wzDiagDebug, string);
    }

    @Override
    protected void initPane() {
        this.setLayout(new GridBagLayout());
        this.paneGc = new GridBagConstraints();
        this.paneGc.anchor = 18;
        this.paneGc.gridx = 0;
        this.paneGc.gridy = 0;
        this.paneGc.gridwidth = 1;
        this.paneGc.gridheight = 1;
        this.paneGc.weightx = 0.0;
        this.paneGc.weighty = 0.0;
        this.paneGc.fill = 1;
        this.paneGc.insets = new Insets(5, 5, 0, 0);
        this.addLeftPane();
        this.paneGc.gridx = 1;
        this.paneGc.gridy = 0;
        this.paneGc.gridwidth = 1;
        this.paneGc.gridheight = 1;
        this.paneGc.weightx = 0.0;
        this.paneGc.weighty = 0.0;
        this.paneGc.fill = 1;
        this.paneGc.insets = new Insets(5, 5, 0, 0);
        this.addRightPane();
    }

    protected void addLeftPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.setBorder(BorderFactory.createTitledBorder("Circuit"));
        this.circuitNameAttr = new AbstractCcdAttrsPane.CircuitNameAttr();
        jPanel.add((Component)this.circuitNameAttr.getUI(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.circuitTypeAttr = new AbstractCcdAttrsPane.CircuitTypeAttr(this.getCircuitType());
        jPanel.add((Component)this.circuitTypeAttr.getUI(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.setCircuitSize(19);
        this.circuitSizeAttr = this.getCircuitSizeAttr();
        this.circuitSizeAttr.setEnabled(false);
        jPanel.add((Component)this.circuitSizeAttr.getUI(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.optChannel = this.getOpticalChannelAttr();
        jPanel.add((Component)this.optChannel.getUI(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.biDirAttr = new AbstractCcdAttrsPane.BiDirAttr();
        jPanel.add((Component)this.biDirAttr.getUI(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.singleNodeOchncAttr = new SingleNodeOchncAttr();
        jPanel.add((Component)this.singleNodeOchncAttr.getUI(), gridBagConstraints);
        this.singleNodeOchncAttr.singleNodeOchncCB.addActionListener(this);
        if (this.isPossibleProtectionCheck()) {
            ++gridBagConstraints.gridy;
            this.protectionAttr = new ProtectionAttr();
            jPanel.add((Component)this.protectionAttr.getUI(), gridBagConstraints);
            this.protectionAttr.protectionCB.addActionListener(this);
        }
        this.paneGc.gridheight = 4;
        this.add((Component)jPanel, this.paneGc);
        this.paneGc.gridy = 4;
        this.paneGc.gridheight = 2;
        this.paneGc.anchor = 16;
        this.adminStateAttr = this.getAdminStateAttr();
        this.add((Component)this.adminStateAttr.getUI(), this.paneGc);
        this.paneGc.gridy = 6;
        this.paneGc.weightx = 1.0;
        this.paneGc.weighty = 1.0;
        this.paneGc.gridheight = 0;
        this.add(Box.createVerticalGlue(), this.paneGc);
    }

    protected boolean isPossibleProtectionCheck() {
        return true;
    }

    protected void addRightPane() {
        this.paneGc.weighty = 1.0;
        this.paneGc.weightx = 1.0;
        this.paneGc.gridheight = 0;
        this.add(Box.createHorizontalGlue(), this.paneGc);
    }

    protected OpticalChannelAttr getOpticalChannelAttr() {
        return new OpticalChannelAttr(1);
    }

    protected AbstractCcdAttrsPane.AdminStateAttr getAdminStateAttr() {
        this.adminStateAttr = new OchncAdminStateAttr();
        return this.adminStateAttr;
    }

    @Override
    protected void parseAdminAttr(ArrayList arrayList) {
        arrayList.add(this.parseAttr(this.adminStateAttr.getStateString()));
    }

    protected AbstractCcdAttrsPane.CircuitSizeAttr getCircuitSizeAttr() {
        return new AbstractCcdAttrsPane.CircuitSizeAttr(this.getCircuitType());
    }

    @Override
    public void revalidateData() {
        boolean bl;
        boolean bl2;
        super.revalidateData();
        if (this.circuitInfo == null) {
            bl2 = this.isSingleNode();
            bl = this.isProtected();
        } else {
            bl2 = this.circuitInfo.singleNodeOchnc();
            bl = this.circuitInfo.isProtected();
        }
        if (this.singleNodeOchncAttr != null) {
            this.singleNodeOchncAttr.singleNodeOchncCB.setSelected(bl2);
        }
        if (this.protectionAttr != null) {
            this.protectionAttr.protectionCB.setSelected(bl);
        }
        this.updateBiDir();
    }

    @Override
    public void validatePage() throws Exception {
        super.validatePage();
        if (this.optChannel != null) {
            this.getCircuitInfo().setCktOptChannel(this.optChannel.getChannel());
        }
        this.getCircuitInfo().setSingleNode(this.isSingleNode());
        if (this.db.on()) {
            this.db.println("singleNodeOchnc=" + this.isSingleNode());
        }
        this.getCircuitInfo().setProtected(this.isProtected());
    }

    @Override
    protected ArrayList<String[]> getAttrPairs() {
        ArrayList arrayList = super.getAttrPairs();
        if (this.optChannel != null) {
            arrayList.add(this.parseAttr(this.optChannel));
        }
        if (this.singleNodeOchncAttr != null) {
            if (this.isSingleNode()) {
                arrayList.add(this.parseAttr("OCHNC DCN: Yes"));
            } else {
                arrayList.add(this.parseAttr("OCHNC DCN: No"));
            }
        }
        if (this.protectionAttr != null) {
            arrayList.add(this.parseAttr(this.protectionAttr.getString()));
        }
        return arrayList;
    }

    public boolean isSingleNode() {
        if (this.singleNodeOchncAttr != null) {
            return this.singleNodeOchncAttr.getSingleNode();
        }
        return false;
    }

    @Override
    public int getAdminState() {
        if (this.adminStateAttr.getUI().isVisible()) {
            return super.getAdminState();
        }
        return 3;
    }

    public boolean isProtected() {
        if (this.protectionAttr != null) {
            return this.protectionAttr.isProtected();
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.protectionAttr != null && this.protectionAttr.protectionCB == actionEvent.getSource()) {
            this.updateBiDir();
        }
        if (this.singleNodeOchncAttr != null && this.singleNodeOchncAttr.singleNodeOchncCB == actionEvent.getSource()) {
            this.updateBiDir();
        }
        super.actionPerformed(actionEvent);
    }

    private void updateBiDir() {
        boolean bl;
        if (this.circuitInfo == null) {
            bl = this.circuitBiDir;
        } else {
            boolean bl2 = bl = this.circuitInfo.dir() == 1;
        }
        if (this.biDirAttr != null) {
            if (this.isSingleNode() || this.isProtected()) {
                this.biDirAttr.bidirCB.setEnabled(false);
                this.biDirAttr.bidirCB.setSelected(true);
            } else {
                this.biDirAttr.bidirCB.setEnabled(true);
                this.biDirAttr.bidirCB.setSelected(bl);
            }
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdOCHNCAttrsPane;
    }

    @Override
    public void dispose() {
        this.optChannel = null;
        this.singleNodeOchncAttr = null;
        this.protectionAttr = null;
        super.dispose();
    }

    @Override
    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("Opt Wavelength:  " + this.optChannel + "\n");
        stringBuffer.append("Circuit SingleNode: " + this.isSingleNode() + "\n");
        stringBuffer.append("Circuit protection: " + this.isProtected() + "\n");
        return stringBuffer.toString();
    }

    class OchncAdminStateAttr
    extends AbstractCcdAttrsPane.AdminStateAttr {
        OchncAdminStateAttr() {
            this.adminStatePanel = new OchncAdminStatePanel();
        }

        @Override
        public String toString() {
            return this.getStateString();
        }
    }

    static class OchncAdminStatePanel
    extends AbstractAdminStatePanel
    implements IAdminStatePanel {
        protected JLabel adminStateLB;
        protected Attribute[] adminStateAttrs;

        public OchncAdminStatePanel() {
            this(false);
        }

        public OchncAdminStatePanel(boolean bl) {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createTitledBorder("State"));
            JPanel jPanel = AbstractProvPane.createHorizontalPanel(null);
            jPanel.setAlignmentX(0.0f);
            this.adminStateLB = new JLabel("State: ");
            jPanel.add(this.adminStateLB);
            this.adminStateAttrs = this.getAdminAttrs(bl);
            this.adminStateCB = new UComboBox((Object[])this.adminStateAttrs);
            jPanel.add((Component)this.adminStateCB);
            this.add(jPanel);
            this.setAdminState(bl ? -2 : 3);
        }

        Attribute[] getAdminAttrs(boolean bl) {
            Attribute[] attributeArray = NetAdminState.getAdminStateAttrs();
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            for (int i = 0; i < attributeArray.length; ++i) {
                int n = attributeArray[i].getIntValue();
                if (n == 4 || n != 3 && n != 1 && (n == 0 || n == 2)) continue;
                arrayList.add(attributeArray[i]);
            }
            if (bl) {
                arrayList.add(NetAdminState.NO_CHANGE_ATTR);
            }
            return arrayList.toArray(new Attribute[0]);
        }

        @Override
        public void setAdminState(int n) {
            if (this.getAdminState() == n) {
                return;
            }
            for (int i = 0; i < this.adminStateAttrs.length; ++i) {
                if (this.adminStateAttrs[i].getIntValue() != n) continue;
                this.adminStateCB.setSelectedItem((Object)this.adminStateAttrs[i]);
            }
        }

        @Override
        public void disableAll() {
            this.adminStateCB.setEnabled(false);
            this.adminStateLB.setEnabled(false);
        }

        @Override
        public void enableAll() {
            this.adminStateCB.setEnabled(true);
            this.adminStateLB.setEnabled(true);
        }

        @Override
        public boolean getApplyDropPorts() {
            return false;
        }

        @Override
        public void setApplyDropPorts(boolean bl) {
        }

        @Override
        public void setApplyDropPortsApplicable(boolean bl) {
        }

        @Override
        public boolean isDropPortsSelected() {
            return false;
        }

        @Override
        protected boolean isIS(int n) {
            return super.isIS(n) || n == 3;
        }
    }

    class ProtectionAttr {
        protected JCheckBox protectionCB;
        private JPanel p = new JPanel();

        ProtectionAttr() {
            this.p.setLayout(new BorderLayout());
            this.protectionCB = new JCheckBox("Protection");
            this.p.add(this.protectionCB);
            this.setEnabled(true);
        }

        public JPanel getUI() {
            return this.p;
        }

        boolean isProtected() {
            return this.protectionCB.isSelected();
        }

        public void setEnabled(boolean bl) {
            this.protectionCB.setEnabled(bl);
        }

        String getString() {
            if (this.isProtected()) {
                return "Protection: Required";
            }
            return "Protection: Not required";
        }
    }

    class SingleNodeOchncAttr {
        protected JCheckBox singleNodeOchncCB;
        private JPanel p = WzPane.createHorizontalPanel(null);

        SingleNodeOchncAttr() {
            this.p.setAlignmentX(0.0f);
            this.singleNodeOchncCB = new JCheckBox("OCHNC DCN");
            this.p.add(this.singleNodeOchncCB);
            this.setEnabled(true);
        }

        public JPanel getUI() {
            return this.p;
        }

        public boolean getSingleNode() {
            return this.singleNodeOchncCB.isSelected();
        }

        public void setEnabled(boolean bl) {
            this.singleNodeOchncCB.setEnabled(bl);
        }

        public String toString() {
            return "Single Node: " + this.getSingleNode();
        }
    }
}

