/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchncHelper;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.OchncCircuitEnd;
import cerent.cms.ui.circuits.AbstractCcdEndpointPanel;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.CcdEndpointsPane;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.SortablePortString;
import cerent.util.AnnotatedException;
import cerent.util.ILoNum;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CcdOCHNCEndpointPanel
extends AbstractCcdEndpointPanel {
    private EndPointAttr prEndPoint = null;
    private EndPointAttr localReverseEndPoint = null;

    public CcdOCHNCEndpointPanel(String string, AbstractCircuitDialog abstractCircuitDialog, CcdEndpointsPane ccdEndpointsPane) {
        super(string, abstractCircuitDialog, ccdEndpointsPane);
        boolean bl;
        boolean bl2 = bl = !ccdEndpointsPane.inSourcePane() && this.getCircuitInfo().singleNodeOchnc() && this.getCircuitInfo().isProtected();
        if (bl) {
            this.shelfLB.setText("Shelf(W)");
            this.slotLB.setText("Slot(W)");
            this.portLB.setText("Port(W)");
            this.prEndPoint = new EndPointAttr("Protected Source", "Shelf(P):", "Slot(P):", "Port(P):");
        } else if (this.getCircuitInfoType() == 9 && this.getCircuitInfoDir() == 1) {
            String string2 = new String(ccdEndpointsPane.inSourcePane() ? "Local Drop" : "Local Source");
            this.localReverseEndPoint = new EndPointAttr(string2, "Shelf:", "Slot:", "Port:");
            this.localReverseEndPoint.setVisible(false);
        }
    }

    @Override
    protected void addComponents(GridBagConstraints gridBagConstraints) {
    }

    @Override
    protected List getLoParts() {
        return this.loParts;
    }

    @Override
    protected void setLoComponentsFromEndpoint() {
    }

    @Override
    protected void localRefresh(ICircuitType iCircuitType, int n) {
        if (this.prEndPoint != null) {
            if (this.endpoint.getNodeModel() != null) {
                List list = this.getCircuit().getAvailDropPorts(this.endpoint.getNodeModel(), this.getCircuitInfo(), true);
                this.prEndPoint.loadAvailPorts(list);
            } else {
                this.prEndPoint.disable();
            }
        } else if (this.localReverseEndPoint != null) {
            try {
                List<IEntityModel> list = OchncHelper.getReversePorts(this.getCircuitInfo().cktOptChannel(), this.endpoint.getEntityModel());
                this.localReverseEndPoint.loadAvailPorts(list);
                this.localReverseEndPoint.setVisible(list.size() > 0);
                this.otsLinesPanel.setSelectedEntity(this.endpoint, this.getCircuit() == null);
            }
            catch (ObjNotFound objNotFound) {
                if (db.on()) {
                    db.println(this.title + " localRefresh: exception in getReversePorts");
                }
                this.localReverseEndPoint.setVisible(false);
            }
        }
    }

    @Override
    protected void setLoComponents(ILoNum iLoNum) {
    }

    @Override
    protected SortedMap createNewLoMap() {
        return null;
    }

    @Override
    protected void selectLoComponentsFromEndpoint() {
    }

    @Override
    protected void putInLoMap(SortedMap sortedMap, INetCircuitEnd iNetCircuitEnd) {
    }

    @Override
    protected boolean inLoMap(SortedMap sortedMap, ILoNum iLoNum) {
        return false;
    }

    @Override
    protected ILoNum getFirstLoFromLoMap(SortedMap sortedMap, int n) {
        return null;
    }

    @Override
    protected JComboBox getHoCB() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.slotCB) {
            String string = (String)this.slotCB.getSelectedItem();
            if (this.isNull(string, "newSlot")) {
                return;
            }
            if (db.on()) {
                db.println(this.title + " OCHNC actionPerformed: slot " + this.slot + " -> " + string);
            }
            this.slot = string;
            this.otsLinesPanel.setVisible(true);
            this.isEther = false;
            this.portMap = (SortedMap)this.entityMap.get(this.slot);
            if (this.isNull(this.portMap, "portMap")) {
                this.setCBList(this.portCB, null);
                this.otsLinesPanel.reset();
                return;
            }
            if (this.portMap.size() == 0) {
                if (db.on()) {
                    db.println(this.title + " portMap is empty");
                }
                this.otsLinesPanel.reset();
                return;
            }
            this.setCBList(this.portCB, this.portMap.keySet());
            if (this.portMap.size() == 1) {
                SortablePortString sortablePortString = (SortablePortString)this.portMap.firstKey();
                if (!sortablePortString.isEmpty()) {
                    if (!sortablePortString.equals(this.portCB.getSelectedItem())) {
                        this.portCB.setSelectedItem(sortablePortString);
                    }
                } else {
                    this.port = null;
                    try {
                        this.setEntity((IEntityModel)this.portMap.get(sortablePortString));
                    }
                    catch (AnnotatedException annotatedException) {
                        if (db.on()) {
                            db.println(this.title + " actionPerformed(slotCB): exception in setEntity");
                        }
                        this.clearEntity(annotatedException, true);
                    }
                }
                this.portCB.setEnabled(false);
            } else if (this.localReverseEndPoint != null) {
                this.localReverseEndPoint.setVisible(false);
            }
        } else if (object == this.portCB) {
            SortablePortString sortablePortString = (SortablePortString)this.portCB.getSelectedItem();
            if (this.isNull(sortablePortString, "newPort")) {
                this.otsLinesPanel.reset();
                return;
            }
            if (db.on()) {
                db.println(this.title + " OCHNC actionPerformed: port " + this.port + " -> " + sortablePortString);
            }
            this.port = sortablePortString;
            try {
                this.setEntity((IEntityModel)this.portMap.get(this.port));
                if (!this.otsLinesPanel.showOTSSide()) {
                    this.otsLinesPanel.setVisible(false);
                }
            }
            catch (AnnotatedException annotatedException) {
                if (db.on()) {
                    db.println(this.title + " actionPerformed(portCB): exception in setEntity");
                }
                this.clearEntity(annotatedException, false);
                this.otsLinesPanel.setVisible(true);
            }
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    protected void setEntity(IEntityModel iEntityModel) throws AnnotatedException {
        db.info(this.title + " setEntity: slot = " + this.slot + ", port = " + this.port);
        if (!iEntityModel.equals(this.getEntityModel())) {
            this.endpoint.setEntityIndex(iEntityModel.getEntityIndex());
            this.endpoint.setHoNum(null);
            this.endpoint.setLoNum(null);
            this.hoNum = null;
            this.resetLoNum();
            this.isEther = false;
            if (this.localReverseEndPoint != null) {
                List<IEntityModel> list = OchncHelper.getReversePorts(this.getCircuitInfo().cktOptChannel(), iEntityModel);
                this.localReverseEndPoint.loadAvailPorts(list);
                this.localReverseEndPoint.setVisible(list.size() > 0);
            }
            this.otsLinesPanel.setSelectedEntity(this.endpoint, this.getCircuit() == null);
        }
    }

    @Override
    protected boolean fullySelected() {
        if (this.slot == null) {
            return false;
        }
        if (this.slotCB.isEnabled() && this.slotCB.getSelectedIndex() < 0) {
            return false;
        }
        if (this.portCB.isEnabled() && this.portCB.getSelectedIndex() < 0) {
            return false;
        }
        if (this.prEndPoint != null) {
            return this.prEndPoint.fullySelected();
        }
        if (this.localReverseEndPoint != null) {
            return this.localReverseEndPoint.fullySelected();
        }
        return true;
    }

    @Override
    protected void reset() {
        super.reset();
        if (this.prEndPoint != null) {
            this.prEndPoint.disable();
        }
        if (this.localReverseEndPoint != null) {
            this.localReverseEndPoint.disable();
        }
    }

    @Override
    public void recycle() {
        super.recycle();
        if (this.prEndPoint != null) {
            this.prEndPoint.recycle();
        }
        if (this.prEndPoint != null) {
            this.prEndPoint.disable();
        }
    }

    @Override
    public INetCircuitEnd getProtEndPoint() {
        return this.prEndPoint != null ? this.prEndPoint.myEndpoint : null;
    }

    @Override
    public INetCircuitEnd getReverseEndPoint() {
        return this.localReverseEndPoint != null ? this.localReverseEndPoint.myEndpoint : this.getReverse();
    }

    @Override
    protected String getStatusText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CircuitEndCellRenderer.asSlashSeparatedString(this.endpoint));
        if (this.localReverseEndPoint != null) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(this.node.getName());
            stringBuilder.append("/");
            stringBuilder.append(CircuitEndCellRenderer.asSlashSeparatedString(this.localReverseEndPoint.myEndpoint));
        }
        return stringBuilder.toString();
    }

    private INetCircuitEnd getReverse() {
        block3: {
            try {
                List<IEntityModel> list = OchncHelper.getReversePorts(this.getCircuitInfo().cktOptChannel(), this.endpoint.getEntityModel());
                if (list.size() == 1) {
                    return new OchncCircuitEnd(this.endpoint.getNetElement(), list.get(0).getEntityIndex(), this.getCircuitInfo().cktOptChannel());
                }
            }
            catch (ObjNotFound objNotFound) {
                if (!db.on()) break block3;
                db.println(this.title + " actionPerformed(portCB): exception in setEntity");
            }
        }
        return null;
    }

    class EndPointAttr
    implements ActionListener {
        private final JLabel myTitleLB;
        private final JLabel myShelfLB;
        private final JLabel mySlotLB;
        private final JLabel myPortLB;
        private final JComboBox myShelfCB;
        private final JComboBox mySlotCB;
        private final JComboBox myPortCB;
        private SortedMap<String, SortedMap<SortablePortString, IEntityModel>> myModuleMap;
        private final SortedMap<String, SortedMap<String, SortedMap<SortablePortString, IEntityModel>>> myShelfMap;
        private SortedMap<SortablePortString, IEntityModel> myPortMap;
        private final INetCircuitEnd myEndpoint;

        public EndPointAttr(String string, String string2, String string3, String string4) {
            AbstractCcdEndpointPanel.db.fine(CcdOCHNCEndpointPanel.this.title + "::" + string + " <init>");
            CcdOCHNCEndpointPanel.this.gbc.insets = new Insets(15, 1, 1, 1);
            this.myTitleLB = this.addLB(string, CcdOCHNCEndpointPanel.this.gbc);
            this.myShelfLB = new JLabel(string2, 4);
            this.myShelfCB = this.addCB(this.myShelfLB, "myShelfCB", CcdOCHNCEndpointPanel.this.gbc);
            this.myShelfLB.setVisible(false);
            this.myShelfCB.setVisible(false);
            CcdOCHNCEndpointPanel.this.gbc.insets = new Insets(1, 1, 1, 1);
            this.mySlotLB = new JLabel(string3, 4);
            this.mySlotCB = this.addCB(this.mySlotLB, "mySlotCB", CcdOCHNCEndpointPanel.this.gbc);
            this.myPortLB = new JLabel(string4, 4);
            this.myPortCB = this.addCB(this.myPortLB, "myPortCB", CcdOCHNCEndpointPanel.this.gbc);
            this.myEndpoint = new NetCircuitEnd();
            this.myModuleMap = new TreeMap<String, SortedMap<SortablePortString, IEntityModel>>();
            this.myShelfMap = new TreeMap<String, SortedMap<String, SortedMap<SortablePortString, IEntityModel>>>();
        }

        JLabel addLB(String string, GridBagConstraints gridBagConstraints) {
            AbstractCcdEndpointPanel.db.fine(CcdOCHNCEndpointPanel.this.title + "::addLB:" + string);
            JLabel jLabel = new JLabel(string);
            jLabel.setPreferredSize(new Dimension(100, 20));
            JPanel jPanel = new JPanel(new BorderLayout(0, 0));
            jPanel.setPreferredSize(new Dimension(300, 22));
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)jLabel, "West");
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 1;
            jPanel.add((Component)new JLabel(), "Center");
            CcdOCHNCEndpointPanel.this.endPointsPanel.add((Component)jPanel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            return jLabel;
        }

        JComboBox addCB(JLabel jLabel, String string, GridBagConstraints gridBagConstraints) {
            AbstractCcdEndpointPanel.db.fine(CcdOCHNCEndpointPanel.this.title + "::" + this.myTitleLB.getText() + "::addCB:" + string);
            JComboBox jComboBox = new JComboBox();
            jLabel.setPreferredSize(new Dimension(50, 20));
            jComboBox.setName(string);
            JPanel jPanel = new JPanel(new BorderLayout(0, 0));
            jPanel.setPreferredSize(new Dimension(300, 22));
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)jLabel, "West");
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 1;
            jPanel.add(jComboBox, "Center");
            CcdOCHNCEndpointPanel.this.endPointsPanel.add((Component)jPanel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            return jComboBox;
        }

        private void setCBList(JComboBox jComboBox, Set<?> set) {
            jComboBox.removeActionListener(this);
            if (set != null) {
                Object object = jComboBox.getSelectedItem();
                if (AbstractCcdEndpointPanel.db.on()) {
                    AbstractCcdEndpointPanel.db.println(CcdOCHNCEndpointPanel.this.title + " setCBList: " + jComboBox.getName() + " choices: " + set.toString());
                }
                jComboBox.setModel(new DefaultComboBoxModel<Object>(set.toArray()));
                if (object == null || !set.contains(object)) {
                    jComboBox.setSelectedItem(null);
                }
            } else {
                jComboBox.setSelectedItem(null);
            }
            if (set == null || set.isEmpty()) {
                if (AbstractCcdEndpointPanel.db.on()) {
                    AbstractCcdEndpointPanel.db.println(CcdOCHNCEndpointPanel.this.title + " setCBList: disabling " + jComboBox.getName());
                }
                jComboBox.setEnabled(false);
            } else {
                jComboBox.setEnabled(set != null && set.size() > 1);
                jComboBox.addActionListener(this);
            }
        }

        void loadAvailPorts(List<IEntityModel> list) {
            AbstractCcdEndpointPanel.db.fine(CcdOCHNCEndpointPanel.this.title + "::" + this.myTitleLB.getText() + "::loadAvailPorts");
            this.recycle();
            SortablePortString sortablePortString = null;
            this.myEndpoint.setNodeModel(CcdOCHNCEndpointPanel.this.endpoint.getNodeModel());
            for (Object object2 : list) {
                TreeMap<SortablePortString, IEntityModel> treeMap;
                if (object2 == null) {
                    if (AbstractCcdEndpointPanel.db.on()) {
                        AbstractCcdEndpointPanel.db.println(CcdOCHNCEndpointPanel.this.title + " localRefresh: null entity returned from getAvailDropPorts");
                    }
                    return;
                }
                if (object2.getGenericClass() == 7) {
                    sortablePortString = new SortablePortString((IEntityModel)object2);
                } else if (object2.getGenericClass() == 6) {
                    sortablePortString = new SortablePortString();
                } else {
                    if (AbstractCcdEndpointPanel.db.on()) {
                        AbstractCcdEndpointPanel.db.println(CcdOCHNCEndpointPanel.this.title + " localRefresh: unexpected entity: " + object2);
                    }
                    return;
                }
                String string = CcdOCHNCEndpointPanel.this.getSlotString((IEntityModel)object2);
                String string2 = CcdOCHNCEndpointPanel.this.getShelfString((IEntityModel)object2);
                TreeMap<String, TreeMap<SortablePortString, IEntityModel>> treeMap2 = (TreeMap<String, TreeMap<SortablePortString, IEntityModel>>)this.myShelfMap.get(string2);
                if (treeMap2 == null) {
                    treeMap2 = new TreeMap<String, TreeMap<SortablePortString, IEntityModel>>();
                    this.myShelfMap.put(string2, treeMap2);
                }
                if ((treeMap = (TreeMap<SortablePortString, IEntityModel>)treeMap2.get(string)) == null) {
                    treeMap = new TreeMap<SortablePortString, IEntityModel>();
                    treeMap2.put(string, treeMap);
                }
                treeMap.put(sortablePortString, (IEntityModel)object2);
            }
            Object object = null;
            if (CcdOCHNCEndpointPanel.this.isMultiShelf) {
                Object object2;
                this.myShelfLB.setVisible(CcdOCHNCEndpointPanel.this.isMultiShelf);
                this.myShelfCB.setVisible(CcdOCHNCEndpointPanel.this.isMultiShelf);
                object2 = new TreeSet<String>(this.myShelfMap.keySet());
                this.setCBList(this.myShelfCB, (Set<?>)object2);
                object = this.myShelfMap.keySet().size() == 1 ? this.myShelfMap.keySet().iterator().next() : (String)CcdOCHNCEndpointPanel.this.shelfCB.getSelectedItem();
                if (object != null) {
                    if (!((String)object).equals(this.myShelfCB.getSelectedItem())) {
                        this.myShelfCB.setSelectedItem(object);
                    }
                    this.myShelfCB.setEnabled(this.myShelfMap.keySet().size() > 1);
                }
            } else if (this.myShelfMap.keySet().size() > 0) {
                object = this.myShelfMap.keySet().iterator().next();
            }
            this.initSlots((String)object);
            this.initPorts();
        }

        void setVisible(boolean bl) {
            AbstractCcdEndpointPanel.db.fine(CcdOCHNCEndpointPanel.this.title + "::" + this.myTitleLB.getText() + "::setVisible=" + bl);
            this.myTitleLB.setVisible(bl);
            this.myShelfLB.setVisible(CcdOCHNCEndpointPanel.this.isMultiShelf && bl);
            this.mySlotLB.setVisible(bl);
            this.myPortLB.setVisible(bl);
            this.myShelfCB.setVisible(CcdOCHNCEndpointPanel.this.isMultiShelf && bl);
            this.mySlotCB.setVisible(bl);
            this.myPortCB.setVisible(bl);
        }

        void disable() {
            this.setCBList(this.myShelfCB, null);
            this.setCBList(this.mySlotCB, null);
            this.setCBList(this.myPortCB, null);
        }

        void recycle() {
            if (this.myModuleMap != null) {
                this.myModuleMap.clear();
            }
            if (this.myPortMap != null) {
                this.myPortMap.clear();
            }
            if (this.myShelfMap != null) {
                this.myShelfMap.clear();
            }
            this.myShelfCB.removeActionListener(this);
            this.mySlotCB.removeActionListener(this);
            this.myPortCB.removeActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block9: {
                Object object = actionEvent.getSource();
                if (object == this.myShelfCB) {
                    this.initSlots((String)this.myShelfCB.getSelectedItem());
                } else if (object == this.mySlotCB) {
                    this.initPorts();
                } else if (object == this.myPortCB) {
                    SortablePortString sortablePortString = (SortablePortString)this.myPortCB.getSelectedItem();
                    if (CcdOCHNCEndpointPanel.this.isNull(sortablePortString, "newPort")) {
                        return;
                    }
                    if (AbstractCcdEndpointPanel.db.on()) {
                        AbstractCcdEndpointPanel.db.println(CcdOCHNCEndpointPanel.this.title + "::" + this.myTitleLB.getText() + " actionPerformed: port " + sortablePortString);
                    }
                    try {
                        this.setMyEntity((IEntityModel)this.myPortMap.get(sortablePortString));
                    }
                    catch (AnnotatedException annotatedException) {
                        if (!AbstractCcdEndpointPanel.db.on()) break block9;
                        AbstractCcdEndpointPanel.db.println(CcdOCHNCEndpointPanel.this.title + " actionPerformed(portCB): exception in setProtEntity");
                    }
                }
            }
        }

        private void initSlots(String string) {
            String string2;
            if (CcdOCHNCEndpointPanel.this.isNull(string, "newShelf")) {
                return;
            }
            if (AbstractCcdEndpointPanel.db.on()) {
                AbstractCcdEndpointPanel.db.println(CcdOCHNCEndpointPanel.this.title + "::" + this.myTitleLB.getText() + " actionPerformed: shelf -> " + string);
            }
            this.myModuleMap = (SortedMap)this.myShelfMap.get(string);
            if (CcdOCHNCEndpointPanel.this.isNull(this.myModuleMap, "myModuleMap") || this.myModuleMap.size() == 0) {
                if (AbstractCcdEndpointPanel.db.on()) {
                    AbstractCcdEndpointPanel.db.println(CcdOCHNCEndpointPanel.this.title + " myModuleMap is empty");
                }
                this.setCBList(this.mySlotCB, null);
                return;
            }
            this.setCBList(this.mySlotCB, this.myModuleMap.keySet());
            if (this.myModuleMap.size() == 1 && !(string2 = this.myModuleMap.firstKey()).equals(this.mySlotCB.getSelectedItem())) {
                this.mySlotCB.setSelectedItem(string2);
            }
        }

        private void initPorts() {
            String string = (String)this.mySlotCB.getSelectedItem();
            if (CcdOCHNCEndpointPanel.this.isNull(string, "newSlot")) {
                return;
            }
            if (AbstractCcdEndpointPanel.db.on()) {
                AbstractCcdEndpointPanel.db.println(CcdOCHNCEndpointPanel.this.title + "::" + this.myTitleLB.getText() + " actionPerformed: slot -> " + string);
            }
            this.myPortMap = (SortedMap)this.myModuleMap.get(string);
            if (CcdOCHNCEndpointPanel.this.isNull(this.myPortMap, "prPortMap") || this.myPortMap.size() == 0) {
                if (AbstractCcdEndpointPanel.db.on()) {
                    AbstractCcdEndpointPanel.db.println(CcdOCHNCEndpointPanel.this.title + " prPortMap is empty");
                }
                this.setCBList(this.myPortCB, null);
                return;
            }
            this.setCBList(this.myPortCB, this.myPortMap.keySet());
            if (this.myPortMap.size() == 1) {
                block9: {
                    SortablePortString sortablePortString = this.myPortMap.firstKey();
                    if (!sortablePortString.isEmpty()) {
                        if (!sortablePortString.equals(this.myPortCB.getSelectedItem())) {
                            this.myPortCB.setSelectedItem(sortablePortString);
                        }
                        try {
                            this.setMyEntity((IEntityModel)this.myPortMap.get(sortablePortString));
                        }
                        catch (AnnotatedException annotatedException) {
                            if (!AbstractCcdEndpointPanel.db.on()) break block9;
                            AbstractCcdEndpointPanel.db.println(CcdOCHNCEndpointPanel.this.title + " actionPerformed(slotCB): exception in setEntity");
                        }
                    }
                }
                this.myPortCB.setEnabled(false);
            }
        }

        private IEntityModel getMyEntityModel() {
            IEntityModel iEntityModel;
            block2: {
                iEntityModel = null;
                try {
                    iEntityModel = this.myEndpoint.getEntityModel();
                }
                catch (ObjNotFound objNotFound) {
                    if (!AbstractCcdEndpointPanel.db.on()) break block2;
                    AbstractCcdEndpointPanel.db.println("Can't find the entity model");
                }
            }
            return iEntityModel;
        }

        private void setMyEntity(IEntityModel iEntityModel) throws AnnotatedException {
            AbstractCcdEndpointPanel.db.info(CcdOCHNCEndpointPanel.this.title + "::" + this.myTitleLB.getText() + "::setMyEntity: " + iEntityModel);
            if (!iEntityModel.equals(this.getMyEntityModel())) {
                this.myEndpoint.setEntityIndex(iEntityModel.getEntityIndex());
                this.myEndpoint.setHoNum(null);
                this.myEndpoint.setLoNum(null);
            }
        }

        boolean fullySelected() {
            if (this.mySlotCB.isVisible() && this.mySlotCB.getSelectedIndex() < 0) {
                return false;
            }
            return !this.myPortCB.isVisible() || this.myPortCB.getSelectedIndex() >= 0;
        }
    }
}

