/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.Feature;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IDwdmTrkLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPlimTrkLineModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchTrailAttrsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.IOchCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ncp.TrkAttribOperator;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.RevertiveBehaviorPanel;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.CcdOchAttrsTableModel;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.WzCcdPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.BoundTextField;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class CcdOchAttrsPane
extends WzCcdPane {
    private JPanel trunkTablePanel;
    private ProtectionAttr protectionAttr;
    private CcdOchAttrsTableModel tableModel;
    private OchTrailAttrsHelper.TrunkInfo trunkInfo;
    private OchTrailAttrsHelper.ProtectionInfo protectionInfo;
    private IEntityModel trkSrcModel;
    private IEntityModel trkDstModel;
    private IEntityModel regenPortModel;
    private OchTrailAttrsHelper.TrunkInfo regenTrunkInfo = null;
    private UTable table;
    boolean disableOTNProvisioning = false;
    private UComboBox otnStatusCB;
    private UComboBox fecCB;
    private UComboBox sdBerCB;
    private UComboBox mappingCB;
    private UComboBox proactiveProtCB;
    private UComboBox triggerThresholdCB;
    private BoundTextField triggerWindowTP;
    private UComboBox revertThresholdCB;
    private BoundTextField revertWindowTP;
    boolean needsFrrProvisioning = false;
    private boolean isOc768 = false;

    public CcdOchAttrsPane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        super(wzDialog, wzDiagDebug, string);
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdOchAttrsPane;
    }

    @Override
    public void enteringPane() {
        super.enteringPane();
        TablePropertyMgr.getColumnPrefs((JTable)this.table, "CcdOchAttrsPane");
        if (!this.goingForward) {
            try {
                this.restoreAll();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    public boolean handleBack() {
        AbstractCircuitDialog abstractCircuitDialog = this.getAbstractCktDlg();
        if (abstractCircuitDialog.getCircuit().getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            try {
                abstractCircuitDialog.deleteDestination();
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.println("Delete destination failed: " + exception.getMessage());
                }
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_DELETE_DESTINATION_FAILED);
            }
        }
        return super.handleBack();
    }

    public void handleCancel() {
        try {
            this.restoreAll();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private void setUpCombo() throws AbstractCmsNoSuchEntityException, NoSuchEquipment, NoSuchInterface, WrongInterfaceType {
        OchTrailAttrsHelper.TrunkInfo trunkInfo;
        IPortModel iPortModel = null;
        if (!this.areTrunkAttrsApplicable(this.trkSrcModel) && !this.areTrunkAttrsApplicable(this.trkDstModel)) {
            iPortModel = (IPortModel)this.trkSrcModel;
            this.disableOTNProvisioning = true;
        } else {
            iPortModel = !this.areTrunkAttrsApplicable(this.trkSrcModel) ? (IPortModel)this.trkSrcModel : (!this.areTrunkAttrsApplicable(this.trkDstModel) ? (IPortModel)this.trkDstModel : (IPortModel)this.trkSrcModel);
        }
        OchTrailAttrsHelper.TrunkInfo trunkInfo2 = OchTrailAttrsHelper.getTrunkAttrs((IEntityModel)iPortModel);
        this.otnStatusCB.setSelectedItem((Object)(trunkInfo2.isG709() ? OchTrailAttrsHelper.OTNStatus.OTN_ENABLE : OchTrailAttrsHelper.OTNStatus.OTN_DISABLE));
        this.sdBerCB.setSelectedItem((Object)OchTrailAttrsHelper.SdBerValues.getSdBerValue(trunkInfo2.getSdBer()));
        this.mappingCB.setSelectedItem((Object)OchTrailAttrsHelper.Mapping.getMapping(trunkInfo2.getMappingType()));
        OchTrailAttrsHelper.TrunkInfo trunkInfo3 = trunkInfo = this.regenTrunkInfo != null ? this.regenTrunkInfo : trunkInfo2;
        if (this.needsFrrProvisioning) {
            this.proactiveProtCB.setSelectedIndex(trunkInfo.getProactiveProtection());
            this.triggerThresholdCB.setSelectedIndex(trunkInfo.getTriggerThreshold() - 1);
            this.revertThresholdCB.setSelectedIndex(trunkInfo.getRevertThreshold() - 1);
            this.triggerWindowTP.setText(trunkInfo.getTriggerWindow() + "");
            this.revertWindowTP.setText(trunkInfo.getRevertWindow() + "");
        }
        IPortModel iPortModel2 = (IPortModel)this.trkDstModel;
        if (iPortModel.getEqType() == 291 && iPortModel2.getEqType() == 291 && (iPortModel.getModuleModel().getEqType() == 292 || iPortModel.getModuleModel().getEqType() == 320 || iPortModel2.getModuleModel().getEqType() == 292 || iPortModel2.getModuleModel().getEqType() == 320)) {
            this.fecCB.setSelectedItem((Object)OchTrailAttrsHelper.FecValues.FEC_ENHANCED);
            this.isOc768 = true;
        } else {
            this.fecCB.setSelectedItem((Object)OchTrailAttrsHelper.FecValues.getFecValue(trunkInfo2.getFecMode()));
        }
        if (this.disableOTNProvisioning) {
            this.otnStatusCB.setEnabled(false);
            this.fecCB.setEnabled(false);
            this.sdBerCB.setEnabled(false);
            this.mappingCB.setEnabled(false);
        } else {
            this.otnStatusCB.setEnabled(true);
            this.fecCB.setEnabled(!this.isOc768 && trunkInfo2.isG709());
            this.sdBerCB.setEnabled(true);
            this.mappingCB.setEnabled(true);
        }
    }

    private void setUpProtectionPane() throws AbstractCmsNoSuchEntityException, NoSuchEquipment, NoSuchInterface, AbstractCmsNoSuchElementException {
        boolean bl = this.isProtected();
        this.protectionAttr.setupProtection(bl);
        if (bl) {
            boolean bl2 = false;
            int n = 300;
            bl2 = this.tableModel.getRevertive(1);
            n = this.tableModel.getReversionTime(1);
            if (!bl2) {
                bl2 = this.tableModel.getRevertive(0);
                n = this.tableModel.getReversionTime(0);
            }
            if (bl2) {
                this.protectionAttr.setRevertiveCheckBoxEnable(bl2);
                this.protectionAttr.setReversionComboTime(n);
            }
        } else {
            this.protectionAttr.setRevertiveCheckBoxEnable(false);
        }
    }

    @Override
    public void revalidateData() {
        super.revalidateData();
        boolean bl = false;
        Exception exception = null;
        try {
            IEntityModel iEntityModel = this.getAbstractCktDlg().getSource().getEntityModel();
            IEntityModel iEntityModel2 = this.getAbstractCktDlg().getDest().getEntityModel();
            this.trkSrcModel = OchTrailHelper.getTrunkPorts(iEntityModel)[0];
            this.trkDstModel = OchTrailHelper.getTrunkPorts(iEntityModel2)[0];
            boolean bl2 = this.isProtected() && !OchTrailAttrsHelper.isTrunkInUse(this.trkSrcModel) && !OchTrailAttrsHelper.isTrunkInUse(this.trkDstModel);
            this.tableModel.updateModel(new IEntityModel[]{this.trkSrcModel, this.trkDstModel}, bl2);
            this.setUpCombo();
            this.setUpProtectionPane();
        }
        catch (Exception exception2) {
            exception = exception2;
            bl = true;
            SDebug.printStackTrace((Throwable)exception2);
        }
        if (bl) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CANNOT_FIND_TRUNK_MODEL, (Object)exception.toString());
            return;
        }
    }

    @Override
    public void validatePage() throws Exception {
        INetCircuit iNetCircuit;
        TablePropertyMgr.setColumnPrefs((JTable)this.table, "CcdOchAttrsPane");
        this.setTrunkInfo(new OchTrailAttrsHelper.TrunkInfo(this.otnStatusCB.getSelectedItem().equals((Object)OchTrailAttrsHelper.OTNStatus.OTN_ENABLE), ((OchTrailAttrsHelper.FecValues)((Object)this.fecCB.getSelectedItem())).getValue(), ((OchTrailAttrsHelper.SdBerValues)((Object)this.sdBerCB.getSelectedItem())).getValue(), ((OchTrailAttrsHelper.Mapping)((Object)this.mappingCB.getSelectedItem())).getValue(), this.getProactiveProtectionValue(), this.getTriggerThresholdValue(), this.getTriggerWindowValue(), this.getRevertThresholdValue(), this.getRevertWindowValue()));
        this.saveTrunkAttrs(this.trkSrcModel, this.trkDstModel);
        if (this.isProtected() && this.areReversionAttrsApplicable(this.trkSrcModel) && this.areReversionAttrsApplicable(this.trkDstModel)) {
            this.setProtectionInfo(new OchTrailAttrsHelper.ProtectionInfo(true, this.protectionAttr.getRevertiveBehavior()));
            this.saveReversionAttrs(this.trkSrcModel, this.trkDstModel);
        }
        if ((iNetCircuit = this.getAbstractCktDlg().getCircuit()).getCircuitTypeObj().isOchTrailTunnelCircuitType() && iNetCircuit.getCircuitSpanNum() == 0) {
            CircuitCreationDialog circuitCreationDialog = (CircuitCreationDialog)this.getAbstractCktDlg();
            circuitCreationDialog.addDestinationToOchTrail();
        }
    }

    @Override
    protected void handleNextException(Exception exception) {
        try {
            this.restoreAll();
        }
        catch (Exception exception2) {
            SDebug.printStackTrace((Throwable)exception2);
        }
        super.handleNextException(exception);
    }

    private boolean areTrunkAttrsApplicable(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, NoSuchInterface {
        IInterfaceModel iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel();
        if (iInterfaceModel instanceof IPlimTrkLineModel) {
            return true;
        }
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        if (iModuleModel instanceof IDwdmModuleModel && !((IDwdmModuleModel)iModuleModel).supportsOTN()) {
            return false;
        }
        if (OchTrailHelper.isLineCard(iEntityModel)) {
            if (this.db.on()) {
                this.db.println("areTrunkAttrsApplicable - Not Applicable: The Trunk is not a line card; Port: " + iEntityModel);
            }
            return false;
        }
        if (OchTrailAttrsHelper.isTrunkInUse(iEntityModel)) {
            if (this.db.on()) {
                this.db.println("areTrunkAttrsApplicable - Not Applicable: The Trunk port already belongs to another OchTrailTunnelNetLink; Port: " + iEntityModel);
            }
            return false;
        }
        return true;
    }

    private boolean areReversionAttrsApplicable(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, NoSuchInterface {
        if (iEntityModel == null || !OchTrailHelper.isProtected(iEntityModel)) {
            if (this.db.on()) {
                this.db.println("areReversionAttrsApplicable - Not Applicable: The Trunk is not protected; Port: " + iEntityModel);
            }
            return false;
        }
        return true;
    }

    private void saveTrunkAttrs(IEntityModel iEntityModel, IEntityModel iEntityModel2) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, DetailedConfigError, NoSuchInterface, WrongInterfaceType, ConfigError, ObjNotFound, ProvisionError {
        if (this.trkSrcModel != null && this.trkDstModel != null) {
            TrkAttribOperator trkAttribOperator = ((IOchCircuit)((Object)this.getAbstractCktDlg().getCircuit())).getTrkAttribOperator();
            if (trkAttribOperator != null) {
                trkAttribOperator.saveTrunkAttrs(this.trkSrcModel, this.trkDstModel, this.getTrunkInfo());
            }
        } else {
            throw new ObjNotFound("Unable to find the src and dst Trunk Ports.");
        }
    }

    private void saveReversionAttrs(IEntityModel iEntityModel, IEntityModel iEntityModel2) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, AbstractCmsNoSuchElementException, ObjNotFound {
        if (!this.isProtected()) {
            return;
        }
        if (this.trkSrcModel != null && this.trkDstModel != null) {
            TrkAttribOperator trkAttribOperator = ((OchccCircuit)this.getAbstractCktDlg().getCircuit()).getTrkAttribOperator();
            if (trkAttribOperator != null) {
                trkAttribOperator.saveReversions(this.trkSrcModel, this.trkDstModel, this.getProtectionInfo().getRevertiveBehavior());
            }
        } else {
            throw new ObjNotFound("Unable to find the src and dst Trunk Ports.");
        }
    }

    private void restoreTrunkAttrs() throws Exception {
        TrkAttribOperator trkAttribOperator = ((IOchCircuit)((Object)this.getAbstractCktDlg().getCircuit())).getTrkAttribOperator();
        if (trkAttribOperator != null) {
            trkAttribOperator.clearTrunkAttrs();
        }
    }

    private void restoreReversionAttrs() throws Exception {
        TrkAttribOperator trkAttribOperator;
        if (this.isProtected() && (trkAttribOperator = ((OchccCircuit)this.getAbstractCktDlg().getCircuit()).getTrkAttribOperator()) != null) {
            trkAttribOperator.clearReversions();
        }
    }

    public void restoreAll() throws Exception {
        if (this.trkSrcModel == null || this.trkDstModel == null) {
            throw new ObjNotFound("Unable to find the src and dst Ports.");
        }
        this.restoreTrunkAttrs();
        this.restoreReversionAttrs();
    }

    @Override
    protected String getNextPaneName() {
        return "OCH Circuit Routing Preferences";
    }

    @Override
    protected void initPane() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        this.setLayout(new BorderLayout());
        this.trunkTablePanel = CcdOchAttrsPane.createVerticalPanel("Trunk Setting");
        JPanel jPanel = CcdOchAttrsPane.createVerticalPanel("Current Values");
        JPanel jPanel2 = CcdOchAttrsPane.createVerticalPanel("Provisioning Values");
        JPanel jPanel3 = CcdOchAttrsPane.createVerticalPanel("Proactive Protection Attributes");
        try {
            object6 = this.getAbstractCktDlg().getSource().getEntityModel();
            object5 = this.getAbstractCktDlg().getDest().getEntityModel();
            this.trkSrcModel = OchTrailHelper.getTrunkPorts(object6)[0];
            this.trkDstModel = OchTrailHelper.getTrunkPorts(object5)[0];
            this.initTable();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        catch (NoSuchEquipment noSuchEquipment) {
            SDebug.printStackTrace((Throwable)noSuchEquipment);
        }
        catch (ObjNotFound objNotFound) {
            SDebug.printStackTrace((Throwable)objNotFound);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        this.table.setPreferredScrollableViewportSize(new Dimension(this.table.getPreferredSize().width, 70));
        object6 = new JScrollPane((Component)this.table);
        jPanel.add((Component)object6);
        object5 = new JLabel("ITU-T G.709 OTN: ");
        IInterfaceModel iInterfaceModel = ((IPortModel)this.trkSrcModel).getInterfaceModel();
        if (iInterfaceModel instanceof IPlimTrkLineModel) {
            object4 = new OchTrailAttrsHelper.OTNStatus[]{OchTrailAttrsHelper.OTNStatus.OTN_ENABLE};
            this.otnStatusCB = new UComboBox((Object[])object4);
        } else {
            this.otnStatusCB = new UComboBox((Object[])OchTrailAttrsHelper.OTNStatus.values());
        }
        this.otnStatusCB.addActionListener((ActionListener)this);
        object4 = new JLabel("FEC: ");
        this.fecCB = new UComboBox((Object[])OchTrailAttrsHelper.FecValues.values());
        JLabel jLabel = new JLabel("SD BER: ");
        this.sdBerCB = new UComboBox((Object[])OchTrailAttrsHelper.SdBerValues.values());
        JLabel jLabel2 = new JLabel("Mapping: ");
        this.mappingCB = new UComboBox((Object[])OchTrailAttrsHelper.getAvailableMapping(this.tableModel.getMappingDataTypeFirstTrunk(), this.tableModel.getMappingDataTypeSecondTrunk()));
        JLabel jLabel3 = new JLabel("Trigger Threshold: ");
        JLabel jLabel4 = new JLabel("Trigger Window: ");
        JLabel jLabel5 = new JLabel("Revert Threshold: ");
        JLabel jLabel6 = new JLabel("Revert Window: ");
        JLabel jLabel7 = new JLabel("Proactive Protection: ");
        INetCircuit iNetCircuit = this.getAbstractCktDlg().getCircuit();
        if (iNetCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            object3 = ((IOchCircuit)((Object)this.getAbstractCktDlg().getCircuit())).getRegenTrunkEntityModels();
            boolean bl = false;
            object2 = ((NetCircuitEnd)iNetCircuit.getSources().get(0)).getNodeModel().getNeType();
            if (object2 != null) {
                boolean bl2 = bl = ((String)object2).compareToIgnoreCase("crs") == 0;
            }
            if (bl) {
                object = null;
                if (object3.size() > 0) {
                    this.regenPortModel = (IEntityModel)object3.get(0);
                    try {
                        this.regenTrunkInfo = OchTrailAttrsHelper.getTrunkAttrs(this.regenPortModel);
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        WzDiagDebug.printStackTrace((Throwable)wrongInterfaceType);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        WzDiagDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                    catch (NoSuchEquipment noSuchEquipment) {
                        WzDiagDebug.printStackTrace((Throwable)noSuchEquipment);
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        WzDiagDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                    object = (IDwdmTrkLineModel)((IPortModel)this.regenPortModel).getInterfaceModel();
                } else {
                    object = ((IPortModel)this.trkSrcModel).getInterfaceModel();
                }
                if (Feature.provides((INodeModel)object.getNodeModel(), (Feature)Feature.CRS_PROACTIVE_PROTECTION)) {
                    this.proactiveProtCB = new UComboBox((Object[])new String[]{"Disable", "Enable"});
                    if (this.regenPortModel != null) {
                        this.triggerThresholdCB = new UComboBox(((IDwdmTrkLineModel)object).getTriggerThresholdsList());
                        this.revertThresholdCB = new UComboBox(((IDwdmTrkLineModel)object).getRevertThresholdsList());
                    } else {
                        this.triggerThresholdCB = new UComboBox(((IPlimTrkLineModel)object).getTriggerThresholdsList());
                        this.revertThresholdCB = new UComboBox(((IPlimTrkLineModel)object).getRevertThresholdsList());
                    }
                    this.triggerWindowTP = new BoundTextField(32, 10);
                    this.revertWindowTP = new BoundTextField(32, 10);
                    this.needsFrrProvisioning = true;
                }
            }
        }
        object3 = new GridBagLayout();
        JPanel jPanel4 = new JPanel((LayoutManager)object3);
        object2 = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0);
        jPanel4.add((Component)object5, object2);
        ((GridBagConstraints)object2).gridx = 2;
        ((GridBagConstraints)object2).insets = new Insets(0, 5, 5, 15);
        jPanel4.add((Component)this.otnStatusCB, object2);
        ((GridBagConstraints)object2).gridx = 3;
        ((GridBagConstraints)object2).insets = new Insets(0, 0, 5, 5);
        jPanel4.add((Component)object4, object2);
        ((GridBagConstraints)object2).gridx = 4;
        ((GridBagConstraints)object2).insets = new Insets(0, 5, 5, 15);
        jPanel4.add((Component)this.fecCB, object2);
        ((GridBagConstraints)object2).gridx = 5;
        ((GridBagConstraints)object2).insets = new Insets(0, 0, 5, 5);
        jPanel4.add((Component)jLabel, object2);
        ((GridBagConstraints)object2).gridx = 6;
        ((GridBagConstraints)object2).insets = new Insets(0, 5, 5, 15);
        jPanel4.add((Component)this.sdBerCB, object2);
        ((GridBagConstraints)object2).gridx = 1;
        ((GridBagConstraints)object2).gridy = 3;
        ((GridBagConstraints)object2).insets = new Insets(10, 0, 5, 5);
        jPanel4.add((Component)jLabel2, object2);
        ((GridBagConstraints)object2).gridx = 2;
        ((GridBagConstraints)object2).gridy = 3;
        ((GridBagConstraints)object2).insets = new Insets(10, 5, 5, 15);
        jPanel4.add((Component)this.mappingCB, object2);
        jPanel2.add(jPanel4);
        if (this.needsFrrProvisioning) {
            object3 = new GridBagLayout();
            object = new JPanel((LayoutManager)object3);
            object2 = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0);
            ((GridBagConstraints)object2).gridx = 1;
            ((Container)object).add((Component)jLabel7, object2);
            ((GridBagConstraints)object2).gridx = 2;
            ((GridBagConstraints)object2).insets = new Insets(0, 5, 5, 15);
            ((Container)object).add((Component)this.proactiveProtCB, object2);
            ((GridBagConstraints)object2).gridx = 1;
            ((GridBagConstraints)object2).gridy = 2;
            ((GridBagConstraints)object2).insets = new Insets(10, 0, 5, 15);
            ((Container)object).add((Component)jLabel3, object2);
            ((GridBagConstraints)object2).gridx = 2;
            ((GridBagConstraints)object2).gridy = 2;
            ((GridBagConstraints)object2).insets = new Insets(10, 5, 5, 15);
            ((Container)object).add((Component)this.triggerThresholdCB, object2);
            ((GridBagConstraints)object2).gridx = 3;
            ((GridBagConstraints)object2).gridy = 2;
            ((GridBagConstraints)object2).insets = new Insets(10, 0, 5, 5);
            ((Container)object).add((Component)jLabel4, object2);
            ((GridBagConstraints)object2).gridx = 4;
            ((GridBagConstraints)object2).gridy = 2;
            ((GridBagConstraints)object2).insets = new Insets(10, 5, 5, 15);
            this.triggerWindowTP.setMinimumSize(new Dimension(120, 15));
            ((Container)object).add((Component)this.triggerWindowTP, object2);
            ((GridBagConstraints)object2).gridx = 1;
            ((GridBagConstraints)object2).gridy = 3;
            ((GridBagConstraints)object2).insets = new Insets(20, 0, 5, 5);
            ((Container)object).add((Component)jLabel5, object2);
            ((GridBagConstraints)object2).gridx = 2;
            ((GridBagConstraints)object2).gridy = 3;
            ((GridBagConstraints)object2).insets = new Insets(20, 5, 5, 15);
            ((Container)object).add((Component)this.revertThresholdCB, object2);
            ((GridBagConstraints)object2).gridx = 3;
            ((GridBagConstraints)object2).gridy = 3;
            ((GridBagConstraints)object2).insets = new Insets(20, 0, 5, 5);
            ((Container)object).add((Component)jLabel6, object2);
            ((GridBagConstraints)object2).gridx = 4;
            ((GridBagConstraints)object2).gridy = 3;
            ((GridBagConstraints)object2).insets = new Insets(20, 5, 5, 15);
            ((Container)object).add((Component)this.revertWindowTP, object2);
            jPanel3.add((Component)object);
            jPanel2.add(jPanel3);
            int n = this.parent.getHeight();
            int n2 = this.parent.getWidth();
            Dimension dimension = new Dimension(n2, n + 50);
            this.parent.setSize(dimension);
        }
        this.trunkTablePanel.add(jPanel);
        this.trunkTablePanel.add(jPanel2);
        this.add((Component)this.trunkTablePanel, "Center");
        this.protectionAttr = new ProtectionAttr();
        this.add((Component)this.protectionAttr.getUI(), "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.otnStatusCB) {
            UComboBox uComboBox = (UComboBox)object;
            Object object2 = uComboBox.getSelectedItem();
            if (object2.equals((Object)OchTrailAttrsHelper.OTNStatus.OTN_DISABLE)) {
                this.fecCB.setSelectedItem((Object)OchTrailAttrsHelper.FecValues.FEC_DISABLE);
                this.fecCB.setEnabled(false);
            } else if (!this.isOc768) {
                this.fecCB.setEnabled(true);
            }
        }
    }

    private void initTable() throws AbstractCmsNoSuchEntityException, NoSuchEquipment, NoSuchInterface, ObjNotFound {
        this.tableModel = new CcdOchAttrsTableModel(new IEntityModel[]{this.trkSrcModel, this.trkDstModel});
        this.table = new UTable((TableModel)this.tableModel);
        this.table.getColumnModel().getColumn(0).setCellRenderer(this.table.getTableHeader().getDefaultRenderer());
    }

    private CircuitCreatInfo getCircuitInfo() {
        return this.parent == null ? null : this.getAbstractCktDlg().getCircuitInfo();
    }

    private boolean isProtected() {
        return this.getCircuitInfo().isProtected() && (this.trkSrcModel == null || !OchTrailHelper.isProtectedOCHNCService(this.trkSrcModel));
    }

    public OchTrailAttrsHelper.ProtectionInfo getProtectionInfo() {
        return this.protectionInfo;
    }

    public void setProtectionInfo(OchTrailAttrsHelper.ProtectionInfo protectionInfo) {
        this.protectionInfo = protectionInfo;
    }

    public OchTrailAttrsHelper.TrunkInfo getTrunkInfo() {
        return this.trunkInfo;
    }

    public void setTrunkInfo(OchTrailAttrsHelper.TrunkInfo trunkInfo) {
        if (this.needsFrrProvisioning) {
            String string = (String)this.triggerThresholdCB.getSelectedItem();
            String string2 = (String)this.revertThresholdCB.getSelectedItem();
            trunkInfo.setTriggerThresholdStr(string);
            trunkInfo.setRevertThresholdStr(string2);
        }
        this.trunkInfo = trunkInfo;
    }

    private int getTriggerThresholdValue() {
        if (this.needsFrrProvisioning) {
            return this.triggerThresholdCB.getSelectedIndex() + 1;
        }
        return -1;
    }

    private int getRevertThresholdValue() {
        if (this.needsFrrProvisioning) {
            return this.revertThresholdCB.getSelectedIndex() + 1;
        }
        return -1;
    }

    private int getTriggerWindowValue() {
        int n = -1;
        if (this.needsFrrProvisioning) {
            try {
                n = Integer.parseInt(this.triggerWindowTP.getText());
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMsg.displayDetailed((Component)this, NEMC.EID_INVALID_NUMBER, " Enter a valid number for Trigger Window.");
            }
        }
        return n;
    }

    private int getRevertWindowValue() {
        int n = -1;
        if (this.needsFrrProvisioning) {
            try {
                n = Integer.parseInt(this.revertWindowTP.getText());
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMsg.displayDetailed((Component)this, NEMC.EID_INVALID_NUMBER, " Enter a valid number for Revert Window.");
            }
        }
        return n;
    }

    private int getProactiveProtectionValue() {
        if (this.needsFrrProvisioning) {
            return this.proactiveProtCB.getSelectedIndex();
        }
        return -1;
    }

    class ProtectionAttr {
        private boolean isProtected;
        RevertiveBehaviorPanel revertiveBehaviorPanel;
        private JPanel p = new JPanel();

        ProtectionAttr() {
            this.p.setLayout(new BorderLayout());
            this.p.setBorder(BorderFactory.createTitledBorder("Protection"));
            this.revertiveBehaviorPanel = new RevertiveBehaviorPanel(null);
            this.p.add((Component)this.revertiveBehaviorPanel, "Center");
        }

        protected void setupProtection(boolean bl) {
            this.revertiveBehaviorPanel.setRevertiveEnabled(bl);
        }

        public JPanel getUI() {
            return this.p;
        }

        public boolean isProtected() {
            return this.isProtected;
        }

        public boolean isRevertive() {
            IRevertiveBehavior iRevertiveBehavior = this.revertiveBehaviorPanel.getRevertiveBehavior();
            return iRevertiveBehavior.getReversionMode() == 2;
        }

        public void setRevertiveCheckBoxEnable(boolean bl) {
            this.revertiveBehaviorPanel.setRevertive(bl);
        }

        public void setReversionComboTime(int n) {
            this.revertiveBehaviorPanel.setReversionTime(n);
        }

        public int getRevertiveTime() {
            return this.revertiveBehaviorPanel.getReversionTime();
        }

        public IRevertiveBehavior getRevertiveBehavior() {
            return this.revertiveBehaviorPanel.getRevertiveBehavior();
        }
    }
}

