/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitSize;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.route.RoutePrefs;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.AutorangeInfo;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.ICcdRoutePane;
import cerent.cms.ui.circuits.UnprotectedToUpsrDialog;
import cerent.cms.ui.circuits.WzCcdPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IgnorableDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CcdRoutePane
extends WzCcdPane
implements ChangeListener,
ICcdRoutePane {
    boolean amChildOfUnprotectedToUpsrDialog = false;
    boolean amChildOfCircuitCreationDialog = false;
    protected WzCcdPane.AutoRouteCheckBox autoRouteCB;
    protected JCheckBox advRouteCB;
    protected JCheckBox urnCB;
    protected JCheckBox rrbcCB;
    protected JCheckBox tsccCB;
    protected JCheckBox wtsmCB;
    protected JCheckBox pathProtCB;
    protected JCheckBox pcaCB;
    protected JCheckBox driCB;
    protected JRadioButton ndRequired;
    protected JRadioButton ndDesired;
    protected JRadioButton ldOnly;
    protected ButtonGroup nodeDiversity;
    protected ButtonGroup routingDirection;
    private Preferences prefs = Preferences.instance();
    static final String PREF_PATH = "ctc.circuit.creation";
    private static final String PREF_URN = "useRequiredNodesSpans";
    private static final String PREF_RRBC = "reviewRouteBeforeCreation";
    private static final String PREF_WTSM = "warnIfCktRouteChangesTimeSlot";
    static final String PREF_DRI = "dri";
    public static final String PCA_TITLE = "PCA Circuit Creation";
    public static final String PREF_PCA_VALUE = "warnPca";
    public static final String PREF_PCA_DESCR = "CircuitCreation: PCA Circuits are unprotected";
    private boolean sameNode = false;
    private boolean mayEnablePca = true;
    protected RoutePrefs routePrefs;
    protected boolean pca = false;
    protected boolean pathProt = false;
    protected boolean autoRoute = false;
    protected boolean urn = false;
    protected boolean rrbc = false;
    protected boolean arcb = false;
    protected boolean tscc = false;
    protected boolean wtsm = false;

    @Override
    public String getShortName() {
        return "Routing Options";
    }

    public CcdRoutePane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string) {
        super(abstractCircuitDialog, wzDiagDebug, string);
        this.amChildOfUnprotectedToUpsrDialog = abstractCircuitDialog instanceof UnprotectedToUpsrDialog;
        this.amChildOfCircuitCreationDialog = abstractCircuitDialog instanceof CircuitCreationDialog;
    }

    @Override
    protected void initPane() {
        this.db.fine("initPane()");
        this.getRoutePrefs();
        this.setLayout(new BoxLayout(this, 1));
        this.autoRouteCB = new WzCcdPane.AutoRouteCheckBox((AbstractCircuitDialog)this.parent, PREF_PATH, PREF_URN, PREF_RRBC, PREF_WTSM);
        this.add(this.autoRouteCB);
        this.autoRouteCB.init();
        this.autoRoute = this.autoRouteCB.getDefaultAutoRoute();
        this.urn = this.autoRouteCB.getDefaultUrn();
        this.rrbc = this.autoRouteCB.getDefaultRrbc();
        this.tscc = this.autoRouteCB.getDefaultTscc();
        this.wtsm = this.autoRouteCB.getDefaultWtsm();
        this.autoRouteCB.addChangeListener(this);
        JPanel jPanel = new JPanel();
        this.add(jPanel);
        jPanel.setAlignmentX(0.0f);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 20, 0));
        jPanel.setLayout(new FlowLayout(0));
        this.urnCB = new JCheckBox("Using Required Nodes/Spans");
        jPanel.add(this.urnCB);
        String string = "Review Route Before Creation    ";
        this.urnCB.setSelected(this.urn);
        if (this.amChildOfUnprotectedToUpsrDialog) {
            this.urnCB.setSelected(false);
            this.urnCB.setEnabled(false);
            string = "Review Route Before Upgrade";
        }
        this.urnCB.addChangeListener(this);
        this.rrbcCB = new JCheckBox(string);
        jPanel.add(this.rrbcCB);
        this.rrbcCB.setSelected(this.rrbc);
        this.rrbcCB.addChangeListener(this);
        this.tsccCB = new JCheckBox("VT-DS3 Mapped Conversion ");
        jPanel.add(this.tsccCB);
        this.tsccCB.setSelected(this.tscc);
        this.tsccCB.addChangeListener(this);
        this.wtsmCB = new JCheckBox("Check Time Slot Changes   ");
        jPanel.add(this.wtsmCB);
        this.wtsmCB.setSelected(this.wtsm);
        this.wtsmCB.addChangeListener(this);
        if (!AbstractCircuitDialog.isSonet()) {
            this.tsccCB.setVisible(false);
        }
        this.add(Box.createVerticalStrut(15));
        this.pathProtCB = new JCheckBox("Fully Protected Path");
        this.add(this.pathProtCB);
        this.pathProtCB.addChangeListener(this);
        JPanel jPanel2 = new JPanel();
        this.add(jPanel2);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        JPanel jPanel3 = CcdRoutePane.createVerticalPanel("Node-Diverse Path");
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        this.ndRequired = new JRadioButton("Nodal Diversity Required");
        jPanel3.add(this.ndRequired);
        this.ndDesired = new JRadioButton("Nodal Diversity Desired", true);
        jPanel3.add(this.ndDesired);
        this.ldOnly = new JRadioButton("Link Diversity Only");
        jPanel3.add(this.ldOnly);
        this.nodeDiversity = new ButtonGroup();
        this.nodeDiversity.add(this.ndRequired);
        this.nodeDiversity.add(this.ndDesired);
        this.nodeDiversity.add(this.ldOnly);
        ++gridBagConstraints.gridx;
        JPanel jPanel4 = CcdRoutePane.createVerticalPanel(null);
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        this.pcaCB = new JCheckBox("Protection Channel Access");
        jPanel4.add(this.pcaCB);
        this.pcaCB.addActionListener(this);
        this.driCB = new JCheckBox("Dual Ring Interconnect");
        jPanel4.add(this.driCB);
        this.driCB.addActionListener(this);
        this.advRouteCB = new JCheckBox("Overlay Ring");
        jPanel4.add(this.advRouteCB);
        this.advRouteCB.addChangeListener(this);
        if (this.amChildOfUnprotectedToUpsrDialog) {
            this.driCB.setEnabled(false);
            this.driCB.setSelected(false);
            this.advRouteCB.setEnabled(false);
            this.advRouteCB.setSelected(false);
        }
    }

    protected INetCircuit getCircuit() {
        return this.getAbstractCktDlg().getCircuit();
    }

    protected CircuitCreatInfo getCircuitInfo() {
        return this.getAbstractCktDlg().getCircuitInfo();
    }

    protected boolean getPortGrouping() {
        return this.getAbstractCktDlg().getPortGrouping();
    }

    @Override
    public boolean isAutoRoute() {
        return this.autoRoute;
    }

    @Override
    public boolean isPca() {
        return this.pca;
    }

    @Override
    public void setPca(boolean bl) {
        this.pca = bl;
    }

    @Override
    public boolean isPathProt() {
        return this.pathProt;
    }

    @Override
    public void setPathProt(boolean bl) {
        this.pathProt = bl;
    }

    @Override
    public boolean isRrbc() {
        return this.rrbc;
    }

    @Override
    public boolean isUrn() {
        return this.urn;
    }

    @Override
    public RoutePrefs getRoutePrefs() {
        if (this.routePrefs == null) {
            this.routePrefs = new RoutePrefs();
            this.routePrefs.setPathProt(0);
            this.routePrefs.setDiversityOption(1);
        }
        return this.routePrefs;
    }

    @Override
    public void setRoutePrefs(RoutePrefs routePrefs) {
        if (routePrefs != null) {
            this.routePrefs = routePrefs;
        }
    }

    private int getEqTypeFromCktEnd(INetCircuitEnd iNetCircuitEnd) {
        try {
            IEntityModel iEntityModel;
            if (iNetCircuitEnd != null && (iEntityModel = iNetCircuitEnd.getEntityModel()) != null) {
                return iEntityModel.getEqType();
            }
        }
        catch (ObjNotFound objNotFound) {
            // empty catch block
        }
        return 0;
    }

    protected boolean allowTscc() {
        boolean bl = CircuitSize.getCircuitSize((int)this.getAbstractCktDlg().getCircuitInfo().size()).getEnum() == 1;
        boolean bl2 = true;
        int n = this.getEqTypeFromCktEnd(this.getAbstractCktDlg().getSource());
        switch (n) {
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 61: {
                break;
            }
            default: {
                bl2 = false;
            }
        }
        boolean bl3 = true;
        int n2 = this.getEqTypeFromCktEnd(this.getAbstractCktDlg().getDest());
        int n3 = this.getAbstractCktDlg().getCircuitType();
        if (n3 != 7) {
            switch (n2) {
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 61: {
                    break;
                }
                default: {
                    bl3 = false;
                }
            }
        }
        boolean bl4 = true;
        if (n3 != 7) {
            if (n == n2 && (n == 32 || n == 33)) {
                bl4 = false;
            }
        } else if (n == 33 || n == 34) {
            bl4 = false;
        }
        return bl && bl2 && bl3 && bl4;
    }

    protected boolean forceTscc() {
        int n = this.getAbstractCktDlg().getCircuitType();
        int n2 = this.getEqTypeFromCktEnd(this.getAbstractCktDlg().getSource());
        int n3 = this.getEqTypeFromCktEnd(this.getAbstractCktDlg().getDest());
        INetCircuitEnd iNetCircuitEnd = null;
        INetCircuitEnd iNetCircuitEnd2 = null;
        iNetCircuitEnd = this.getAbstractCktDlg().getSource();
        iNetCircuitEnd2 = this.getAbstractCktDlg().getDest();
        try {
            if (iNetCircuitEnd != null && iNetCircuitEnd.getEntityModel().getParent().getEqType() == 145 && iNetCircuitEnd.getEntityModel().getPositionInParent() > 13 && iNetCircuitEnd.getEntityModel().getPositionInParent() % 2 == 0) {
                n2 = 32;
            }
            if (iNetCircuitEnd2 != null && iNetCircuitEnd2.getEntityModel().getParent().getEqType() == 145 && iNetCircuitEnd2.getEntityModel().getPositionInParent() > 13 && iNetCircuitEnd2.getEntityModel().getPositionInParent() % 2 == 0) {
                n3 = 32;
            }
        }
        catch (ObjNotFound objNotFound) {
            this.db.println("Error in Retrieving Eqpt Type");
            WzDiagDebug.printStackTrace((Throwable)objNotFound);
        }
        if (n == 1 && (n2 == 32 && n3 == 33 || n2 == 33 && n3 == 32)) {
            return true;
        }
        return n == 7 && n2 == 32;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.autoRouteCB) {
            this.autoRoute = this.autoRouteCB.isSelected();
            if (this.amChildOfUnprotectedToUpsrDialog) {
                this.ndRequired.setEnabled(this.autoRoute);
                this.ndDesired.setEnabled(this.autoRoute);
                this.ldOnly.setEnabled(this.autoRoute);
            } else {
                this.urnCB.setEnabled(this.autoRoute);
                this.wtsmCB.setEnabled(this.autoRoute);
            }
            this.rrbcCB.setEnabled(this.autoRoute);
            if (this.autoRoute) {
                this.advRouteCB.setSelected(false);
                this.advRouteCB.setEnabled(false);
                this.getCircuit().setOverlayRing(false);
            } else {
                if (this.isValidOverlayCircuitType() && !this.driCB.isSelected() && !this.pcaCB.isSelected() && this.amChildOfCircuitCreationDialog) {
                    this.advRouteCB.setEnabled(true);
                } else {
                    this.advRouteCB.setEnabled(false);
                }
                this.getCircuit().setOverlayRing(false);
            }
            if (this.sameNode && !this.samePort() && this.getCircuit().getCircuitTypeObj().isHoCircuitType() || this.amChildOfUnprotectedToUpsrDialog && this.getCircuit().hasMxpn()) {
                this.urnCB.setSelected(false);
                this.rrbcCB.setSelected(false);
                this.urnCB.setEnabled(false);
                this.rrbcCB.setEnabled(false);
                this.wtsmCB.setSelected(false);
            }
            if (!this.autoRoute) {
                this.urnCB.setSelected(false);
                this.rrbcCB.setSelected(false);
                this.tsccCB.setSelected(false);
                this.wtsmCB.setSelected(false);
                if (this.sameNode && !this.samePort() && this.getCircuit().getCircuitTypeObj().isHoCircuitType()) {
                    this.pathProtCB.setSelected(false);
                    this.pathProtCB.setEnabled(false);
                    this.pcaCB.setEnabled(true);
                }
            } else if (!this.amChildOfUnprotectedToUpsrDialog) {
                if (this.sameNode && !this.pathProtCB.isSelected()) {
                    this.pathProtCB.setEnabled(true);
                }
                if (this.sameNode && !this.samePort() && this.getCircuit().getCircuitTypeObj().isHoCircuitType()) {
                    this.pathProtCB.setSelected(this.routePrefs.getPathProt() == 0 || this.routePrefs.getPathProt() == 5);
                }
            }
            boolean bl = this.allowTscc();
            this.tsccCB.setEnabled(this.autoRoute && bl && !this.forceTscc());
            this.tsccCB.setSelected(this.forceTscc());
            if (!bl) {
                this.tscc = false;
            }
            this.db.fine("stateChanged: autoRouteCB is " + this.autoRoute);
            if (this.autoRoute && this.driCB.isSelected()) {
                this.urnCB.setSelected(true);
                this.urnCB.setEnabled(false);
            }
        } else if (object == this.pathProtCB) {
            this.pathProt = this.pathProtCB.isSelected();
            this.db.fine("stateChanged: pathProtCB is " + this.pathProt);
            if (!this.amChildOfUnprotectedToUpsrDialog) {
                this.ndRequired.setEnabled(this.pathProt && !this.driCB.isSelected() && !this.advRouteCB.isSelected());
                this.ndDesired.setEnabled(this.pathProt && !this.driCB.isSelected() && !this.advRouteCB.isSelected());
                this.ldOnly.setEnabled(this.pathProt && !this.driCB.isSelected() && !this.advRouteCB.isSelected());
            }
            if (this.pathProtCB.isSelected()) {
                this.pcaCB.setSelected(false);
                if (this.isBridgedOneWay() && !this.amChildOfUnprotectedToUpsrDialog) {
                    this.driCB.setSelected(true);
                }
                if (this.driCB.isSelected()) {
                    this.ndRequired.setSelected(true);
                }
            } else {
                this.driCB.setSelected(false);
                if (this.autoRouteCB.isSelected() && !this.sameNode && !this.getPortGrouping() && !this.amChildOfUnprotectedToUpsrDialog) {
                    this.urnCB.setEnabled(true);
                }
            }
            if (this.mayEnablePca) {
                this.pcaCB.setEnabled(!this.pathProtCB.isSelected());
            }
            if (!this.amChildOfUnprotectedToUpsrDialog) {
                this.driCB.setEnabled(this.pathProtCB.isSelected() && !this.getPortGrouping() && this.getCircuit().useLAP() == null && !this.getAbstractCktDlg().isVcatType() && !this.isBridgedOneWay() && !this.getCircuitInfo().isBackHaulCircuit());
            }
            if (this.isValidOverlayCircuitType() && !this.driCB.isSelected() && !this.pcaCB.isSelected() && this.amChildOfCircuitCreationDialog && !this.autoRouteCB.isSelected()) {
                this.advRouteCB.setEnabled(true);
            }
            if (this.advRouteCB.isSelected()) {
                this.driCB.setSelected(false);
                this.driCB.setEnabled(false);
                this.pcaCB.setSelected(false);
                this.pcaCB.setEnabled(false);
            }
        } else if (object == this.urnCB) {
            this.urn = this.urnCB.isSelected();
            if (this.urn) {
                this.wtsmCB.setSelected(false);
                this.wtsm = false;
            }
            this.wtsmCB.setEnabled(!this.urn);
        } else if (object == this.rrbcCB) {
            this.rrbc = this.rrbcCB.isSelected();
        } else if (object == this.advRouteCB) {
            this.arcb = this.advRouteCB.isSelected();
            if (this.arcb) {
                this.driCB.setSelected(false);
                this.driCB.setEnabled(false);
                this.pcaCB.setSelected(false);
                this.pcaCB.setEnabled(false);
                this.ndRequired.setEnabled(false);
                this.ndDesired.setEnabled(false);
                this.ldOnly.setEnabled(false);
            } else if (this.pathProtCB.isSelected()) {
                this.driCB.setEnabled(true);
                this.ndRequired.setEnabled(!this.driCB.isSelected());
                this.ndDesired.setEnabled(!this.driCB.isSelected());
                this.ldOnly.setEnabled(!this.driCB.isSelected());
            } else {
                this.pcaCB.setEnabled(true);
            }
            this.autoRouteCB.setEnabled(!this.arcb);
            this.getCircuit().setOverlayRing(this.arcb);
        } else if (object == this.pcaCB) {
            this.pca = !this.pathProtCB.isSelected() && this.pcaCB.isSelected();
        } else if (object == this.tsccCB) {
            this.tscc = this.tsccCB.isSelected();
        }
        this.syncButtons();
    }

    @Override
    public void validatePage() throws Exception {
        this.autoRoute = this.autoRouteCB.isSelected();
        this.rrbc = this.rrbcCB.isSelected();
        this.urn = this.urnCB.isSelected();
        this.arcb = this.advRouteCB.isSelected();
        this.wtsm = this.wtsmCB.isSelected();
        if (!this.amChildOfUnprotectedToUpsrDialog) {
            this.prefs.setBoolean(PREF_PATH, PREF_URN, this.urnCB.isSelected());
        }
        this.prefs.setBoolean(PREF_PATH, PREF_RRBC, this.rrbcCB.isSelected());
        this.prefs.setBoolean(PREF_PATH, PREF_DRI, this.driCB.isSelected());
        this.prefs.setBoolean(PREF_PATH, PREF_WTSM, this.wtsmCB.isSelected());
        this.routePrefs = new RoutePrefs();
        this.routePrefs.setTsValidation(this.wtsmCB.isSelected());
        if (this.pathProtCB.isSelected()) {
            this.routePrefs.setPathProt(0);
            this.routePrefs.setOrigSource(this.getAbstractCktDlg().getSource().getNetElement());
            this.routePrefs.setOrigDrop(this.getAbstractCktDlg().getDest().getNetElement());
        } else {
            this.routePrefs.setPathProt(2);
            this.routePrefs.setOrigSource(null);
            this.routePrefs.setOrigDrop(null);
        }
        int n = this.ndRequired.isSelected() ? 1 : (this.ndDesired.isSelected() ? 2 : 3);
        this.routePrefs.setDiversityOption(n);
        this.pca = !this.pathProtCB.isSelected() && this.pcaCB.isSelected();
        this.routePrefs.setPcaPref(this.pcaCB.isSelected());
        this.routePrefs.setDri(this.driCB.isSelected());
        this.tscc = this.tsccCB.isSelected();
        if (!this.amChildOfUnprotectedToUpsrDialog) {
            try {
                this.addOrRouteNewCircuit();
            }
            catch (Exception exception) {
                WzDiagDebug.printStackTrace((Throwable)exception);
                throw exception;
            }
        } else if (this.autoRouteCB.isSelected() && this.rrbcCB.isSelected()) {
            ((UnprotectedToUpsrDialog)this.parent).calculateAlternatePath();
        }
        if (this.prefs.getBoolean(PREF_PATH, PREF_WTSM, false)) {
            this.getTsSwitchWarnings();
        }
    }

    @Override
    protected void handlePostValidate() {
        AutorangeInfo autorangeInfo = this.getAutorangeInfo();
        if (autorangeInfo != null) {
            autorangeInfo.routePrefs = this.getRoutePrefs();
        }
    }

    protected void addOrRouteNewCircuit() throws Exception {
        if (!this.urn && !this.tscc) {
            this.getAbstractCktDlg().deleteDestination();
            this.db.fine("addOrRouteNewCircuit(): deleteDestination() worked");
            if (this.autoRoute) {
                if (!this.getAbstractCktDlg().isLoCkt() || this.getAbstractCktDlg().isLoCkt() && !this.getCircuit().needRoute(this.getAbstractCktDlg().getDest())) {
                    this.getAbstractCktDlg().addDestination(true);
                    this.db.fine("addOrRouteNewCircuit(): addDestination(true) worked");
                }
            } else {
                this.getAbstractCktDlg().addDestination(false);
            }
        }
    }

    @Override
    protected JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string = this.autoRouteCB.toString();
        String string2 = "";
        arrayList.add(new String[]{"Routing: ", string});
        if (this.pathProtCB.isSelected()) {
            string = "Fully protected";
            if (this.driCB.isSelected()) {
                string = string + " (DRI)";
            }
            if (this.autoRouteCB.isSelected()) {
                if (this.ndRequired.isSelected()) {
                    string2 = "Node diversity required";
                } else if (this.ndDesired.isSelected()) {
                    string2 = "Node diversity desired";
                } else if (this.ldOnly.isSelected()) {
                    string2 = "Link diversity";
                }
            }
        } else {
            string = "Unprotected";
            if (this.pcaCB.isSelected()) {
                string = string + " (PCA)";
            }
        }
        arrayList.add(new String[]{"Protection: ", string});
        if (!string2.equals("")) {
            arrayList.add(new String[]{"Path Diversity:", string2});
        }
        if (this.advRouteCB.isEnabled()) {
            String string3 = null;
            string3 = this.advRouteCB.isSelected() ? new String("True") : new String("False");
            arrayList.add(new String[]{"Overlay Ring: ", string3});
        }
        return CcdRoutePane.getGridPanel(arrayList);
    }

    @Override
    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.amChildOfUnprotectedToUpsrDialog) {
            stringBuffer.append(((UnprotectedToUpsrDialog)this.parent).getCktStatus());
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.autoRouteCB);
        stringBuffer.append("\nProtection: ");
        if (this.pathProtCB.isSelected()) {
            stringBuffer.append("Fully protected");
            if (this.driCB.isSelected()) {
                stringBuffer.append(" (DRI)");
            }
            if (this.autoRouteCB.isSelected() && !this.ldOnly.isSelected()) {
                stringBuffer.append("\nNode-diverse route: ");
                if (this.ndRequired.isSelected()) {
                    stringBuffer.append("required");
                } else if (this.ndDesired.isSelected()) {
                    stringBuffer.append("desired");
                }
            }
        } else {
            stringBuffer.append(" Unprotected");
            if (this.pcaCB.isSelected()) {
                stringBuffer.append(" (PCA)");
            }
        }
        this.db.fine("getStatusText(): " + stringBuffer.toString());
        return stringBuffer.toString();
    }

    @Override
    public boolean handleBack() {
        try {
            this.getAbstractCktDlg().deleteDestination();
        }
        catch (Exception exception) {
            WzDiagDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_DELETE_DESTINATION_FAILED);
        }
        return super.handleBack();
    }

    @Override
    protected String getNextPaneName() {
        if (this.tscc) {
            return "Conversion Circuit Constraints For Automatic Routing";
        }
        if (!this.urn) {
            if (this.getAbstractCktDlg().isLoCkt()) {
                return CircuitCreationDialog.WZPANE_GET_LO;
            }
            return "Route Review/Edit";
        }
        return "Circuit Constraints For Automatic Routing";
    }

    @Override
    public void revalidateData() {
        int n;
        this.db.fine("revalidateData");
        this.autoRouteCB.init();
        this.autoRoute = this.autoRouteCB.getDefaultAutoRoute();
        this.urn = this.autoRouteCB.getDefaultUrn();
        this.rrbc = this.autoRouteCB.getDefaultRrbc();
        this.tscc = this.autoRouteCB.getDefaultTscc();
        this.urnCB.setSelected(this.urn);
        this.rrbcCB.setSelected(this.rrbc);
        this.tsccCB.setSelected(this.tscc);
        this.advRouteCB.setSelected(this.arcb);
        boolean bl = this.forceTscc();
        if (this.sameNode && !this.samePort() && this.getCircuit().getCircuitTypeObj().isHoCircuitType() && !this.getCircuit().isMonitorCircuit()) {
            this.db.fine("revalidateData(): sameNode, differentPort, nonMonitorHO");
            this.autoRoute = false;
            this.autoRouteCB.setSelected(this.autoRoute);
            this.autoRouteCB.setEnabled(true);
            this.urnCB.setSelected(false);
            this.urnCB.setEnabled(false);
            this.urn = this.urnCB.isSelected();
            this.rrbcCB.setSelected(false);
            this.rrbcCB.setEnabled(false);
            this.rrbc = this.rrbcCB.isSelected();
            this.tsccCB.setSelected(bl);
            this.tsccCB.setEnabled(this.autoRoute && this.allowTscc() && !bl);
            this.tscc = this.tsccCB.isSelected();
            this.wtsmCB.setSelected(false);
            this.wtsmCB.setEnabled(false);
            this.wtsm = false;
        } else if (this.sameNode || this.getAbstractCktDlg().getPortGrouping()) {
            this.db.fine("revalidateData(): sameNode or PortGrouping");
            this.autoRoute = true;
            this.autoRouteCB.setSelected(this.autoRoute);
            this.autoRouteCB.setEnabled(this.sameNode ? 1 : 3);
            this.urnCB.setSelected(false);
            this.urnCB.setEnabled(false);
            this.urn = this.urnCB.isSelected();
            this.rrbcCB.setSelected(false);
            this.rrbcCB.setEnabled(false);
            this.rrbc = this.rrbcCB.isSelected();
            this.tsccCB.setSelected(bl);
            this.tsccCB.setEnabled(this.allowTscc() && !bl);
            this.tscc = this.tsccCB.isSelected();
            this.wtsmCB.setSelected(false);
            this.wtsmCB.setEnabled(false);
            this.wtsm = false;
        } else if (this.getAbstractCktDlg().autoRange) {
            this.db.fine("revalidateData(): autoRange");
            this.autoRoute = true;
            this.autoRouteCB.setSelected(this.autoRoute);
            this.autoRouteCB.setEnabled(2);
            this.urnCB.setEnabled(true);
            if (this.getAbstractCktDlg().getPortGrouping()) {
                this.urnCB.setSelected(false);
                this.urn = this.urnCB.isSelected();
                this.urnCB.setEnabled(false);
            }
            this.rrbcCB.setSelected(false);
            this.rrbc = this.rrbcCB.isSelected();
            this.rrbcCB.setEnabled(false);
            this.tsccCB.setSelected(bl);
            this.tsccCB.setEnabled(this.allowTscc() && !bl);
            this.tscc = this.tsccCB.isSelected();
        } else {
            if (bl) {
                this.autoRoute = true;
            }
            if (this.autoRouteCB.isUserChangeable() && this.parent instanceof CircuitCreationDialog && ((CircuitCreationDialog)this.parent).isCircuitTL1Compatible() && !this.tscc) {
                this.autoRoute = false;
            }
            if (!this.autoRoute) {
                this.urnCB.setSelected(false);
                this.urnCB.setEnabled(false);
                this.urn = false;
                this.rrbcCB.setSelected(false);
                this.rrbcCB.setEnabled(false);
                this.rrbc = false;
                this.tsccCB.setSelected(false);
                this.tsccCB.setEnabled(false);
                this.tscc = false;
                this.wtsmCB.setSelected(false);
                this.wtsmCB.setEnabled(false);
                this.wtsm = false;
            } else {
                this.tsccCB.setSelected(bl);
                this.tsccCB.setEnabled(this.allowTscc() && !bl);
            }
            this.autoRouteCB.setSelected(this.autoRoute);
            if (this.urnCB.isSelected()) {
                this.wtsmCB.setSelected(false);
                this.wtsmCB.setEnabled(false);
                this.wtsm = false;
            }
            if (bl) {
                this.db.fine("revalidateData(): tscc");
                this.autoRouteCB.setEnabled(4);
            } else {
                this.db.fine("revalidateData(): not tscc");
                this.autoRouteCB.setEnabled(true);
            }
        }
        if (this.amChildOfUnprotectedToUpsrDialog) {
            this.ndRequired.setEnabled(this.autoRouteCB.isSelected());
            this.ndDesired.setEnabled(this.autoRouteCB.isSelected());
            this.ldOnly.setEnabled(this.autoRouteCB.isSelected());
        }
        if (this.noPathProt()) {
            this.pathProtCB.setSelected(false);
            this.pathProtCB.setEnabled(false);
        } else if (this.amChildOfUnprotectedToUpsrDialog) {
            this.pathProtCB.setSelected(true);
            this.pathProtCB.setEnabled(false);
        } else {
            this.pathProtCB.setSelected(this.routePrefs.getPathProt() == 0 || this.routePrefs.getPathProt() == 5);
            this.pathProtCB.setEnabled(true);
        }
        if (this.getPortGrouping()) {
            this.driCB.setSelected(false);
        } else if (!this.pathProtCB.isSelected() || this.amChildOfUnprotectedToUpsrDialog || this.getCircuitInfo().isBackHaulCircuit()) {
            this.driCB.setEnabled(false);
        }
        if (this.getAbstractCktDlg().getAltDestNode() != null && this.getAbstractCktDlg().getAltDestNode() != this.getAbstractCktDlg().getDestNode() || this.getAbstractCktDlg().getAltSourceNode() != null && this.getAbstractCktDlg().getAltSourceNode() != this.getAbstractCktDlg().getSourceNode()) {
            if (this.isBridgedOneWay()) {
                this.pathProtCB.setEnabled(true);
                this.driCB.setEnabled(false);
            } else {
                this.pathProtCB.setEnabled(false);
            }
            this.pathProtCB.setSelected(true);
            if (!this.amChildOfUnprotectedToUpsrDialog) {
                this.driCB.setSelected(true);
            }
        }
        if (this.driCB.isSelected() && this.autoRouteCB.isSelected()) {
            this.urnCB.setSelected(true);
            this.urnCB.setEnabled(false);
        }
        if ((n = this.routePrefs.getDiversityOption()) == 1) {
            this.ndRequired.setSelected(true);
        } else if (n == 2) {
            this.ndDesired.setSelected(true);
        } else {
            this.ldOnly.setSelected(true);
        }
        if (!this.amChildOfUnprotectedToUpsrDialog) {
            this.forceNodalDiverseRequired(this.pathProtCB.isSelected() && this.driCB.isSelected() && !this.sameNode);
        }
        this.mayEnablePca = true;
        if (this.getCircuit().getCircuitTypeObj().isLoCircuitType()) {
            INetCircuit iNetCircuit = this.getCircuit().useLAP();
            if (iNetCircuit != null) {
                if (iNetCircuit.isPca()) {
                    this.pathProtCB.setSelected(false);
                    this.pathProtCB.setEnabled(false);
                    this.pcaCB.setSelected(true);
                    this.pcaCB.setEnabled(false);
                    this.ndRequired.setEnabled(false);
                    this.ndDesired.setEnabled(false);
                    this.ldOnly.setEnabled(false);
                } else if (!iNetCircuit.isCircuitProtected()) {
                    this.pathProtCB.setSelected(false);
                    this.pathProtCB.setEnabled(false);
                    this.pcaCB.setSelected(false);
                    this.pcaCB.setEnabled(true);
                    this.ndRequired.setEnabled(false);
                    this.ndDesired.setEnabled(false);
                    this.ldOnly.setEnabled(false);
                } else {
                    this.pcaCB.setSelected(false);
                    this.pcaCB.setEnabled(false);
                    this.mayEnablePca = false;
                }
            }
        } else {
            this.pcaCB.setSelected(this.isPca());
        }
        boolean bl2 = this.advRouteCB.isSelected();
        if (bl2) {
            this.driCB.setSelected(false);
            this.driCB.setEnabled(false);
            this.pcaCB.setSelected(false);
            this.pcaCB.setEnabled(false);
            this.ndRequired.setEnabled(false);
            this.ndDesired.setEnabled(false);
            this.ldOnly.setEnabled(false);
            this.autoRouteCB.setEnabled(false);
        }
    }

    private boolean noPathProt() {
        return !this.getPortGrouping() && (this.getCircuit().getCircuitTypeObj().isEthernetCircuitType() || this.getCircuit().getCircuitTypeObj().isTunnelCircuitType() || this.getCircuit().getCircuitTypeObj().isLAPCircuitType() || this.getCircuitInfo().monitor() || this.sameNode && !this.samePort() && this.getCircuit().getCircuitTypeObj().isHoCircuitType());
    }

    private boolean isBridgedOneWay() {
        return this.getAbstractCktDlg().getAltDestNode() != null && this.getAbstractCktDlg().getAltDestNode() != this.getAbstractCktDlg().getDestNode() && !this.getCircuit().isBidirectional();
    }

    @Override
    public void enteringPane() {
        this.sameNode = !(this.getAbstractCktDlg().getSourceNode() != this.getAbstractCktDlg().getDestNode() || this.getAbstractCktDlg().getAltDestNode() != null && this.getAbstractCktDlg().getSourceNode() != this.getAbstractCktDlg().getAltDestNode() || this.getAbstractCktDlg().getAltSourceNode() != null && this.getAbstractCktDlg().getSourceNode() != this.getAbstractCktDlg().getAltSourceNode());
        super.enteringPane();
        this.syncButtons();
        if (this.amChildOfUnprotectedToUpsrDialog) {
            ((UnprotectedToUpsrDialog)this.parent).setSpanUpdated(false);
        }
    }

    private boolean samePort() {
        IEntityModel iEntityModel;
        IEntityModel iEntityModel2;
        if (!this.sameNode) {
            return false;
        }
        INetCircuitEnd iNetCircuitEnd = this.getAbstractCktDlg().getSource();
        INetCircuitEnd iNetCircuitEnd2 = this.getAbstractCktDlg().getDest();
        try {
            iEntityModel2 = iNetCircuitEnd.getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            iEntityModel2 = null;
        }
        try {
            iEntityModel = iNetCircuitEnd2.getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            iEntityModel = null;
        }
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iNetCircuitEnd;
        NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)iNetCircuitEnd2;
        if (iEntityModel2 != null && iEntityModel2.getPayloadType() == 6 && netCircuitEnd.isEtherP2PCircuitEnd() || iEntityModel != null && iEntityModel.getPayloadType() == 6 && netCircuitEnd2.isEtherP2PCircuitEnd()) {
            return true;
        }
        return this.getAbstractCktDlg().getSource().getEntityIndex() == this.getAbstractCktDlg().getDest().getEntityIndex();
    }

    protected void syncButtons() {
        boolean bl = !this.autoRouteCB.isSelected() || this.autoRouteCB.isSelected() && (this.getAbstractCktDlg().isLoCkt() || this.urnCB.isSelected() || this.rrbcCB.isSelected() || this.tsccCB.isSelected());
        this.getAbstractCktDlg().setNextEnabled(bl);
        this.getAbstractCktDlg().setFinishEnabled(!bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.pcaCB) {
            if (this.pcaCB.isSelected()) {
                IgnorableDialog.infoDialog((Component)this, (String)this.getAbstractCktDlg().getPcaWarningMsg(), (String)PCA_TITLE, (String)PREF_PCA_VALUE, (String)PREF_PCA_DESCR);
            }
            this.setOverlayStateforPCAOrDRI(this.pcaCB.isSelected());
        } else if (object == this.driCB) {
            this.forceNodalDiverseRequired(this.driCB.isSelected());
            this.forceUrn(this.driCB.isSelected());
            this.setOverlayStateforPCAOrDRI(this.driCB.isSelected());
        }
    }

    private boolean isValidOverlayCircuitType() {
        int n = this.getAbstractCktDlg().getCircuit().getCircuitType();
        return n == 1 || n == 4;
    }

    private void setOverlayStateforPCAOrDRI(boolean bl) {
        if (!this.isValidOverlayCircuitType() || !this.amChildOfCircuitCreationDialog) {
            return;
        }
        boolean bl2 = this.autoRouteCB.isSelected();
        if (bl2) {
            return;
        }
        this.advRouteCB.setEnabled(!bl);
        this.advRouteCB.setSelected(false);
    }

    private void forceUrn(boolean bl) {
        if (bl) {
            if (this.autoRouteCB.isSelected()) {
                this.urnCB.setSelected(true);
                this.urnCB.setEnabled(false);
            }
        } else {
            this.urnCB.setSelected(false);
            this.urnCB.setEnabled(!this.sameNode && !this.getAbstractCktDlg().getPortGrouping() && this.autoRouteCB.isSelected());
        }
    }

    private void forceNodalDiverseRequired(boolean bl) {
        if (bl) {
            this.ndRequired.setSelected(true);
        } else {
            this.ndDesired.setSelected(true);
        }
        this.ndRequired.setEnabled(!bl);
        this.ndDesired.setEnabled(!bl);
        this.ldOnly.setEnabled(!bl);
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdRoutePane;
    }

    @Override
    public void removeListeners() {
        if (this.autoRouteCB != null) {
            this.autoRouteCB.removeChangeListener(this);
        }
        if (this.urnCB != null) {
            this.urnCB.removeChangeListener(this);
        }
        if (this.rrbcCB != null) {
            this.rrbcCB.removeChangeListener(this);
        }
        if (this.pathProtCB != null) {
            this.pathProtCB.removeChangeListener(this);
        }
        if (this.pcaCB != null) {
            this.pcaCB.removeActionListener(this);
        }
        if (this.driCB != null) {
            this.driCB.removeActionListener(this);
        }
        super.removeListeners();
    }

    @Override
    public void dispose() {
        this.routePrefs = null;
        super.dispose();
    }

    @Override
    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("Same node " + this.sameNode + "\n");
        stringBuffer.append("May Enable PCA: " + this.mayEnablePca + "\n");
        stringBuffer.append("Route Prefs: " + this.routePrefs + "\n");
        if (this.routePrefs != null) {
            stringBuffer.append(this.routePrefs.prettyString());
        }
        stringBuffer.append("PCA: " + this.pca + "\n");
        stringBuffer.append("Path Protected: " + this.pathProt + "\n");
        stringBuffer.append("Review Route Before Creation: " + this.rrbc + "\n");
        stringBuffer.append("Use Required Nodes: " + this.urn + "\n");
        stringBuffer.append("Autoroute: " + this.autoRoute + "\n");
        stringBuffer.append("AutorouteChangeable: " + this.autoRouteCB.isUserChangeable() + "\n");
        return stringBuffer.toString();
    }

    public void getTsSwitchWarnings() {
        StringBuffer stringBuffer = new StringBuffer();
        INetCircuit iNetCircuit = this.getCircuit();
        List list = iNetCircuit.getTimeSlotViolations();
        if (list != null && list.size() != 0) {
            stringBuffer.append("The Circuit Route Changes Time Slots On The Following Spans: ");
            stringBuffer.append("\n");
            for (int i = 0; i < list.size(); ++i) {
                if (list.size() > 1) {
                    stringBuffer.append("Warning #" + (i + 1) + " " + ": " + "\n");
                }
                String string = (String)list.get(i);
                stringBuffer.append(string);
                stringBuffer.append("\n\n");
            }
            stringBuffer.append("Is it OK to continue with the circuit creation?");
            this.isOkToPostValidate = CerentDialog.yesNoDialog((Component)this, (String)stringBuffer.toString(), (String)"Time Slot Change Warning");
        }
    }
}

