/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.INodeModel;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.circuits.CircuitDesignMap;
import cerent.cms.ui.network.NetMapLink;
import cerent.util.HoLoHelper;
import cerent.util.ILoNum;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;

public class CcdRoutePaneHelper {
    private CircuitDesignMap circuitMap;

    CcdRoutePaneHelper(CircuitDesignMap circuitDesignMap) {
        this.circuitMap = circuitDesignMap;
    }

    public String getSpanDesc(MapLink mapLink, NetLinkSpan netLinkSpan) {
        return this.getSpanDesc(mapLink, netLinkSpan.getLink(), netLinkSpan.getLoNum(), netLinkSpan);
    }

    public String getSpanDesc(MapLink mapLink, INetLink iNetLink) {
        return this.getSpanDesc(mapLink, iNetLink, null, null);
    }

    private String getSpanDesc(MapLink mapLink, INetLink iNetLink, ILoNum iLoNum, NetLinkSpan netLinkSpan) {
        Object object;
        NetMapLink netMapLink = (NetMapLink)mapLink;
        String string = netMapLink.getSrcEntityString();
        boolean bl = false;
        if (iNetLink != null) {
            object = null;
            object = iNetLink.getReverseLink();
            if (object != null && object.getPhysicalSize() != iNetLink.getPhysicalSize()) {
                bl = true;
            }
        }
        if (iNetLink.getSrcHo() != null) {
            string = string + "/" + HoLoHelper.getDisplay(iNetLink.getSrcHo(), true);
        }
        if (netLinkSpan != null && netLinkSpan.getSrcHoNum() != null) {
            string = string + "/" + HoLoHelper.getDisplay(netLinkSpan.getSrcHoNum(), true);
        }
        object = netMapLink.getDstEntityString();
        if (iNetLink.getDstHo() != null) {
            object = (String)object + "/" + HoLoHelper.getDisplay(iNetLink.getDstHo(), true);
        }
        if (netLinkSpan != null && netLinkSpan.getDstHoNum() != null) {
            object = (String)object + "/" + HoLoHelper.getDisplay(netLinkSpan.getDstHoNum(), true);
        }
        if (iLoNum != null) {
            object = (String)object + "/" + HoLoHelper.getDisplay(iLoNum, "", true);
            string = string + "/" + HoLoHelper.getDisplay(iLoNum, "", true);
        }
        if (mapLink.isSrcArrowEnabled() && !mapLink.isTargetArrowEnabled()) {
            if (bl) {
                return (String)object + " - " + string + " (Unknown)";
            }
            return (String)object + " - " + string + " (" + netMapLink.getProtectionTypeString() + " " + netMapLink.getLinkTypeString() + ")";
        }
        if (bl) {
            return string + " - " + (String)object + " (Unknown)";
        }
        return string + " - " + (String)object + " (" + netMapLink.getProtectionTypeString() + " " + netMapLink.getLinkTypeString() + ")";
    }

    public INetLink getNetLink(NetLinkSpan netLinkSpan) {
        if (netLinkSpan == null) {
            return null;
        }
        return netLinkSpan.getLink();
    }

    protected MapLink getMapLink(INetLink iNetLink) {
        if (iNetLink == null) {
            return null;
        }
        MapLink mapLink = this.circuitMap.getDirectionalMapLink(iNetLink);
        return mapLink;
    }

    public MapLink getMapLink(NetLinkSpan netLinkSpan) {
        if (netLinkSpan == null) {
            return null;
        }
        INetLink iNetLink = this.getNetLink(netLinkSpan);
        if (iNetLink == null) {
            return null;
        }
        MapLink mapLink = this.circuitMap.getDirectionalMapLink(iNetLink);
        return mapLink;
    }

    public MapLink netToMapLink(NetLinkSpan netLinkSpan) {
        if (netLinkSpan == null) {
            return null;
        }
        return this.netToMapLink(netLinkSpan.getLink());
    }

    public MapLink netToMapLink(INetLink iNetLink) {
        if (iNetLink == null) {
            return null;
        }
        MapLink mapLink = this.circuitMap.getDirectionalMapLink(iNetLink);
        if (mapLink == null) {
            iNetLink = this.circuitMap.findReverseLink(iNetLink);
            mapLink = this.circuitMap.getDirectionalMapLink(iNetLink);
        }
        return mapLink;
    }

    protected INetElement getNetElement(MapNode mapNode) {
        if (mapNode == null) {
            return null;
        }
        INodeModel iNodeModel = this.getNodeModel(mapNode);
        return Network.instance().getNetElem(iNodeModel.getNodeId());
    }

    public INodeModel getNodeModel(MapNode mapNode) {
        if (mapNode == null) {
            return null;
        }
        return (INodeModel)mapNode.getUserObject();
    }

    public MapNode getMapNode(INetElement iNetElement) {
        if (iNetElement == null) {
            return null;
        }
        return this.getMapNode(iNetElement.getNodeModel());
    }

    public MapNode getMapNode(INodeModel iNodeModel) {
        if (iNodeModel == null) {
            return null;
        }
        return this.circuitMap.getMapNode(iNodeModel);
    }
}

