/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.INodeModel;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzStatusPanel;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.CcdRouteConstraintPane;
import cerent.cms.ui.circuits.RoutingConstraint;
import cerent.cms.ui.circuits.VcatMemberTableData;
import cerent.util.AnnotatedException;
import cerent.util.gui.GridPanel;
import cerent.util.gui.MultiLineLabelUI;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;

public class CcdVcatRouteConstraintPane
extends CcdRouteConstraintPane
implements ActionListener {
    JComboBox memberCB;
    JPanel memSelPanel;
    int curRowIndex = -1;
    int newSelectedRowIndex = -1;
    HashMap includeMap = new HashMap();
    HashMap excludeMap = new HashMap();

    public CcdVcatRouteConstraintPane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string, boolean bl) {
        super(abstractCircuitDialog, wzDiagDebug, string, bl);
    }

    @Override
    void getMoreUIs() {
        super.getMoreUIs();
        this.memSelPanel = CcdVcatRouteConstraintPane.createHorizontalPanel(null);
        JLabel jLabel = new JLabel("Route Member number:");
        this.memSelPanel.add(jLabel);
        this.memberCB = new JComboBox();
        this.memSelPanel.add(this.memberCB);
        this.memSelPanel.add(Box.createHorizontalGlue());
        this.memberCB.setModel(new DefaultComboBoxModel());
        this.memSelPanel.setVisible(false);
    }

    @Override
    protected void enteringPaneBackwards() {
        if (this.getAbstractCktDlg().isVcatCommonFiberRouting()) {
            super.enteringPaneBackwards();
        }
    }

    @Override
    public void enteringPane() {
        super.enteringPane();
        if (!this.getAbstractCktDlg().isVcatCommonFiberRouting()) {
            this.topPanel.add((Component)this.memSelPanel, "North");
            this.memSelPanel.setVisible(true);
            Iterator iterator = this.membersTableModel.tabData.iterator();
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.memberCB.getModel();
            while (iterator.hasNext()) {
                VcatMemberTableData vcatMemberTableData = (VcatMemberTableData)iterator.next();
                defaultComboBoxModel.addElement(vcatMemberTableData.memberNumber);
            }
            this.memberCB.setSelectedIndex(0);
            this.curRowIndex = -1;
            this.fillInIncludesAndExcludes(0);
        } else {
            this.memSelPanel.setVisible(false);
        }
        this.initBlsrDriUI();
        this.memberCB.addActionListener(this);
        if (this.db.on()) {
            this.db.println("End of enteringPane()");
            this.dbDumpIncludesExcludes();
        }
    }

    @Override
    public void leavingPane() {
        this.setVcatProtectionType(0);
        if (!this.getAbstractCktDlg().isVcatCommonFiberRouting()) {
            this.memberCB.removeActionListener(this);
            ((DefaultComboBoxModel)this.memberCB.getModel()).removeAllElements();
            this.memSelPanel.setVisible(false);
        }
        super.leavingPane();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.memberCB) {
            this.memberSelChanged(this.memberCB.getSelectedIndex());
        } else {
            NetVcatCircuit netVcatCircuit = (NetVcatCircuit)this.getAbstractCktDlg().getCircuit();
            if (netVcatCircuit.isOpenEndedVcatCircuit()) {
                int n = 0;
                if (!this.getAbstractCktDlg().isVcatCommonFiberRouting()) {
                    n = this.memberCB.getSelectedIndex();
                }
                this.dstNode = this.getAbstractCktDlg().getDestList()[n].getNodeModel();
            }
            super.actionPerformed(actionEvent);
        }
    }

    protected void memberSelChanged(int n) {
        if (this.curRowIndex != -1 && this.curRowIndex != n) {
            Integer n2 = (Integer)this.memberCB.getItemAt(this.curRowIndex);
            Integer n3 = (Integer)this.memberCB.getItemAt(n);
            if (this.olm.getSize() > 0) {
                ArrayList<Object> arrayList = new ArrayList<Object>(this.olm.getContent());
                this.includeMap.put(n2, arrayList);
                this.olm.clearAll();
            } else if (this.includeMap.containsKey(n2)) {
                this.includeMap.remove(n2);
            }
            if (!this.exclusionArrayList.isEmpty()) {
                ArrayList arrayList = new ArrayList(this.exclusionArrayList);
                this.excludeMap.put(n2, arrayList);
                this.exclusionArrayList.clear();
                this.exclusionListModel.clear();
            } else if (this.excludeMap.containsKey(n2)) {
                this.excludeMap.remove(n2);
            }
            if (n == -1) {
                return;
            }
            this.fillInIncludesAndExcludes(n);
        }
    }

    private void fillInIncludesAndExcludes(int n) {
        ArrayList arrayList;
        String string;
        MapLink mapLink;
        Integer n2 = (Integer)this.memberCB.getItemAt(n);
        this.unSetNode();
        this.unSetLink();
        this.setVcatProtectionType(n);
        if (this.getAbstractCktDlg().getCircuitInfo().isOVcat() && !this.getAbstractCktDlg().isVcatCommonFiberRouting()) {
            this.cleanup(n);
        } else if (this.getAbstractCktDlg().getCircuitInfo().isOVcat() && this.getAbstractCktDlg().isVcatCommonFiberRouting()) {
            this.cleanup(0);
        } else {
            this.cleanup();
        }
        ArrayList arrayList2 = (ArrayList)this.includeMap.get(n2);
        if (arrayList2 != null) {
            for (RoutingConstraint routingConstraint : arrayList2) {
                if (routingConstraint.isElemConstraint()) {
                    this.addRoutingConstraintToOlm(routingConstraint, routingConstraint.getLabel());
                    continue;
                }
                if (!routingConstraint.isLinkConstraint()) continue;
                ArrayList arrayList3 = routingConstraint.getLinkConstraintList();
                this.addRoutingConstraintToOlm(routingConstraint, routingConstraint.getLabel());
                for (int i = 0; i < arrayList3.size(); ++i) {
                    Object e = arrayList3.get(i);
                    mapLink = this.getMapLink((INetLink)e);
                    if (routingConstraint.arrowType == 2) {
                        mapLink.reverseArrow();
                    }
                    string = this.circuitMap.getLinkDesc(mapLink);
                }
            }
        }
        if ((arrayList = (ArrayList)this.excludeMap.get(n2)) != null) {
            for (Object e : arrayList) {
                if (e instanceof INetElement) {
                    string = ((INetElement)e).getNodeModel().getName();
                    this.exclusionArrayList.add(e);
                    this.exclusionListModel.addElement(string);
                    continue;
                }
                if (!(e instanceof INetLink)) continue;
                mapLink = this.getMapLink((INetLink)e);
                string = this.circuitMap.getLinkDesc(mapLink);
                this.exclusionArrayList.add(e);
                this.exclusionListModel.addElement(string);
            }
        }
        this.addButton.setEnabled(false);
        this.exclusionButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.curRowIndex = n;
        this.initBlsrDriUI();
        this.mapConstraints();
    }

    @Override
    public void validatePage() throws Exception {
        if (!this.getAbstractCktDlg().isVcatCommonFiberRouting()) {
            Integer n = (Integer)this.memberCB.getItemAt(this.curRowIndex);
            if (this.olm.getSize() > 0) {
                ArrayList<Object> arrayList = new ArrayList<Object>(this.olm.getContent());
                this.includeMap.put(n, arrayList);
                this.olm.clearAll();
            } else if (this.includeMap.containsKey(n)) {
                this.includeMap.remove(n);
            }
            if (!this.exclusionArrayList.isEmpty()) {
                ArrayList arrayList = new ArrayList(this.exclusionArrayList);
                this.excludeMap.put(n, arrayList);
                this.exclusionArrayList.clear();
                this.exclusionListModel.clear();
            } else if (this.excludeMap.containsKey(n)) {
                this.excludeMap.remove(n);
            }
            this.storeVcatRoutePrefs();
            if (this.bIsBlsrDriCkt) {
                this.validateUpsrReversion();
            }
            this.addOrRouteNewCircuit();
            this.storeStatusText();
            if (this.db.on()) {
                this.db.println("post store text: dumping includes/excludes");
                this.dbDumpIncludesExcludes();
            }
        } else {
            super.validatePage();
        }
    }

    private void dbDumpIncludesExcludes() {
        int n;
        List list;
        for (Integer n2 : this.excludeMap.keySet()) {
            this.db.println("Excludes, Member #: " + n2);
            list = (List)this.excludeMap.get(n2);
            for (n = 0; n < list.size(); ++n) {
                this.db.println(n + "\t" + list.get(n));
            }
        }
        for (Integer n2 : this.includeMap.keySet()) {
            this.db.println("Includes, Member #: " + n2);
            list = (List)this.includeMap.get(n2);
            for (n = 0; n < list.size(); ++n) {
                this.db.println(n + "\t" + list.get(n));
            }
        }
    }

    void storeVcatRoutePrefs() throws Exception {
        this.clearAllVcatRoutePrefConstraints(this.getAbstractCktDlg().getRoutePrefs());
        int n = this.memberCB.getItemCount();
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)this.memberCB.getItemAt(i);
            ArrayList arrayList = (ArrayList)this.includeMap.get(n2);
            ArrayList arrayList2 = (ArrayList)this.excludeMap.get(n2);
            MemberPrefs memberPrefs = this.getMemberPref(this.getAbstractCktDlg().getRoutePrefs(), n2);
            if (memberPrefs != null) {
                try {
                    this.storeRoutePrefs(n2, memberPrefs, arrayList, arrayList2);
                    continue;
                }
                catch (ObjDuplicate objDuplicate) {
                    this.clearAllVcatRoutePrefConstraints(this.getAbstractCktDlg().getRoutePrefs());
                    int n3 = this.getMemProtectionType(n2);
                    if (n3 == 6 || n3 == 0) {
                        String string = "Ensure that the constraints only apply to the working path of the protected circuit.\n";
                        throw new AnnotatedException(string, (Exception)((Object)objDuplicate));
                    }
                    String string = "A route cannot be found that conforms to the set of constraints. \nPlease verfiy your constraint list.\n";
                    throw new AnnotatedException(string, (Exception)((Object)objDuplicate));
                }
            }
            this.db.println("storeVcatRoutePrefs(): memberPrefs not found for member id : " + n2 + "this should not happen");
        }
    }

    void clearAllVcatRoutePrefConstraints(RoutePrefs routePrefs) {
        LinkedList linkedList = routePrefs.getFwdDropPrefs().getMemberGroupPrefs();
        LinkedList linkedList2 = new LinkedList();
        if (linkedList == null) {
            return;
        }
        for (MemberGroupPrefs memberGroupPrefs : linkedList) {
            MemberPrefs memberPrefs;
            block6: {
                memberPrefs = memberGroupPrefs.getMemberPrefs();
                try {
                    memberPrefs.setReqEntityList(linkedList2);
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block6;
                    WzDiagDebug.printStackTrace((Throwable)exception);
                }
            }
            try {
                memberPrefs.setExcEntityList(linkedList2);
            }
            catch (Exception exception) {
                if (!this.db.on()) continue;
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    public void removeListeners() {
        if (this.memberCB != null) {
            this.memberCB.removeActionListener(this);
        }
        super.removeListeners();
    }

    protected MemberPrefs getMemberPref(RoutePrefs routePrefs, int n) {
        MemberPrefs memberPrefs = null;
        LinkedList linkedList = routePrefs.getFwdDropPrefs().getMemberGroupPrefs();
        if (linkedList == null) {
            return memberPrefs;
        }
        for (MemberGroupPrefs memberGroupPrefs : linkedList) {
            memberPrefs = memberGroupPrefs.getMemberPrefs();
            if (memberPrefs.getMemberId() != n) continue;
            return memberPrefs;
        }
        return memberPrefs;
    }

    protected void initBlsrDriUI() {
        boolean bl = this.useDRI() && (this.getAbstractCktDlg().getCircuit().getCircuitTypeObj().isHoCircuitType() || this.getAbstractCktDlg().getCircuit().getCircuitTypeObj().isHoVcatCircuitType());
        this.blsrDriButton.setVisible(bl);
    }

    @Override
    protected boolean useDRI() {
        boolean bl;
        block4: {
            bl = false;
            if (this.getAbstractCktDlg().isVcatCommonFiberRouting()) {
                return bl;
            }
            try {
                VcatMemberTableData vcatMemberTableData = (VcatMemberTableData)this.membersTableModel.tabData.get(this.curRowIndex);
                if (vcatMemberTableData.protectionType == 5) {
                    bl = true;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!this.db.on()) break block4;
                WzDiagDebug.printStackTrace((Throwable)indexOutOfBoundsException);
            }
        }
        return bl;
    }

    @Override
    protected JComponent getStatusComponent() {
        Serializable serializable2;
        if (this.getAbstractCktDlg().isVcatCommonFiberRouting()) {
            return super.getStatusComponent();
        }
        WzStatusPanel wzStatusPanel = new WzStatusPanel(false);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Serializable serializable2 : this.includeMap.keySet()) {
            if (arrayList.contains(serializable2)) continue;
            arrayList.add((Integer)serializable2);
        }
        for (Serializable serializable2 : this.excludeMap.keySet()) {
            if (arrayList.contains(serializable2)) continue;
            arrayList.add((Integer)serializable2);
        }
        Collections.sort(arrayList);
        if (arrayList.isEmpty()) {
            wzStatusPanel.push(new JLabel("No constraints for any member circuits specified."), null, true);
            return wzStatusPanel;
        }
        wzStatusPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        serializable2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        int n = 0;
        while (n < arrayList.size()) {
            GridPanel gridPanel;
            GridPanel gridPanel2;
            JLabel jLabel;
            JPanel jPanel2;
            ArrayList<GridPanel> arrayList2;
            WzStatusPanel wzStatusPanel2 = new WzStatusPanel(false);
            Integer n2 = (Integer)arrayList.get(n);
            JLabel jLabel2 = new JLabel("Constraints For Member " + n2);
            wzStatusPanel2.push(jLabel2, null, true);
            List list = (List)this.includeMap.get(n2);
            if (list != null && list.size() > 0) {
                arrayList2 = new ArrayList<GridPanel>();
                jPanel2 = new JPanel();
                jPanel2.setLayout(new BorderLayout());
                jLabel = new JLabel();
                jLabel.setUI((LabelUI)new MultiLineLabelUI());
                jLabel.setText("Required Nodes/Links:");
                jPanel2.add((Component)jLabel, "North");
                for (int i = 0; i < list.size(); ++i) {
                    gridPanel2 = new GridPanel[]{"#" + String.valueOf(i + 1), list.get(i).toString()};
                    arrayList2.add(gridPanel2);
                }
                gridPanel = CcdVcatRouteConstraintPane.getGridPanel(arrayList2);
                jPanel2.add((Component)gridPanel, "Center");
                wzStatusPanel2.push(jPanel2, null, true);
            }
            if ((arrayList2 = (ArrayList<GridPanel>)this.excludeMap.get(n2)) != null && arrayList2.size() > 0) {
                jPanel2 = new JPanel();
                jPanel2.setLayout(new BorderLayout());
                jLabel = new JLabel();
                jLabel.setUI((LabelUI)new MultiLineLabelUI());
                jLabel.setText("Excluded Nodes/Links:");
                jPanel2.add((Component)jLabel, "North");
                gridPanel = new ArrayList();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    Object e = arrayList2.get(i);
                    String string = null;
                    if (e instanceof INetElement) {
                        string = this.getNodeModel(this.getMapNode((INetElement)e)).getName();
                    } else if (e instanceof INetLink) {
                        string = this.circuitMap.getLinkDesc(this.getMapLink((INetLink)e));
                    }
                    String[] stringArray = new String[]{"#" + String.valueOf(i + 1), string};
                    gridPanel.add(stringArray);
                }
                gridPanel2 = CcdVcatRouteConstraintPane.getGridPanel((List)gridPanel);
                jPanel2.add((Component)gridPanel2, "Center");
                wzStatusPanel2.push(jPanel2, null, true);
            }
            ((GridBagConstraints)serializable2).gridy = n++;
            jPanel.add((Component)wzStatusPanel2, serializable2);
        }
        wzStatusPanel.add((Component)jPanel, "Center");
        return wzStatusPanel;
    }

    @Override
    boolean setNode(MapNode mapNode) {
        boolean bl = true;
        INodeModel iNodeModel = null;
        NetVcatCircuit netVcatCircuit = (NetVcatCircuit)this.getAbstractCktDlg().getCircuit();
        if (netVcatCircuit.isOpenEndedVcatCircuit()) {
            int n = 0;
            if (!this.getAbstractCktDlg().isVcatCommonFiberRouting()) {
                n = this.memberCB.getSelectedIndex();
            }
            this.dstNode = this.getAbstractCktDlg().getDestList()[n].getNodeModel();
            INodeModel iNodeModel2 = null;
            INetCircuitEnd iNetCircuitEnd = this.getAbstractCktDlg().getAltDestList()[n];
            if (iNetCircuitEnd != null) {
                iNodeModel2 = iNetCircuitEnd.getNodeModel();
            }
            iNodeModel = this.getAbstractCktDlg().getAltDestNode();
            this.getAbstractCktDlg().setAltDestNode(iNodeModel2);
        }
        bl = super.setNode(mapNode);
        if (netVcatCircuit.isOpenEndedVcatCircuit()) {
            this.getAbstractCktDlg().setAltDestNode(iNodeModel);
        }
        return bl;
    }
}

