/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.INodeModel;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.SvlanCircuit;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.NetworkProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.circuits.CircuitEditTabbedView;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.VcgTableModel;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.TextPanel;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;

public class CedGeneralPane
extends NetworkProvPane
implements DocumentListener {
    private INetCircuit curCircuit;
    private JTextField nameTF;
    private JLabel primaryRoutingLabel;
    private JLabel protLabel;
    private JLabel typeLabel;
    private JLabel sizeLabel;
    private JLabel cktDir;
    private JLabel optChLabel;
    private JLabel svlanLabel;
    private VcgTableModel vcgTableModel;
    private UTable vcgTable;
    private static final SDebug db = new SDebug("CedGeneralPane");

    public CedGeneralPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        NetCircuitModel netCircuitModel = (NetCircuitModel)tabbedView.getUiModel();
        this.curCircuit = netCircuitModel.getNetCircuit();
        this.curCircuit.addObserver((Observer)((Object)this));
        boolean bl = false;
        INodeModel iNodeModel = this.curCircuit.getSrcNetElement().getNodeModel();
        if (iNodeModel != null && iNodeModel.getNeType() != null) {
            boolean bl2 = bl = iNodeModel.getNeType().indexOf("crs") > -1;
        }
        if (this.curCircuit.getDrops().size() > 0 && (iNodeModel = ((NetCircuitDropInfo)this.curCircuit.getDrops().get(0)).getNodeModel()) != null && iNodeModel.getNeType() != null) {
            bl |= iNodeModel.getNeType().indexOf("crs") > -1;
        }
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        if (this.curCircuit.getCircuitTypeObj().isVcatCircuitType()) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(3, 1));
            TextPanel textPanel = new TextPanel("Name: ", 48);
            this.nameTF = textPanel.getTextField();
            this.nameTF.getDocument().addDocumentListener(this);
            this.enableComponent(this.nameTF);
            jPanel.add(textPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(3, 2));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.add(new JLabel("Circuit Type:  "));
            this.typeLabel = new JLabel();
            jPanel3.add(this.typeLabel);
            jPanel2.add(jPanel3);
            jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.add(new JLabel("Circuit Size: "));
            this.sizeLabel = new JLabel();
            jPanel3.add(this.sizeLabel);
            jPanel2.add(jPanel3);
            jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.add(new JLabel("Protection Type:  "));
            this.protLabel = new JLabel();
            jPanel3.add(this.protLabel);
            jPanel2.add(jPanel3);
            jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            this.primaryRoutingLabel = new JLabel();
            jPanel3.add(this.primaryRoutingLabel);
            jPanel2.add(jPanel3);
            jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.add(new JLabel("VCAT Attributes: "));
            jPanel2.add(jPanel3);
            jPanel.add(jPanel2);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 0));
            this.vcgTableModel = new VcgTableModel((NetVcatCircuit)this.curCircuit);
            this.vcgTable = new UTable((TableModel)this.vcgTableModel);
            this.vcgTable.sizeColumnsToFit(-1);
            UScrollPane uScrollPane = new UScrollPane((Component)this.vcgTable);
            uScrollPane.setAlignmentY(0.0f);
            jPanel4.add((Component)uScrollPane);
            jPanel4.add(Box.createHorizontalGlue());
            jPanel.add(jPanel4);
            this.add(jPanel);
            return;
        }
        if (this.curCircuit.getCircuitType() == 16) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(2, 1));
            TextPanel textPanel = new TextPanel("Name: ", 48);
            this.nameTF = textPanel.getTextField();
            this.nameTF.getDocument().addDocumentListener(this);
            this.enableComponent(this.nameTF);
            jPanel.add(textPanel);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new GridLayout(3, 2));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 0));
            jPanel6.add(new JLabel("Circuit Type:  "));
            this.typeLabel = new JLabel();
            jPanel6.add(this.typeLabel);
            jPanel5.add(jPanel6);
            jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 0));
            jPanel6.add(new JLabel("SVLAN:  "));
            this.svlanLabel = new JLabel();
            jPanel6.add(this.svlanLabel);
            jPanel5.add(jPanel6);
            jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 0));
            jPanel6.add(new JLabel("Protection Type:  "));
            this.protLabel = new JLabel();
            jPanel6.add(this.protLabel);
            jPanel5.add(jPanel6);
            jPanel.add(jPanel5);
            this.add(jPanel);
            return;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        TextPanel textPanel = new TextPanel("Name: ", 48);
        this.nameTF = textPanel.getTextField();
        this.nameTF.getDocument().addDocumentListener(this);
        this.enableComponent(this.nameTF);
        jPanel.add(textPanel);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(5, 2));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        jPanel8.add(new JLabel("Circuit Type:  "));
        this.typeLabel = new JLabel();
        jPanel8.add(this.typeLabel);
        jPanel7.add(jPanel8);
        jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        jPanel8.add(new JLabel("Circuit Size: "));
        this.sizeLabel = new JLabel();
        jPanel8.add(this.sizeLabel);
        jPanel7.add(jPanel8);
        if (this.curCircuit.getCircuitType() == 9) {
            jPanel8 = new JPanel();
            jPanel8.setLayout(new BoxLayout(jPanel8, 0));
            jPanel8.add(new JLabel("Circuit Dir:  "));
            this.cktDir = new JLabel();
            jPanel8.add(this.cktDir);
            jPanel7.add(jPanel8);
            jPanel8 = new JPanel();
            jPanel8.setLayout(new BoxLayout(jPanel8, 0));
            jPanel8.add(new JLabel("OCHNC Wavelength:  "));
            this.optChLabel = new JLabel();
            jPanel8.add(this.optChLabel);
            jPanel7.add(jPanel8);
            jPanel8 = new JPanel();
            jPanel8.setLayout(new BoxLayout(jPanel8, 0));
            jPanel8.add(new JLabel("Protection Type:  "));
            this.protLabel = new JLabel();
            jPanel8.add(this.protLabel);
            jPanel7.add(jPanel8);
        } else if (this.curCircuit.getCircuitType() == 14) {
            jPanel8 = new JPanel();
            jPanel8.setLayout(new BoxLayout(jPanel8, 0));
            jPanel8.add(new JLabel("OCHNC Wavelength:  "));
            this.optChLabel = new JLabel();
            jPanel8.add(this.optChLabel);
            jPanel7.add(jPanel8);
            jPanel8 = new JPanel();
            jPanel8.setLayout(new BoxLayout(jPanel8, 0));
            jPanel8.add(new JLabel("Protection Type:  "));
            this.protLabel = new JLabel();
            jPanel8.add(this.protLabel);
            jPanel7.add(jPanel8);
        } else if (this.curCircuit.getCircuitType() == 15) {
            if (bl) {
                this.nameTF.setEnabled(false);
            }
            jPanel8 = new JPanel();
            jPanel8.setLayout(new BoxLayout(jPanel8, 0));
            jPanel8.add(new JLabel("OCHNC Wavelength:  "));
            this.optChLabel = new JLabel();
            jPanel8.add(this.optChLabel);
            jPanel7.add(jPanel8);
            jPanel8 = new JPanel();
            jPanel8.setLayout(new BoxLayout(jPanel8, 0));
            jPanel8.add(new JLabel("Protection Type:  "));
            this.protLabel = new JLabel();
            jPanel8.add(this.protLabel);
            jPanel7.add(jPanel8);
        } else {
            jPanel8 = new JPanel();
            jPanel8.setLayout(new BoxLayout(jPanel8, 0));
            jPanel8.add(new JLabel("Protection Type:  "));
            this.protLabel = new JLabel();
            jPanel8.add(this.protLabel);
            jPanel7.add(jPanel8);
            jPanel8 = new JPanel();
            jPanel8.setLayout(new BoxLayout(jPanel8, 0));
            this.primaryRoutingLabel = new JLabel();
            jPanel8.add(this.primaryRoutingLabel);
            jPanel7.add(jPanel8);
        }
        jPanel.add(jPanel7);
        this.add(jPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (db.on()) {
            db.println("dispose");
        }
        CedGeneralPane cedGeneralPane = this;
        synchronized (cedGeneralPane) {
            this.curCircuit.deleteObserver((Observer)((Object)this));
            this.curCircuit = null;
        }
        if (this.vcgTableModel != null) {
            this.vcgTableModel.dispose();
        }
        super.destroy();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    @Override
    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("applyChangesToModel: start");
        }
        if (this.curCircuit.isCircuitNodeInVersionUp()) {
            ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_FAIL_APPLY_CHANGES, CEMC.EID_NODE_UPGRADING_EXCEPTION.getMessage());
        } else {
            try {
                String string = this.nameTF.getText();
                if (string.contains(":")) {
                    String string2 = new String("We do not recommend that you use a colon in a circuit name.\nDo you want to continue ?");
                    if (CerentDialog.yesNoDialog((Component)((Object)this), (String)string2, (String)"Circuit Name Confirmation")) {
                        this.curCircuit.rename(string);
                    }
                } else {
                    this.curCircuit.rename(string);
                }
            }
            catch (CircuitProvError circuitProvError) {
                String string = circuitProvError.getMessage();
                string = string + ".\nIt is possible that the name " + "contains illegal characters,\nis too long, or cannot be " + "renamed in its current state.";
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_CKT_NAME_PARAM_1, (Object)string);
            }
            if (db.on()) {
                db.println("Circuit renamed to: " + this.nameTF.getText());
            }
        }
        if (db.on()) {
            db.println("applyChangesToModel: finish");
        }
    }

    @Override
    public void refreshFromModel() {
        block33: {
            if (CedGeneralPane.db.on) {
                db.println("CedGeneralPane.refreshFromModel()");
            }
            TDMTerminology tDMTerminology = CircuitMapUtil.getTDMTerminology(this.curCircuit);
            try {
                int n;
                Object object;
                this.nameTF.setText(this.curCircuit.getCircuitName());
                if (this.curCircuit.getCircuitType() == 9) {
                    this.cktDir.setText(NetworkDefaults.circuitDirectionToString(this.curCircuit.getCircuitDir()));
                } else if (this.curCircuit.getCircuitType() == 16) {
                    this.svlanLabel.setText(Integer.toString(((SvlanCircuit)this.curCircuit).getSvlan()));
                } else {
                    int n2 = this.curCircuit.getState();
                    if (n2 != 5 && n2 != 6) {
                        object = "???";
                        if (this.curCircuit.getCircuitTypeObj().isVcatCircuitType()) {
                            n = this.curCircuit.getVcatRoutingPref();
                            switch (n) {
                                case 0: {
                                    object = "N/A";
                                    break;
                                }
                                case 1: {
                                    object = "Common Fiber Route";
                                    break;
                                }
                                case 2: {
                                    object = "Split Route";
                                }
                            }
                        } else {
                            n = this.curCircuit.getDropPathProtection();
                            switch (n) {
                                case 0: {
                                    object = "Fully Protected Path";
                                    break;
                                }
                                case 1: {
                                    object = "Protected Path";
                                    break;
                                }
                                case 2: {
                                    object = "Unprotected Path";
                                    break;
                                }
                                case 3: {
                                    object = "Fully Unprotected Path";
                                    break;
                                }
                                case 4: {
                                    object = "Protection Channel Access";
                                    break;
                                }
                                case 5: {
                                    object = "Dual Ring Interconnect";
                                    break;
                                }
                                case 6: {
                                    object = "Fully Line Protected Path";
                                    break;
                                }
                                case 9: {
                                    object = "N/A";
                                }
                            }
                        }
                        if (this.primaryRoutingLabel != null) {
                            this.primaryRoutingLabel.setText("Routing Preference: " + (String)object);
                        }
                    }
                }
                if (this.optChLabel != null) {
                    this.optChLabel.setText(Wavelength.getWavelengthStringFromWavelength(this.curCircuit.getCircuitOptChannel()));
                }
                if (this.protLabel != null) {
                    this.protLabel.setText(NetworkDefaults.circuitProtTypeToString(this.curCircuit.getProtType(), tDMTerminology));
                    if (this.curCircuit.getProtType() == 15) {
                        this.protLabel.setForeground(Color.red);
                    } else {
                        this.protLabel.setForeground(Color.black);
                    }
                }
                if ((this.curCircuit.getCircuitTypeObj().isOchncType() || this.curCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) && ((OchncCircuit)this.curCircuit).isDCNCircuit()) {
                    String string = tDMTerminology.getCircuitTypeShortString(this.curCircuit.getCircuitTypeObj());
                    this.typeLabel.setText(string + " DCN");
                } else {
                    this.typeLabel.setText(tDMTerminology.getCircuitTypeString(this.curCircuit.getCircuitTypeObj()));
                }
                String string = !this.curCircuit.getCircuitTypeObj().isOchccCircuitType() ? this.curCircuit.getCircuitSizeObj().getCircuitSizeString() : OchTrailHelper.getCircuitSizeString((OchccCircuit)this.curCircuit);
                if (this.curCircuit.getCircuitTypeObj().isVcatCircuitType()) {
                    this.vcgTableModel.initModelData();
                    this.vcgTableModel.fireTableDataChanged();
                    object = (NetVcatCircuit)this.curCircuit;
                    n = ((NetVcatCircuit)object).getConfiguredForwardMemberSize();
                    string = string + "-" + n + "v";
                }
                this.sizeLabel.setText(string);
                ((CircuitEditTabbedView)this.parentTV).upsrUpdate();
            }
            catch (NullPointerException nullPointerException) {
                if (!CedGeneralPane.db.on) break block33;
                db.println("CedGeneralPane.updateInfo(): Circuit has been set to null while trying to update Pane.");
            }
        }
    }
}

