/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.NetServiceState;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.VcatNotReconfigurable;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.model.circuits.VcatMemberCktDataSource;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetVcatTermination;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.circuits.AddVcatMembersDialog;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.cms.ui.circuits.CircuitEditDialog;
import cerent.cms.ui.circuits.CircuitEditTabbedView;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.CircuitsByNameTable;
import cerent.cms.ui.circuits.CircuitsTableModel;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventMaskUtil;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CedVcatMembersPane
extends AbstractPane
implements ActionListener,
ListSelectionListener,
MouseListener {
    private CircuitEditTabbedView parent;
    private static final SDebug db = new SDebug("CedVcatMembersPane");
    private static final String EDIT_MEMBER = "Edit Member...";
    private static final String ADD_MEMBER = "Add Member...";
    private static final String DELETE_MEMBER = "Delete Member...";
    private VcatMemberCktDataSource memCktsDataSource;
    private CircuitsTableModel model;
    private ColumnRenderer[] columnRenderers = null;
    private INetCircuit ckt;
    private JButton editMemBn;
    private JButton addMemBtn;
    private JButton delMemBtn;
    private static final int MAX_RECOMMENDED_DIALOGS = 4;
    private boolean vcgReconfigurable = false;
    static final String DELETE_TITLE = "Delete Members";
    static final String PREF_DELETE_VALUE = "warnDeleteMembers";
    static final String PREF_DELETE_DESCR = "VCAT: Deleting members changes the circuit size";
    static final String FULLY_DELETE_WARN_MSG = "Deleting members changes the circuit size.";

    public CedVcatMembersPane(String string, CircuitEditTabbedView circuitEditTabbedView) {
        super(string, circuitEditTabbedView);
        this.parent = circuitEditTabbedView;
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        NetCircuitModel netCircuitModel = (NetCircuitModel)circuitEditTabbedView.getUiModel();
        this.ckt = netCircuitModel.getNetCircuit();
        this.memCktsDataSource = new VcatMemberCktDataSource(this.ckt);
        this.columnRenderers = CircuitColumnRenderer.createTableRenderers(1);
        this.model = new CircuitsTableModel((RowDataSource)this.memCktsDataSource, this.columnRenderers, INetCircuit.class);
        this.table = new CircuitsByNameTable(this.model);
        this.table.addMouseListener(this);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.editMemBn = new JButton(EDIT_MEMBER);
        this.editMemBn.addActionListener(this);
        this.editMemBn.setEnabled(false);
        this.addMemBtn = new JButton(ADD_MEMBER);
        this.addMemBtn.addActionListener(this);
        this.enableComponent(this.addMemBtn);
        this.delMemBtn = new JButton(DELETE_MEMBER);
        this.delMemBtn.addActionListener(this);
        this.delMemBtn.setEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.add(this.editMemBn);
        jPanel.add(this.addMemBtn);
        jPanel.add(this.delMemBtn);
        this.add(jPanel, "South");
    }

    @Override
    public void refresh() {
        if (CedVcatMembersPane.db.on) {
            db.println("refresh");
        }
    }

    @Override
    public void leavingPage() throws Exception {
        this.memCktsDataSource.setEnabled(false);
    }

    @Override
    public void destroy() {
        if (this.memCktsDataSource != null) {
            this.memCktsDataSource.dispose();
        }
        super.destroy();
    }

    @Override
    public void enteringPage() throws Exception {
        this.memCktsDataSource.setEnabled(true);
        this.addMemBtn.setEnabled(false);
        this.delMemBtn.setEnabled(false);
        NetVcatCircuit netVcatCircuit = (NetVcatCircuit)this.ckt;
        INetVcatTermination iNetVcatTermination = null;
        this.vcgReconfigurable = true;
        if (!this.vcgReconfigurable) {
            return;
        }
        List list = netVcatCircuit.getAllVcatTerms();
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && this.vcgReconfigurable) {
            iNetVcatTermination = (INetVcatTermination)iterator.next();
            try {
                iNetVcatTermination.getNumOfNewMembersAllowed();
                this.vcgReconfigurable = true;
            }
            catch (VcatNotReconfigurable vcatNotReconfigurable) {
                this.vcgReconfigurable = false;
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)vcatNotReconfigurable);
            }
        }
        if (this.vcgReconfigurable) {
            int n = netVcatCircuit.getState();
            int n2 = netVcatCircuit.getAllMemberCircuits().size();
            if (n == 1 || n == 5 || n2 == 0) {
                this.enableComponent(this.addMemBtn);
            }
        }
        this.syncButtons();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        boolean bl;
        if (actionEvent.getSource() == this.editMemBn) {
            this.editSelectedCircuits(this.getSelectedCircuits());
        }
        if (actionEvent.getSource() == this.delMemBtn) {
            Object object2;
            bl = true;
            object = this.getSelectedCircuits();
            int[] nArray = ((NetVcatCircuit)this.ckt).memberDeleteCheck((INetCircuit[])object);
            Object object3 = null;
            if (nArray != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    object3 = object[nArray[i]];
                    if (object3.getState() != 8) continue;
                    String string = object[nArray[i]].getCircuitName();
                    bl = false;
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BRIDGE_AND_ROLL_CANNOT_DELETE_CIRCUIT_PARAM_1, (Object)string);
                }
            } else if (((NetVcatCircuit)this.ckt).requireForceDeletion(this.getSelectedCircuits())) {
                String string = NetServiceState.getServiceStateStringFromServiceState(0);
                object2 = NetServiceState.getServiceStateStringFromServiceState(1);
                String string2 = CircuitMapUtil.getTDMTerminology(this.ckt).getTermForAdminState(4);
                bl = CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)("Deleting " + string + " or " + (String)object2 + " VCAT members \n" + "will affect the service of entire circuit for\n" + "a certain period of time. \n\n" + (this.isVcatTermLCAS() ? "To avoid traffic loss, place the VCAT members\nin the " + string2 + " state before you delete them.\n\n" : "") + "Is it OK to continue with the VCAT member deletion?"), (String)DELETE_TITLE, (int)1);
            }
            if (bl) {
                INetCircuit[] iNetCircuitArray;
                INetCircuitEnd iNetCircuitEnd2;
                List list = this.ckt.getDrops();
                object2 = this.ckt.getSources();
                boolean bl2 = false;
                for (INetCircuitEnd iNetCircuitEnd2 : list) {
                    try {
                        if (((NetCircuitDropInfo)iNetCircuitEnd2).getEntityModel().getModuleModel().getEqType() != 283 && ((NetCircuitDropInfo)iNetCircuitEnd2).getEntityModel().getModuleModel().getEqType() != 284) continue;
                        bl2 = true;
                        break;
                    }
                    catch (ObjNotFound objNotFound) {
                        if (!db.on()) continue;
                        SDebug.printStackTrace((Throwable)objNotFound);
                    }
                }
                if (!bl2) {
                    iNetCircuitArray = object2.iterator();
                    while (iNetCircuitArray.hasNext()) {
                        iNetCircuitEnd2 = (NetCircuitEnd)iNetCircuitArray.next();
                        try {
                            if (((NetCircuitEnd)iNetCircuitEnd2).getEntityModel().getModuleModel().getEqType() != 283 && ((NetCircuitEnd)iNetCircuitEnd2).getEntityModel().getModuleModel().getEqType() != 284) continue;
                            bl2 = true;
                        }
                        catch (ObjNotFound objNotFound) {
                            if (!db.on()) continue;
                            SDebug.printStackTrace((Throwable)objNotFound);
                        }
                    }
                }
                iNetCircuitArray = this.getSelectedCircuits();
                if (bl2) {
                    if (iNetCircuitArray.length > 9 && this.ckt.getCircuitSize() == 1) {
                        iNetCircuitEnd2 = new String[]{"10", "STS-1"};
                        ErrorMsg.displayError((Component)this.getParent(), (EID)NEMC.EID_CEMR_MEMBER_DELETION, (Object[])iNetCircuitEnd2);
                        return;
                    }
                    if (iNetCircuitArray.length > 3 && this.ckt.getCircuitSize() == 2) {
                        iNetCircuitEnd2 = new String[]{"4", "STS-3c"};
                        ErrorMsg.displayError((Component)this.getParent(), (EID)NEMC.EID_CEMR_MEMBER_DELETION, (Object[])iNetCircuitEnd2);
                        return;
                    }
                    if (iNetCircuitArray.length > 9 && this.ckt.getCircuitSize() == 0) {
                        iNetCircuitEnd2 = new String[]{"10", "VT1.5"};
                        ErrorMsg.displayError((Component)this.getParent(), (EID)NEMC.EID_CEMR_MEMBER_DELETION, (Object[])iNetCircuitEnd2);
                        return;
                    }
                    if (iNetCircuitArray.length > 4 && this.ckt.getCircuitSize() == 12) {
                        iNetCircuitEnd2 = new String[]{"5", "VC4"};
                        ErrorMsg.displayError((Component)this.getParent(), (EID)NEMC.EID_CEMR_MEMBER_DELETION, (Object[])iNetCircuitEnd2);
                        return;
                    }
                    if (iNetCircuitArray.length > 4 && this.ckt.getCircuitSize() == 11) {
                        iNetCircuitEnd2 = new String[]{"5", "VC3"};
                        ErrorMsg.displayError((Component)this.getParent(), (EID)NEMC.EID_CEMR_MEMBER_DELETION, (Object[])iNetCircuitEnd2);
                        return;
                    }
                    if (iNetCircuitArray.length > 29 && this.ckt.getCircuitSize() == 10) {
                        iNetCircuitEnd2 = new String[]{"30", "VC12"};
                        ErrorMsg.displayError((Component)this.getParent(), (EID)NEMC.EID_CEMR_MEMBER_DELETION, (Object[])iNetCircuitEnd2);
                        return;
                    }
                }
                IgnorableDialog.infoDialog((Component)((Object)this), (String)FULLY_DELETE_WARN_MSG, (String)DELETE_TITLE, (String)PREF_DELETE_VALUE, (String)PREF_DELETE_DESCR);
                try {
                    ((NetVcatCircuit)this.ckt).destroyMemberCkts(this.getSelectedCircuits());
                }
                catch (Exception exception) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_VCAT_MEMBER_DELETE_FAILED_PARAM_1, (Object)exception.getMessage());
                }
            }
        }
        if (actionEvent.getSource() == this.addMemBtn) {
            bl = EventMaskUtil.isCtrlShiftPressed(actionEvent);
            object = new AddVcatMembersDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), this.ckt, !bl);
            ((WzDialog)object).showModal();
        }
    }

    private boolean isVcatTermLCAS() {
        List list = ((NetVcatCircuit)this.ckt).getAllVcatTerms();
        if (list.size() == 0) {
            return false;
        }
        for (INetVcatTermination iNetVcatTermination : list) {
            if (iNetVcatTermination.getLcasMode() != 2) continue;
            return true;
        }
        return false;
    }

    protected INetCircuit[] getSelectedCircuits() {
        int[] nArray = this.table.getSelectedRows();
        INetCircuit[] iNetCircuitArray = new INetCircuit[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            iNetCircuitArray[i] = (INetCircuit)this.model.getValueAt(nArray[i], 0);
        }
        if (iNetCircuitArray.length == 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CKT_MEMBER_NOT_SELECTED);
            iNetCircuitArray = new INetCircuit[]{};
        }
        return iNetCircuitArray;
    }

    private void editSelectedCircuits(INetCircuit[] iNetCircuitArray) {
        String string;
        if (iNetCircuitArray.length > 4 && !CerentDialog.yesNoDialog((Component)((Object)this), (String)(string = "You have chosen to open " + iNetCircuitArray.length + " Edit Circuit Dialogs at once.\n" + "The recommended maximum is " + 4 + ".\n" + "Are you sure you wish to do this?"), (String)("Open " + iNetCircuitArray.length + " Edit Circuit Dialogs"))) {
            return;
        }
        for (int i = 0; i < iNetCircuitArray.length; ++i) {
            CircuitEditDialog.instance(iNetCircuitArray[i]).show();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.syncButtons();
        }
    }

    protected void syncButtons() {
        int n;
        int n2 = this.table != null ? this.table.getSelectedRowCount() : -1;
        int n3 = n = this.table != null ? this.table.getRowCount() : -1;
        if (db.on()) {
            db.println("syncButtons " + (n2 != -1 && n != -1 ? n2 + "/" + n + " (Sel/Tot)" + (n2 > n ? " !!!" : "") : "table is null"));
        }
        if (this.table != null) {
            boolean bl;
            boolean bl2 = bl = n > 0 && n2 > 0;
            if (bl) {
                this.editMemBn.setEnabled(true);
                if (this.vcgReconfigurable) {
                    this.enableComponent(this.delMemBtn);
                }
            } else {
                this.editMemBn.setEnabled(false);
                this.delMemBtn.setEnabled(false);
            }
        } else {
            this.editMemBn.setEnabled(false);
            this.delMemBtn.setEnabled(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getClickCount() == 2 && (n = this.table.rowAtPoint(mouseEvent.getPoint())) != -1) {
            this.table.setRowSelectionInterval(n, n);
            this.editSelectedCircuits(this.getSelectedCircuits());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

