/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IVlanModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.VlanStpSanityCheckFailed;
import cerent.cms.ui.NetworkProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.CcdVlanPane;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.vlan.VlanStpDialog;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CedVlanPane
extends NetworkProvPane
implements ListDataListener {
    private CcdVlanPane2 vlanPane;
    private INetCircuit ckt;
    private Frame frame;

    public CedVlanPane(String string, TabbedView tabbedView, Frame frame) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        NetCircuitModel netCircuitModel = (NetCircuitModel)tabbedView.getUiModel();
        this.ckt = netCircuitModel.getNetCircuit();
        this.ckt.addObserver((Observer)((Object)this));
        WzDiagDebug wzDiagDebug = new WzDiagDebug("FromCedVlanPane");
        this.vlanPane = new CcdVlanPane2(null, this, wzDiagDebug, string);
        this.vlanPane.revalidateData();
        this.vlanPane.addListDataListener(this);
        this.vlanPane.setEnabled(this.isUserAuthorized());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.add(this.vlanPane);
        this.add(jPanel);
        this.frame = frame;
    }

    INetCircuit getCircuit() {
        return this.ckt;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.setDirty();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.setDirty();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.setDirty();
    }

    @Override
    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("applyChangesToModel: start");
        }
        this.vlanPane.validatePage();
        if (db.on()) {
            db.println("applyChangesToModel: finish");
        }
    }

    protected void displayErrorDialog(Pane pane, Exception exception, String string) {
        Object[] objectArray;
        if (exception instanceof AnnotatedException && (objectArray = (Object[])exception).getChild() instanceof VlanStpSanityCheckFailed) {
            exception = objectArray.getChild();
        }
        if (exception instanceof VlanStpSanityCheckFailed) {
            objectArray = new String[]{"View Table", "Close"};
            String string2 = ErrorMsg.getString((EID)NEMC.EID_CKT_VLANSTP_ERROR);
            int n = CerentDialog.errorDialog((Component)((Object)this), (String)string2, (String)"VLAN/Spanning Tree Violation", (Object[])objectArray, (Object)objectArray[0]);
            if (n == 0) {
                VlanStpSanityCheckFailed vlanStpSanityCheckFailed = (VlanStpSanityCheckFailed)exception;
                IVlanModel[] iVlanModelArray = this.vlanPane.getDstVlans();
                VlanStpDialog vlanStpDialog = new VlanStpDialog(this.frame, vlanStpSanityCheckFailed.getNodeModel(), iVlanModelArray);
                vlanStpDialog.show();
            }
        } else {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)pane, (EID)NEMC.EID_ERROR_PROVISIONING_VLAN);
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel: start");
        }
        if (this.ckt == null) {
            return;
        }
        this.vlanPane.setVlanSet(Arrays.asList(this.ckt.getNetVlans()));
        if (db.on()) {
            db.println("refreshFromModel: finish");
        }
    }

    @Override
    public void destroy() {
        if (db.on()) {
            db.println("destroy:");
        }
        if (this.vlanPane != null) {
            this.vlanPane.dispose();
            this.vlanPane = null;
        }
        if (this.ckt != null) {
            this.ckt.deleteObserver((Observer)((Object)this));
            this.ckt = null;
        }
        super.destroy();
    }

    @Override
    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("enteringPage");
        }
        this.vlanPane.enteringPane();
        super.enteringPage();
    }

    @Override
    public void leavingPage() throws Exception {
        if (db.on()) {
            db.println("leavingPage");
        }
        this.vlanPane.getNextPaneName();
        super.leavingPage();
    }

    class CcdVlanPane2
    extends CcdVlanPane {
        private CedVlanPane editPane;

        public CcdVlanPane2(CircuitCreationDialog circuitCreationDialog, CedVlanPane cedVlanPane2, WzDiagDebug wzDiagDebug, String string) {
            super(circuitCreationDialog, wzDiagDebug, string);
            this.editPane = null;
            this.editPane = cedVlanPane2;
        }

        @Override
        public INetCircuit getCircuit() {
            return this.editPane.getCircuit();
        }
    }
}

