/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitType;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.TdmProtocolType;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.circuits.Autoranger;
import cerent.cms.ui.circuits.CcdWizardInfo;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.gui.IntegerDocument;
import cerent.util.gui.TextPanel;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CircuitCreationWizard
extends JDialog
implements ActionListener,
ListSelectionListener,
DocumentListener {
    private static final String VIGNETTE = "/images/CTC_dialogVignette.gif";
    private static final String PREF_PATH = "ctc.circuit.creation";
    private static final String PREF_TYPE = "type";
    private static final String NEXT = "Next>";
    private static final String CANCEL = "Cancel";
    private static final int MAX_CKT_NUM = 9999;
    private JList lstCircuitTypes;
    private DefaultListModel listModel;
    private JTextField numCktTF;
    private JCheckBox autoRangeCB;
    private JCheckBox pgCB;
    private TextPanel tp;
    private JButton nextButton;
    private JButton cancelButton;
    private IModel uiModel;
    private Frame parent;
    private CcdWizardInfo wizardInfo = new CcdWizardInfo();
    private INodeModel srcNode = null;
    private INodeModel dstNode = null;
    private boolean makeModal;
    public int circuitType;

    public CircuitCreationWizard(Frame frame, boolean bl, IModel iModel) {
        super(frame, "Circuit Creation", true);
        this.makeModal = bl;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CircuitCreationWizard.this.dispose();
            }
        });
        this.parent = frame;
        this.uiModel = iModel;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getUpperPane(), "Center");
        container.add((Component)this.getBottomPane(), "South");
        this.readCircuitPrefs();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private JPanel getRightPane() {
        JPanel jPanel = AbstractPane.createVerticalPanel(null);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = AbstractPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel("Circuit Type:");
        jLabel.setAlignmentX(0.0f);
        jLabel.setHorizontalAlignment(2);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        this.lstCircuitTypes = new JList(this.getCircuitTypeListModel());
        this.lstCircuitTypes.setAlignmentX(0.0f);
        this.lstCircuitTypes.setVisibleRowCount(10);
        this.lstCircuitTypes.setSelectionMode(0);
        this.lstCircuitTypes.addListSelectionListener(this);
        this.lstCircuitTypes.setPreferredSize(new Dimension(250, this.lstCircuitTypes.getHeight()));
        this.lstCircuitTypes.setCellRenderer(new CircuitTypeRenderer());
        jPanel2 = AbstractPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add((Component)new UScrollPane((Component)this.lstCircuitTypes));
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        this.tp = new TextPanel("Num. of circuits: ", 4);
        this.tp.setAlignmentX(0.0f);
        this.numCktTF = this.tp.getTextField();
        this.numCktTF.setDocument(new IntegerDocument(0, 9999));
        this.numCktTF.getDocument().addDocumentListener(this);
        this.numCktTF.setText("1");
        this.tp.add(Box.createHorizontalGlue());
        this.autoRangeCB = new JCheckBox("Auto-ranged");
        this.tp.add(this.autoRangeCB);
        this.autoRangeCB.addActionListener(this);
        this.autoRangeCB.setEnabled(false);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.tp);
        jPanel2 = AbstractPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        this.pgCB = new JCheckBox("For VC3 Port Grouping Only", false);
        jPanel2.add(this.pgCB);
        this.pgCB.setVisible(false);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        return jPanel;
    }

    private JPanel getLeftPane() {
        JPanel jPanel = new JPanel();
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(VIGNETTE));
        jPanel.add(new JLabel(imageIcon));
        return jPanel;
    }

    private JPanel getUpperPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getLeftPane(), "West");
        jPanel.add((Component)this.getRightPane(), "Center");
        return jPanel;
    }

    private JPanel getBottomPane() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 5, 5));
        this.nextButton = new JButton(NEXT);
        this.cancelButton = new JButton(CANCEL);
        jPanel.add(this.nextButton);
        jPanel.add(this.cancelButton);
        jPanel.add(new CSHelpButton(NetCSHelpConst.CircuitCreationWizard));
        this.nextButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        return jPanel;
    }

    private void readCircuitPrefs() {
        Preferences preferences = Preferences.instance();
        int n = CircuitType.UNDEFINED_TYPE;
        try {
            n = preferences.getInt(PREF_PATH, PREF_TYPE, n);
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
        if (n != CircuitType.UNDEFINED_TYPE) {
            for (int i = 0; i < this.lstCircuitTypes.getModel().getSize(); ++i) {
                ICircuitType iCircuitType = (ICircuitType)this.lstCircuitTypes.getModel().getElementAt(i);
                if (iCircuitType.getEnum() != n) continue;
                this.lstCircuitTypes.setSelectedIndex(i);
                break;
            }
        }
        if (this.lstCircuitTypes.getModel().getSize() > 0 && this.lstCircuitTypes.getSelectedIndex() == -1) {
            this.lstCircuitTypes.setSelectedIndex(0);
        }
    }

    private void writeCircuitPrefs() {
        if (this.lstCircuitTypes.getSelectedIndex() == -1) {
            return;
        }
        Preferences preferences = Preferences.instance();
        ICircuitType iCircuitType = (ICircuitType)this.lstCircuitTypes.getSelectedValue();
        preferences.setInt(PREF_PATH, PREF_TYPE, iCircuitType.getEnum());
    }

    protected static ArrayList getNetSupportedCktTypes() {
        ICircuitType[] iCircuitTypeArray;
        ITdmProtocolType iTdmProtocolType;
        Network network = Network.instance();
        List list = network.getNetElemsWithTdmProtocolType(0);
        List list2 = network.getNetElemsWithTdmProtocolType(1);
        ArrayList<ICircuitType> arrayList = new ArrayList<ICircuitType>();
        if (list.size() > 0) {
            iTdmProtocolType = TdmProtocolType.getTdmProtocolType((int)0);
            iCircuitTypeArray = iTdmProtocolType.getSupportedCircuitTypes();
            arrayList.addAll(Arrays.asList(iCircuitTypeArray));
        }
        if (list2.size() > 0) {
            iTdmProtocolType = TdmProtocolType.getTdmProtocolType((int)1);
            iCircuitTypeArray = iTdmProtocolType.getSupportedCircuitTypes();
            arrayList.addAll(arrayList.size(), Arrays.asList(iCircuitTypeArray));
        }
        arrayList.add(CircuitType.getCircuitType((int)9));
        arrayList.add(CircuitType.getCircuitType((int)15));
        arrayList.add(CircuitType.getCircuitType((int)14));
        return arrayList;
    }

    private DefaultListModel getCircuitTypeListModel() {
        this.listModel = new DefaultListModel();
        Iterator iterator = CircuitCreationWizard.getNetSupportedCktTypes().iterator();
        while (iterator.hasNext()) {
            this.listModel.addElement(iterator.next());
        }
        return this.listModel;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ICircuitType iCircuitType = (ICircuitType)this.lstCircuitTypes.getSelectedValue();
        if (iCircuitType != null) {
            if (Autoranger.autorangeSupported(iCircuitType.getEnum())) {
                this.tp.setVisible(true);
                this.autoRangeCB.setVisible(true);
            } else {
                this.numCktTF.setText("1");
                this.tp.setVisible(false);
                this.autoRangeCB.setSelected(false);
                this.autoRangeCB.setVisible(false);
            }
            if (iCircuitType.getEnum() == 6) {
                this.pgCB.setVisible(true);
            } else {
                this.pgCB.setVisible(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.nextButton) {
            this.nextButton.setEnabled(false);
            this.handleNext();
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    private void handleNext() {
        if (!this.validatePage()) {
            this.nextButton.setEnabled(true);
            return;
        }
        CircuitCreationDialog circuitCreationDialog = new CircuitCreationDialog(this, this.wizardInfo, this.parent, this.makeModal, this.uiModel);
        if (this.wizardInfo.srcNode != null) {
            circuitCreationDialog.setSourceNode(this.wizardInfo.srcNode);
        }
        if (this.wizardInfo.dstNode != null) {
            circuitCreationDialog.setDestNode(this.wizardInfo.dstNode);
        }
        this.setVisible(false);
        circuitCreationDialog.showModal();
        this.dispose();
    }

    private boolean validatePage() {
        int n;
        try {
            n = Integer.parseInt(this.numCktTF.getText());
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CKT_CREATE_NUMBER_ERROR);
            return false;
        }
        if (n < 1) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CKT_CREATE_NUMBER_ERROR);
            return false;
        }
        if (this.lstCircuitTypes.getSelectedIndex() == -1) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CKT_CREATE_TYPE_NOT_SELECTED);
            return false;
        }
        this.wizardInfo.srcNode = this.srcNode;
        this.wizardInfo.dstNode = this.dstNode;
        this.wizardInfo.circuitType = ((ICircuitType)this.lstCircuitTypes.getSelectedValue()).getEnum();
        this.wizardInfo.numCircuits = n;
        this.wizardInfo.autoRange = this.autoRangeCB.isVisible() && this.autoRangeCB.isSelected();
        this.wizardInfo.portGrouping = this.pgCB.isVisible() && this.pgCB.isSelected();
        this.writeCircuitPrefs();
        return true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    private boolean isAutoRoutingAllowed() {
        int n;
        String[] stringArray = new String[]{"CTC.circuits.AutoRoute", "CTC.circuits.RouteAutomatically", "CTC.circuits.RouteAutomaticallyDefaultOverridable"};
        INodeModel iNodeModel = NetworkModel.instance().getCmsHostModel();
        for (n = 0; n < stringArray.length; ++n) {
            try {
                stringArray[n] = iNodeModel.getDefaultValue(stringArray[n]);
                continue;
            }
            catch (Exception exception) {
                stringArray[n] = "";
            }
        }
        n = (stringArray[1].equalsIgnoreCase("") ? stringArray[0].equalsIgnoreCase("true") : stringArray[1].equalsIgnoreCase("true")) ? 1 : 0;
        boolean bl = stringArray[2].equalsIgnoreCase("true");
        return n != 0 || bl;
    }

    private void documentModified(DocumentEvent documentEvent) {
        if (this.autoRangeCB == null) {
            return;
        }
        try {
            int n = Integer.parseInt(this.numCktTF.getText());
            if (n > 1 && this.isAutoRoutingAllowed()) {
                this.autoRangeCB.setEnabled(true);
                this.autoRangeCB.setSelected(true);
            } else {
                this.autoRangeCB.setEnabled(false);
                this.autoRangeCB.setSelected(false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.autoRangeCB.setEnabled(false);
            this.autoRangeCB.setSelected(false);
        }
    }

    public void showAgain() {
        this.nextButton.setEnabled(true);
        this.setVisible(true);
    }

    @Override
    public void dispose() {
        this.uiModel = null;
        super.dispose();
    }

    public void setSourceNode(INodeModel iNodeModel) {
        this.srcNode = iNodeModel;
    }

    public void setDestNode(INodeModel iNodeModel) {
        this.dstNode = iNodeModel;
    }

    class CircuitTypeRenderer
    extends DefaultListCellRenderer {
        DefaultListCellRenderer renderer = new DefaultListCellRenderer();

        CircuitTypeRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.renderer = (DefaultListCellRenderer)this.renderer.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                this.renderer.setText(((CircuitType)object).getProtocolIndepCktTypeStr());
            }
            return this.renderer;
        }
    }
}

