/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.circuits.CircuitFilter;
import cerent.cms.model.circuits.CircuitFilterCriteria;
import cerent.cms.ui.circuits.CircuitFilterAdvancedPane;
import cerent.cms.ui.circuits.CircuitFilterDialog;
import cerent.cms.ui.circuits.CircuitFilterGeneralPane;
import cerent.cms.ui.circuits.CircuitsPane;
import cerent.util.SDebug;
import cerent.util.gui.AbstractPropertySheet;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

class CircuitFilterPropertySheet
extends AbstractPropertySheet {
    private CircuitsPane parent = null;
    private CircuitFilter circuitFilter;
    private CircuitFilterCriteria filterCriteria;
    private CircuitFilterGeneralPane generalPane;
    private CircuitFilterAdvancedPane advancedPane;
    protected JButton restoreDefaultsButton;
    protected ActionListener restoreDefaultsListener;

    public CircuitFilterPropertySheet(CircuitsPane circuitsPane, CircuitFilterDialog circuitFilterDialog, CircuitFilter circuitFilter) {
        super((Window)((Object)circuitFilterDialog), true);
        this.parent = circuitsPane;
        this.circuitFilter = circuitFilter;
        this.onInitialUpdate();
    }

    public void onInitialUpdate() {
        this.filterCriteria = this.circuitFilter.getFilterCriteria();
        this.generalPane = new CircuitFilterGeneralPane("General", this.parent, this, this.filterCriteria);
        this.addPane(this.generalPane);
        this.advancedPane = new CircuitFilterAdvancedPane("Advanced", this.parent, this, this.filterCriteria);
        this.addPane(this.advancedPane);
        this.restoreDefaultsButton = new JButton("Restore Defaults");
        this.buttonPane.add((Component)this.restoreDefaultsButton, "West");
        this.restoreDefaultsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CircuitFilterPropertySheet.this.onRestoreDefaults();
            }
        };
        this.restoreDefaultsButton.addActionListener(this.restoreDefaultsListener);
        super.removeApply();
    }

    public void onRestoreDefaults() {
        this.generalPane.restoreDefaults();
        this.advancedPane.restoreDefaults();
    }

    @Override
    public boolean onValidate() {
        return this.generalPane.onValidate() && this.advancedPane.onValidate() && super.onValidate();
    }

    @Override
    public void onApply() {
        try {
            this.generalPane.store();
            this.advancedPane.store();
            this.filterCriteria.saveCriteriaPreferences();
            this.filterCriteria.filterCriteriaChanged();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public void dispose() {
        this.restoreDefaultsButton.removeActionListener(this.restoreDefaultsListener);
        this.generalPane.dispose();
        this.advancedPane.dispose();
        this.restoreDefaultsButton = null;
        this.restoreDefaultsListener = null;
        this.parent = null;
        this.filterCriteria = null;
        this.circuitFilter = null;
        this.generalPane = null;
        this.advancedPane = null;
    }
}

