/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitMergeManager;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NotFullyMerged;
import cerent.cms.ui.circuits.CedMergePane;
import cerent.util.EID;
import cerent.util.NEMC;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.gui.ProgressDialog;
import cerent.util.gui.ProgressDialogControl;
import cerent.util.gui.ProgressDialogResult;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observer;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class CircuitMergeDialog
extends JDialog
implements ProgressDialogControl {
    private static final SDebug db = new SDebug("CircuitMergeDialog");
    private CircuitMergeManager mergeManager = CircuitMergeManager.instance();
    private List circuitsToMerge = new ArrayList();
    private int mergeOperation;
    private CircuitMergeManager.MergeResult mergeResult;
    private boolean needLooseMerge;
    private Component parent;

    public CircuitMergeDialog(Component component, List list, int n) {
        super(JOptionPane.getFrameForComponent(component), CircuitMergeDialog.getOperationString(n) + " Dialog", true);
        this.parent = component;
        this.init(list, n);
        this.startMerge();
    }

    private void init(List list, int n) {
        this.circuitsToMerge.clear();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.circuitsToMerge.add((INetCircuit)iterator.next());
        }
        this.mergeOperation = n;
    }

    private void startMerge() {
        this.mergeManager.init(this.circuitsToMerge, this.mergeOperation);
        ProgressDialog.start(this, CircuitMergeDialog.getOperationString(this.mergeOperation), CircuitMergeDialog.getWaitString(this.mergeOperation), this, 2000, 20, false);
    }

    public void executeTask(Observer observer) throws Exception {
        observer.update(null, CircuitMergeDialog.getWaitString(this.mergeOperation));
        this.mergeResult = this.mergeManager.mergeCircuits();
    }

    public String getResultString(Exception exception) {
        throw new DeprecatedMethodCalled("ProgressDialogControl.getResultString(Exception)");
    }

    public ProgressDialogResult getResult(Exception exception) {
        ProgressDialogResult progressDialogResult = null;
        if (exception == null) {
            if (this.mergeOperation == 1) {
                if (this.mergeResult.validCircuitsAfterMerge.size() > 1) {
                    progressDialogResult = new ProgressDialogResult(1, (EID)NEMC.WID_SLAVE_CIRCUITS_REMAINED_AFTER_MERGE);
                }
            } else if (this.mergeOperation == 2) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = this.circuitsToMerge.size();
                int n2 = this.mergeResult.changedCircuitNum;
                int n3 = this.mergeResult.addedCircuitNum;
                int n4 = this.mergeResult.deletedCircuitNum;
                if (n2 > 0) {
                    stringBuffer.append("  [" + n2 + " " + PluralisationUtil.s("circuit", n2) + " " + "changed]");
                }
                if (n3 > 0) {
                    stringBuffer.append((stringBuffer.length() > 0 ? "\n" : "") + "  [" + n3 + " " + PluralisationUtil.s("circuit", n3) + " " + "added]");
                }
                if (n4 > 0) {
                    stringBuffer.append((stringBuffer.length() > 0 ? "\n" : "") + "  [" + n4 + " " + PluralisationUtil.s("circuit", n4) + " " + "deleted]");
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.insert(0, n + " " + PluralisationUtil.s("circuit", n) + " " + PluralisationUtil.s("was", n) + " selected:\n");
                } else {
                    stringBuffer.append("None of the " + n + " selected " + PluralisationUtil.s("circuit", n) + " " + PluralisationUtil.s("was", n) + " reconfigured.");
                }
                progressDialogResult = new ProgressDialogResult(stringBuffer.toString());
            }
        } else {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            if (this.mergeOperation == 0 && exception instanceof NotFullyMerged) {
                this.needLooseMerge = true;
            } else {
                progressDialogResult = this.mergeOperation == 2 ? new ProgressDialogResult(2, NEMC.EID_ERROR_RECONFIGURE_CIRCUITS_PARAM_1, new String[]{exception.getMessage()}) : new ProgressDialogResult(2, NEMC.EID_ERROR_MERGE_CIRCUITS_PARAM_1, new String[]{exception.getMessage()});
            }
        }
        if (this.parent instanceof CedMergePane) {
            ((CedMergePane)((Object)this.parent)).mergeProcessFinished();
        }
        return progressDialogResult;
    }

    protected boolean needLooseMerge() {
        return this.needLooseMerge;
    }

    private static String getOperationString(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return "Merge Circuits";
            }
            case 2: {
                return "Reconfigure Circuits";
            }
        }
        throw new IllegalArgumentException("The operation type is unknown.");
    }

    private static String getWaitString(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return "Circuits are being merged. Please wait...";
            }
            case 2: {
                return "Circuits are being reconfigured. Please wait...";
            }
        }
        throw new IllegalArgumentException("The operation type is unknown.");
    }

    public void stop() {
    }

    public boolean stopRequired() {
        return false;
    }

    public void suspend() {
    }

    public void resume() {
    }
}

