/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.ncp.INetCircuit;
import cerent.cms.ui.circuits.ByNameTable;
import cerent.cms.ui.circuits.CircuitsTableModel;
import cerent.util.SDebug;
import javax.swing.event.TableModelEvent;

public class CircuitsByNameTable
extends ByNameTable {
    private CircuitsTableModel model = null;
    protected static final SDebug db = new SDebug("CircuitsByNameTable");

    public CircuitsByNameTable(CircuitsTableModel circuitsTableModel) {
        super(circuitsTableModel);
        this.model = circuitsTableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setRowHeights(TableModelEvent tableModelEvent) {
        try {
            CircuitsByNameTable circuitsByNameTable = this;
            synchronized (circuitsByNameTable) {
                this.setRowHeight(16);
                for (int i = 0; i < this.getRowCount(); ++i) {
                    INetCircuit iNetCircuit = (INetCircuit)this.getValueAt(i, 0);
                    if (iNetCircuit == null || iNetCircuit.getDrops() == null || iNetCircuit.getSources() == null) continue;
                    int n = iNetCircuit.getDrops().size();
                    int n2 = iNetCircuit.getSources().size();
                    int n3 = Math.max(n, n2);
                    if (this.model != null && this.model.spanDetailsOn()) {
                        int n4 = iNetCircuit.getCircuitSpans().size();
                        n3 = Math.max(n3, n4);
                    }
                    if (n3 == 0) continue;
                    this.setRowHeight(i, n3 * 18);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (db.on()) {
                db.println("ArrayIndexOutOfBoundsException in setRowHeights");
            }
            super.setRowHeights(tableModelEvent);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        this.selectCircuits();
    }

    protected void selectCircuits() {
    }
}

