/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.INodeModel;
import cerent.cms.ncp.INetCircuitDropInfo;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AdminStatePanel;
import cerent.cms.ui.circuits.CcdEndpointsPane;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.cms.ui.circuits.CircuitDropCreationDialog;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.IDropCreationPane;
import cerent.cms.ui.circuits.WzCcdPane;
import cerent.util.Preferences;
import cerent.util.gui.IgnorableDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DropCreationPane
extends WzCcdPane
implements ChangeListener,
Observer,
IDropCreationPane {
    private CircuitDropCreationDialog parent;
    CcdEndpointsPane newDropPane;
    private JCheckBox autoRouteCB;
    private JCheckBox UrnCB;
    private JCheckBox RrbcCB;
    private JCheckBox pathProtCB;
    private JCheckBox pcaCB;
    private JRadioButton ndRequired;
    private JRadioButton ndDesired;
    private JRadioButton ldOnly;
    private ButtonGroup nodeDiversity;
    private JComponent ndOuter;
    private Preferences prefs = Preferences.instance();
    private static final String PREF_PATH = "ctc.drop.creation";
    private static final String PREF_URN = "useRequiredNodesSpans";
    private static final String PREF_RRBC = "reviewRouteBeforeCreation";
    private static final int ENDPOINT_HEIGHT = 150;
    protected RoutePrefs routePrefs;
    protected boolean pca = false;
    protected boolean pathProt = false;
    protected boolean rrbc = false;
    protected boolean urn = false;
    protected boolean autoRoute = false;

    @Override
    public CcdEndpointsPane getDropPane() {
        return this.newDropPane;
    }

    @Override
    public RoutePrefs getRoutePrefs() {
        return this.routePrefs;
    }

    @Override
    public boolean isRrbc() {
        return this.rrbc;
    }

    @Override
    public boolean isUrn() {
        return this.urn;
    }

    @Override
    public boolean isAutoRoute() {
        return this.autoRoute;
    }

    @Override
    public boolean isPca() {
        return this.pca;
    }

    @Override
    public void setPca(boolean bl) {
        this.pca = bl;
    }

    @Override
    public boolean isPathProt() {
        return this.pathProt;
    }

    @Override
    public void setPathProt(boolean bl) {
        this.pathProt = bl;
    }

    public DropCreationPane(CircuitDropCreationDialog circuitDropCreationDialog, WzDiagDebug wzDiagDebug, String string) {
        super(circuitDropCreationDialog, wzDiagDebug, string);
        this.parent = circuitDropCreationDialog;
    }

    @Override
    protected void initPane() {
        this.setLayout(new BoxLayout(this, 0));
        Box box = Box.createVerticalBox();
        box.add(new BoundedJPanel("Main", this.getMainPanel()));
        box.add(Box.createVerticalStrut(15));
        box.add(new BoundedJPanel("State", this.getAdminStatePanel()));
        box.add(Box.createVerticalGlue());
        Box box2 = Box.createVerticalBox();
        box2.add(new BoundedJPanel("Routing", this.getRoutingPanel()));
        box2.add(Box.createVerticalStrut(15));
        box2.add(new BoundedJPanel("Protect", this.getProtectionPanel()));
        box2.add(Box.createVerticalGlue());
        this.add(box);
        this.add(Box.createHorizontalStrut(15));
        this.add(box2);
    }

    private JComponent getMainPanel() {
        this.newDropPane = new CcdEndpointsPane(this.parent, this.db, "New Drop", "Drop", false, true);
        this.newDropPane.enteringPane();
        if (this.newDropPane.getNodeCB() != null) {
            ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>();
            List list = this.parent.getCircuit().getCircuitNodes();
            for (INetCircuitNode iNetCircuitNode : list) {
                if (!CircuitMapUtil.isBlsrDriNode(iNetCircuitNode)) continue;
                arrayList.add(iNetCircuitNode.getNodeModel());
                if (!this.db.on()) continue;
                this.db.println("Intend to remove " + iNetCircuitNode.getNodeModel() + " from the list of drop choices because " + "it is a pri/sec BLSR-DRI node.");
            }
            if (arrayList.size() > 0) {
                this.newDropPane.removeNodesFromNodeList(arrayList);
            }
            this.startObserving();
        }
        return this.newDropPane;
    }

    private JComponent getAdminStatePanel() {
        this.parent.adminStatePanel = new AdminStatePanel("Circuit State", "Note: Circuit state operations apply to the \nentire circuit.\n", this.parent.getCircuit(), true, true);
        return this.parent.adminStatePanel;
    }

    private JComponent getProtectionPanel() {
        this.pathProtCB = new JCheckBox("Fully Protected Path", this.getDropProtectionDefault());
        this.pathProtCB.addChangeListener(this);
        this.pcaCB = new JCheckBox("Protection Channel Access");
        this.pcaCB.addActionListener(this);
        this.ndRequired = new JRadioButton("Nodal Diversity Required");
        this.ndDesired = new JRadioButton("Nodal Diversity Desired", true);
        this.ldOnly = new JRadioButton("Link Diversity Only");
        this.nodeDiversity = new ButtonGroup();
        this.nodeDiversity.add(this.ndRequired);
        this.nodeDiversity.add(this.ndDesired);
        this.nodeDiversity.add(this.ldOnly);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)this.pathProtCB, gridBagConstraints);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(20));
        this.ndOuter = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1));
        jPanel2.add(this.ndRequired);
        jPanel2.add(this.ndDesired);
        jPanel2.add(this.ldOnly);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Node-Diverse Path"));
        this.ndOuter.add((Component)jPanel2, "North");
        this.ndOuter.add(Box.createVerticalStrut(5));
        this.ndOuter.add((Component)this.pcaCB, "South");
        box.add(this.ndOuter);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)box, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder("Protection"));
        return jPanel;
    }

    private boolean getDropProtectionDefault() {
        int n = this.parent.ckt.getDropPathProtection();
        return n == 0;
    }

    private JComponent getRoutingPanel() {
        this.autoRouteCB = new JCheckBox("Route Automatically");
        this.autoRouteCB.addChangeListener(this);
        this.UrnCB = new JCheckBox("Using Required Nodes/Spans");
        this.UrnCB.addChangeListener(this);
        this.RrbcCB = new JCheckBox("Review Route Before Creation");
        this.RrbcCB.addChangeListener(this);
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(this.UrnCB);
        jPanel.add(this.RrbcCB);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.autoRouteCB, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Routing"));
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(20));
        box.add(jPanel);
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)box, gridBagConstraints);
        return jPanel2;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.autoRouteCB) {
            if (!this.autoRouteCB.isSelected()) {
                this.UrnCB.setSelected(false);
                this.RrbcCB.setSelected(false);
            }
            this.UrnCB.setEnabled(this.autoRouteCB.isSelected());
            this.RrbcCB.setEnabled(this.autoRouteCB.isSelected());
        } else if (object == this.pathProtCB) {
            this.ndRequired.setEnabled(this.pathProtCB.isSelected());
            this.ndDesired.setEnabled(this.pathProtCB.isSelected());
            this.ldOnly.setEnabled(this.pathProtCB.isSelected());
            this.pcaCB.setEnabled(!this.pathProtCB.isSelected());
        }
        this.syncButtons();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.pcaCB && this.pcaCB.isSelected()) {
            IgnorableDialog.yesNoDialog((Component)this, (String)this.parent.getPcaWarningMsg(), (String)"Warning", (String)"warnPca", (String)"CircuitCreation: PCA Circuits are unprotected");
        }
    }

    void startObserving() {
        if (this.newDropPane != null) {
            CcdEndpointsPane.NodeChangedObservable nodeChangedObservable = this.newDropPane.nodeChangeObservable;
            nodeChangedObservable.addObserver(this);
            if (this.db.on()) {
                this.db.println("start observing the nodeChangeObservable");
            }
        }
    }

    @Override
    public void stopObserving() {
        if (this.newDropPane != null) {
            CcdEndpointsPane.NodeChangedObservable nodeChangedObservable = this.newDropPane.nodeChangeObservable;
            nodeChangedObservable.deleteObserver(this);
            if (this.db.on()) {
                this.db.println("stop observing the nodeChangeObservable");
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        HashSet<INodeModel> hashSet = new HashSet<INodeModel>();
        boolean bl = false;
        for (Object object2 : this.parent.getCircuit().getCircuitNodes()) {
            hashSet.add(object2.getNodeModel());
            if (bl) continue;
            bl = CircuitMapUtil.isBlsrDriNode((INetCircuitNode)object2);
        }
        boolean bl2 = false;
        if (!this.pathProtCB.isSelected()) {
            for (Object object3 : this.parent.getCircuit().getCircuitSpans()) {
                Object object4 = object3.getLink();
                if (!object4.isPca()) continue;
                bl2 = true;
                break;
            }
        }
        if (this.parent.getCircuit().getState() == 5) {
            boolean bl3 = this.parent.getCircuit().isCircuitProtected();
            this.pathProtCB.setSelected(bl3);
            this.pathProtCB.setEnabled(bl3);
        } else if (this.parent.getCircuit().getState() == 1) {
            this.pathProtCB.setSelected(0 == this.parent.getCircuit().getDropPathProtection());
            this.pathProtCB.setEnabled(false);
        }
        if (this.parent.getSourceNode() == this.newDropPane.nodeModel || hashSet.contains(this.newDropPane.nodeModel) || this.newDropPane.nodeModel == null) {
            this.autoRouteCB.setSelected(true);
            this.autoRouteCB.setEnabled(false);
            this.UrnCB.setSelected(false);
            this.UrnCB.setEnabled(false);
            this.RrbcCB.setSelected(false);
            this.RrbcCB.setEnabled(false);
            this.ndRequired.setEnabled(false);
            this.ndDesired.setEnabled(false);
            this.ldOnly.setEnabled(false);
            if (!this.pathProtCB.isSelected()) {
                this.pcaCB.setSelected(bl2);
                this.pcaCB.setEnabled(false);
            }
        } else if (this.parent.getCircuit().isUpsr1wayTl1()) {
            this.autoRouteCB.setSelected(false);
            this.autoRouteCB.setEnabled(false);
            this.UrnCB.setSelected(false);
            this.UrnCB.setEnabled(false);
            this.RrbcCB.setSelected(false);
            this.RrbcCB.setEnabled(false);
        } else if (bl && !hashSet.contains(this.newDropPane.nodeModel)) {
            this.autoRouteCB.setSelected(false);
            this.autoRouteCB.setEnabled(false);
            this.UrnCB.setSelected(false);
            this.UrnCB.setEnabled(false);
            this.RrbcCB.setSelected(false);
            this.RrbcCB.setEnabled(false);
        } else {
            this.autoRouteCB.setSelected(this.autoRoute);
            this.autoRouteCB.setEnabled(true);
            this.UrnCB.setSelected(this.prefs.getBoolean(PREF_PATH, PREF_URN, false) && this.autoRoute);
            this.RrbcCB.setSelected(this.prefs.getBoolean(PREF_PATH, PREF_RRBC, false) && this.autoRoute);
            this.UrnCB.setEnabled(this.autoRoute);
            this.RrbcCB.setEnabled(this.autoRoute);
            this.ndRequired.setEnabled(this.pathProtCB.isSelected());
            this.ndDesired.setEnabled(this.pathProtCB.isSelected());
            this.ldOnly.setEnabled(this.pathProtCB.isSelected());
            boolean bl4 = false;
            for (Object object4 : this.parent.getCircuit().getCircuitSpans()) {
                INetLink iNetLink = object4.getLink();
                if (!(iNetLink instanceof NetLink) || !((NetLink)iNetLink).inBLSR()) continue;
                bl4 = true;
                break;
            }
            this.pcaCB.setSelected(!this.pathProtCB.isSelected() && bl2);
            this.pcaCB.setEnabled(!this.pathProtCB.isSelected() && !bl2 && !bl4);
        }
        this.syncButtons();
    }

    private void syncButtons() {
        boolean bl = !this.autoRouteCB.isSelected() || this.autoRouteCB.isSelected() && (this.UrnCB.isSelected() || this.RrbcCB.isSelected());
        this.parent.setNextEnabled(bl);
        this.parent.setFinishEnabled(!bl);
    }

    void resetMainPanel() {
        this.newDropPane.reset();
        if (this.parent.getCircuit().getCircuitTypeObj().isEthernetCircuitType()) {
            ArrayList arrayList;
            try {
                arrayList = this.parent.getCircuit().getEtherAddDropCircuitNodes();
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                arrayList = new ArrayList();
            }
            ArrayList<INodeModel> arrayList2 = new ArrayList<INodeModel>(arrayList.size());
            this.db.info("Restricting node list for Ethernet:");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                INodeModel iNodeModel = ((INetCircuitNode)iterator.next()).getNodeModel();
                arrayList2.add(iNodeModel);
                this.db.fine("-> adding " + iNodeModel.getName());
            }
            this.newDropPane.setNodeList(arrayList2);
        }
        this.parent.adminStatePanel.setEnabled(this.parent.getCircuit(), true);
        this.parent.adminStatePanel.setAdminState(this.parent.getCircuit().getAdminState());
    }

    void resetRoutePanel() {
        if (this.parent.getCircuit().getProtType() == 16) {
            this.ndOuter.setVisible(false);
            this.pathProtCB.setVisible(false);
            return;
        }
        this.pathProtCB.setSelected(this.parent.getCircuit().getDropPathProtection() == 0 || this.parent.getCircuit().getDropPathProtection() == 5);
        this.pathProtCB.setEnabled(false);
    }

    @Override
    public void validatePage() throws Exception {
        this.newDropPane.validatePage();
        this.prefs.setBoolean(PREF_PATH, PREF_URN, this.UrnCB.isSelected());
        this.prefs.setBoolean(PREF_PATH, PREF_RRBC, this.RrbcCB.isSelected());
        this.autoRoute = this.autoRouteCB.isSelected();
        this.rrbc = this.RrbcCB.isSelected();
        this.urn = this.UrnCB.isSelected();
        this.pca = !this.pathProtCB.isSelected() && this.pcaCB.isSelected();
        this.routePrefs = new RoutePrefs();
        this.routePrefs.setPathProt(0);
        this.routePrefs.setDiversityOption(1);
        if (this.pathProtCB.isVisible()) {
            this.routePrefs.setPathProt(this.pathProtCB.isSelected() ? 0 : 2);
            int n = this.ndRequired.isSelected() ? 1 : (this.ndDesired.isSelected() ? 2 : 3);
            this.routePrefs.setDiversityOption(n);
            this.routePrefs.setPcaPref(this.pcaCB.isSelected());
            this.db.info("validatePage(): user selected routePrefs  pathProt=" + this.routePrefs.getPathProt() + "  diversity =" + this.routePrefs.getDiversityOption() + " pca=" + this.routePrefs.getPcaPref());
        } else {
            Iterator iterator = this.parent.getCircuit().getDrops().iterator();
            if (iterator.hasNext()) {
                this.routePrefs.setPathProt(((INetCircuitDropInfo)iterator.next()).getPathProt());
            }
            this.db.info("apply(): derived routePrefs  pathProt=" + this.routePrefs.getPathProt() + "  diversity = " + this.routePrefs.getDiversityOption() + " pca=" + this.routePrefs.getPcaPref());
        }
        this.parent.setNewCircuitEnd((INetCircuitEnd)this.newDropPane.getEndpoints().get(0));
        try {
            if (this.autoRoute && this.urn || !this.autoRoute) {
                this.parent.addDestination(false);
            } else {
                this.parent.addDestination(true);
                if (this.db.on) {
                    this.db.println("validatePage: addDestination() succeeded");
                }
            }
        }
        catch (Exception exception) {
            try {
                this.parent.deleteDestination();
            }
            catch (Exception exception2) {
                this.db.finer("validatePage: deleteDestination exception caught");
            }
            throw exception;
        }
    }

    @Override
    public void revalidateData() {
        this.syncButtons();
        this.revalidate();
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.DropCreationPane;
    }

    @Override
    protected JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{"Name: ", this.parent.getCircuit().getCircuitName()});
        INetCircuitEnd[] iNetCircuitEndArray = new INetCircuitEnd[]{this.parent.getCircuit().getPrimarySource()};
        arrayList.add(new String[]{"From: ", CircuitColumnRenderer.getEndpoints(this.parent.getCircuit(), iNetCircuitEndArray)});
        String string = this.newDropPane.getStatusText();
        int n = string.indexOf(58);
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1, string.length());
        arrayList.add(new String[]{string2, string3});
        int n2 = this.routePrefs.getPathProt();
        String string4 = "";
        String string5 = "N/A";
        if (n2 == 0) {
            string4 = "Fully Protected";
            int n3 = this.routePrefs.getDiversityOption();
            if (n3 == 1) {
                string5 = "Node-diverse";
            } else if (n3 == 3) {
                string5 = "Link-diverse";
            }
        } else if (n2 == 2) {
            string4 = "Unprotected";
        }
        if (!string4.equals("")) {
            arrayList.add(new String[]{"Protection:", string4});
        }
        if (string4.equals("Fully Protected")) {
            arrayList.add(new String[]{"Diversity:", string5});
        }
        return DropCreationPane.getGridPanel(arrayList);
    }

    @Override
    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Name: ");
        stringBuffer.append(this.parent.getCircuit().getCircuitName());
        stringBuffer.append("\n");
        INetCircuitEnd[] iNetCircuitEndArray = new INetCircuitEnd[]{this.parent.getCircuit().getPrimarySource()};
        stringBuffer.append("\nFrom: ");
        stringBuffer.append(CircuitColumnRenderer.getEndpoints(this.parent.getCircuit(), iNetCircuitEndArray));
        stringBuffer.append(this.newDropPane.getStatusText());
        stringBuffer.append("\nRouting: ");
        int n = this.routePrefs.getPathProt();
        if (n == 0) {
            stringBuffer.append(" fully protected");
            int n2 = this.routePrefs.getDiversityOption();
            if (n2 == 1) {
                stringBuffer.append("\n  Node-diverse");
            } else if (n2 == 3) {
                stringBuffer.append("\n  Link-diverse");
            }
        } else if (n == 2) {
            stringBuffer.append(" unprotected");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    public void enteringPane() {
        this.startObserving();
        super.enteringPane();
    }

    @Override
    protected String getNextPaneName() {
        if (this.urn) {
            this.stopObserving();
            return "Circuit Route Constraints";
        }
        if (this.rrbc || !this.autoRoute) {
            this.stopObserving();
            return "Route Review and Edit";
        }
        return null;
    }

    @Override
    public void removeListeners() {
        this.stopObserving();
        if (this.pathProtCB != null) {
            this.pathProtCB.removeChangeListener(this);
        }
        if (this.pcaCB != null) {
            this.pcaCB.removeActionListener(this);
        }
        if (this.autoRouteCB != null) {
            this.autoRouteCB.removeChangeListener(this);
        }
        if (this.UrnCB != null) {
            this.UrnCB.removeChangeListener(this);
        }
        if (this.RrbcCB != null) {
            this.RrbcCB.removeChangeListener(this);
        }
        super.removeListeners();
    }

    @Override
    public void dispose() {
        this.routePrefs = null;
        super.dispose();
    }

    @Override
    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("Route Prefs: " + this.routePrefs + "\n");
        stringBuffer.append("PCA: " + this.pca + "\n");
        stringBuffer.append("Path Protected: " + this.pathProt + "\n");
        stringBuffer.append("Require Review Before Creation: " + this.rrbc + "\n");
        stringBuffer.append("Use Required Nodes: " + this.urn + "\n");
        stringBuffer.append("AutoRoute: " + this.autoRoute);
        return stringBuffer.toString();
    }

    class BoundedJPanel
    extends JPanel {
        private String name;
        private final Dimension MIN_D;
        private final Dimension MAX_D;

        BoundedJPanel(String string, JComponent jComponent) {
            super(new BorderLayout());
            this.MIN_D = new Dimension(200, 150);
            this.MAX_D = new Dimension(500, 300);
            this.add(jComponent);
            this.name = string;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.MIN_D;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.MAX_D;
        }
    }
}

