/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ui.circuits.AbstractProtectedCircuitMapNode;
import cerent.cms.ui.circuits.OchccProtectedCircuitMapPort;
import cerent.cms.ui.network.CircuitMapPort;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapToolkit;

public class OchccProtectedCircuitMapNode
extends AbstractProtectedCircuitMapNode {
    private MapPort unprotectedPgPort;

    public OchccProtectedCircuitMapNode(MapToolkit mapToolkit) {
        super(mapToolkit);
    }

    @Override
    protected CircuitMapPort doCreateCircuitMapPort(DetailedMapNode detailedMapNode, MapLinkConnector mapLinkConnector, INetCircuitEnd iNetCircuitEnd) {
        INodeModel iNodeModel;
        Object object = this.getUserObject();
        if (object != null && object instanceof INodeModel && OchTrailHelper.isTrunkPort(iNodeModel = (INodeModel)object, iNetCircuitEnd.getEntityIndex()) && OchTrailHelper.isProtected(iNodeModel, iNetCircuitEnd.getEntityIndex())) {
            return new OchccProtectedCircuitMapPort(detailedMapNode, mapLinkConnector, iNetCircuitEnd.getEntityIndex());
        }
        return super.doCreateCircuitMapPort(detailedMapNode, mapLinkConnector, iNetCircuitEnd);
    }

    @Override
    public int getEntityIndex(MapPort mapPort) {
        if (mapPort instanceof OchccProtectedCircuitMapPort) {
            return ((OchccProtectedCircuitMapPort)mapPort).getTrunkIndex();
        }
        return super.getEntityIndex(mapPort);
    }

    @Override
    protected IEntityModel[] getPgPorts(INodeModel iNodeModel, int n) throws AbstractCmsNoSuchEntityException, NoSuchEquipment {
        return OchTrailHelper.getTrunkPorts(iNodeModel, n);
    }

    @Override
    protected MapPort getUnprotectedPgPort() {
        if (this.unprotectedPgPort == null) {
            MapPort[] mapPortArray = this.getPorts();
            INodeModel iNodeModel = (INodeModel)this.getUserObject();
            for (int i = 0; i < mapPortArray.length; ++i) {
                int n;
                MapPort mapPort = mapPortArray[i];
                if (mapPort instanceof OchccProtectedCircuitMapPort || !OchTrailHelper.isClientPort(iNodeModel, n = this.getEntityIndex(mapPort))) continue;
                this.unprotectedPgPort = mapPort;
                break;
            }
        }
        return this.unprotectedPgPort;
    }

    @Override
    protected int getUnprotectedSelectorSide() {
        MapPort mapPort = this.getUnprotectedPgPort();
        int n = 0;
        if (mapPort != null) {
            int n2 = mapPort.getSide();
            n = n2 == 2 ? 14 : (n2 == 1 ? 15 : (n2 == -2 ? 13 : 16));
        }
        return n;
    }
}

