/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.OchncHelper;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.util.EID;
import cerent.util.KErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class OchncLinesPanel
extends JPanel {
    private static final String OUT_PORT = "Out:";
    private static final String IN_PORT = "In:";
    private static final String OUT_WORKING_PORT = "Out[w]:";
    private static final String IN_WORKING_PORT = "In[w]:";
    private static final String OUT_PROTECTION_PORT = "Out[p]:";
    private static final String IN_PROTECTION_PORT = "In[p]:";
    private static final int WRK_IDX = 0;
    private static final int PRT_IDX = 1;
    private static final int RX_IDX = 0;
    private static final int TX_IDX = 1;
    private static final String UNKNOWN_PORT = "Unknown";
    private static final String DIRLESS_PORT = "Multiple Directions Available";
    private SDebug db;
    private boolean isOchnc;
    private boolean isOchTrail;
    private boolean isOchcc;
    private boolean isSingleNode;
    private boolean showOTS;
    private int cktOptChannel;
    private boolean isBidirectional;
    private boolean isProtected;
    private boolean isValid;
    private String errorMessage;
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints gbc = new GridBagConstraints();
    private JTextField[] outTF;
    private JTextField[] inTF;

    public OchncLinesPanel(SDebug sDebug, CircuitCreatInfo circuitCreatInfo) {
        sDebug.fine("OchncLinesPanel <init>");
        this.db = sDebug;
        this.isBidirectional = circuitCreatInfo.dir() == 1;
        this.isProtected = circuitCreatInfo.isProtected();
        this.cktOptChannel = circuitCreatInfo.cktOptChannel();
        this.isOchnc = circuitCreatInfo.type() == 9;
        this.isOchTrail = circuitCreatInfo.type() == 15;
        this.isSingleNode = circuitCreatInfo.singleNodeOchnc();
        this.showOTS = true;
        this.isOchcc = circuitCreatInfo.type() == 14;
        this.init();
        this.initLayout();
        this.setBorder(BorderFactory.createTitledBorder("OTS Lines"));
    }

    public OchncLinesPanel(SDebug sDebug, int n) {
        sDebug.fine("OchncLinesPanel <init>");
        this.db = sDebug;
        this.cktOptChannel = n;
        this.isBidirectional = true;
        this.isProtected = false;
        this.isOchnc = false;
        this.isOchTrail = true;
        this.init();
        this.initLayout();
        this.setBorder(BorderFactory.createTitledBorder("OTS Lines"));
    }

    public void setSelectedEntity(INetCircuitEnd iNetCircuitEnd, boolean bl) {
        this.db.fine("OchncLinesPanel::setSelectedEntity=" + iNetCircuitEnd.getNodeModel() + ":" + iNetCircuitEnd.getEntityIndex());
        this.reset();
        this.setSelectedEntityForOch(iNetCircuitEnd, bl);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OchncLinesPanel.this.doLayout();
            }
        });
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public boolean showOTSSide() {
        if (this.isSingleNode) {
            return this.showOTS;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void initLayout(boolean bl, boolean bl2) {
        this.db.fine("OchncLinesPanel::initLayout:" + bl + "," + bl2);
        this.initLayout();
        JLabel[] jLabelArray = new JLabel[]{};
        JLabel[] jLabelArray2 = new JLabel[]{};
        if (this.isBidirectional) {
            if (bl) {
                jLabelArray = new JLabel[]{new JLabel(OUT_WORKING_PORT), new JLabel(OUT_PROTECTION_PORT)};
                jLabelArray2 = new JLabel[]{new JLabel(IN_WORKING_PORT), new JLabel(IN_PROTECTION_PORT)};
            } else {
                jLabelArray = new JLabel[]{new JLabel(OUT_PORT)};
                jLabelArray2 = new JLabel[]{new JLabel(IN_PORT)};
            }
        } else if (bl2) {
            jLabelArray = new JLabel[]{new JLabel(OUT_PORT)};
        } else {
            jLabelArray2 = new JLabel[]{new JLabel(IN_PORT)};
        }
        this.outTF = new JTextField[jLabelArray.length];
        this.inTF = new JTextField[jLabelArray2.length];
        for (int i = 0; i < 2; ++i) {
            if (bl2 && i < jLabelArray.length) {
                this.outTF[i] = this.addTF(jLabelArray[i], this.gbc);
            }
            if (i < jLabelArray2.length) {
                this.inTF[i] = this.addTF(jLabelArray2[i], this.gbc);
            }
            if (bl2 || i >= jLabelArray.length) continue;
            this.outTF[i] = this.addTF(jLabelArray[i], this.gbc);
        }
    }

    private void setValues(IEntityModel[][] iEntityModelArray, boolean bl, boolean bl2) {
        Object object;
        String string = UNKNOWN_PORT;
        if (iEntityModelArray[0].length > 0) {
            if (bl2) {
                object = OchncHelper.getWorkingOutLinePort(this.cktOptChannel, iEntityModelArray[0][0]);
                if (object != null) {
                    string = CircuitMapUtil.getSpanLabel((IEntityModel)object, null, null);
                }
            } else {
                object = OchncHelper.getOutLinePorts(this.cktOptChannel, iEntityModelArray[0][0]);
                if (object != null && object.size() == 1) {
                    string = CircuitMapUtil.getSpanLabel((IEntityModel)object.get(0), null, null);
                } else if (object != null && object.size() > 1) {
                    string = DIRLESS_PORT;
                }
            }
        }
        this.outTF[0].setText(string);
        string = UNKNOWN_PORT;
        if (iEntityModelArray[0].length > 1) {
            if (bl2) {
                object = OchncHelper.getWorkingInLinePort(this.cktOptChannel, iEntityModelArray[0][1]);
                if (object != null) {
                    string = CircuitMapUtil.getSpanLabel((IEntityModel)object, null, null);
                }
            } else {
                object = OchncHelper.getInLinePorts(this.cktOptChannel, iEntityModelArray[0][1]);
                if (object != null && object.size() == 1) {
                    string = CircuitMapUtil.getSpanLabel((IEntityModel)object.get(0), null, null);
                } else if (object != null && object.size() > 1) {
                    string = DIRLESS_PORT;
                }
            }
        }
        this.inTF[0].setText(string);
        if (bl) {
            string = UNKNOWN_PORT;
            if (iEntityModelArray[1].length > 0) {
                object = OchncHelper.getOutLinePorts(this.cktOptChannel, iEntityModelArray[1][0]);
                if (object != null && object.size() == 1) {
                    string = CircuitMapUtil.getSpanLabel((IEntityModel)object.get(0), null, null);
                } else if (object != null && object.size() > 1) {
                    string = DIRLESS_PORT;
                }
            }
            this.outTF[1].setText(string);
            string = UNKNOWN_PORT;
            if (iEntityModelArray[1].length > 1) {
                object = OchncHelper.getInLinePorts(this.cktOptChannel, iEntityModelArray[1][1]);
                if (object != null && object.size() == 1) {
                    string = CircuitMapUtil.getSpanLabel((IEntityModel)object.get(0), null, null);
                } else if (object != null && object.size() > 1) {
                    string = DIRLESS_PORT;
                }
            }
            this.inTF[1].setText(string);
        } else if (bl2) {
            string = UNKNOWN_PORT;
            if (iEntityModelArray[0].length > 0 && (object = OchncHelper.getProtectedOutLinePort(this.cktOptChannel, iEntityModelArray[0][0])) != null) {
                string = CircuitMapUtil.getSpanLabel((IEntityModel)object, null, null);
            }
            this.outTF[1].setText(string);
            string = UNKNOWN_PORT;
            if (iEntityModelArray[0].length > 1 && (object = OchncHelper.getProtectedInLinePort(this.cktOptChannel, iEntityModelArray[0][1])) != null) {
                string = CircuitMapUtil.getSpanLabel((IEntityModel)object, null, null);
            }
            this.inTF[1].setText(string);
        }
    }

    private void setSelectedEntityForOchcc(IEntityModel iEntityModel, boolean bl) {
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        boolean bl2 = OchTrailHelper.isClientPort(iEntityModel);
        boolean bl3 = OchTrailHelper.isProtected(iEntityModel.getModuleModel());
        IEntityModel[] iEntityModelArray = new IEntityModel[]{};
        if (bl2) {
            try {
                iEntityModelArray = OchTrailHelper.getTrunkPorts(iNodeModel, iEntityModel.getEntityIndex());
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.println("Cannot find trunk ports for client " + iEntityModel);
                    SDebug.printStackTrace((Throwable)exception);
                }
                this.isValid = false;
                this.errorMessage = KErrorMsg.getString((EID)NEMC.EID_NO_TRUNKS_FOR_OCHCC_PARAM_1, (Object)iEntityModel);
            }
        } else {
            iEntityModelArray = new IEntityModel[]{iEntityModel};
        }
        if (this.isValid && bl3 && iEntityModelArray.length != 2) {
            this.isValid = false;
            this.errorMessage = KErrorMsg.getString((EID)NEMC.EID_PROTECT_CARD_NEEDS_2_TRUNKS_PARAM_1, (Object)new Integer(iEntityModelArray.length));
        }
        IEntityModel[][] iEntityModelArrayArray = new IEntityModel[iEntityModelArray.length][];
        boolean bl4 = false;
        boolean bl5 = false;
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            iEntityModelArrayArray[i] = new IEntityModel[0];
            try {
                iEntityModelArrayArray[i] = OchTrailHelper.getColocatedOchPorts(iEntityModelArray[i]);
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.println("Cannot find colocated ports for trunk " + iEntityModelArray[i]);
                    SDebug.printStackTrace((Throwable)exception);
                }
                this.isValid = false;
                this.errorMessage = KErrorMsg.getString((EID)NEMC.EID_COLOCATED_OCH_FAILED_PARAM_1, (Object)iEntityModelArray[i]);
            }
            if (!bl4) {
                bl4 = iEntityModelArrayArray[i].length > 0;
            }
            bl5 |= OchTrailHelper.isProtectedOCHNCService(iEntityModelArray[i]);
        }
        if (!bl4) {
            if (this.db.on()) {
                this.db.println("Non colocated trunk ports. No OTS Lines.");
            }
            return;
        }
        if (bl3 && bl5) {
            if (this.db.on()) {
                this.db.println("Both OCHCC and OCHNC Protected are not allowed.");
            }
            this.isValid = false;
            this.errorMessage = KErrorMsg.getString((EID)NEMC.EID_DOUBLE_PROT_NOT_ALLOWED);
            return;
        }
        this.initLayout(bl3 || bl5, bl);
        this.setValues(iEntityModelArrayArray, bl3, bl5);
    }

    private void setSelectedEntityForOch(INetCircuitEnd iNetCircuitEnd, boolean bl) {
        IEntityModel iEntityModel = null;
        try {
            iEntityModel = iNetCircuitEnd.getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            if (this.db.on()) {
                this.db.println("Cannot find endpoint entity model for " + iNetCircuitEnd);
                SDebug.printStackTrace((Throwable)objNotFound);
            }
            this.isValid = false;
            this.errorMessage = KErrorMsg.getString((EID)NEMC.EID_CANNOT_FIND_ENTITY_PARAM_1, (Object)iNetCircuitEnd);
            return;
        }
        if (this.isOchnc) {
            this.setSelectedEntityForOchnc(iEntityModel, bl);
        } else if (this.isOchTrail) {
            this.setSelectedEntityForOchTrail(iEntityModel, bl);
        } else if (this.isOchcc) {
            this.setSelectedEntityForOchcc(iEntityModel, bl);
        }
    }

    private void setSelectedEntityForOchnc(IEntityModel iEntityModel, boolean bl) {
        Object object;
        boolean bl2 = OchPortsHelper.isAddPort(iEntityModel);
        if (!OchPortsHelper.isOchPort(iEntityModel)) {
            this.showOTS = false;
            return;
        }
        this.initLayout(this.isProtected, bl2);
        if (bl2 || this.isBidirectional) {
            if (this.isProtected) {
                object = OchncHelper.getWorkingOutLinePort(this.cktOptChannel, iEntityModel);
                if (object != null) {
                    this.outTF[0].setText(CircuitMapUtil.getSpanLabel((IEntityModel)object, null, null));
                } else {
                    this.outTF[0].setText(UNKNOWN_PORT);
                    this.isValid = false;
                    this.errorMessage = KErrorMsg.getString((EID)NEMC.EID_CANNOT_FIND_PROT_OUT_LINE_PARAM_1, (Object)iEntityModel);
                }
                object = OchncHelper.getProtectedOutLinePort(this.cktOptChannel, iEntityModel);
                if (object != null) {
                    this.outTF[1].setText(CircuitMapUtil.getSpanLabel((IEntityModel)object, null, null));
                } else {
                    this.outTF[1].setText(UNKNOWN_PORT);
                    this.isValid = false;
                    this.errorMessage = KErrorMsg.getString((EID)NEMC.EID_CANNOT_FIND_PROT_OUT_LINE_PARAM_1, (Object)iEntityModel);
                }
            } else {
                object = OchncHelper.getOutLinePorts(this.cktOptChannel, iEntityModel);
                if (object != null && object.size() == 1) {
                    this.outTF[0].setText(CircuitMapUtil.getSpanLabel((IEntityModel)object.get(0), null, null));
                } else if (object != null && object.size() > 1) {
                    this.outTF[0].setText(DIRLESS_PORT);
                } else {
                    this.outTF[0].setText(UNKNOWN_PORT);
                    this.isValid = false;
                    this.errorMessage = KErrorMsg.getString((EID)NEMC.EID_CANNOT_FIND_OUT_LINE_PARAM_1, (Object)iEntityModel);
                }
            }
        }
        if (!bl2 || this.isBidirectional) {
            if (this.isProtected) {
                object = OchncHelper.getWorkingInLinePort(this.cktOptChannel, iEntityModel);
                if (object != null) {
                    this.inTF[0].setText(CircuitMapUtil.getSpanLabel((IEntityModel)object, null, null));
                } else {
                    this.inTF[0].setText(UNKNOWN_PORT);
                    this.isValid = false;
                    this.errorMessage = KErrorMsg.getString((EID)NEMC.EID_CANNOT_FIND_PROT_IN_LINE_PARAM_1, (Object)CircuitMapUtil.getSpanLabel(iEntityModel, null, null));
                }
                object = OchncHelper.getProtectedInLinePort(this.cktOptChannel, iEntityModel);
                if (object != null) {
                    this.inTF[1].setText(CircuitMapUtil.getSpanLabel((IEntityModel)object, null, null));
                } else {
                    this.inTF[1].setText(UNKNOWN_PORT);
                    this.isValid = false;
                    this.errorMessage = KErrorMsg.getString((EID)NEMC.EID_CANNOT_FIND_PROT_IN_LINE_PARAM_1, (Object)CircuitMapUtil.getSpanLabel(iEntityModel, null, null));
                }
            } else {
                object = OchncHelper.getInLinePorts(this.cktOptChannel, iEntityModel);
                if (object != null && object.size() == 1) {
                    this.inTF[0].setText(CircuitMapUtil.getSpanLabel((IEntityModel)object.get(0), null, null));
                } else if (object != null && object.size() > 1) {
                    this.inTF[0].setText(DIRLESS_PORT);
                } else {
                    this.inTF[0].setText(UNKNOWN_PORT);
                    this.isValid = false;
                    this.errorMessage = KErrorMsg.getString((EID)NEMC.EID_CANNOT_FIND_IN_LINE_PARAM_1, (Object)CircuitMapUtil.getSpanLabel(iEntityModel, null, null));
                }
            }
        }
    }

    private void setSelectedEntityForOchTrail(IEntityModel iEntityModel, boolean bl) {
        IEntityModel[] iEntityModelArray = new IEntityModel[]{};
        iEntityModelArray = new IEntityModel[]{iEntityModel};
        IEntityModel[][] iEntityModelArrayArray = new IEntityModel[iEntityModelArray.length][];
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            iEntityModelArrayArray[i] = new IEntityModel[0];
            try {
                iEntityModelArrayArray[i] = OchTrailHelper.getColocatedOchPorts(iEntityModelArray[i]);
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.println("Cannot find colocated ports for trunk " + iEntityModelArray[i]);
                    SDebug.printStackTrace((Throwable)exception);
                }
                this.isValid = false;
                this.errorMessage = KErrorMsg.getString((EID)NEMC.EID_COLOCATED_OCH_FAILED_PARAM_1, (Object)iEntityModelArray[i]);
            }
            if (!bl2) {
                bl2 = iEntityModelArrayArray[i].length > 0;
            }
            bl3 |= OchTrailHelper.isProtectedOCHNCService(iEntityModelArray[i]);
        }
        if (!bl2) {
            if (this.db.on()) {
                this.db.println("Non colocated trunk ports. No OTS Lines.");
            }
            return;
        }
        this.initLayout(bl3, bl);
        this.setValues(iEntityModelArrayArray, false, bl3);
    }

    protected JTextField addTF(JLabel jLabel, GridBagConstraints gridBagConstraints) {
        jLabel.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints.gridx = 0;
        JTextField jTextField = new JTextField();
        jTextField.setPreferredSize(new Dimension(250, 22));
        jTextField.setMinimumSize(new Dimension(100, 22));
        jTextField.setEditable(false);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)jTextField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        return jTextField;
    }

    void reset() {
        this.db.fine("OchncLinesPanel::reset=" + this.isVisible());
        this.removeAll();
        this.isValid = true;
        this.errorMessage = null;
        this.showOTS = true;
    }

    @Override
    public void setVisible(boolean bl) {
        this.db.fine("OchncLinesPanel::setVisible=" + bl);
        super.setVisible(bl);
    }

    private void init() {
        this.setLayout(this.gbl);
    }

    private void initLayout() {
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.gbc.insets = new Insets(5, 5, 0, 0);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
    }
}

