/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.IYCableModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchncHelper;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.OchncCircuitEnd;
import cerent.cms.ui.circuits.AbstractProtectedCircuitMapPort;
import cerent.cms.ui.network.CircuitMapNode;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapLinkConnector;

public class OchncProtectedCircuitMapPort
extends AbstractProtectedCircuitMapPort {
    private SDebug db = new SDebug("OchncProtectedCircuitMapPort");
    private int otsLinePgIndex;
    private IEntityModel otsLinePgPort;
    private IPortModel otsInternalPgPort;
    private IYCableModel splitter;
    private int optChannel;

    public OchncProtectedCircuitMapPort(DetailedMapNode detailedMapNode, MapLinkConnector mapLinkConnector, int n, int n2) {
        super(detailedMapNode, mapLinkConnector);
        this.otsLinePgIndex = n;
        this.optChannel = n2;
    }

    public int getOtsPgIndex() {
        return this.otsLinePgIndex;
    }

    @Override
    public IEntityModel getPort() {
        if (this.otsLinePgPort == null) {
            Object object = this.parentNode.getUserObject();
            if (object != null && object instanceof INodeModel) {
                INodeModel iNodeModel = (INodeModel)object;
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                try {
                    this.otsLinePgPort = iEntityTableModel.getEntityModelByIndex(this.getOtsPgIndex());
                }
                catch (Exception exception) {
                    this.db.severe("Cannot find trunk EM for " + Integer.toHexString(this.getOtsPgIndex()) + ": " + exception.getMessage());
                }
            } else {
                this.db.severe("parentKey is not a valid INodeModel instance: " + object);
            }
        }
        return this.otsLinePgPort;
    }

    @Override
    public IPortModel getInternalPort() {
        if (this.otsInternalPgPort == null) {
            Object object;
            IPortModel iPortModel = (IPortModel)this.getPort();
            ISideModel iSideModel = OchncHelper.getSideFromLineInOut(iPortModel);
            if (iSideModel.getLineIn() == iPortModel.getEntityIndex() && (object = this.parentNode.getUserObject()) != null && object instanceof INodeModel) {
                INodeModel iNodeModel = (INodeModel)object;
                CircuitMapNode circuitMapNode = (CircuitMapNode)this.parentNode;
                OchncCircuit ochncCircuit = (OchncCircuit)circuitMapNode.getNetCircuit();
                OchncCircuitEnd ochncCircuitEnd = new OchncCircuitEnd(iNodeModel, circuitMapNode.getCircuitEnd(this), this.optChannel);
                INetCircuitEnd iNetCircuitEnd = ochncCircuit.getSrcCircuitEnd(ochncCircuitEnd);
                try {
                    iPortModel = (IPortModel)iNetCircuitEnd.getEntityModel();
                }
                catch (ObjNotFound objNotFound) {
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
            }
            this.otsInternalPgPort = OchncHelper.getSplitterPort(this.optChannel, (IEntityModel)iPortModel);
        }
        return this.otsInternalPgPort;
    }

    @Override
    public boolean isActivePort() {
        try {
            return this.getInternalPort().getInterfaceModel().isCurrentlyActive();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    @Override
    public boolean isWorkingPort() {
        try {
            return this.getInternalPort().getInterfaceModel().getProtectionRole() == 1;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    @Override
    public IYCableModel getYCableOrSplitterModel() throws AbstractCmsNoSuchElementException {
        if (this.splitter == null) {
            this.splitter = OchncHelper.getSplitterModel(this.getInternalPort());
        }
        return this.splitter;
    }

    @Override
    public int getProtectionOp() throws AbstractCmsNoSuchElementException {
        return this.getYCableOrSplitterModel().getProtection();
    }

    @Override
    public void setProtectionOp(int n) throws AbstractCmsNoSuchElementException, InvalidProtectionOp, InternalCommError {
        this.getYCableOrSplitterModel().setProtection(n);
    }
}

