/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IPptData;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.WrongPortType;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.gui.DefaultChartDataModel;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.data.IlvDataSource;
import ilog.views.chart.data.IlvDefaultDataSet;
import ilog.views.chart.data.IlvDefaultDataSource;
import java.awt.Color;
import java.awt.Paint;

class PptChartDataModel
extends DefaultChartDataModel {
    private static final long serialVersionUID = 1L;
    private double[][] yvalues;
    private double[] xvalues;
    private String[] labels;
    private String[] seriesLabels = new String[]{"Power", "Threshold"};
    private double min;
    private double max;
    private KDebug db;
    private int[] ports;
    public static final double THRESHOLD_NOT_AVAILABLE = -1000000.0;

    public PptChartDataModel(IPptData iPptData, KDebug kDebug) {
        this.db = kDebug;
        long[] lArray = iPptData.getPowerValues();
        long[] lArray2 = iPptData.getThresholds();
        this.ports = iPptData.getInterfaceIds();
        int n = this.ports.length;
        this.yvalues = new double[2][n];
        this.xvalues = new double[n];
        this.labels = new String[n];
        this.max = this.min = (double)lArray[0];
        INetElement iNetElement = Network.instance().findNetElemByIp(InetUtil.makeDottedString(iPptData.getNodeIp()));
        for (int i = 0; i < n; ++i) {
            this.xvalues[i] = (double)i + 1.0;
            this.yvalues[0][i] = (double)lArray[i] / 10.0;
            try {
                StringBuffer stringBuffer;
                block15: {
                    stringBuffer = new StringBuffer();
                    IPortModel iPortModel = (IPortModel)iNetElement.getNodeModel().getEntityTable().getEntityModelByIndex(this.ports[i]);
                    if (iNetElement.getNodeModel().isMultishelf()) {
                        stringBuffer.append(iPortModel.getShelfId() + "/");
                    }
                    stringBuffer.append(String.format("s%d/p%d\n", iPortModel.getSlot(), iPortModel.getPortNum()[0]));
                    stringBuffer.append(String.format("%s\n", iPortModel.getParent().getEqLabel()));
                    if (iPortModel instanceof IOpticsPortModel) {
                        IOpticsPortModel iOpticsPortModel = (IOpticsPortModel)iPortModel;
                        try {
                            stringBuffer.append(iOpticsPortModel.getOptPortTypeString());
                        }
                        catch (NoSuchEquipment noSuchEquipment) {
                            if (kDebug.on) {
                                kDebug.println(String.format("NoSuchInterface in PptChartDataModel - port 0x%x", this.ports[i]));
                            }
                        }
                        catch (WrongPortType wrongPortType) {
                            if (!kDebug.on) break block15;
                            kDebug.println(String.format("WrongPortType in PptChartDataModel - port 0x%x", this.ports[i]));
                        }
                    }
                }
                this.labels[i] = stringBuffer.toString();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (kDebug.on()) {
                    kDebug.println(String.format("Port 0x%x not found in PptChartDataModel", this.ports[i]));
                }
                this.labels[i] = String.format("0x%x", this.ports[i]);
            }
            if ((double)lArray[i] > this.max) {
                this.max = lArray[i];
            } else if ((double)lArray[i] < this.min) {
                this.min = lArray[i];
            }
            if ((double)lArray2[i] != -1000000.0) {
                this.yvalues[1][i] = (double)lArray2[i] / 10.0;
                if ((double)lArray2[i] > this.max) {
                    this.max = lArray2[i];
                    continue;
                }
                if (!((double)lArray2[i] < this.min)) continue;
                this.min = lArray2[i];
                continue;
            }
            this.yvalues[1][i] = -1000000.0;
        }
        this.max /= 10.0;
        this.min /= 10.0;
    }

    public int getNumSeries() {
        return 2;
    }

    public String[] getPointLabels() {
        return this.labels;
    }

    public String[] getSeriesLabels() {
        return this.seriesLabels;
    }

    public double[] getXSeries(int n) {
        return this.xvalues;
    }

    public double[] getYSeries(int n) {
        if (n == 0 || n == 1) {
            return this.yvalues[n];
        }
        return new double[0];
    }

    public double getMax() {
        if (this.max != this.min) {
            return this.max + 0.1 * (this.max - this.min);
        }
        return this.max + Math.abs(this.max);
    }

    public double getMin() {
        if (this.max != this.min) {
            return this.min - 0.1 * (this.max - this.min);
        }
        return this.max - Math.abs(this.max);
    }

    public int[] getPortIds() {
        return this.ports;
    }

    public IlvStyle[] getStyles() {
        IlvStyle[] ilvStyleArray = new IlvStyle[]{new IlvStyle((Paint)Color.CYAN), new IlvStyle((Paint)Color.GRAY)};
        return ilvStyleArray;
    }

    public IlvDataSource getDataSource() {
        PptDataSet[] pptDataSetArray = new PptDataSet[]{new PptDataSet(this.seriesLabels[0], this.yvalues[0]), new PptDataSet(this.seriesLabels[1], this.yvalues[1])};
        pptDataSetArray[0].setDataLabels(this.getPointLabels());
        pptDataSetArray[1].setDataLabels(this.getPointLabels());
        return new IlvDefaultDataSource((IlvDataSet[])pptDataSetArray);
    }

    class PptDataSet
    extends IlvDefaultDataSet {
        private static final long serialVersionUID = 1L;

        public PptDataSet(String string, double[] dArray) {
            super(string, dArray);
        }

        public Double getUndefValue() {
            return -1000000.0;
        }
    }
}

