/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IPptData;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.WrongPortType;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import java.util.Date;
import java.util.List;

class PptFormatter {
    private List<IPptData> fwdResult;
    private List<IPptData> revResult;
    private static final String DATE = "_DATE_";
    private static final String TITLE = "Exported Data - PPT - _DATE_";
    private static final String HEADER = "<html><head><title>Exported Data - PPT - _DATE_</title></head><body><center><h2>Exported Data - PPT - _DATE_</h2></center>";
    private static final String FROM = "_FROM_";
    private static final String TO = "_TO_";
    private static final String PATH_TITLE = "<center><h3>From _FROM_ to _TO_</h3></center>";
    private String src;
    private String dst;
    private KDebug db;
    private INetCircuit ckt;

    private String formatPath(List<IPptData> list) {
        StringBuffer stringBuffer = new StringBuffer();
        INetElement iNetElement = null;
        INetElement iNetElement2 = null;
        for (IPptData iPptData : list) {
            INetElement iNetElement3 = Network.instance().findNetElemByIp(InetUtil.makeDottedString(iPptData.getNodeIp()));
            if (iNetElement == null) {
                iNetElement = iNetElement3;
            }
            iNetElement2 = iNetElement3;
            stringBuffer.append(String.format("<center><h4>%s</h4></center>", iNetElement3.getName()));
            stringBuffer.append("<center><table border=1 cellspacing=0 cellpadding=2>");
            stringBuffer.append("<tr><td><strong>Shelf</strong></td><td><strong>Slot</strong></td><td><strong>Port</strong></td><td><strong>Card type</strong></td><td><strong>Port Type</strong></td><td><strong>Power (dBm)</strong></td><td><strong>Threshold (dBm)</strong></td></tr>");
            int[] nArray = iPptData.getInterfaceIds();
            long[] lArray = iPptData.getPowerValues();
            long[] lArray2 = iPptData.getThresholds();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                try {
                    IPortModel iPortModel = (IPortModel)iNetElement3.getNodeModel().getEntityTable().getEntityModelByIndex(nArray[i]);
                    if (!(iPortModel instanceof IOpticsPortModel)) continue;
                    IOpticsPortModel iOpticsPortModel = (IOpticsPortModel)iPortModel;
                    stringBuffer.append(String.format("<tr><td>%d</td><td>%d</td><td>%d</td><td>%s</td><td>%s</td><td>%.2f</td><td>%s</td></tr>", iPortModel.getShelfId(), iPortModel.getSlot(), iPortModel.getPortNum()[0], iPortModel.getParent().getEqLabel(), iOpticsPortModel.getOptPortTypeString(), (double)lArray[i] / 10.0, (double)lArray2[i] == -1000000.0 ? "N/A" : String.valueOf((double)lArray2[i] / 10.0)));
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) continue;
                    this.db.println("PptFormatter: AbstractCmsNoSuchEntityException");
                    continue;
                }
                catch (NoSuchEquipment noSuchEquipment) {
                    if (!this.db.on()) continue;
                    this.db.println("PptFormatter: NoSuchEquipment");
                    continue;
                }
                catch (WrongPortType wrongPortType) {
                    if (!this.db.on()) continue;
                    this.db.println("PptFormatter: WrongPortType");
                }
            }
            stringBuffer.append("</table></center>");
        }
        return PATH_TITLE.replace(FROM, iNetElement.getName()).replace(TO, iNetElement2.getName()) + stringBuffer.toString();
    }

    public PptFormatter(INetCircuit iNetCircuit, List<IPptData> list, List<IPptData> list2, KDebug kDebug) {
        this.ckt = iNetCircuit;
        this.fwdResult = list;
        this.revResult = list2;
        this.db = kDebug;
        this.src = InetUtil.makeDottedString(list.get(0).getNodeIp());
        this.dst = InetUtil.makeDottedString(list.get(list.size() - 1).getNodeIp());
    }

    public String htmlFormat() {
        StringBuffer stringBuffer = new StringBuffer(HEADER.replace(DATE, new Date().toString()));
        stringBuffer.append("<center><p><b>Circuit name: </b>" + this.ckt.getCircuitName() + "<br>");
        stringBuffer.append("<b> Circuit type: </b>" + this.ckt.getCircuitTypeObj().getProtocolIndepCktTypeStr() + "</p></center>");
        if (this.fwdResult != null && this.fwdResult.size() > 0) {
            stringBuffer.append(this.formatPath(this.fwdResult));
        }
        if (this.revResult != null && this.revResult.size() > 0) {
            stringBuffer.append(this.formatPath(this.revResult));
        }
        stringBuffer.append("</body></html>");
        return stringBuffer.toString();
    }
}

