/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.RollValidator;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.CcdEndpointsPane;
import cerent.cms.ui.circuits.RollCreationDialog;
import cerent.util.AnnotatedException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;

public class RollEndpointsPane
extends CcdEndpointsPane {
    public RollEndpointsPane(RollCreationDialog rollCreationDialog, WzDiagDebug wzDiagDebug, String string, String string2) {
        super(rollCreationDialog, wzDiagDebug, string, string2);
    }

    @Override
    protected void updateAvailPorts(INodeModel iNodeModel, boolean bl) throws AnnotatedException {
        super.updateAvailPorts(iNodeModel, bl);
        Iterator iterator = this.availPorts.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel = (IEntityModel)iterator.next();
            if (iEntityModel instanceof IPortModel) {
                if (((IPortModel)iEntityModel).isOptical()) continue;
                iterator.remove();
                continue;
            }
            IModuleModel iModuleModel = iEntityModel.getModuleModel();
            int n = iModuleModel.getEqType();
            if (RollValidator.isValidBNRCard(n)) continue;
            iterator.remove();
        }
        if (this.db.on()) {
            this.db.info("available ports after filtering is " + ((AbstractCollection)((Object)this.availPorts)).toString());
        }
    }

    @Override
    public void validatePage() throws Exception {
        super.validatePage();
        ((RollCreationDialog)this.parent).rollTo1 = this.mainPanel.endpoint;
        StringBuffer stringBuffer = new StringBuffer();
        RollValidator.getInstance().checkRollToOnLink(((RollCreationDialog)this.parent).rollFromCkt, null, ((RollCreationDialog)this.parent).rollTo1, stringBuffer);
        if (stringBuffer.length() != 0) {
            throw new Exception(stringBuffer.toString());
        }
    }

    @Override
    protected void updateNodeList() {
        LinkedList<INodeModel> linkedList = new LinkedList<INodeModel>();
        linkedList.add(this.lastNodeModel);
        this.setNodeList(linkedList);
    }

    @Override
    protected List getEndpoints() {
        ArrayList arrayList = new ArrayList();
        INetCircuitEnd iNetCircuitEnd = ((RollCreationDialog)this.parent).bNr1;
        INetCircuit iNetCircuit = ((RollCreationDialog)this.parent).rollFromCkt;
        INetCircuitNode iNetCircuitNode = null;
        List list = iNetCircuit.getCircuitNodeFromNE(iNetCircuitEnd.getNetElement());
        if (list != null) {
            iNetCircuitNode = list.size() > 1 ? iNetCircuit.getCircuitNodeFromCktEnd(iNetCircuitEnd) : (NetCircuitNode)list.get(0);
        }
        List list2 = iNetCircuitNode.getIngressPoints();
        List list3 = iNetCircuitNode.getEgressPoints();
        if (list2.contains(iNetCircuitEnd)) {
            arrayList.add(iNetCircuit.getSources().get(0));
        } else if (list3.contains(iNetCircuitEnd)) {
            arrayList.add(iNetCircuit.getDrops().get(0));
        }
        return arrayList;
    }

    @Override
    protected JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{"Endpoint:", this.nodeModel.getName() + "/" + this.mainPanel.getStatusText()});
        return RollEndpointsPane.getGridPanel(arrayList);
    }

    @Override
    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nEndpoint: ");
        stringBuffer.append(this.nodeModel.getName());
        stringBuffer.append("/");
        stringBuffer.append(this.mainPanel.getStatusText());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    public void enteringPane() {
        super.enteringPane();
        this.useAltCB.setEnabled(false);
        this.useAltCB.setVisible(false);
        this.nodeCB.setEnabled(false);
        this.getAbstractCktDlg().setNextEnabled(false);
        this.getAbstractCktDlg().setFinishEnabled(true);
        if (!this.goingForward) {
            try {
                this.parent.forceBack();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setEnabledButtons() {
    }

    @Override
    protected String getNextPaneName() {
        return null;
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.RollEndpointsPane;
    }
}

