/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.INodeModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.route.NoRoute;
import cerent.cms.ui.CircuitNameException;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.AddVcatMembersDialog;
import cerent.cms.ui.circuits.AutorangeInfo;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.UnprotectedToUpsrDialog;
import cerent.util.AnnotatedException;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import javax.swing.JCheckBox;

public abstract class WzCcdPane
extends WzPane {
    public WzCcdPane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        super(wzDialog, wzDiagDebug, string);
    }

    void handleFinish() {
    }

    @Override
    protected void handleNextException(Exception exception) {
        Object object;
        if (exception instanceof AnnotatedException) {
            object = (AnnotatedException)((Object)exception);
            exception = object.getChild();
        }
        if (exception instanceof NoRoute) {
            object = (NoRoute)((Object)exception);
            DetailedLog detailedLog = ((NoRoute)((Object)object)).getDetailedLog();
            if (detailedLog == null) {
                ErrorMsg.displayError((Component)this, (EID)this.getNoRouteEmcErrorId());
            } else {
                CerentDialog.errorDialog((Component)this, (String)ErrorMsg.getString((EID)this.getNoRouteEmcErrorId()), (String)"Route Error", (DetailedLog)detailedLog, (boolean)false);
            }
        } else if (!(exception instanceof CircuitNameException)) {
            super.handleNextException(exception);
        }
    }

    protected EID getNoRouteEmcErrorId() {
        return NEMC.EID_CKT_CREATE_ROUTE_ERROR;
    }

    protected AutorangeInfo getAutorangeInfo() {
        if (this.parent instanceof CircuitCreationDialog) {
            return ((CircuitCreationDialog)this.parent).getAutorangeInfo();
        }
        if (this.parent instanceof AddVcatMembersDialog) {
            return ((AddVcatMembersDialog)this.parent).getAutorangeInfo();
        }
        return null;
    }

    public AbstractCircuitDialog getAbstractCktDlg() {
        return (AbstractCircuitDialog)this.parent;
    }

    protected class AutoRouteCheckBox
    extends JCheckBox {
        public static final int NoOverride = 0;
        public static final int SameNodeRequiresAutoRouting = 1;
        public static final int AutoRangingRequiresAutoRouting = 2;
        public static final int PortGroupingRequiresAutoRouting = 3;
        public static final int ConversionCircuitRequiresAutoRouting = 4;
        private boolean amChildOfUnprotectedToUpsrDialog;
        private boolean defaultAutoRoute;
        private boolean autoRouteUserChangeable;
        private int overrideReason;
        private boolean defaultUrn;
        private boolean defaultRrbc;
        private boolean defaultTscc;
        private boolean defaultWtsm;
        private Preferences prefs;
        private String prefPath;
        private String prefUrn;
        private String prefRrbc;
        private String prefWtsm;

        public AutoRouteCheckBox(AbstractCircuitDialog abstractCircuitDialog, String string, String string2, String string3, String string4) {
            super("Route Automatically:");
            this.amChildOfUnprotectedToUpsrDialog = false;
            this.defaultAutoRoute = true;
            this.autoRouteUserChangeable = true;
            this.overrideReason = 0;
            this.defaultUrn = false;
            this.defaultRrbc = false;
            this.defaultTscc = false;
            this.defaultWtsm = false;
            this.prefs = Preferences.instance();
            this.amChildOfUnprotectedToUpsrDialog = abstractCircuitDialog instanceof UnprotectedToUpsrDialog;
            this.prefPath = string;
            this.prefUrn = string2;
            this.prefRrbc = string3;
            this.prefWtsm = string4;
            this.defaultAutoRoute = true;
            this.autoRouteUserChangeable = true;
            this.overrideReason = 0;
            this.defaultUrn = false;
            this.defaultRrbc = false;
            this.defaultTscc = false;
        }

        public AutoRouteCheckBox(AbstractCircuitDialog abstractCircuitDialog, String string, String string2, String string3) {
            super("Route Automatically:");
            this.amChildOfUnprotectedToUpsrDialog = false;
            this.defaultAutoRoute = true;
            this.autoRouteUserChangeable = true;
            this.overrideReason = 0;
            this.defaultUrn = false;
            this.defaultRrbc = false;
            this.defaultTscc = false;
            this.defaultWtsm = false;
            this.prefs = Preferences.instance();
            this.amChildOfUnprotectedToUpsrDialog = abstractCircuitDialog instanceof UnprotectedToUpsrDialog;
            this.prefPath = string;
            this.prefUrn = string2;
            this.prefRrbc = string3;
            this.defaultAutoRoute = true;
            this.autoRouteUserChangeable = true;
            this.overrideReason = 0;
            this.defaultUrn = false;
            this.defaultRrbc = false;
            this.defaultTscc = false;
        }

        public void init() {
            String[] stringArray = new String[]{"CTC.circuits.AutoRoute", "CTC.circuits.RouteAutomatically", "CTC.circuits.RouteAutomaticallyDefaultOverridable"};
            INodeModel iNodeModel = NetworkModel.instance().getCmsHostModel();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    stringArray[i] = iNodeModel.getDefaultValue(stringArray[i]);
                    continue;
                }
                catch (NoSuchDefault noSuchDefault) {
                    stringArray[i] = "";
                }
            }
            this.defaultAutoRoute = stringArray[1].equalsIgnoreCase("") ? stringArray[0].equalsIgnoreCase("true") : stringArray[1].equalsIgnoreCase("true");
            this.autoRouteUserChangeable = !stringArray[2].equalsIgnoreCase("false");
            WzCcdPane.this.db.fine("AutoRoute: Default " + this.defaultAutoRoute + " Changeable " + this.autoRouteUserChangeable);
            this.overrideReason = 0;
            this.defaultTscc = false;
            this.defaultWtsm = false;
            this.defaultRrbc = false;
            this.defaultUrn = false;
            if (this.defaultAutoRoute) {
                if (!this.amChildOfUnprotectedToUpsrDialog) {
                    this.defaultUrn = this.prefs.getBoolean(this.prefPath, this.prefUrn, this.defaultUrn);
                }
                this.defaultRrbc = this.prefs.getBoolean(this.prefPath, this.prefRrbc, this.defaultRrbc);
            }
            WzCcdPane.this.db.fine("Preferences: URN " + this.defaultUrn + " RRBC " + this.defaultRrbc + " TSCC " + this.defaultTscc + " WTSM " + this.defaultWtsm);
            super.setEnabled(this.defaultAutoRoute);
        }

        @Override
        public void setEnabled(boolean bl) {
            WzCcdPane.this.db.fine("setEnabled() : " + bl + " changeable: " + this.autoRouteUserChangeable);
            if (this.autoRouteUserChangeable) {
                super.setEnabled(bl);
            } else {
                this.setEnabled(0);
            }
        }

        public void setEnabled(int n) {
            WzCcdPane.this.db.fine("setEnabled() : " + n + " changeable: " + this.autoRouteUserChangeable);
            if (n > 0) {
                super.setEnabled(false);
            } else {
                super.setEnabled(this.autoRouteUserChangeable);
            }
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("Routing: ");
            stringBuffer.append(this.isSelected() ? "automatic" : "manual");
            String string = "";
            switch (this.overrideReason) {
                case 0: {
                    string = this.autoRouteUserChangeable ? "" : " (unchangeable)";
                    break;
                }
                case 1: {
                    string = "\n(Intra-node cross-connect requires Auto-Routing)";
                    break;
                }
                case 2: {
                    string = "\n(Auto-Ranging requires Auto-Routing)";
                    break;
                }
                case 3: {
                    string = "\n(Port Grouping requires Auto-Routing)";
                    break;
                }
                case 4: {
                    string = "\n(Conversion Circuits Require Auto-Routing)";
                }
            }
            stringBuffer.append(string);
            return stringBuffer.toString();
        }

        public boolean isUserChangeable() {
            return this.autoRouteUserChangeable;
        }

        public boolean getDefaultAutoRoute() {
            return this.defaultAutoRoute;
        }

        public boolean getDefaultUrn() {
            return this.defaultUrn;
        }

        public boolean getDefaultRrbc() {
            return this.defaultRrbc;
        }

        public boolean getDefaultTscc() {
            return this.defaultTscc;
        }

        public boolean getDefaultWtsm() {
            return this.defaultWtsm;
        }
    }
}

