/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.event;

import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.event.EventInfo;
import cerent.cms.ui.AbstractInvalidViewException;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.ViewNameFactory;
import cerent.cms.ui.event.IEventPanelController;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class EventPanelController
implements IEventPanelController {
    private AbstractViewController avc;

    public EventPanelController(AbstractViewController abstractViewController) {
        this.avc = abstractViewController;
    }

    public void mouseClicked(MouseEvent mouseEvent, JTable jTable, AbstractTableModel abstractTableModel) {
        int n;
        if (mouseEvent.getClickCount() == 2 && (n = jTable.rowAtPoint(mouseEvent.getPoint())) != -1) {
            EventInfo eventInfo = (EventInfo)abstractTableModel.getValueAt(n, 0);
            try {
                int n2 = NetworkModel.instance().getMostCurrentNodeId(eventInfo.getNodeId());
                int n3 = 0;
                INodeModel iNodeModel = NetworkModel.instance().getNodeModel(n2);
                if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF) && iNodeModel.isMultishelf() && !eventInfo.isMultishelfViewCondition()) {
                    n3 = eventInfo.getShelfId();
                }
                ViewNameFactory viewNameFactory = new ViewNameFactory();
                ViewName viewName = viewNameFactory.getViewName(eventInfo, n2);
                this.avc.tryJumpView(viewName);
                try {
                    this.avc.jumpView(viewName, true);
                }
                catch (AbstractInvalidViewException abstractInvalidViewException) {
                    viewName = new ViewName(new int[]{n2, n3});
                    this.avc.jumpView(viewName, true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

