/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.event;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.event.EventInfo;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.event.ConditionsPane;
import cerent.cms.ui.event.EventPanel;
import cerent.cms.ui.event.FilterDialog;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.row.RowDataSource;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class NetworkConditionsPane
extends ConditionsPane {
    private static final SDebug db = new SDebug("NetworkConditionsPane");
    private NetworkModel netModel;

    public NetworkConditionsPane(String string, NetworkModel networkModel, TabbedView tabbedView, IEventPanelController iEventPanelController) {
        super(string, networkModel, tabbedView, iEventPanelController, db);
        this.netModel = networkModel;
    }

    @Override
    protected List getNodeModelList() {
        LinkedList<INodeModel> linkedList = new LinkedList<INodeModel>();
        Collection collection = Network.instance().getElements();
        for (INetElement iNetElement : collection) {
            INodeModel iNodeModel = this.netModel.getNodeModel(iNetElement.getNodeId());
            if (iNodeModel == null) continue;
            linkedList.add(iNodeModel);
        }
        return linkedList;
    }

    @Override
    protected EventPanel createEventPanel(IEventPanelController iEventPanelController) {
        return new EventPanel((RowDataSource)this.rowSource, iEventPanelController, 195);
    }

    @Override
    protected void showFilterDialog() {
        try {
            Collection collection = Network.instance().getElements();
            int n = 0;
            INetElement iNetElement2 = null;
            INodeModel[] iNodeModelArray = new INodeModel[collection.size()];
            for (INetElement iNetElement2 : collection) {
                if (iNetElement2 != null) {
                    iNodeModelArray[n] = iNetElement2.getNodeModel();
                }
                ++n;
            }
            this.eventFilter.setNodeModel(iNodeModelArray);
            new FilterDialog(this, this.eventFilter, "Condition Filter").show();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    protected INodeModel getAffectedNodeModel(EventInfo eventInfo) {
        INodeModel iNodeModel = null;
        IModel iModel = this.getUiModel();
        if (iModel instanceof NetworkModel) {
            NetworkModel networkModel = (NetworkModel)iModel;
            try {
                iNodeModel = networkModel.getNodeModel(eventInfo.getNodeId());
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.println("AbstractCmsIOException caught trying to find the INodeModel affected by EventInfo=" + eventInfo);
                iNodeModel = null;
            }
        }
        return iNodeModel;
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.ConditionsPane;
    }

    @Override
    protected String getErrorMsg() {
        return ErrorMsg.getString((EID)NEMC.EID_NET_RTRV_COND_ERROR);
    }
}

