/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ipodwdm;

import cerent.cms.model.INodeModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.ISideModels;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.ipodwdm.DetailedSRLGReportDialog;
import cerent.cms.ui.ipodwdm.SRLGRowObject;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.IPoDWDMUtility;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;

public class DetailedSRLGDataSource
extends AbstractRowDataSource
implements IObserver {
    private ArrayList<SRLGRowObject> rows = new ArrayList();
    private IPoDWDMUtility dwdmUtil;
    private DetailedSRLGReportDialog drg;
    private INodeModel nodeModel;
    private ISideModel smod;
    protected static final SDebug db = new SDebug("DetailedSRLGDataSource");

    public DetailedSRLGDataSource(DetailedSRLGReportDialog detailedSRLGReportDialog) {
        this.drg = detailedSRLGReportDialog;
        this.init();
        this.refresh();
    }

    private void init() {
        try {
            this.dwdmUtil = IPoDWDMUtility.instance();
        }
        catch (Exception exception) {
            ErrorMsg.displayError(null, (EID)NEMC.EID_INITIALIZATION_ERROR);
        }
    }

    public void update(IObservable iObservable, Object object) {
        block3: {
            try {
                if (iObservable instanceof ISideModel || iObservable instanceof INodeModel) {
                    this.refresh();
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                db.println("update(): exception" + exception);
            }
        }
    }

    private void addSideObserver(ISideModel iSideModel) {
        this.smod = iSideModel;
        if (!iSideModel.isObserver((IObserver)this)) {
            this.smod.addObserver((IObserver)this);
        }
    }

    private void deleteSideObserver(ISideModel iSideModel) {
        this.smod = iSideModel;
        if (iSideModel.isObserver((IObserver)this)) {
            this.smod.deleteObserver((IObserver)this);
        }
    }

    public synchronized void refresh() {
        Object object;
        String string;
        long l;
        String string2;
        SRLGRowObject sRLGRowObject;
        if (db.on()) {
            db.println("Refreshing the data source.");
        }
        this.deleteAll();
        Iterator iterator = this.dwdmUtil.getMSTPNodes().iterator();
        while (iterator.hasNext()) {
            try {
                this.nodeModel = (INodeModel)iterator.next();
                sRLGRowObject = new SRLGRowObject(this.nodeModel, this.nodeModel.getName());
                string2 = sRLGRowObject.getEntityName();
                l = sRLGRowObject.getUniqueSRLG();
                string = sRLGRowObject.getAdditionalSRLG().trim();
                if (string.indexOf(",") != -1) {
                    this.nodeModel.addObserver((IObserver)this);
                    this.rows.add(new SRLGRowObject(this.nodeModel, string2, l, SRLGRowObject.UNIQUE_STRING));
                    object = new StringTokenizer(string, ",");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        this.rows.add(new SRLGRowObject(this.nodeModel, string2, Long.parseLong(((StringTokenizer)object).nextToken().trim()), SRLGRowObject.ADDITIONAL_SRLG));
                    }
                    continue;
                }
                this.nodeModel.addObserver((IObserver)this);
                this.rows.add(new SRLGRowObject(this.nodeModel, string2, l, SRLGRowObject.UNIQUE_STRING));
                if (string.equals(SRLGRowObject.UNKNOWN_STRING)) continue;
                if (string.equals("")) continue;
                this.rows.add(new SRLGRowObject(this.nodeModel, string2, Long.parseLong(string), SRLGRowObject.ADDITIONAL_SRLG));
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Error Occurred.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        iterator = this.dwdmUtil.getLinksForSRLG().iterator();
        while (iterator.hasNext()) {
            try {
                INetLink iNetLink = (INetLink)iterator.next();
                object = this.dwdmUtil.constructLinkFormat(iNetLink);
                this.nodeModel = iNetLink.getSrc().getNodeModel();
                ISideModels iSideModels = this.nodeModel.getSideModels();
                int n = this.dwdmUtil.getSrcSideId(iNetLink);
                sRLGRowObject = new SRLGRowObject(iNetLink, iSideModels, n, (String)object);
                string2 = sRLGRowObject.getEntityName();
                l = sRLGRowObject.getUniqueSRLG();
                string = sRLGRowObject.getAdditionalSRLG();
                if (string.indexOf(",") != -1) {
                    this.addSideObserver(iSideModels.getSideById(n));
                    this.rows.add(new SRLGRowObject(iNetLink, iSideModels, string2, l, SRLGRowObject.UNIQUE_STRING));
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        this.rows.add(new SRLGRowObject(iNetLink, iSideModels, string2, Long.parseLong(stringTokenizer.nextToken().trim()), SRLGRowObject.ADDITIONAL_SRLG));
                    }
                    continue;
                }
                this.addSideObserver(iSideModels.getSideById(n));
                this.rows.add(new SRLGRowObject(iNetLink, iSideModels, string2, l, SRLGRowObject.UNIQUE_STRING));
                if (string.equals(SRLGRowObject.UNKNOWN_STRING)) continue;
                if (string.equals("")) continue;
                this.rows.add(new SRLGRowObject(iNetLink, iSideModels, string2, Long.parseLong(string), SRLGRowObject.ADDITIONAL_SRLG));
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Error Occurred.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        this.changed();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getObjectAtRow(int n) {
        try {
            return this.rows.get(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Collection<SRLGRowObject> getAllObjects() {
        return this.rows;
    }

    public void changed() {
        this.fireDataSourceChanged();
    }

    private void deleteAll() {
        for (int i = 0; i < this.rows.size(); ++i) {
            try {
                SRLGRowObject sRLGRowObject = this.rows.get(i);
                if (sRLGRowObject.getNodeModel() != null) {
                    sRLGRowObject.getNodeModel().deleteObserver((IObserver)this);
                    continue;
                }
                if (sRLGRowObject.getDwdmLink() == null) continue;
                INetLink iNetLink = sRLGRowObject.getDwdmLink();
                int n = this.dwdmUtil.getSrcSideId(iNetLink);
                this.deleteSideObserver(iNetLink.getSrc().getNodeModel().getSideModels().getSideById(n));
                this.deleteSideObserver(iNetLink.getDst().getNodeModel().getSideModels().getSideById(n));
                continue;
            }
            catch (WrongNodeSide wrongNodeSide) {
                if (!db.on()) continue;
                db.println("Error Occurred.");
                KDebug.printStackTrace((Throwable)wrongNodeSide);
            }
        }
        this.rows.clear();
    }
}

