/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.Attribute;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.Feature;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.IUpsrOps;
import cerent.cms.ui.AbstractProvPane;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.network.CircuitMapNode;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapSelector;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;

public class CircuitMapSelector
extends MapSelector {
    private static SDebug db = new SDebug("CircuitMapSelector");
    String CMD_SELECTOR_OP = "PS";
    private static Attribute[] switchStates;
    private IUpsrOps upsrOps;
    protected String protectionString;

    public CircuitMapSelector(DetailedMapNode detailedMapNode) {
        super(detailedMapNode);
    }

    public IUpsrOps getUpsrOps() {
        return this.upsrOps;
    }

    public void setUpsrOps(IUpsrOps iUpsrOps) {
        this.upsrOps = iUpsrOps;
        try {
            switchStates = NetworkDefaults.getAttributeMap().getAttributeArray("protectionOpApsClear");
        }
        catch (Exception exception) {
            db.println("Cannot obtain switchStates.");
        }
    }

    public Color getStateColor(int n) {
        return Color.white;
    }

    public String getProtectionString() {
        return this.protectionString;
    }

    public void setProtectionString(String string) {
        this.protectionString = string;
    }

    @Override
    public String getToolTipText() {
        String string = "selector";
        int n = this.parentNode.getSelectors().length;
        Object object = this.getUserObject();
        if (n > 1 && object instanceof Integer) {
            int n2 = (Integer)object;
            string = n2 == 0 ? "first selector" : "second selector";
        }
        return string + ": " + this.protectionString;
    }

    @Override
    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        if (this.upsrOps == null) {
            return;
        }
        Object object = this.getUserObject();
        Object object2 = this.parentNode.getUserObject();
        if (object != null && object instanceof Integer && object2 != null && object2 instanceof INodeModel) {
            int n;
            int n2 = (Integer)object;
            INodeModel iNodeModel = (INodeModel)object2;
            boolean bl = AbstractProvPane.isUserAuthorized((IModel)iNodeModel, SecurityLevel.MAINTENANCE);
            if (n2 == 1 && !Feature.provides((INodeModel)iNodeModel, (Feature)Feature.REV_PROT_OP)) {
                this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Switching the c-d path selector is not supported on this node.", 42);
                return;
            }
            int n3 = 0;
            try {
                n3 = n2 == 1 ? this.upsrOps.getReverseProtectionOp() : this.upsrOps.getProtectionOp();
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Selector information unavailable.", 42);
                return;
            }
            for (int i = 0; i < switchStates.length; ++i) {
                n = switchStates[i].getIntValue();
                if (n != n3) continue;
                uPopupMenu.add((Component)new JLabel(" Please Select New Switch State:"));
                JMenuItem jMenuItem = new JMenuItem(switchStates[i].toString() + " (current operation)");
                jMenuItem.setEnabled(false);
                uPopupMenu.add(jMenuItem);
                break;
            }
            int[] nArray = CircuitMapSelector.getAllowedUpsrOps(n3);
            for (n = 0; n < nArray.length; ++n) {
                int n4 = nArray[n];
                for (int i = 0; i < switchStates.length; ++i) {
                    int n5 = switchStates[i].getIntValue();
                    if (n4 != n5) continue;
                    JMenuItem jMenuItem = new JMenuItem(switchStates[i].toString());
                    jMenuItem.setActionCommand(this.CMD_SELECTOR_OP);
                    jMenuItem.addActionListener(this);
                    jMenuItem.setEnabled(bl);
                    uPopupMenu.add(jMenuItem);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block19: {
            String string = actionEvent.getActionCommand();
            if (string.equals(this.CMD_SELECTOR_OP)) {
                if (this.upsrOps == null || switchStates == null) {
                    db.println("Cannot set protection op; upsrops= " + this.upsrOps + ", switchstates= " + switchStates);
                    return;
                }
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                String string2 = jMenuItem.getText();
                int n = -1;
                for (int i = 0; i < switchStates.length; ++i) {
                    if (!switchStates[i].toString().equals(string2)) continue;
                    n = switchStates[i].getIntValue();
                    break;
                }
                if (n == -1) {
                    ErrorMsg.displayError((Component)this.mtk.getGraphWindow(), (EID)NEMC.EID_CANT_MATCH_MENU_ITEM_PARAM_1, (Object)string2);
                    return;
                }
                Object object = this.getUserObject();
                if (object != null && object instanceof Integer) {
                    INetCircuitNode iNetCircuitNode = ((CircuitMapNode)this.parentNode).getNetCircuitNode();
                    int n2 = (Integer)object;
                    int n3 = CircuitMapUtil.getActivePathCode(iNetCircuitNode, n2);
                    boolean bl = false;
                    if ((n == 5 || n == 3) && n3 == 1) {
                        bl = true;
                    } else if ((n == 6 || n == 4) && n3 == 2) {
                        bl = true;
                    }
                    try {
                        if (bl && !CerentDialog.yesNoDialog((Component)this.mtk.getGraphWindow(), (String)(NEMC.WID_SWITCH_TO_ACTIVE_WARNING + "\n\nIs it OK to continue?"), (String)"Confirm Selector Switch")) {
                            return;
                        }
                        if (!CerentDialog.yesNoDialog((Component)this.mtk.getGraphWindow(), (String)("The " + CircuitMapUtil.UPSR_TERM + " selector will be switched to " + string2 + ".\n" + "Is it OK to continue?"), (String)"Confirm Selector Switch")) {
                            return;
                        }
                        if (n2 == 1) {
                            this.upsrOps.setReverseProtectionOp(n);
                            break block19;
                        }
                        this.upsrOps.setProtectionOp(n);
                    }
                    catch (ConnectionInLoopback connectionInLoopback) {
                        SDebug.printStackTrace((Throwable)connectionInLoopback);
                        ErrorMsg.displayError((Component)this.mtk.getGraphWindow(), (EID)NEMC.EID_PROTOP_ON_CONN_W_XCLOOPBACK);
                    }
                    catch (InvalidProtectionOp invalidProtectionOp) {
                        SDebug.printStackTrace((Throwable)invalidProtectionOp);
                        ErrorMsg.displayDetailed((Component)this.mtk.getGraphWindow(), NEMC.EID_INVALID_PROTECTION_OPER, invalidProtectionOp.getMessage());
                    }
                    catch (InternalCommError internalCommError) {
                        SDebug.printStackTrace((Throwable)internalCommError);
                        ErrorMsg.displayError((Component)this.mtk.getGraphWindow(), (EID)NEMC.EID_COMMUNICATION_ERROR_PARAM_1, (Object)internalCommError.getMessage());
                    }
                    catch (ConnectionTypeError connectionTypeError) {
                        SDebug.printStackTrace((Throwable)connectionTypeError);
                        ErrorMsg.displayError((Component)this.mtk.getGraphWindow(), (EID)NEMC.EID_CONNECTION_TYPE_ERROR, (Object)connectionTypeError.getMessage());
                    }
                    catch (ConnectionInTestAccess connectionInTestAccess) {
                        SDebug.printStackTrace((Throwable)connectionInTestAccess);
                        ErrorMsg.displayError((Component)this.mtk.getGraphWindow(), (EID)NEMC.EID_CONNECTION_IN_TEST_ACCESS, (Object)connectionInTestAccess.getMessage());
                    }
                    catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                        ErrorMsg.displayDetailed(null, NEMC.EID_COMMUNICATION_ERROR_PARAM_1, abstractCmsCommFailException.getMessage(), abstractCmsCommFailException.toString());
                    }
                }
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    public static int[] getAllowedUpsrOps(int n) {
        int[] nArray = null;
        switch (n) {
            case 8: {
                nArray = new int[]{0, 1, 3, 4, 5, 6};
                break;
            }
            case 0: {
                nArray = new int[]{1, 3, 4, 5, 6};
                break;
            }
            case 1: {
                nArray = new int[]{0};
                break;
            }
            case 3: {
                nArray = new int[]{0, 1};
                break;
            }
            case 4: {
                nArray = new int[]{0, 1};
                break;
            }
            case 5: {
                nArray = new int[]{0, 1, 3, 4};
                break;
            }
            case 6: {
                nArray = new int[]{0, 1, 3, 4};
                break;
            }
            default: {
                nArray = new int[]{0, 1, 3, 4, 5, 6};
            }
        }
        return nArray;
    }
}

