/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.INodeModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.event.NetworkAlarmStore;
import cerent.cms.model.event.NetworkEventStore;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.MainTabbedView;
import cerent.cms.ui.MaintenancePane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProvisionPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.circuits.CircuitsTabbedView;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.event.NetworkAlarmPane;
import cerent.cms.ui.event.NetworkConditionsPane;
import cerent.cms.ui.event.NetworkEventPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;

public class NetworkTabbedView
extends MainTabbedView
implements ITabName {
    private NetworkAlarmStore alarmStore = null;
    private NetworkEventStore eventStore = null;
    private IEventPanelController eventController = null;
    protected static final SDebug db = new SDebug("NetworkTabbedView");

    public NetworkTabbedView(NetworkAlarmStore networkAlarmStore, NetworkEventStore networkEventStore, IEventPanelController iEventPanelController) {
        super(NetworkModel.instance());
        this.alarmStore = networkAlarmStore;
        this.eventStore = networkEventStore;
        this.eventController = iEventPanelController;
        this.addTab("Alarms", (Component)this.getAlarmTab());
        this.addTab("Conditions", (Component)this.getConditionTab());
        this.addTab("History", (Component)this.getEventTab());
        this.addTab("Circuits", (Component)this.getCircuitTab());
        this.addTab("Provisioning", (Component)this.getProvisionTab());
        this.addTab("Maintenance", (Component)this.getMaintenanceTab());
    }

    @Override
    public Pane getAlarmTab() {
        return new NetworkAlarmPane("Alarms", this, this.alarmStore, this.eventController);
    }

    public Pane getConditionTab() {
        return new NetworkConditionsPane("Conditions", (NetworkModel)this.getUiModel(), this, this.eventController);
    }

    @Override
    public Pane getEventTab() {
        return new NetworkEventPane("History", this, this.eventStore, this.eventController);
    }

    @Override
    public Pane getCircuitTab() {
        return new CircuitsTabbedView("Circuits", null, this);
    }

    public Pane getProvisionTab() {
        Collection collection = Network.instance().getElements();
        Iterator iterator = collection.iterator();
        INodeModel[] iNodeModelArray = new INodeModel[collection.size()];
        int n = 0;
        while (iterator.hasNext()) {
            INetElement iNetElement = (INetElement)iterator.next();
            iNodeModelArray[n++] = iNetElement.getNodeModel();
        }
        return new ProvisionPane("Provisioning", this, iNodeModelArray);
    }

    public Pane getMaintenanceTab() {
        return new MaintenancePane("Maintenance", this);
    }

    public void update(Observable observable, Object object) {
    }

    public void displayErrorDialog(TabbedView tabbedView, Exception exception, EID eID) {
        ErrorMsg.displayError((Component)tabbedView, (EID)eID, (Object)exception.getMessage());
    }

    public NetworkAlarmStore getAlarmStore() {
        return this.alarmStore;
    }

    public IEventPanelController getEventController() {
        return this.eventController;
    }
}

